# Chemotherapy - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Chemotherapy**

## Logical Model: Chemotherapy 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Chemotherapy | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:Chemotherapy |

 
Chemotherapy 

**Usages:**

* Use this Logical Model: [Treatment Summary](StructureDefinition-TreatmentSummary.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.pcsp|current/StructureDefinition/Chemotherapy)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Chemotherapy.csv), [Excel](StructureDefinition-Chemotherapy.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Chemotherapy",
  "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Chemotherapy",
  "version" : "1.0.0",
  "name" : "Chemotherapy",
  "title" : "Chemotherapy",
  "status" : "active",
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "Chemotherapy",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "fhir",
      "uri" : "hl7.org/fhir/r4",
      "name" : "Chemotherapy model to PCSP HL7 FHIR R4 Profiles"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Chemotherapy",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "Chemotherapy",
        "path" : "Chemotherapy",
        "short" : "Chemotherapy",
        "definition" : "Chemotherapy",
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "MedicationAdministration.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/MedicationAdministration-eu-pcsp')"
          }
        ]
      },
      {
        "id" : "Chemotherapy.relatedDiagnosis",
        "path" : "Chemotherapy.relatedDiagnosis",
        "short" : "Related Diagnosis",
        "definition" : "Identifier of the diagnosis for which this chemotherapy is performed",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".reasonReference"
          }
        ]
      },
      {
        "id" : "Chemotherapy.startDate",
        "path" : "Chemotherapy.startDate",
        "short" : "Start date",
        "definition" : "Please report the date of the first chemotherapy given. If the date is unkown or partially missed insert the year at the best of your knowledge.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".effectivePeriod.start"
          }
        ]
      },
      {
        "id" : "Chemotherapy.endDate",
        "path" : "Chemotherapy.endDate",
        "short" : "End date",
        "definition" : "Please report the date of the last chemotherapy given. If the date is unkown or partially missed insert the year at the best of your knowledge.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".effectivePeriod.end"
          }
        ]
      },
      {
        "id" : "Chemotherapy.istitutionOfTreatment",
        "path" : "Chemotherapy.istitutionOfTreatment",
        "short" : "Institution of treatment",
        "definition" : "Please indicate the institution in which all or most of the chemotherapeutic treatment was given",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".extension(http://hl7.eu/fhir/ig/pcsp/StructureDefinition/ActLocation-eu-pcsp).conformsTo(http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Location-eu-pcsp)"
          }
        ]
      },
      {
        "id" : "Chemotherapy.istitutionOfTreatment.description",
        "path" : "Chemotherapy.istitutionOfTreatment.description",
        "short" : "Institution description",
        "definition" : "Please provide name, city and countryof the institution",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Location.description"
          }
        ]
      },
      {
        "id" : "Chemotherapy.istitutionOfTreatment.name",
        "path" : "Chemotherapy.istitutionOfTreatment.name",
        "short" : "Institution name",
        "definition" : "Institution name",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Location.name"
          }
        ]
      },
      {
        "id" : "Chemotherapy.istitutionOfTreatment.address",
        "path" : "Chemotherapy.istitutionOfTreatment.address",
        "short" : "Institution address",
        "definition" : "Institution address",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Location.address.city"
          }
        ]
      },
      {
        "id" : "Chemotherapy.istitutionOfTreatment.address.name",
        "path" : "Chemotherapy.istitutionOfTreatment.address.name",
        "short" : "Institution city",
        "definition" : "Institution city",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "Chemotherapy.istitutionOfTreatment.address.country",
        "path" : "Chemotherapy.istitutionOfTreatment.address.country",
        "short" : "Institution country",
        "definition" : "Institution country",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Location.address.country"
          }
        ]
      },
      {
        "id" : "Chemotherapy.productAdministration",
        "path" : "Chemotherapy.productAdministration",
        "short" : "Product(s) administartion data",
        "definition" : "Information about the product(s) administered",
        "min" : 1,
        "max" : "20",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".medication[x]"
          }
        ]
      },
      {
        "id" : "Chemotherapy.productAdministration.agent",
        "path" : "Chemotherapy.productAdministration.agent",
        "short" : "Antineoplastic and immunostimulating agents",
        "definition" : "In this section, any of the 'antineoplastic and immunostimulating agents' received by the survivor should be reported,  Drugs names are reported based on the ATC code listed under L01 to L04 in Appendix.  Synonyms are included. When you start typing the name of the drug, the possible options will automatically suggested by the system. \nUp to 20 drugs are allowed into the system.  The variable acronym changes based on the ordinal cmulative number of drugs received (e.g. FN_1, FN_2, FN_3, ?)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".medicationCodeableConcept"
          }
        ]
      },
      {
        "id" : "Chemotherapy.productAdministration.dose",
        "path" : "Chemotherapy.productAdministration.dose",
        "short" : "Dose (NOT in PCSP DB)",
        "definition" : "Dose received of each drug for this administration",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".dosage.dose"
          }
        ]
      },
      {
        "id" : "Chemotherapy.productAdministration.cumulativeDose",
        "path" : "Chemotherapy.productAdministration.cumulativeDose",
        "short" : "Cumulative Dose",
        "definition" : "Report the total cumulative dose received of each drug. ",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".extension(http://hl7.eu/fhir/ig/pcsp/StructureDefinition/ResourceRelatedInfo-eu-pcsp).conformsTo(http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-cumulativeDoseChemo-eu-pcsp)"
          }
        ]
      },
      {
        "id" : "Chemotherapy.productAdministration.cumulativeDose.notAvailable",
        "path" : "Chemotherapy.productAdministration.cumulativeDose.notAvailable",
        "short" : "Not calculated or not known dose",
        "definition" : "Flag indicating if the dose was not calculated or it was not known",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".valueCodeableConcept = http://terminology.hl7.org/CodeSystem/data-absent-reason#unknown"
          },
          {
            "identity" : "fhir",
            "map" : ".dataAbsentReason"
          }
        ]
      },
      {
        "id" : "Chemotherapy.productAdministration.cumulativeDose.measureType",
        "path" : "Chemotherapy.productAdministration.cumulativeDose.measureType",
        "short" : "How the dose was determined (estimation or calculation)",
        "definition" : "Specify if the cumulative dose reported has been all calculated on real data or  estimated based on the expected dose prescribed by the protocol.  If some part of the calculation was based on estimated values, the whole field should be 'estimated'",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".method"
          }
        ]
      },
      {
        "id" : "Chemotherapy.productAdministration.cumulativeDose.completionStatus",
        "path" : "Chemotherapy.productAdministration.cumulativeDose.completionStatus",
        "short" : "The reported doses are incomplete (either under- or over-estimated)",
        "definition" : "Check in case of incomplete doses",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".status = #preliminary"
          }
        ]
      },
      {
        "id" : "Chemotherapy.productAdministration.cumulativeDose.statusReason",
        "path" : "Chemotherapy.productAdministration.cumulativeDose.statusReason",
        "short" : "Specify reasons why",
        "definition" : "Specify reasons of incomplete estimated doses",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".extension('http://hl7.org/fhir/StructureDefinition/event-statusReason')"
          }
        ]
      },
      {
        "id" : "Chemotherapy.productAdministration.cumulativeDose.value",
        "path" : "Chemotherapy.productAdministration.cumulativeDose.value",
        "short" : "Total cumulative dose",
        "definition" : "Report the total cumulative dose received of each drug.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "decimal"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".valueQuantity.value"
          }
        ]
      },
      {
        "id" : "Chemotherapy.productAdministration.cumulativeDose.unit",
        "path" : "Chemotherapy.productAdministration.cumulativeDose.unit",
        "short" : "Measure unit",
        "definition" : "If the dose was calculated, please report the measure unit of the calculation\n1 => mg/m2\n2 => gr/m2\n3 => UI/m2\n4 => NK\n5 => NC (not calculated)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".valueQuantity.unit (human readeable)"
          },
          {
            "identity" : "fhir",
            "map" : ".valueQuantity.code (code)"
          }
        ]
      },
      {
        "id" : "Chemotherapy.corticosteroids",
        "path" : "Chemotherapy.corticosteroids",
        "short" : "Prolonged corticosteroids as anti-cancer treatment at least 4 weeks continuously",
        "definition" : "Report 'yes' if the survivor was treated with steroids for at least 4 weeks continuously\n1 => Yes\n2 => No\n-9922 => NK",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "MedicationStatement.where(medicationCodeableConcept = 'http://www.whocc.no/atc|H02' and dosage.timing.repeat.boundsDuration.where( value='4' and code = 'w' and comparator ='>' )"
          }
        ]
      },
      {
        "id" : "Chemotherapy.intrathecalInjections",
        "path" : "Chemotherapy.intrathecalInjections",
        "short" : "Intrathecal injections",
        "definition" : "Intrathecal injections",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "MedicationStatement.where(dosage.route = https://standardterms.edqm.eu|20042000)"
          }
        ]
      },
      {
        "id" : "Chemotherapy.intrathecalInjections.status",
        "path" : "Chemotherapy.intrathecalInjections.status",
        "short" : "Did the survivor receive therapeutic intrathecal injections ?",
        "definition" : "Please state if the survivor received any therapeutic intrathecal injections\n1 => Yes\n2 => No\n-9922 => NK",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".exists()"
          }
        ]
      },
      {
        "id" : "Chemotherapy.intrathecalInjections.number",
        "path" : "Chemotherapy.intrathecalInjections.number",
        "short" : "Total number",
        "definition" : "Report the total number of injections",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "integer"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".dosage.timing.repeat.count"
          },
          {
            "identity" : "fhir",
            "map" : ".count()"
          }
        ]
      },
      {
        "id" : "Chemotherapy.intrathecalInjections.productName",
        "path" : "Chemotherapy.intrathecalInjections.productName",
        "short" : "Drug(s) administered",
        "definition" : "Please report the names of drugs injected intrathecal",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".medicationCodeableConcept.text"
          }
        ]
      },
      {
        "id" : "Chemotherapy.otherTreatments",
        "path" : "Chemotherapy.otherTreatments",
        "short" : "Other chemothrapeutic treatments",
        "definition" : "Report any other chemothrapeutic treatments that are not included in the ATC code",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "MedicationStatement"
          }
        ]
      },
      {
        "id" : "Chemotherapy.otherTreatments.productName",
        "path" : "Chemotherapy.otherTreatments.productName",
        "short" : "Drugs name",
        "definition" : "If yes, describe treatments",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".medicationCodeableConcept.text"
          }
        ]
      }
    ]
  }
}

```
