# FollowupSurPass - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **FollowupSurPass**

## Questionnaire: FollowupSurPass 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/Questionnaire/FollowupSurPass | *Version*:1.0.0 |
| Draft as of 2025-10-16 | *Computable Name*:FollowupSurPass |

 
Follow up form. The first Followup-Surpass form must be completed at the same time as the SurPass is delivered or in any case at the first visit after the end of the treatment (OT). 

**Structure**

* [LinkID](https://hl7.org/fhir/R4/formats.html#table): FollowupSurPass
  * [Text](https://hl7.org/fhir/R4/formats.html#table): Follow up form. The first Followup-Surpass form must be completed at the same time as the SurPass is delivered or in any case at the first visit after the end of the treatment (OT).
  * [Cardinality](https://hl7.org/fhir/R4/formats.html#table): 
  * [Type](https://hl7.org/fhir/R4/formats.html#table): Questionnaire
  * [Flags](https://hl7.org/fhir/R4/formats.html#table): 
  * [Description & Constraints](https://hl7.org/fhir/R4/formats.html#table)![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC): http://hl7.eu/fhir/ig/pcsp/Questionnaire/FollowupSurPass#1.0.0
* [LinkID](https://hl7.org/fhir/R4/formats.html#table): ![](icon-q-coding.png)first-visit
  * [Text](https://hl7.org/fhir/R4/formats.html#table): First visit?
  * [Cardinality](https://hl7.org/fhir/R4/formats.html#table): 1..1
  * [Type](https://hl7.org/fhir/R4/formats.html#table): [choice](https://hl7.org/fhir/R4/codesystem-item-type.html#item-type-choice)
  * [Flags](https://hl7.org/fhir/R4/formats.html#table): 
  * [Description & Constraints](https://hl7.org/fhir/R4/formats.html#table)![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC): Value Set:[YesNoVS](ValueSet-FollowupSurPass_YesNoVS.md)
* [LinkID](https://hl7.org/fhir/R4/formats.html#table): ![](icon-q-coding.png)consent
  * [Text](https://hl7.org/fhir/R4/formats.html#table): Informed consent to participate in the Followup-SurPass
  * [Cardinality](https://hl7.org/fhir/R4/formats.html#table): 1..1
  * [Type](https://hl7.org/fhir/R4/formats.html#table): [choice](https://hl7.org/fhir/R4/codesystem-item-type.html#item-type-choice)
  * [Flags](https://hl7.org/fhir/R4/formats.html#table): 
  * [Description & Constraints](https://hl7.org/fhir/R4/formats.html#table)![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC): Enable When:[first-visit](#item.first-visit)=Value Set:[YesNoVS](ValueSet-FollowupSurPass_YesNoVS.md)
* [LinkID](https://hl7.org/fhir/R4/formats.html#table): ![](icon-q-date.png)consent-date
  * [Text](https://hl7.org/fhir/R4/formats.html#table): Consent date
  * [Cardinality](https://hl7.org/fhir/R4/formats.html#table): 0..1
  * [Type](https://hl7.org/fhir/R4/formats.html#table): [date](https://hl7.org/fhir/R4/codesystem-item-type.html#item-type-date)
  * [Flags](https://hl7.org/fhir/R4/formats.html#table): ![](icon-qi-hidden.png)![](icon-qi-hidden.png)
  * [Description & Constraints](https://hl7.org/fhir/R4/formats.html#table)![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC): Enable When:[first-visit](#item.first-visit)=
* [LinkID](https://hl7.org/fhir/R4/formats.html#table): ![](icon-q-date.png)visit-date
  * [Text](https://hl7.org/fhir/R4/formats.html#table): Visit date
  * [Cardinality](https://hl7.org/fhir/R4/formats.html#table): 1..1
  * [Type](https://hl7.org/fhir/R4/formats.html#table): [date](https://hl7.org/fhir/R4/codesystem-item-type.html#item-type-date)
  * [Flags](https://hl7.org/fhir/R4/formats.html#table): 
  * [Description & Constraints](https://hl7.org/fhir/R4/formats.html#table)![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC): 
* [LinkID](https://hl7.org/fhir/R4/formats.html#table): ![](icon-q-coding.png)new-cancer-after-off-therapy
  * [Text](https://hl7.org/fhir/R4/formats.html#table): Predisposing genetic syndromes or clinical conditions associated with the tumor diagnosed after the first off-therapy
  * [Cardinality](https://hl7.org/fhir/R4/formats.html#table): 0..1
  * [Type](https://hl7.org/fhir/R4/formats.html#table): [choice](https://hl7.org/fhir/R4/codesystem-item-type.html#item-type-choice)
  * [Flags](https://hl7.org/fhir/R4/formats.html#table): 
  * [Description & Constraints](https://hl7.org/fhir/R4/formats.html#table)![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC): Enable When:[first-visit](#item.first-visit)=Value Set:[YesNoVS](ValueSet-FollowupSurPass_YesNoVS.md)
* [LinkID](https://hl7.org/fhir/R4/formats.html#table): ![](icon-q-text.png)sepcify-new-cancer-txt-1
  * [Text](https://hl7.org/fhir/R4/formats.html#table): If yes, specify
  * [Cardinality](https://hl7.org/fhir/R4/formats.html#table): 1..1
  * [Type](https://hl7.org/fhir/R4/formats.html#table): [text](https://hl7.org/fhir/R4/codesystem-item-type.html#item-type-text)
  * [Flags](https://hl7.org/fhir/R4/formats.html#table): 
  * [Description & Constraints](https://hl7.org/fhir/R4/formats.html#table)![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC): Enable When:[new-cancer-after-off-therapy](#item.new-cancer-after-off-therapy)=
* [LinkID](https://hl7.org/fhir/R4/formats.html#table): ![](icon-q-coding.png)other-clinical
  * [Text](https://hl7.org/fhir/R4/formats.html#table): Other clinical pictures, not associated with the tumor at the time of diagnosis
  * [Cardinality](https://hl7.org/fhir/R4/formats.html#table): 0..1
  * [Type](https://hl7.org/fhir/R4/formats.html#table): [choice](https://hl7.org/fhir/R4/codesystem-item-type.html#item-type-choice)
  * [Flags](https://hl7.org/fhir/R4/formats.html#table): 
  * [Description & Constraints](https://hl7.org/fhir/R4/formats.html#table)![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC): Enable When:[first-visit](#item.first-visit)=Value Set:[YesNoVS](ValueSet-FollowupSurPass_YesNoVS.md)
* [LinkID](https://hl7.org/fhir/R4/formats.html#table): ![](icon-q-text.png)sepcify-other-clinical-txt-1
  * [Text](https://hl7.org/fhir/R4/formats.html#table): If yes, specify
  * [Cardinality](https://hl7.org/fhir/R4/formats.html#table): 1..1
  * [Type](https://hl7.org/fhir/R4/formats.html#table): [text](https://hl7.org/fhir/R4/codesystem-item-type.html#item-type-text)
  * [Flags](https://hl7.org/fhir/R4/formats.html#table): 
  * [Description & Constraints](https://hl7.org/fhir/R4/formats.html#table)![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC): Enable When:[other-clinical](#item.other-clinical)=
* [LinkID](https://hl7.org/fhir/R4/formats.html#table): ![](icon-q-coding.png)new-condition-after-off-therapy
  * [Text](https://hl7.org/fhir/R4/formats.html#table): After the first off therapy the patient experienced one or more pathological conditions
  * [Cardinality](https://hl7.org/fhir/R4/formats.html#table): 1..1
  * [Type](https://hl7.org/fhir/R4/formats.html#table): [choice](https://hl7.org/fhir/R4/codesystem-item-type.html#item-type-choice)
  * [Flags](https://hl7.org/fhir/R4/formats.html#table): 
  * [Description & Constraints](https://hl7.org/fhir/R4/formats.html#table)![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC): Enable When:[first-visit](#item.first-visit)=Value Set:[YesNoVS](ValueSet-FollowupSurPass_YesNoVS.md)
* [LinkID](https://hl7.org/fhir/R4/formats.html#table): ![](icon-q-group.png)group-condition-1
  * [Text](https://hl7.org/fhir/R4/formats.html#table): Pathological conditions
  * [Cardinality](https://hl7.org/fhir/R4/formats.html#table): 1..*
  * [Type](https://hl7.org/fhir/R4/formats.html#table): [group](https://hl7.org/fhir/R4/codesystem-item-type.html#item-type-group)
  * [Flags](https://hl7.org/fhir/R4/formats.html#table): 
  * [Description & Constraints](https://hl7.org/fhir/R4/formats.html#table)![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC): Enable When:[new-condition-after-off-therapy](#item.new-condition-after-off-therapy)=
* [LinkID](https://hl7.org/fhir/R4/formats.html#table): ![](icon-q-coding.png)condition-1
  * [Text](https://hl7.org/fhir/R4/formats.html#table): Condition
  * [Cardinality](https://hl7.org/fhir/R4/formats.html#table): 1..1
  * [Type](https://hl7.org/fhir/R4/formats.html#table): [choice](https://hl7.org/fhir/R4/codesystem-item-type.html#item-type-choice)
  * [Flags](https://hl7.org/fhir/R4/formats.html#table): 
  * [Description & Constraints](https://hl7.org/fhir/R4/formats.html#table)![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC): Value Set:[Conditions: follow up](ValueSet-cond-test-vs.md)
* [LinkID](https://hl7.org/fhir/R4/formats.html#table): ![](icon-q-text.png)condition-note-1
  * [Text](https://hl7.org/fhir/R4/formats.html#table): null
  * [Cardinality](https://hl7.org/fhir/R4/formats.html#table): 0..1
  * [Type](https://hl7.org/fhir/R4/formats.html#table): [text](https://hl7.org/fhir/R4/codesystem-item-type.html#item-type-text)
  * [Flags](https://hl7.org/fhir/R4/formats.html#table): ![](icon-qi-readonly.png)![](icon-qi-readonly.png)
  * [Description & Constraints](https://hl7.org/fhir/R4/formats.html#table)![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC): Initial Value: string = This space will contain guidance for the selected condition. Content is not yet available.
* [LinkID](https://hl7.org/fhir/R4/formats.html#table): ![](icon-q-text.png)condition-other-1
  * [Text](https://hl7.org/fhir/R4/formats.html#table): If other, specify
  * [Cardinality](https://hl7.org/fhir/R4/formats.html#table): 1..1
  * [Type](https://hl7.org/fhir/R4/formats.html#table): [text](https://hl7.org/fhir/R4/codesystem-item-type.html#item-type-text)
  * [Flags](https://hl7.org/fhir/R4/formats.html#table): 
  * [Description & Constraints](https://hl7.org/fhir/R4/formats.html#table)![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC): Enable When:* [condition-1](#item.condition-1) = 
* [condition-1](#item.condition-1) = 
* [condition-1](#item.condition-1) = 
* [condition-1](#item.condition-1) = 
* [condition-1](#item.condition-1) = 
* [condition-1](#item.condition-1) = 
* [condition-1](#item.condition-1) = 
* [condition-1](#item.condition-1) = 
* [condition-1](#item.condition-1) = 
* [condition-1](#item.condition-1) = 
* [condition-1](#item.condition-1) = 
* [condition-1](#item.condition-1) = 
* [condition-1](#item.condition-1) = 
* [condition-1](#item.condition-1) = 
* [condition-1](#item.condition-1) = 
* [condition-1](#item.condition-1) = 
* [condition-1](#item.condition-1) = 
* [condition-1](#item.condition-1) = 
* [condition-1](#item.condition-1) = 
* [condition-1](#item.condition-1) = 
* [condition-1](#item.condition-1) = 
* [condition-1](#item.condition-1) = 
* [condition-1](#item.condition-1) = 
* [condition-1](#item.condition-1) = 
* [condition-1](#item.condition-1) = 
* [condition-1](#item.condition-1) = 
* [condition-1](#item.condition-1) = 
* [condition-1](#item.condition-1) = 
* [condition-1](#item.condition-1) = 
* [condition-1](#item.condition-1) = 
* [condition-1](#item.condition-1) = 
* [condition-1](#item.condition-1) = 
* [condition-1](#item.condition-1) = 
* [condition-1](#item.condition-1) = 
* [condition-1](#item.condition-1) = 
* [condition-1](#item.condition-1) = 
* [condition-1](#item.condition-1) = 
* [condition-1](#item.condition-1) = 
* [condition-1](#item.condition-1) = 
* [condition-1](#item.condition-1) = 
* [condition-1](#item.condition-1) = 
* [condition-1](#item.condition-1) = 
* [condition-1](#item.condition-1) = 
* [condition-1](#item.condition-1) = 
* [condition-1](#item.condition-1) = 

* [LinkID](https://hl7.org/fhir/R4/formats.html#table): ![](icon-q-date.png)appearance-date-1
  * [Text](https://hl7.org/fhir/R4/formats.html#table): Onset date
  * [Cardinality](https://hl7.org/fhir/R4/formats.html#table): 1..1
  * [Type](https://hl7.org/fhir/R4/formats.html#table): [date](https://hl7.org/fhir/R4/codesystem-item-type.html#item-type-date)
  * [Flags](https://hl7.org/fhir/R4/formats.html#table): 
  * [Description & Constraints](https://hl7.org/fhir/R4/formats.html#table)![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC): 
* [LinkID](https://hl7.org/fhir/R4/formats.html#table): ![](icon-q-coding.png)condition-grading-1
  * [Text](https://hl7.org/fhir/R4/formats.html#table): Grading m-CTCAE at onset/last visit
  * [Cardinality](https://hl7.org/fhir/R4/formats.html#table): 1..1
  * [Type](https://hl7.org/fhir/R4/formats.html#table): [choice](https://hl7.org/fhir/R4/codesystem-item-type.html#item-type-choice)
  * [Flags](https://hl7.org/fhir/R4/formats.html#table): 
  * [Description & Constraints](https://hl7.org/fhir/R4/formats.html#table)![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC): Value Set:[Grade: follow up](ValueSet-grade-test-vs.md)
* [LinkID](https://hl7.org/fhir/R4/formats.html#table): ![](icon-q-coding.png)condition-evolution-1
  * [Text](https://hl7.org/fhir/R4/formats.html#table): Evolution
  * [Cardinality](https://hl7.org/fhir/R4/formats.html#table): 1..1
  * [Type](https://hl7.org/fhir/R4/formats.html#table): [choice](https://hl7.org/fhir/R4/codesystem-item-type.html#item-type-choice)
  * [Flags](https://hl7.org/fhir/R4/formats.html#table): 
  * [Description & Constraints](https://hl7.org/fhir/R4/formats.html#table)![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC): Options:[2 options](#opt-item.condition-evolution-1)
* [LinkID](https://hl7.org/fhir/R4/formats.html#table): ![](icon-q-date.png)resolution-date-1
  * [Text](https://hl7.org/fhir/R4/formats.html#table): If yes, date
  * [Cardinality](https://hl7.org/fhir/R4/formats.html#table): 1..1
  * [Type](https://hl7.org/fhir/R4/formats.html#table): [date](https://hl7.org/fhir/R4/codesystem-item-type.html#item-type-date)
  * [Flags](https://hl7.org/fhir/R4/formats.html#table): 
  * [Description & Constraints](https://hl7.org/fhir/R4/formats.html#table)![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC): Enable When:[condition-evolution-1](#item.condition-evolution-1)=
* [LinkID](https://hl7.org/fhir/R4/formats.html#table): ![](icon-q-coding.png)new-condition-grading-1
  * [Text](https://hl7.org/fhir/R4/formats.html#table): If changed, new grading
  * [Cardinality](https://hl7.org/fhir/R4/formats.html#table): 1..1
  * [Type](https://hl7.org/fhir/R4/formats.html#table): [choice](https://hl7.org/fhir/R4/codesystem-item-type.html#item-type-choice)
  * [Flags](https://hl7.org/fhir/R4/formats.html#table): 
  * [Description & Constraints](https://hl7.org/fhir/R4/formats.html#table)![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC): Enable When:[condition-evolution-1](#item.condition-evolution-1)=Value Set:[Grade: follow up](ValueSet-grade-test-vs.md)
* [LinkID](https://hl7.org/fhir/R4/formats.html#table): ![](icon-q-text.png)details-1
  * [Text](https://hl7.org/fhir/R4/formats.html#table): Details
  * [Cardinality](https://hl7.org/fhir/R4/formats.html#table): 0..1
  * [Type](https://hl7.org/fhir/R4/formats.html#table): [text](https://hl7.org/fhir/R4/codesystem-item-type.html#item-type-text)
  * [Flags](https://hl7.org/fhir/R4/formats.html#table): 
  * [Description & Constraints](https://hl7.org/fhir/R4/formats.html#table)![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC): 
* [LinkID](https://hl7.org/fhir/R4/formats.html#table): ![](icon-q-text.png)next-check-1
  * [Text](https://hl7.org/fhir/R4/formats.html#table): Next check-up planned on
  * [Cardinality](https://hl7.org/fhir/R4/formats.html#table): 0..1
  * [Type](https://hl7.org/fhir/R4/formats.html#table): [text](https://hl7.org/fhir/R4/codesystem-item-type.html#item-type-text)
  * [Flags](https://hl7.org/fhir/R4/formats.html#table): 
  * [Description & Constraints](https://hl7.org/fhir/R4/formats.html#table)![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC): 
* [LinkID](https://hl7.org/fhir/R4/formats.html#table): ![](icon-q-coding.png)condition-changed
  * [Text](https://hl7.org/fhir/R4/formats.html#table): Have any pathological conditions that were still present (unresolved) at the previous visit resolved or changed in degree?
  * [Cardinality](https://hl7.org/fhir/R4/formats.html#table): 1..1
  * [Type](https://hl7.org/fhir/R4/formats.html#table): [choice](https://hl7.org/fhir/R4/codesystem-item-type.html#item-type-choice)
  * [Flags](https://hl7.org/fhir/R4/formats.html#table): 
  * [Description & Constraints](https://hl7.org/fhir/R4/formats.html#table)![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC): Enable When:[first-visit](#item.first-visit)=Value Set:[YesNoNAVS](ValueSet-FollowupSurPass_YesNoNAVS.md)
* [LinkID](https://hl7.org/fhir/R4/formats.html#table): ![](icon-q-group.png)group-condition-2
  * [Text](https://hl7.org/fhir/R4/formats.html#table): Pathological conditions
  * [Cardinality](https://hl7.org/fhir/R4/formats.html#table): 1..*
  * [Type](https://hl7.org/fhir/R4/formats.html#table): [group](https://hl7.org/fhir/R4/codesystem-item-type.html#item-type-group)
  * [Flags](https://hl7.org/fhir/R4/formats.html#table): 
  * [Description & Constraints](https://hl7.org/fhir/R4/formats.html#table)![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC): Enable When:* [condition-changed](#item.condition-changed) = 
* [condition-changed](#item.condition-changed) = 

* [LinkID](https://hl7.org/fhir/R4/formats.html#table): ![](icon-q-coding.png)condition-2
  * [Text](https://hl7.org/fhir/R4/formats.html#table): Condition
  * [Cardinality](https://hl7.org/fhir/R4/formats.html#table): 1..1
  * [Type](https://hl7.org/fhir/R4/formats.html#table): [choice](https://hl7.org/fhir/R4/codesystem-item-type.html#item-type-choice)
  * [Flags](https://hl7.org/fhir/R4/formats.html#table): 
  * [Description & Constraints](https://hl7.org/fhir/R4/formats.html#table)![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC): Value Set:[Conditions: follow up](ValueSet-cond-test-vs.md)
* [LinkID](https://hl7.org/fhir/R4/formats.html#table): ![](icon-q-text.png)condition-note-2
  * [Text](https://hl7.org/fhir/R4/formats.html#table): null
  * [Cardinality](https://hl7.org/fhir/R4/formats.html#table): 0..1
  * [Type](https://hl7.org/fhir/R4/formats.html#table): [text](https://hl7.org/fhir/R4/codesystem-item-type.html#item-type-text)
  * [Flags](https://hl7.org/fhir/R4/formats.html#table): ![](icon-qi-readonly.png)![](icon-qi-readonly.png)
  * [Description & Constraints](https://hl7.org/fhir/R4/formats.html#table)![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC): Initial Value: string = This space will contain guidance for the selected condition. Content is not yet available.
* [LinkID](https://hl7.org/fhir/R4/formats.html#table): ![](icon-q-text.png)condition-other-2
  * [Text](https://hl7.org/fhir/R4/formats.html#table): If other, specify
  * [Cardinality](https://hl7.org/fhir/R4/formats.html#table): 1..1
  * [Type](https://hl7.org/fhir/R4/formats.html#table): [text](https://hl7.org/fhir/R4/codesystem-item-type.html#item-type-text)
  * [Flags](https://hl7.org/fhir/R4/formats.html#table): 
  * [Description & Constraints](https://hl7.org/fhir/R4/formats.html#table)![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC): Enable When:* [condition-2](#item.condition-2) = 
* [condition-2](#item.condition-2) = 
* [condition-2](#item.condition-2) = 
* [condition-2](#item.condition-2) = 
* [condition-2](#item.condition-2) = 
* [condition-2](#item.condition-2) = 
* [condition-2](#item.condition-2) = 
* [condition-2](#item.condition-2) = 
* [condition-2](#item.condition-2) = 
* [condition-2](#item.condition-2) = 
* [condition-2](#item.condition-2) = 
* [condition-2](#item.condition-2) = 
* [condition-2](#item.condition-2) = 
* [condition-2](#item.condition-2) = 
* [condition-2](#item.condition-2) = 
* [condition-2](#item.condition-2) = 
* [condition-2](#item.condition-2) = 
* [condition-2](#item.condition-2) = 
* [condition-2](#item.condition-2) = 
* [condition-2](#item.condition-2) = 
* [condition-2](#item.condition-2) = 
* [condition-2](#item.condition-2) = 
* [condition-2](#item.condition-2) = 
* [condition-2](#item.condition-2) = 
* [condition-2](#item.condition-2) = 
* [condition-2](#item.condition-2) = 
* [condition-2](#item.condition-2) = 
* [condition-2](#item.condition-2) = 
* [condition-2](#item.condition-2) = 
* [condition-2](#item.condition-2) = 
* [condition-2](#item.condition-2) = 
* [condition-2](#item.condition-2) = 
* [condition-2](#item.condition-2) = 
* [condition-2](#item.condition-2) = 
* [condition-2](#item.condition-2) = 
* [condition-2](#item.condition-2) = 
* [condition-2](#item.condition-2) = 
* [condition-2](#item.condition-2) = 
* [condition-2](#item.condition-2) = 
* [condition-2](#item.condition-2) = 
* [condition-2](#item.condition-2) = 
* [condition-2](#item.condition-2) = 
* [condition-2](#item.condition-2) = 
* [condition-2](#item.condition-2) = 
* [condition-2](#item.condition-2) = 

* [LinkID](https://hl7.org/fhir/R4/formats.html#table): ![](icon-q-date.png)appearance-date-2
  * [Text](https://hl7.org/fhir/R4/formats.html#table): Onset date
  * [Cardinality](https://hl7.org/fhir/R4/formats.html#table): 1..1
  * [Type](https://hl7.org/fhir/R4/formats.html#table): [date](https://hl7.org/fhir/R4/codesystem-item-type.html#item-type-date)
  * [Flags](https://hl7.org/fhir/R4/formats.html#table): 
  * [Description & Constraints](https://hl7.org/fhir/R4/formats.html#table)![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC): 
* [LinkID](https://hl7.org/fhir/R4/formats.html#table): ![](icon-q-coding.png)condition-grading-2
  * [Text](https://hl7.org/fhir/R4/formats.html#table): Grading m-CTCAE at onset/last visit
  * [Cardinality](https://hl7.org/fhir/R4/formats.html#table): 1..1
  * [Type](https://hl7.org/fhir/R4/formats.html#table): [choice](https://hl7.org/fhir/R4/codesystem-item-type.html#item-type-choice)
  * [Flags](https://hl7.org/fhir/R4/formats.html#table): 
  * [Description & Constraints](https://hl7.org/fhir/R4/formats.html#table)![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC): Value Set:[Grade: follow up](ValueSet-grade-test-vs.md)
* [LinkID](https://hl7.org/fhir/R4/formats.html#table): ![](icon-q-coding.png)condition-evolution-2
  * [Text](https://hl7.org/fhir/R4/formats.html#table): Evolution
  * [Cardinality](https://hl7.org/fhir/R4/formats.html#table): 1..1
  * [Type](https://hl7.org/fhir/R4/formats.html#table): [choice](https://hl7.org/fhir/R4/codesystem-item-type.html#item-type-choice)
  * [Flags](https://hl7.org/fhir/R4/formats.html#table): 
  * [Description & Constraints](https://hl7.org/fhir/R4/formats.html#table)![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC): Enable When:[condition-changed](#item.condition-changed)=Options:[3 options](#opt-item.condition-evolution-2)
* [LinkID](https://hl7.org/fhir/R4/formats.html#table): ![](icon-q-date.png)resolution-date-2
  * [Text](https://hl7.org/fhir/R4/formats.html#table): If yes, date
  * [Cardinality](https://hl7.org/fhir/R4/formats.html#table): 1..1
  * [Type](https://hl7.org/fhir/R4/formats.html#table): [date](https://hl7.org/fhir/R4/codesystem-item-type.html#item-type-date)
  * [Flags](https://hl7.org/fhir/R4/formats.html#table): 
  * [Description & Constraints](https://hl7.org/fhir/R4/formats.html#table)![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC): Enable When:[condition-evolution-2](#item.condition-evolution-2)=
* [LinkID](https://hl7.org/fhir/R4/formats.html#table): ![](icon-q-coding.png)new-condition-grading-2
  * [Text](https://hl7.org/fhir/R4/formats.html#table): If changed, new grading
  * [Cardinality](https://hl7.org/fhir/R4/formats.html#table): 1..1
  * [Type](https://hl7.org/fhir/R4/formats.html#table): [choice](https://hl7.org/fhir/R4/codesystem-item-type.html#item-type-choice)
  * [Flags](https://hl7.org/fhir/R4/formats.html#table): 
  * [Description & Constraints](https://hl7.org/fhir/R4/formats.html#table)![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC): Enable When:[condition-evolution-2](#item.condition-evolution-2)=Value Set:[Grade: follow up](ValueSet-grade-test-vs.md)
* [LinkID](https://hl7.org/fhir/R4/formats.html#table): ![](icon-q-text.png)details-2
  * [Text](https://hl7.org/fhir/R4/formats.html#table): Details
  * [Cardinality](https://hl7.org/fhir/R4/formats.html#table): 0..1
  * [Type](https://hl7.org/fhir/R4/formats.html#table): [text](https://hl7.org/fhir/R4/codesystem-item-type.html#item-type-text)
  * [Flags](https://hl7.org/fhir/R4/formats.html#table): 
  * [Description & Constraints](https://hl7.org/fhir/R4/formats.html#table)![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC): 
* [LinkID](https://hl7.org/fhir/R4/formats.html#table): ![](icon-q-text.png)next-check-2
  * [Text](https://hl7.org/fhir/R4/formats.html#table): Next check-up planned on
  * [Cardinality](https://hl7.org/fhir/R4/formats.html#table): 0..1
  * [Type](https://hl7.org/fhir/R4/formats.html#table): [text](https://hl7.org/fhir/R4/codesystem-item-type.html#item-type-text)
  * [Flags](https://hl7.org/fhir/R4/formats.html#table): 
  * [Description & Constraints](https://hl7.org/fhir/R4/formats.html#table)![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC): 
* [LinkID](https://hl7.org/fhir/R4/formats.html#table): ![](icon-q-coding.png)new-cancer-after-last-visit
  * [Text](https://hl7.org/fhir/R4/formats.html#table): After the first off therapy the patient experienced one or more pathological conditions?
  * [Cardinality](https://hl7.org/fhir/R4/formats.html#table): 0..1
  * [Type](https://hl7.org/fhir/R4/formats.html#table): [choice](https://hl7.org/fhir/R4/codesystem-item-type.html#item-type-choice)
  * [Flags](https://hl7.org/fhir/R4/formats.html#table): 
  * [Description & Constraints](https://hl7.org/fhir/R4/formats.html#table)![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC): Enable When:[first-visit](#item.first-visit)=Value Set:[YesNoVS](ValueSet-FollowupSurPass_YesNoVS.md)
* [LinkID](https://hl7.org/fhir/R4/formats.html#table): ![](icon-q-group.png)group-condition-3
  * [Text](https://hl7.org/fhir/R4/formats.html#table): Pathological conditions
  * [Cardinality](https://hl7.org/fhir/R4/formats.html#table): 1..*
  * [Type](https://hl7.org/fhir/R4/formats.html#table): [group](https://hl7.org/fhir/R4/codesystem-item-type.html#item-type-group)
  * [Flags](https://hl7.org/fhir/R4/formats.html#table): 
  * [Description & Constraints](https://hl7.org/fhir/R4/formats.html#table)![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC): Enable When:[new-cancer-after-last-visit](#item.new-cancer-after-last-visit)=
* [LinkID](https://hl7.org/fhir/R4/formats.html#table): ![](icon-q-coding.png)condition-3
  * [Text](https://hl7.org/fhir/R4/formats.html#table): Condition
  * [Cardinality](https://hl7.org/fhir/R4/formats.html#table): 1..1
  * [Type](https://hl7.org/fhir/R4/formats.html#table): [choice](https://hl7.org/fhir/R4/codesystem-item-type.html#item-type-choice)
  * [Flags](https://hl7.org/fhir/R4/formats.html#table): 
  * [Description & Constraints](https://hl7.org/fhir/R4/formats.html#table)![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC): Value Set:[Conditions: follow up](ValueSet-cond-test-vs.md)
* [LinkID](https://hl7.org/fhir/R4/formats.html#table): ![](icon-q-text.png)condition-note-3
  * [Text](https://hl7.org/fhir/R4/formats.html#table): null
  * [Cardinality](https://hl7.org/fhir/R4/formats.html#table): 0..1
  * [Type](https://hl7.org/fhir/R4/formats.html#table): [text](https://hl7.org/fhir/R4/codesystem-item-type.html#item-type-text)
  * [Flags](https://hl7.org/fhir/R4/formats.html#table): ![](icon-qi-readonly.png)![](icon-qi-readonly.png)
  * [Description & Constraints](https://hl7.org/fhir/R4/formats.html#table)![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC): Initial Value: string = This space will contain guidance for the selected condition. Content is not yet available.
* [LinkID](https://hl7.org/fhir/R4/formats.html#table): ![](icon-q-text.png)condition-other-3
  * [Text](https://hl7.org/fhir/R4/formats.html#table): If other, specify
  * [Cardinality](https://hl7.org/fhir/R4/formats.html#table): 1..1
  * [Type](https://hl7.org/fhir/R4/formats.html#table): [text](https://hl7.org/fhir/R4/codesystem-item-type.html#item-type-text)
  * [Flags](https://hl7.org/fhir/R4/formats.html#table): 
  * [Description & Constraints](https://hl7.org/fhir/R4/formats.html#table)![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC): Enable When:* [condition-3](#item.condition-3) = 
* [condition-3](#item.condition-3) = 
* [condition-3](#item.condition-3) = 
* [condition-3](#item.condition-3) = 
* [condition-3](#item.condition-3) = 
* [condition-3](#item.condition-3) = 
* [condition-3](#item.condition-3) = 
* [condition-3](#item.condition-3) = 
* [condition-3](#item.condition-3) = 
* [condition-3](#item.condition-3) = 
* [condition-3](#item.condition-3) = 
* [condition-3](#item.condition-3) = 
* [condition-3](#item.condition-3) = 
* [condition-3](#item.condition-3) = 
* [condition-3](#item.condition-3) = 
* [condition-3](#item.condition-3) = 
* [condition-3](#item.condition-3) = 
* [condition-3](#item.condition-3) = 
* [condition-3](#item.condition-3) = 
* [condition-3](#item.condition-3) = 
* [condition-3](#item.condition-3) = 
* [condition-3](#item.condition-3) = 
* [condition-3](#item.condition-3) = 
* [condition-3](#item.condition-3) = 
* [condition-3](#item.condition-3) = 
* [condition-3](#item.condition-3) = 
* [condition-3](#item.condition-3) = 
* [condition-3](#item.condition-3) = 
* [condition-3](#item.condition-3) = 
* [condition-3](#item.condition-3) = 
* [condition-3](#item.condition-3) = 
* [condition-3](#item.condition-3) = 
* [condition-3](#item.condition-3) = 
* [condition-3](#item.condition-3) = 
* [condition-3](#item.condition-3) = 
* [condition-3](#item.condition-3) = 
* [condition-3](#item.condition-3) = 
* [condition-3](#item.condition-3) = 
* [condition-3](#item.condition-3) = 
* [condition-3](#item.condition-3) = 
* [condition-3](#item.condition-3) = 
* [condition-3](#item.condition-3) = 
* [condition-3](#item.condition-3) = 
* [condition-3](#item.condition-3) = 
* [condition-3](#item.condition-3) = 

* [LinkID](https://hl7.org/fhir/R4/formats.html#table): ![](icon-q-date.png)appearance-date-3
  * [Text](https://hl7.org/fhir/R4/formats.html#table): Onset date
  * [Cardinality](https://hl7.org/fhir/R4/formats.html#table): 1..1
  * [Type](https://hl7.org/fhir/R4/formats.html#table): [date](https://hl7.org/fhir/R4/codesystem-item-type.html#item-type-date)
  * [Flags](https://hl7.org/fhir/R4/formats.html#table): 
  * [Description & Constraints](https://hl7.org/fhir/R4/formats.html#table)![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC): 
* [LinkID](https://hl7.org/fhir/R4/formats.html#table): ![](icon-q-coding.png)condition-grading-3
  * [Text](https://hl7.org/fhir/R4/formats.html#table): Grading m-CTCAE at onset/last visit
  * [Cardinality](https://hl7.org/fhir/R4/formats.html#table): 1..1
  * [Type](https://hl7.org/fhir/R4/formats.html#table): [choice](https://hl7.org/fhir/R4/codesystem-item-type.html#item-type-choice)
  * [Flags](https://hl7.org/fhir/R4/formats.html#table): 
  * [Description & Constraints](https://hl7.org/fhir/R4/formats.html#table)![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC): Value Set:[Grade: follow up](ValueSet-grade-test-vs.md)
* [LinkID](https://hl7.org/fhir/R4/formats.html#table): ![](icon-q-coding.png)condition-evolution-3
  * [Text](https://hl7.org/fhir/R4/formats.html#table): Evolution
  * [Cardinality](https://hl7.org/fhir/R4/formats.html#table): 1..1
  * [Type](https://hl7.org/fhir/R4/formats.html#table): [choice](https://hl7.org/fhir/R4/codesystem-item-type.html#item-type-choice)
  * [Flags](https://hl7.org/fhir/R4/formats.html#table): 
  * [Description & Constraints](https://hl7.org/fhir/R4/formats.html#table)![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC): Options:[2 options](#opt-item.condition-evolution-3)
* [LinkID](https://hl7.org/fhir/R4/formats.html#table): ![](icon-q-date.png)resolution-date-3
  * [Text](https://hl7.org/fhir/R4/formats.html#table): If yes, date
  * [Cardinality](https://hl7.org/fhir/R4/formats.html#table): 1..1
  * [Type](https://hl7.org/fhir/R4/formats.html#table): [date](https://hl7.org/fhir/R4/codesystem-item-type.html#item-type-date)
  * [Flags](https://hl7.org/fhir/R4/formats.html#table): 
  * [Description & Constraints](https://hl7.org/fhir/R4/formats.html#table)![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC): Enable When:[condition-evolution-3](#item.condition-evolution-3)=
* [LinkID](https://hl7.org/fhir/R4/formats.html#table): ![](icon-q-coding.png)new-condition-grading-3
  * [Text](https://hl7.org/fhir/R4/formats.html#table): If changed, new grading
  * [Cardinality](https://hl7.org/fhir/R4/formats.html#table): 1..1
  * [Type](https://hl7.org/fhir/R4/formats.html#table): [choice](https://hl7.org/fhir/R4/codesystem-item-type.html#item-type-choice)
  * [Flags](https://hl7.org/fhir/R4/formats.html#table): 
  * [Description & Constraints](https://hl7.org/fhir/R4/formats.html#table)![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC): Enable When:[condition-evolution-3](#item.condition-evolution-3)=Value Set:[Grade: follow up](ValueSet-grade-test-vs.md)
* [LinkID](https://hl7.org/fhir/R4/formats.html#table): ![](icon-q-text.png)details-3
  * [Text](https://hl7.org/fhir/R4/formats.html#table): Details
  * [Cardinality](https://hl7.org/fhir/R4/formats.html#table): 0..1
  * [Type](https://hl7.org/fhir/R4/formats.html#table): [text](https://hl7.org/fhir/R4/codesystem-item-type.html#item-type-text)
  * [Flags](https://hl7.org/fhir/R4/formats.html#table): 
  * [Description & Constraints](https://hl7.org/fhir/R4/formats.html#table)![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC): 
* [LinkID](https://hl7.org/fhir/R4/formats.html#table): ![](icon-q-text.png)next-check-3
  * [Text](https://hl7.org/fhir/R4/formats.html#table): Next check-up planned on
  * [Cardinality](https://hl7.org/fhir/R4/formats.html#table): 0..1
  * [Type](https://hl7.org/fhir/R4/formats.html#table): [text](https://hl7.org/fhir/R4/codesystem-item-type.html#item-type-text)
  * [Flags](https://hl7.org/fhir/R4/formats.html#table): 
  * [Description & Constraints](https://hl7.org/fhir/R4/formats.html#table)![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC): 
* [LinkID](https://hl7.org/fhir/R4/formats.html#table): ![](icon-q-string.png)notes
  * [Text](https://hl7.org/fhir/R4/formats.html#table): Notes
  * [Cardinality](https://hl7.org/fhir/R4/formats.html#table): 0..1
  * [Type](https://hl7.org/fhir/R4/formats.html#table): [string](https://hl7.org/fhir/R4/codesystem-item-type.html#item-type-string)
  * [Flags](https://hl7.org/fhir/R4/formats.html#table): 
  * [Description & Constraints](https://hl7.org/fhir/R4/formats.html#table)![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC): 
* [LinkID](https://hl7.org/fhir/R4/formats.html#table): ![](icon-q-attachment.png)notes-attachments
  * [Text](https://hl7.org/fhir/R4/formats.html#table): Reports relating to significant laboratory instrumental tests
  * [Cardinality](https://hl7.org/fhir/R4/formats.html#table): 0..*
  * [Type](https://hl7.org/fhir/R4/formats.html#table): [attachment](https://hl7.org/fhir/R4/codesystem-item-type.html#item-type-attachment)
  * [Flags](https://hl7.org/fhir/R4/formats.html#table): 
  * [Description & Constraints](https://hl7.org/fhir/R4/formats.html#table)![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC): 
* [LinkID](https://hl7.org/fhir/R4/formats.html#table): ![](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC)Documentation for this format

-------

**Options Sets**

**Answer options for condition-evolution-1**

* Yes, resolved
* No, not resolved

**Answer options for condition-evolution-2**

* No, unchanged
* Yes, changed
* Yes, solved

**Answer options for condition-evolution-3**

* Yes, resolved
* No, not resolved

## Contained Resources

-------

* Include these codes as defined in [`http://loinc.org`](http://loinc.org)version Not Stated (use latest from terminology server)

* **Code**: [LA32-8](https://loinc.org/LA32-8/)
  * **Display**: NO
* **Code**: [LA33-6](https://loinc.org/LA33-6/)
  * **Display**: YES


-------

* Include these codes as defined in [`http://loinc.org`](http://loinc.org)version Not Stated (use latest from terminology server)

* **Code**: [LA32-8](https://loinc.org/LA32-8/)
  * **Display**: NO
* **Code**: [LA33-6](https://loinc.org/LA33-6/)
  * **Display**: YES
* **Code**: [LA30226-7](https://loinc.org/LA30226-7/)
  * **Display**: Not applicable (N/A)




## Resource Content

```json
{
  "resourceType" : "Questionnaire",
  "id" : "FollowupSurPass",
  "contained" : [
    {
      "resourceType" : "ValueSet",
      "id" : "YesNoVS",
      "status" : "draft",
      "experimental" : false,
      "compose" : {
        "include" : [
          {
            "system" : "http://loinc.org",
            "concept" : [
              {
                "code" : "LA32-8",
                "display" : "NO"
              },
              {
                "code" : "LA33-6",
                "display" : "YES"
              }
            ]
          }
        ]
      }
    },
    {
      "resourceType" : "ValueSet",
      "id" : "YesNoNAVS",
      "status" : "draft",
      "experimental" : false,
      "compose" : {
        "include" : [
          {
            "system" : "http://loinc.org",
            "concept" : [
              {
                "code" : "LA32-8",
                "display" : "NO"
              },
              {
                "code" : "LA33-6",
                "display" : "YES"
              },
              {
                "code" : "LA30226-7",
                "display" : "Not applicable (N/A)"
              }
            ]
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.eu/fhir/ig/pcsp/Questionnaire/FollowupSurPass",
  "version" : "1.0.0",
  "name" : "FollowupSurPass",
  "status" : "draft",
  "subjectType" : ["Patient"],
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "Follow up form.\nThe first Followup-Surpass form must be completed at the same time as the SurPass is delivered or in any case at the first visit after the end of the treatment (OT).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "item" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                "code" : "radio-button"
              }
            ]
          }
        }
      ],
      "linkId" : "first-visit",
      "text" : "First visit?",
      "type" : "choice",
      "required" : true,
      "answerValueSet" : "#YesNoVS"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                "code" : "radio-button"
              }
            ]
          }
        }
      ],
      "linkId" : "consent",
      "text" : "Informed consent to participate in the Followup-SurPass",
      "type" : "choice",
      "enableWhen" : [
        {
          "question" : "first-visit",
          "operator" : "=",
          "answerCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA33-6",
            "display" : "YES"
          }
        }
      ],
      "required" : true,
      "answerValueSet" : "#YesNoVS"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
          "valueBoolean" : true
        },
        {
          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
          "valueExpression" : {
            "language" : "text/fhirpath",
            "expression" : "%resource.item.where(linkId='source-question').answer.first().value"
          }
        }
      ],
      "linkId" : "consent-date",
      "text" : "Consent date",
      "type" : "date",
      "enableWhen" : [
        {
          "question" : "first-visit",
          "operator" : "=",
          "answerCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA33-6",
            "display" : "YES"
          }
        }
      ]
    },
    {
      "linkId" : "visit-date",
      "text" : "Visit date",
      "type" : "date",
      "required" : true
    },
    {
      "linkId" : "new-cancer-after-off-therapy",
      "text" : "Predisposing genetic syndromes or clinical conditions associated with the tumor diagnosed after the first off-therapy",
      "type" : "choice",
      "enableWhen" : [
        {
          "question" : "first-visit",
          "operator" : "=",
          "answerCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA33-6",
            "display" : "YES"
          }
        }
      ],
      "answerValueSet" : "#YesNoVS",
      "item" : [
        {
          "linkId" : "sepcify-new-cancer-txt-1",
          "text" : "If yes, specify",
          "type" : "text",
          "enableWhen" : [
            {
              "question" : "new-cancer-after-off-therapy",
              "operator" : "=",
              "answerCoding" : {
                "system" : "http://loinc.org",
                "code" : "LA33-6",
                "display" : "YES"
              }
            }
          ],
          "required" : true
        }
      ]
    },
    {
      "linkId" : "other-clinical",
      "text" : "Other clinical pictures, not associated with the tumor at the time of diagnosis",
      "type" : "choice",
      "enableWhen" : [
        {
          "question" : "first-visit",
          "operator" : "=",
          "answerCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA33-6",
            "display" : "YES"
          }
        }
      ],
      "answerValueSet" : "#YesNoVS",
      "item" : [
        {
          "linkId" : "sepcify-other-clinical-txt-1",
          "text" : "If yes, specify",
          "type" : "text",
          "enableWhen" : [
            {
              "question" : "other-clinical",
              "operator" : "=",
              "answerCoding" : {
                "system" : "http://loinc.org",
                "code" : "LA33-6",
                "display" : "YES"
              }
            }
          ],
          "required" : true
        }
      ]
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                "code" : "radio-button"
              }
            ]
          }
        }
      ],
      "linkId" : "new-condition-after-off-therapy",
      "text" : "After the first off therapy the patient experienced one or more pathological conditions",
      "type" : "choice",
      "enableWhen" : [
        {
          "question" : "first-visit",
          "operator" : "=",
          "answerCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA33-6",
            "display" : "YES"
          }
        }
      ],
      "required" : true,
      "answerValueSet" : "#YesNoVS",
      "item" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-maxOccurs",
              "valueInteger" : 15
            }
          ],
          "linkId" : "group-condition-1",
          "text" : "Pathological conditions",
          "type" : "group",
          "enableWhen" : [
            {
              "question" : "new-condition-after-off-therapy",
              "operator" : "=",
              "answerCoding" : {
                "system" : "http://loinc.org",
                "code" : "LA33-6",
                "display" : "YES"
              }
            }
          ],
          "required" : true,
          "repeats" : true,
          "item" : [
            {
              "linkId" : "condition-1",
              "text" : "Condition",
              "type" : "choice",
              "required" : true,
              "answerValueSet" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/cond-test-vs"
            },
            {
              "linkId" : "condition-note-1",
              "type" : "text",
              "readOnly" : true,
              "initial" : [
                {
                  "valueString" : "This space will contain guidance for the selected condition. Content is not yet available."
                }
              ]
            },
            {
              "linkId" : "condition-other-1",
              "text" : "If other, specify",
              "type" : "text",
              "enableWhen" : [
                {
                  "question" : "condition-1",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "1001,99"
                  }
                },
                {
                  "question" : "condition-1",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "2001,99"
                  }
                },
                {
                  "question" : "condition-1",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "2002,99"
                  }
                },
                {
                  "question" : "condition-1",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "2003,99"
                  }
                },
                {
                  "question" : "condition-1",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "3001,99"
                  }
                },
                {
                  "question" : "condition-1",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "4001,99"
                  }
                },
                {
                  "question" : "condition-1",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "4002,99"
                  }
                },
                {
                  "question" : "condition-1",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "4003,99"
                  }
                },
                {
                  "question" : "condition-1",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "5001,99"
                  }
                },
                {
                  "question" : "condition-1",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "5002,99"
                  }
                },
                {
                  "question" : "condition-1",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "5003,99"
                  }
                },
                {
                  "question" : "condition-1",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "6001,99"
                  }
                },
                {
                  "question" : "condition-1",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "6002,99"
                  }
                },
                {
                  "question" : "condition-1",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "6003,99"
                  }
                },
                {
                  "question" : "condition-1",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "6004,99"
                  }
                },
                {
                  "question" : "condition-1",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "6005,99"
                  }
                },
                {
                  "question" : "condition-1",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "6006,99"
                  }
                },
                {
                  "question" : "condition-1",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "7001,99"
                  }
                },
                {
                  "question" : "condition-1",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "7002,99"
                  }
                },
                {
                  "question" : "condition-1",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "7003,99"
                  }
                },
                {
                  "question" : "condition-1",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "8001,99"
                  }
                },
                {
                  "question" : "condition-1",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "8002,99"
                  }
                },
                {
                  "question" : "condition-1",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "8003,99"
                  }
                },
                {
                  "question" : "condition-1",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "8004,99"
                  }
                },
                {
                  "question" : "condition-1",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "8005,99"
                  }
                },
                {
                  "question" : "condition-1",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "9001,99"
                  }
                },
                {
                  "question" : "condition-1",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "9002,99"
                  }
                },
                {
                  "question" : "condition-1",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "10001,99"
                  }
                },
                {
                  "question" : "condition-1",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "10002,99"
                  }
                },
                {
                  "question" : "condition-1",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "11001,99"
                  }
                },
                {
                  "question" : "condition-1",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "11002,99"
                  }
                },
                {
                  "question" : "condition-1",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "12001,99"
                  }
                },
                {
                  "question" : "condition-1",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "13001,99"
                  }
                },
                {
                  "question" : "condition-1",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "13002,99"
                  }
                },
                {
                  "question" : "condition-1",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "14001,99"
                  }
                },
                {
                  "question" : "condition-1",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "15001,99"
                  }
                },
                {
                  "question" : "condition-1",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "15002,99"
                  }
                },
                {
                  "question" : "condition-1",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "15003,99"
                  }
                },
                {
                  "question" : "condition-1",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "15004,99"
                  }
                },
                {
                  "question" : "condition-1",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "16001,99"
                  }
                },
                {
                  "question" : "condition-1",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "16002,99"
                  }
                },
                {
                  "question" : "condition-1",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "16003,99"
                  }
                },
                {
                  "question" : "condition-1",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "16004,99"
                  }
                },
                {
                  "question" : "condition-1",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "17001,99"
                  }
                },
                {
                  "question" : "condition-1",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "17002,99"
                  }
                }
              ],
              "enableBehavior" : "any",
              "required" : true,
              "readOnly" : false
            },
            {
              "linkId" : "appearance-date-1",
              "text" : "Onset date",
              "type" : "date",
              "required" : true
            },
            {
              "linkId" : "condition-grading-1",
              "text" : "Grading m-CTCAE at onset/last visit",
              "type" : "choice",
              "required" : true,
              "answerValueSet" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/grade-test-vs"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "condition-evolution-1",
              "text" : "Evolution",
              "type" : "choice",
              "required" : true,
              "answerOption" : [
                {
                  "valueString" : "Yes, resolved"
                },
                {
                  "valueString" : "No, not resolved"
                }
              ]
            },
            {
              "linkId" : "resolution-date-1",
              "text" : "If yes, date",
              "type" : "date",
              "enableWhen" : [
                {
                  "question" : "condition-evolution-1",
                  "operator" : "=",
                  "answerString" : "Yes, resolved"
                }
              ],
              "enableBehavior" : "any",
              "required" : true
            },
            {
              "linkId" : "new-condition-grading-1",
              "text" : "If changed, new grading",
              "type" : "choice",
              "enableWhen" : [
                {
                  "question" : "condition-evolution-1",
                  "operator" : "=",
                  "answerString" : "No, not resolved"
                }
              ],
              "required" : true,
              "answerValueSet" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/grade-test-vs"
            },
            {
              "linkId" : "details-1",
              "text" : "Details",
              "type" : "text"
            },
            {
              "linkId" : "next-check-1",
              "text" : "Next check-up planned on",
              "type" : "text"
            }
          ]
        }
      ]
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                "code" : "radio-button"
              }
            ]
          }
        }
      ],
      "linkId" : "condition-changed",
      "text" : "Have any pathological conditions that were still present (unresolved) at the previous visit resolved or changed in degree?",
      "type" : "choice",
      "enableWhen" : [
        {
          "question" : "first-visit",
          "operator" : "=",
          "answerCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA32-8",
            "display" : "NO"
          }
        }
      ],
      "required" : true,
      "answerValueSet" : "#YesNoNAVS",
      "item" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-maxOccurs",
              "valueInteger" : 15
            }
          ],
          "linkId" : "group-condition-2",
          "text" : "Pathological conditions",
          "type" : "group",
          "enableWhen" : [
            {
              "question" : "condition-changed",
              "operator" : "=",
              "answerCoding" : {
                "system" : "http://loinc.org",
                "code" : "LA33-6",
                "display" : "YES"
              }
            },
            {
              "question" : "condition-changed",
              "operator" : "=",
              "answerCoding" : {
                "system" : "http://loinc.org",
                "code" : "LA32-8",
                "display" : "NO"
              }
            }
          ],
          "enableBehavior" : "any",
          "required" : true,
          "repeats" : true,
          "item" : [
            {
              "linkId" : "condition-2",
              "text" : "Condition",
              "type" : "choice",
              "required" : true,
              "answerValueSet" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/cond-test-vs"
            },
            {
              "linkId" : "condition-note-2",
              "type" : "text",
              "readOnly" : true,
              "initial" : [
                {
                  "valueString" : "This space will contain guidance for the selected condition. Content is not yet available."
                }
              ]
            },
            {
              "linkId" : "condition-other-2",
              "text" : "If other, specify",
              "type" : "text",
              "enableWhen" : [
                {
                  "question" : "condition-2",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "1001,99"
                  }
                },
                {
                  "question" : "condition-2",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "2001,99"
                  }
                },
                {
                  "question" : "condition-2",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "2002,99"
                  }
                },
                {
                  "question" : "condition-2",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "2003,99"
                  }
                },
                {
                  "question" : "condition-2",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "3001,99"
                  }
                },
                {
                  "question" : "condition-2",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "4001,99"
                  }
                },
                {
                  "question" : "condition-2",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "4002,99"
                  }
                },
                {
                  "question" : "condition-2",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "4003,99"
                  }
                },
                {
                  "question" : "condition-2",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "5001,99"
                  }
                },
                {
                  "question" : "condition-2",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "5002,99"
                  }
                },
                {
                  "question" : "condition-2",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "5003,99"
                  }
                },
                {
                  "question" : "condition-2",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "6001,99"
                  }
                },
                {
                  "question" : "condition-2",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "6002,99"
                  }
                },
                {
                  "question" : "condition-2",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "6003,99"
                  }
                },
                {
                  "question" : "condition-2",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "6004,99"
                  }
                },
                {
                  "question" : "condition-2",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "6005,99"
                  }
                },
                {
                  "question" : "condition-2",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "6006,99"
                  }
                },
                {
                  "question" : "condition-2",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "7001,99"
                  }
                },
                {
                  "question" : "condition-2",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "7002,99"
                  }
                },
                {
                  "question" : "condition-2",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "7003,99"
                  }
                },
                {
                  "question" : "condition-2",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "8001,99"
                  }
                },
                {
                  "question" : "condition-2",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "8002,99"
                  }
                },
                {
                  "question" : "condition-2",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "8003,99"
                  }
                },
                {
                  "question" : "condition-2",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "8004,99"
                  }
                },
                {
                  "question" : "condition-2",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "8005,99"
                  }
                },
                {
                  "question" : "condition-2",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "9001,99"
                  }
                },
                {
                  "question" : "condition-2",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "9002,99"
                  }
                },
                {
                  "question" : "condition-2",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "10001,99"
                  }
                },
                {
                  "question" : "condition-2",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "10002,99"
                  }
                },
                {
                  "question" : "condition-2",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "11001,99"
                  }
                },
                {
                  "question" : "condition-2",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "11002,99"
                  }
                },
                {
                  "question" : "condition-2",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "12001,99"
                  }
                },
                {
                  "question" : "condition-2",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "13001,99"
                  }
                },
                {
                  "question" : "condition-2",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "13002,99"
                  }
                },
                {
                  "question" : "condition-2",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "14001,99"
                  }
                },
                {
                  "question" : "condition-2",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "15001,99"
                  }
                },
                {
                  "question" : "condition-2",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "15002,99"
                  }
                },
                {
                  "question" : "condition-2",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "15003,99"
                  }
                },
                {
                  "question" : "condition-2",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "15004,99"
                  }
                },
                {
                  "question" : "condition-2",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "16001,99"
                  }
                },
                {
                  "question" : "condition-2",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "16002,99"
                  }
                },
                {
                  "question" : "condition-2",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "16003,99"
                  }
                },
                {
                  "question" : "condition-2",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "16004,99"
                  }
                },
                {
                  "question" : "condition-2",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "17001,99"
                  }
                },
                {
                  "question" : "condition-2",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "17002,99"
                  }
                }
              ],
              "enableBehavior" : "any",
              "required" : true,
              "readOnly" : false
            },
            {
              "linkId" : "appearance-date-2",
              "text" : "Onset date",
              "type" : "date",
              "required" : true
            },
            {
              "linkId" : "condition-grading-2",
              "text" : "Grading m-CTCAE at onset/last visit",
              "type" : "choice",
              "required" : true,
              "answerValueSet" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/grade-test-vs"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "condition-evolution-2",
              "text" : "Evolution",
              "type" : "choice",
              "enableWhen" : [
                {
                  "question" : "condition-changed",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://loinc.org",
                    "code" : "LA33-6",
                    "display" : "YES"
                  }
                }
              ],
              "required" : true,
              "answerOption" : [
                {
                  "valueString" : "No, unchanged"
                },
                {
                  "valueString" : "Yes, changed"
                },
                {
                  "valueString" : "Yes, solved"
                }
              ]
            },
            {
              "linkId" : "resolution-date-2",
              "text" : "If yes, date",
              "type" : "date",
              "enableWhen" : [
                {
                  "question" : "condition-evolution-2",
                  "operator" : "=",
                  "answerString" : "Yes, solved"
                }
              ],
              "enableBehavior" : "any",
              "required" : true
            },
            {
              "linkId" : "new-condition-grading-2",
              "text" : "If changed, new grading",
              "type" : "choice",
              "enableWhen" : [
                {
                  "question" : "condition-evolution-2",
                  "operator" : "=",
                  "answerString" : "Yes, changed"
                }
              ],
              "required" : true,
              "answerValueSet" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/grade-test-vs"
            },
            {
              "linkId" : "details-2",
              "text" : "Details",
              "type" : "text"
            },
            {
              "linkId" : "next-check-2",
              "text" : "Next check-up planned on",
              "type" : "text"
            }
          ]
        }
      ]
    },
    {
      "linkId" : "new-cancer-after-last-visit",
      "text" : "After the first off therapy the patient experienced one or more pathological conditions?",
      "type" : "choice",
      "enableWhen" : [
        {
          "question" : "first-visit",
          "operator" : "=",
          "answerCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA32-8",
            "display" : "NO"
          }
        }
      ],
      "answerValueSet" : "#YesNoVS",
      "item" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-maxOccurs",
              "valueInteger" : 15
            }
          ],
          "linkId" : "group-condition-3",
          "text" : "Pathological conditions",
          "type" : "group",
          "enableWhen" : [
            {
              "question" : "new-cancer-after-last-visit",
              "operator" : "=",
              "answerCoding" : {
                "system" : "http://loinc.org",
                "code" : "LA33-6",
                "display" : "YES"
              }
            }
          ],
          "required" : true,
          "repeats" : true,
          "item" : [
            {
              "linkId" : "condition-3",
              "text" : "Condition",
              "type" : "choice",
              "required" : true,
              "answerValueSet" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/cond-test-vs"
            },
            {
              "linkId" : "condition-note-3",
              "type" : "text",
              "readOnly" : true,
              "initial" : [
                {
                  "valueString" : "This space will contain guidance for the selected condition. Content is not yet available."
                }
              ]
            },
            {
              "linkId" : "condition-other-3",
              "text" : "If other, specify",
              "type" : "text",
              "enableWhen" : [
                {
                  "question" : "condition-3",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "1001,99"
                  }
                },
                {
                  "question" : "condition-3",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "2001,99"
                  }
                },
                {
                  "question" : "condition-3",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "2002,99"
                  }
                },
                {
                  "question" : "condition-3",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "2003,99"
                  }
                },
                {
                  "question" : "condition-3",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "3001,99"
                  }
                },
                {
                  "question" : "condition-3",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "4001,99"
                  }
                },
                {
                  "question" : "condition-3",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "4002,99"
                  }
                },
                {
                  "question" : "condition-3",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "4003,99"
                  }
                },
                {
                  "question" : "condition-3",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "5001,99"
                  }
                },
                {
                  "question" : "condition-3",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "5002,99"
                  }
                },
                {
                  "question" : "condition-3",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "5003,99"
                  }
                },
                {
                  "question" : "condition-3",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "6001,99"
                  }
                },
                {
                  "question" : "condition-3",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "6002,99"
                  }
                },
                {
                  "question" : "condition-3",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "6003,99"
                  }
                },
                {
                  "question" : "condition-3",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "6004,99"
                  }
                },
                {
                  "question" : "condition-3",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "6005,99"
                  }
                },
                {
                  "question" : "condition-3",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "6006,99"
                  }
                },
                {
                  "question" : "condition-3",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "7001,99"
                  }
                },
                {
                  "question" : "condition-3",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "7002,99"
                  }
                },
                {
                  "question" : "condition-3",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "7003,99"
                  }
                },
                {
                  "question" : "condition-3",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "8001,99"
                  }
                },
                {
                  "question" : "condition-3",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "8002,99"
                  }
                },
                {
                  "question" : "condition-3",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "8003,99"
                  }
                },
                {
                  "question" : "condition-3",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "8004,99"
                  }
                },
                {
                  "question" : "condition-3",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "8005,99"
                  }
                },
                {
                  "question" : "condition-3",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "9001,99"
                  }
                },
                {
                  "question" : "condition-3",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "9002,99"
                  }
                },
                {
                  "question" : "condition-3",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "10001,99"
                  }
                },
                {
                  "question" : "condition-3",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "10002,99"
                  }
                },
                {
                  "question" : "condition-3",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "11001,99"
                  }
                },
                {
                  "question" : "condition-3",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "11002,99"
                  }
                },
                {
                  "question" : "condition-3",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "12001,99"
                  }
                },
                {
                  "question" : "condition-3",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "13001,99"
                  }
                },
                {
                  "question" : "condition-3",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "13002,99"
                  }
                },
                {
                  "question" : "condition-3",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "14001,99"
                  }
                },
                {
                  "question" : "condition-3",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "15001,99"
                  }
                },
                {
                  "question" : "condition-3",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "15002,99"
                  }
                },
                {
                  "question" : "condition-3",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "15003,99"
                  }
                },
                {
                  "question" : "condition-3",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "15004,99"
                  }
                },
                {
                  "question" : "condition-3",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "16001,99"
                  }
                },
                {
                  "question" : "condition-3",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "16002,99"
                  }
                },
                {
                  "question" : "condition-3",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "16003,99"
                  }
                },
                {
                  "question" : "condition-3",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "16004,99"
                  }
                },
                {
                  "question" : "condition-3",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "17001,99"
                  }
                },
                {
                  "question" : "condition-3",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
                    "code" : "17002,99"
                  }
                }
              ],
              "enableBehavior" : "any",
              "required" : true,
              "readOnly" : false
            },
            {
              "linkId" : "appearance-date-3",
              "text" : "Onset date",
              "type" : "date",
              "required" : true
            },
            {
              "linkId" : "condition-grading-3",
              "text" : "Grading m-CTCAE at onset/last visit",
              "type" : "choice",
              "required" : true,
              "answerValueSet" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/grade-test-vs"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "condition-evolution-3",
              "text" : "Evolution",
              "type" : "choice",
              "required" : true,
              "answerOption" : [
                {
                  "valueString" : "Yes, resolved"
                },
                {
                  "valueString" : "No, not resolved"
                }
              ]
            },
            {
              "linkId" : "resolution-date-3",
              "text" : "If yes, date",
              "type" : "date",
              "enableWhen" : [
                {
                  "question" : "condition-evolution-3",
                  "operator" : "=",
                  "answerString" : "Yes, resolved"
                }
              ],
              "enableBehavior" : "any",
              "required" : true
            },
            {
              "linkId" : "new-condition-grading-3",
              "text" : "If changed, new grading",
              "type" : "choice",
              "enableWhen" : [
                {
                  "question" : "condition-evolution-3",
                  "operator" : "=",
                  "answerString" : "No, not resolved"
                }
              ],
              "required" : true,
              "answerValueSet" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/grade-test-vs"
            },
            {
              "linkId" : "details-3",
              "text" : "Details",
              "type" : "text"
            },
            {
              "linkId" : "next-check-3",
              "text" : "Next check-up planned on",
              "type" : "text"
            }
          ]
        }
      ]
    },
    {
      "linkId" : "notes",
      "text" : "Notes",
      "type" : "string",
      "required" : false
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/maxSize",
          "valueDecimal" : 5
        }
      ],
      "linkId" : "notes-attachments",
      "text" : "Reports relating to significant laboratory instrumental tests",
      "type" : "attachment",
      "required" : false,
      "repeats" : true
    }
  ]
}

```
