# Mainz - Procedure: Transfusion (Zeisig) - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Mainz - Procedure: Transfusion (Zeisig)**

## Example Procedure: Mainz - Procedure: Transfusion (Zeisig)

Profile: [Procedure: Transfusion other infos](StructureDefinition-Procedure-transfusion-otherinfos-eu-pcsp.md)

**Performed Timing**: Once

**status**: Completed

**code**: Transfusion

**subject**: [Sarah Zeisig Female, DoB: 1996-12-12 ( http://hl7.eu/fhir/ig/pcsp/sid/pat-id-mainz#L0010)](Patient-PatientMainzZeisig.md)

**reasonReference**: [Condition Leukemias, myeloproliferative diseases, and myelodysplastic diseases](Condition-ConditionPrimCancerMainzZeisig.md)



## Resource Content

```json
{
  "resourceType" : "Procedure",
  "id" : "ProcedureTransfusion-1",
  "meta" : {
    "profile" : [
      "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-transfusion-otherinfos-eu-pcsp"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/procedure-performedTiming",
      "valueTiming" : {
        "repeat" : {
          "boundsRange" : {
            "low" : {
              "value" : 9
            }
          }
        }
      }
    }
  ],
  "status" : "completed",
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "5447007",
        "display" : "Transfusion"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/PatientMainzZeisig"
  },
  "reasonReference" : [
    {
      "reference" : "Condition/ConditionPrimCancerMainzZeisig"
    }
  ]
}

```
