# Mainz - Procedure: Stem Cell Transplantation (Zeisig) - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Mainz - Procedure: Stem Cell Transplantation (Zeisig)**

## Example Procedure: Mainz - Procedure: Stem Cell Transplantation (Zeisig)

Profile: [Procedure: Stem Cell Transplantation](StructureDefinition-Procedure-sct-eu-pcsp.md)

**Procedure Used Reference**: [BiologicallyDerivedProduct: extension = matched related,PBSC; productCategory = cells](BiologicallyDerivedProduct-BiologicallyDerivedProduct-SCT1.md)

**status**: Completed

**category**: Transplantation

**code**: Negative for Chlamydia Trachomatis rRNA

**subject**: [Sarah Zeisig Female, DoB: 1996-12-12 ( http://hl7.eu/fhir/ig/pcsp/sid/pat-id-mainz#L0010)](Patient-PatientMainzZeisig.md)

**performed**: 2018-05-16

**location**: [Location Universitätsklinikum Schleswig-Holstein - Campus Lübeck](Location-Location-SCT1.md)

**reasonReference**: [Condition Leukemias, myeloproliferative diseases, and myelodysplastic diseases](Condition-ConditionPrimCancerMainzZeisig.md)



## Resource Content

```json
{
  "resourceType" : "Procedure",
  "id" : "ProcedureSTC-1",
  "meta" : {
    "profile" : [
      "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-sct-eu-pcsp"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/procedure-usedReference",
      "valueReference" : {
        "reference" : "BiologicallyDerivedProduct/BiologicallyDerivedProduct-SCT1"
      }
    }
  ],
  "status" : "completed",
  "category" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "77465005",
        "display" : "Transplantation"
      }
    ]
  },
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "53088000",
        "display" : "Autogenous transplantation"
      }
    ],
    "text" : "Negative for Chlamydia Trachomatis rRNA"
  },
  "subject" : {
    "reference" : "Patient/PatientMainzZeisig"
  },
  "performedDateTime" : "2018-05-16",
  "location" : {
    "reference" : "Location/Location-SCT1"
  },
  "reasonReference" : [
    {
      "reference" : "Condition/ConditionPrimCancerMainzZeisig"
    }
  ]
}

```
