# Cineca - Clinical Protocol - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Cineca - Clinical Protocol**

## PlanDefinition: Cineca - Clinical Protocol 

| | |
| :--- | :--- |
| *Official URL*:https://psp-sp-fhir.dev.sanit.cineca.it/fhir/PlanDefinition/3976 | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*: |

 
Clinical protocol for the CINECA project 

* **Type:**: **Url:**
  * **system:**[http://terminology.hl7.org/CodeSystem/plan-definition-type](http://terminology.hl7.org/6.5.0/CodeSystem-plan-definition-type.html)**code:**clinical-protocol: [Cineca - Clinical Protocol](PlanDefinition-3976.md)
* **Type:**: **Version:**
  * **system:**[http://terminology.hl7.org/CodeSystem/plan-definition-type](http://terminology.hl7.org/6.5.0/CodeSystem-plan-definition-type.html)**code:**clinical-protocol: 1.0.0
* **Type:**: **Title:**
  * **system:**[http://terminology.hl7.org/CodeSystem/plan-definition-type](http://terminology.hl7.org/6.5.0/CodeSystem-plan-definition-type.html)**code:**clinical-protocol: Cineca - Clinical Protocol
* **Type:**: **Date:**
  * **system:**[http://terminology.hl7.org/CodeSystem/plan-definition-type](http://terminology.hl7.org/6.5.0/CodeSystem-plan-definition-type.html)**code:**clinical-protocol: 2025-10-16 12:02:24+0000
* **Type:**: **Publisher:**
  * **system:**[http://terminology.hl7.org/CodeSystem/plan-definition-type](http://terminology.hl7.org/6.5.0/CodeSystem-plan-definition-type.html)**code:**clinical-protocol: PanCareSurPass Project
* **Type:**: **Description:**
  * **system:**[http://terminology.hl7.org/CodeSystem/plan-definition-type](http://terminology.hl7.org/6.5.0/CodeSystem-plan-definition-type.html)**code:**clinical-protocol: Clinical protocol for the CINECA project
* **Type:**: **Jurisdiction:**
  * **system:**[http://terminology.hl7.org/CodeSystem/plan-definition-type](http://terminology.hl7.org/6.5.0/CodeSystem-plan-definition-type.html)**code:**clinical-protocol: 150



## Resource Content

```json
{
  "resourceType" : "PlanDefinition",
  "id" : "3976",
  "meta" : {
    "profile" : [
      "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/PlanDefinition-flt-eu-pcsp"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/procedure-fltArm",
      "valueString" : "GROUP"
    }
  ],
  "url" : "https://psp-sp-fhir.dev.sanit.cineca.it/fhir/PlanDefinition/3976",
  "version" : "1.0.0",
  "title" : "Cineca - Clinical Protocol",
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/plan-definition-type",
        "code" : "clinical-protocol"
      }
    ]
  },
  "status" : "active",
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "Clinical protocol for the CINECA project",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ]
}

```
