# Cineca - Patient: Sample of Patient (Rossi) - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Cineca - Patient: Sample of Patient (Rossi)**

## Example Patient: Cineca - Patient: Sample of Patient (Rossi)

Profile: [Patient: PCSP](StructureDefinition-Patient-eu-pcsp.md)

MARIO ROSSI Male, DoB: 1985-11-11 ( http://hl7.eu/fhir/ig/pcsp/sid/pat-id-cineca#223)

-------

| | |
| :--- | :--- |
| Parent: | * [d.saraceno@cineca.it](mailto:d.saraceno@cineca.it)
* ph: 398593
 |
| [Patient Birth Place](http://hl7.org/fhir/extensions/5.2.0/StructureDefinition-patient-birthPlace.html) | ROSIGNANO MARITTIMO |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "PatientCineca",
  "meta" : {
    "profile" : [
      "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Patient-eu-pcsp"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/patient-birthPlace",
      "valueAddress" : {
        "city" : "ROSIGNANO MARITTIMO"
      }
    }
  ],
  "identifier" : [
    {
      "system" : "http://hl7.eu/fhir/ig/pcsp/sid/pat-id-cineca",
      "value" : "223"
    }
  ],
  "name" : [
    {
      "family" : "ROSSI",
      "given" : ["MARIO"]
    }
  ],
  "gender" : "male",
  "birthDate" : "1985-11-11",
  "contact" : [
    {
      "relationship" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
              "code" : "PRN",
              "display" : "Parent"
            }
          ]
        }
      ],
      "telecom" : [
        {
          "system" : "email",
          "value" : "d.saraceno@cineca.it"
        },
        {
          "system" : "phone",
          "value" : "398593"
        }
      ]
    }
  ]
}

```
