# Hulafe - MedicationAdministration: Chemotherapy Ciclofosfamide - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Hulafe - MedicationAdministration: Chemotherapy Ciclofosfamide**

## Example MedicationAdministration: Hulafe - MedicationAdministration: Chemotherapy Ciclofosfamide

Profile: [MedicationAdministration: Chemotherapy](StructureDefinition-MedicationAdministration-eu-pcsp.md)

**Act Location**: [Location Hospital la Fe](Location-ChemoHulafe-1-Location.md)

**Resource related information**: [Observation Cumulative dose received by a patient for a specific drug.](Observation-ChemoHulafe-1-Ciclofosfamide-dose.md)

**status**: Completed

**medication**: cyclophosphamide

**subject**: [NOMBRE APELLIDO1 APELLIDO2(anonymous) Female, DoB: 2005-07-01 ( urn:oid:2.16.724.4.10.50.200#123456789 (use: official, ))](Patient-PatientHulafe-1.md)

**effective**: 2012-08-08 --> 2012-10-11

**reasonReference**: [Condition un-encoded](Condition-PrimaryCancerHulafe-1.md)



## Resource Content

```json
{
  "resourceType" : "MedicationAdministration",
  "id" : "ChemoHulafe-1-Ciclofosfamide",
  "meta" : {
    "profile" : [
      "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/MedicationAdministration-eu-pcsp"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/event-location",
      "valueReference" : {
        "reference" : "Location/ChemoHulafe-1-Location"
      }
    },
    {
      "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/resource-relatedInfo",
      "valueReference" : {
        "reference" : "Observation/ChemoHulafe-1-Ciclofosfamide-dose"
      }
    }
  ],
  "status" : "completed",
  "medicationCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://www.whocc.no/atc",
        "code" : "L01AA01",
        "display" : "cyclophosphamide"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/PatientHulafe-1",
    "type" : "Patient"
  },
  "effectivePeriod" : {
    "start" : "2012-08-08",
    "end" : "2012-10-11"
  },
  "reasonReference" : [
    {
      "reference" : "Condition/PrimaryCancerHulafe-1"
    }
  ]
}

```
