# Hulafe - Condition: Primary Diagnosis - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Hulafe - Condition: Primary Diagnosis**

## Example Condition: Hulafe - Condition: Primary Diagnosis

Language: es-ES

Profile: [Condition: Primary Cancer](StructureDefinition-Condition-primaryCancer-eu-pcsp.md)

**Condition Asserted Date**: 2021

**Histology-Morphology-Behavior Extension**: 8260/3 - Carcinoma papilar de tiroides

**code**: Carcinoma tiroides

**bodySite**: C73.9

**subject**: [NOMBRE APELLIDO1 APELLIDO2(anonymous) Female, DoB: 2005-07-01 ( urn:oid:2.16.724.4.10.50.200#123456789 (use: official, ))](Patient-PatientHulafe-1.md)

**encounter**: [Encounter: status = finished; class = ambulatory (ActCode#AMB)](Encounter-EncHulafe-1.md)

### Stages

| | |
| :--- | :--- |
| - | **Summary** |
| * | pT1a |

**note**: 

> 

Alergia al epitelio de gato




## Resource Content

```json
{
  "resourceType" : "Condition",
  "id" : "PrimaryCancerHulafe-1",
  "meta" : {
    "profile" : [
      "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-primaryCancer-eu-pcsp"
    ]
  },
  "language" : "es-ES",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/condition-assertedDate",
      "valueDateTime" : "2021"
    },
    {
      "url" : "http://hl7.org/fhir/us/mcode/StructureDefinition/mcode-histology-morphology-behavior",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/icd-o-3",
            "code" : "8260/3",
            "display" : "8260/3 - Carcinoma papilar de tiroides"
          }
        ]
      }
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-NullFlavor",
        "code" : "UNC",
        "display" : "un-encoded"
      }
    ],
    "text" : "Carcinoma tiroides"
  },
  "bodySite" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/mcode-laterality-qualifier",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-NullFlavor",
                "code" : "NA",
                "display" : "Not Applicable"
              }
            ]
          }
        }
      ],
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/icd-o-3",
          "code" : "C73.9",
          "display" : "C73.9 - Tiroides"
        }
      ],
      "text" : "C73.9"
    }
  ],
  "subject" : {
    "reference" : "Patient/PatientHulafe-1",
    "type" : "Patient"
  },
  "encounter" : {
    "reference" : "Encounter/EncHulafe-1",
    "type" : "Encounter"
  },
  "stage" : [
    {
      "summary" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-NullFlavor",
            "code" : "UNC",
            "display" : "un-encoded"
          }
        ],
        "text" : "pT1a"
      }
    }
  ],
  "note" : [
    {
      "text" : "Alergia al epitelio de gato"
    }
  ]
}

```
