# Mainz - Condition: complete Primary Cancer Condition example (TBC) (Zeisig) - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Mainz - Condition: complete Primary Cancer Condition example (TBC) (Zeisig)**

## Example Condition: Mainz - Condition: complete Primary Cancer Condition example (TBC) (Zeisig)

Profile: [Condition: Primary Cancer](StructureDefinition-Condition-primaryCancer-eu-pcsp.md)

**Condition Asserted Date**: 2007-04-04

**Histology-Morphology-Behavior Extension**: 9181/3

**code**: Leukemias, myeloproliferative diseases, and myelodysplastic diseases

**bodySite**: C401

**subject**: [Sarah Zeisig Female, DoB: 1996-12-12 ( http://hl7.eu/fhir/ig/pcsp/sid/pat-id-mainz#L0010)](Patient-PatientMainzZeisig.md)

**encounter**: [Encounter: status = finished; class = ambulatory (ActCode#AMB); period = 2007-07-07 --> (ongoing)](Encounter-EncounterPrimCancerMainzZeisig.md)

### Stages

| | |
| :--- | :--- |
| - | **Summary** |
| * | textual description of stage |

> **evidence****detail**:[Observation Diagnosis](Observation-ObservationPrimCancerMainzZeisig.md)

> **evidence****code**:Textual description of Genetic markers

> **evidence****code**:Textual description of Immunology

> **evidence****code**:Textual description of hereditary predisposition



## Resource Content

```json
{
  "resourceType" : "Condition",
  "id" : "ConditionPrimCancerMainzZeisig",
  "meta" : {
    "profile" : [
      "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-primaryCancer-eu-pcsp"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/condition-assertedDate",
      "valueDateTime" : "2007-04-04"
    },
    {
      "url" : "http://hl7.org/fhir/us/mcode/StructureDefinition/mcode-histology-morphology-behavior",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/icd-o-3",
            "code" : "9181/3"
          }
        ]
      }
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/iccc-3",
        "code" : "081"
      }
    ]
  },
  "bodySite" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/mcode-laterality-qualifier",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://loinc.org",
                "code" : "LA4585-1",
                "display" : "Left"
              }
            ]
          }
        }
      ],
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/icd-o-3",
          "code" : "C401"
        }
      ]
    }
  ],
  "subject" : {
    "reference" : "Patient/PatientMainzZeisig"
  },
  "encounter" : {
    "reference" : "Encounter/EncounterPrimCancerMainzZeisig"
  },
  "stage" : [
    {
      "summary" : {
        "text" : "textual description of stage"
      }
    }
  ],
  "evidence" : [
    {
      "detail" : [
        {
          "reference" : "Observation/ObservationPrimCancerMainzZeisig"
        }
      ]
    },
    {
      "code" : [
        {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "106221001",
              "display" : "Genetic finding"
            }
          ],
          "text" : "Textual description of Genetic markers"
        }
      ]
    },
    {
      "code" : [
        {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "365861007",
              "display" : "Finding of immune status"
            }
          ],
          "text" : "Textual description of Immunology"
        }
      ]
    },
    {
      "code" : [
        {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "32895009",
              "display" : "Hereditary disease"
            }
          ],
          "text" : "Textual description of hereditary predisposition"
        }
      ]
    }
  ]
}

```
