# Mainz - Condition: Primary Cancer (Fischer) - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Mainz - Condition: Primary Cancer (Fischer)**

## Example Condition: Mainz - Condition: Primary Cancer (Fischer)

Profile: [Condition: Primary Cancer](StructureDefinition-Condition-primaryCancer-eu-pcsp.md)

**Condition Asserted Date**: 1994-04-21

**Histology-Morphology-Behavior Extension**: 9510/3

**code**: NoInformation

**bodySite**: C692

**subject**: [Christian Fischer Male, DoB: 1993-07-07 ( http://hl7.eu/fhir/ig/pcsp/sid/pat-id-mainz#L0002)](Patient-PatientMainzFischer.md)

**encounter**: [Encounter: status = finished; class = ambulatory (ActCode#AMB); period = 1994-04-21 --> (ongoing)](Encounter-EncounterPrimCancerMainzFischer.md)



## Resource Content

```json
{
  "resourceType" : "Condition",
  "id" : "ConditionPrimCancerMainzFischer",
  "meta" : {
    "profile" : [
      "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-primaryCancer-eu-pcsp"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/condition-assertedDate",
      "valueDateTime" : "1994-04-21"
    },
    {
      "url" : "http://hl7.org/fhir/us/mcode/StructureDefinition/mcode-histology-morphology-behavior",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/icd-o-3",
            "code" : "9510/3"
          }
        ]
      }
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-NullFlavor",
        "code" : "NI"
      }
    ]
  },
  "bodySite" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/icd-o-3",
          "code" : "C692"
        }
      ]
    }
  ],
  "subject" : {
    "reference" : "Patient/PatientMainzFischer"
  },
  "encounter" : {
    "reference" : "Encounter/EncounterPrimCancerMainzFischer"
  }
}

```
