# PCSP Recommendations - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PCSP Recommendations**

## CodeSystem: PCSP Recommendations 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-recommendation-eu-pcsp | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:CsRecomandationPcsp |

 
Recommendations proposed by the PCSP algorithm 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Recommendation](ValueSet-vs-recommendation-eu-pcsp.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "cs-recommendation-eu-pcsp",
  "url" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-recommendation-eu-pcsp",
  "version" : "1.0.0",
  "name" : "CsRecomandationPcsp",
  "title" : "PCSP Recommendations",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "Recommendations proposed by the PCSP algorithm",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 47,
  "concept" : [
    {
      "code" : "1",
      "display" : "Perform appropriate thyroid screening from the fifth year after the end of radiotherapy. Discuss with your doctor whether to schedule: Clinical thyroid examination every 1-2 years; or Thyroid ultrasound every 3-5 years.",
      "definition" : "Subsequent thyroid cancer"
    },
    {
      "code" : "2",
      "display" : "Perform Mammography and Breast magnetic resonance imaging (MRI) should be performed annually from the eighth year after the end of radiotherapy, but not before the age of 25. These examinations should be continued until at least age 60.",
      "definition" : "Subsequent breast cancer"
    },
    {
      "code" : "3",
      "display" : "Perform: Cardiological evaluation at the end of treatment and every 2-3 years thereafter; Electrocardiogram (ECG) at the end of treatment, to be repeated at the age of 18 and cardiological evaluation in case of palpitations, dizziness and/or fainting/loss of consciousness. Echocardiogram 2 years after the end of treatment, to be repeated every 2-3 years; If female, echocardiogram in the first trimester of pregnancy.",
      "definition" : "Cardiac problems (Cardiomyopathy and/or Valvular disease and/or Cardiac ischemia)"
    },
    {
      "code" : "4",
      "display" : "Perform a spermiogram once the process of puberty is complete (if desired and if the patient wants to evaluate possibility to have children in the future).",
      "definition" : "Impaired fertility Impaired spermatogenesis"
    },
    {
      "code" : "5",
      "display" : "During the stages of puberty: Perform annual clinical check-ups (if clinically necessary, every six months) in order to assess growth rate and pubertal development. Once the process of puberty is complete: Test testosterone levels early in the morning every 2-3 years. If this is not possible, perform LH blood dosage.",
      "definition" : "Testosterone deficiency"
    },
    {
      "code" : "6",
      "display" : "An andrological examination should be performed if symptoms attributable to sexual dysfunction appear.",
      "definition" : "Physical sexual dysfunction"
    },
    {
      "code" : "7",
      "display" : "In girls: Perform at least once a year a clinical check-up to assess height, weight and pubertal development (breast growth). In case of abnormal or no pubertal development, check FSH and 17betaestradiol levels. In women who have already had their first menstrual cycle: Monitor the regularity of menstrual cycles. In case of irregular cycles (less than 21 days or more than 35 days) or if you have not had a cycle for at least 4 months, we recommend a blood test for FSH and estradiol and an endocrine/gynaecological check-up. These examinations are also recommended if you wish to find out about your fertility status.",
      "definition" : "Premature ovarian insufficiency"
    },
    {
      "code" : "8",
      "display" : "Perform an audiometry evaluation: every year until 6 years of age every 2 years until 12 years of age every 5 years thereafter. In addition, an otorhinolaryngological evaluation should be performed in case of tinnitus (ringing/whistling in the ear).",
      "definition" : "Ear problems"
    },
    {
      "code" : "9",
      "display" : "Check blood glucose levels and glycosylated haemoglobin levels at least every 5 years.",
      "definition" : "Impaired glucose metabolism and diabetes melitus"
    },
    {
      "code" : "10",
      "display" : "Check total cholesterol, HDL, LDL and triglycerides levels (lipid profile) at least every 5 years.",
      "definition" : "Dyslipidemia"
    },
    {
      "code" : "11",
      "display" : "Check your weight and height and then calculate your BMI (body mass index) every 2 years (normal adult values 18.5-24.9).",
      "definition" : "Overweight and obesity"
    },
    {
      "code" : "12",
      "display" : "Check blood pressure at least every 2 years and at every medical examination.",
      "definition" : "Hypertension"
    },
    {
      "code" : "13",
      "display" : "Maintain an adequate intake of calcium and vitamin D. Sunlight exposure and regular physical activity. Bone densitometry (DEXA) should be performed at least once. In prepubertal or pubertal children, consider postponing DEXA until the end of puberty. Report any persistent back pain and/or accidental fractures to your doctor.",
      "definition" : "Reduced bone mineral density"
    },
    {
      "code" : "14",
      "display" : "Report any persistent bone pain (particularly joint pain) to your doctor.",
      "definition" : "Osteonecrosis"
    },
    {
      "code" : "15",
      "display" : "Follow any indications already proposed by the endocrinologist; otherwise, perform an endocrinological examination as soon as possible.",
      "definition" : "Hypothalamic-pituitary (HP) axis problems (High risk) Growth hormone deficiency (GHD) TSH deficiency (TSHD) LH/FSH deficiency (LH/FSHD) ACTH deficiency (ACTHD)"
    },
    {
      "code" : "16",
      "display" : "In prepubertal period: Perform clinical check-up every 6 months to assess growth velocity and pubertal development. Measure fT4, TSH, and cortisol levels early in the morning every year; in case of lack of progression of pubertal development also check FSH and LH levels. In the post-pubertal period: - Perform a clinical check-up every year and in women also check the regularity of the menstrual cycle. - Check blood values of fT4, TSH, LH, FSH, iGF1 and cortisol early in the morning every year. - In men, also check total and free testosterone. - In women also check 17-beta estradiol Continue these check-ups for at least 15 years after diagnosis.",
      "definition" : "Hypothalamic-pituitary (HP) axis problems (Standard risk) Growth hormone deficiency (GHD) TSH deficiency (TSHD) LH/FSH deficiency (LH/FSHD) ACTH deficiency (ACTHD)"
    },
    {
      "code" : "17",
      "display" : "A clinical check-up for growth rate and pubertal development (tanner) should be peformed every 6 months until the age of 8.",
      "definition" : "Central precocious puberty (CPP) For girls with age below 8 years"
    },
    {
      "code" : "18",
      "display" : "Perform a clinical check-up every 6 months until the age of 9 to assess growth rate and pubertal development (tanner). Measure testosterone levels in the morning before 10:00 a.m. once a year until age 9.",
      "definition" : "Central precocious puberty (CPP) For boys with age below 9 yearss"
    },
    {
      "code" : "19",
      "display" : "Thyroid hormones (fT4 and TSH) should be tested at least once a year until the age of 18 and every 2-3 years after 18. If female, these tests should also be perform before and during pregnancy. In case of a total thyroidectomy, it is recommended to follow the endocrinologist's indications.",
      "definition" : "Thyroid function problems"
    },
    {
      "code" : "20",
      "display" : "Maintain a healthy lifestyle and alert your doctor immediately in case of sudden onset of neurological symptoms (e.g. acute and/or persistent headache, visual disturbances, strength deficit)",
      "definition" : "Cerebrovascular problem"
    },
    {
      "code" : "21",
      "display" : "Pay attention to the following disorders: attention, language, learning, visual-motor coordination, memory or behavioural disorders. In these cases, perform a neuropsychological assessment.",
      "definition" : "Neurocognitive problems"
    },
    {
      "code" : "22",
      "display" : "Contact your doctor if you experience persistent pain, tingling, reduced strength and/or sensation in your limbs.",
      "definition" : "Peripheral neuropathy"
    },
    {
      "code" : "23",
      "display" : "Have an ophtalmological examination every 5 years",
      "definition" : "Cataract"
    },
    {
      "code" : "24",
      "display" : "An ophtalmological examinationshould be performed at least every 5 years, and in case of eye dryness, pain or irritation and/or visual disturbances.",
      "definition" : "Eye problems"
    },
    {
      "code" : "25",
      "display" : "Perform a maxillofacial evaluation if there are any aesthetic or functional abnormalities of the head and/or face.",
      "definition" : "Craniofacial growth problems"
    },
    {
      "code" : "26",
      "display" : "Perform a clinical assessment of the spine at every medical evaluation and at least every year during pubertal development. Consult an orthopaedic specialist only if abnormalities are detected.",
      "definition" : "Spine scoliosis and kyphosis"
    },
    {
      "code" : "27",
      "display" : "Watch out for urinary symptoms (e.g. frequent urination, painful urination, urinary retention or blood in urine). If any of these symptoms occur, perform a urine test and urine culture and, if necessary, a urine cytology test. If the tests are pathological, a urological evaluation should be performed.",
      "definition" : "Lower urinary tract problems"
    },
    {
      "code" : "28",
      "display" : "Perform appropriate obstetrical follow-up in case of pregnancy,",
      "definition" : "Obstetric problems"
    },
    {
      "code" : "29",
      "display" : "Careful dental hygiene, and a dental examination in case of oral problems such as caries (tooth decay), abnormal tooth development or dry mouth.",
      "definition" : "Dental and oral problems"
    },
    {
      "code" : "30",
      "display" : "A gastroenterological evaluation should be performed in case of persistent abdominal symptoms such as abdominal pain, nausea, vomiting or bowel evacuation disorders.",
      "definition" : "Gastro-intestinal problems"
    },
    {
      "code" : "31",
      "display" : "Perform an ECG after the end of treatment and in any case repeat it after the age of 18, and perform a cardiological assessment if palpitations, dizziness and/or fainting/loss of consciousness occur.",
      "definition" : "Arrhythmia"
    },
    {
      "code" : "32",
      "display" : "Avoid active and passive smoking; Get annual flu and pneumococcal vaccines as indicated by your pediatrician/general practitioner; Perform a spirometry and carbon monoxide diffusion assessment (DLCO) at least once after the end of treatment and to be repeated in case of abnormalities; A clinical chest check-up must be performed by your pediatrician/ general practitioner at least every 5 years.",
      "definition" : "Pulmonary problems"
    },
    {
      "code" : "33",
      "display" : "Perform every 5 years: Urinalysis for creatinuria, proteinuria, glycosuria and phosphaturia; Blood test for creatinine, ionogram, albumin, and calculation of glomerular filtration rate (GFR).",
      "definition" : "Renal problems (Glomerular dysfunction - Tubular dysfunction)"
    },
    {
      "code" : "34",
      "display" : "Regular clinical evaluation for signs and symptoms of liver dysfunction (e.g. hepatomegaly, spider nevi or pruritus). Transaminases, gammaGT and alkaline phosphatase should be measured at least once after treatment ends. In case of an increase in liver enzyme values: if between 1-2 times the normal value: repeat the test within 1 year. If more than 2 times the normal value: repeat the test within 2 months. In case of persistent liver abnormalities: Ask a hepatologist or gastroenterologist for further indications. If there is no obvious explanation (alcohol, medication, obesity) Avoid or use with caution potentially hepatotoxic drugs and supplements Consider immunisation against hepatitis A and B, if not already immune in case of chronic HBV / HCV infections discuss precautions to reduce viral transmission to family and sexual partners",
      "definition" : "Liver problems"
    },
    {
      "code" : "35",
      "display" : "Perform the serum ferritin assay at least once after the end of treatment. Repeat test within 6 months if serum ferritin is above 500 ng/ml. In case of persistent hyperferritinemia, perform an MRI scan to quantify the iron content in the liver. If the latter is confirmed, ask a haematologist about the appropriate treatment (such as phlebotomy or chelation therapy).",
      "definition" : "Iron overload"
    },
    {
      "code" : "36",
      "display" : "Complete the mandatory vaccination calendar and have pneumococcal, meningococcal and Haemophilus Influenzae vaccinations. Start broad-spectrum antibiotic therapy as soon as possible in case of: fever >38.3°C, animal bite with skin lesions, or other symptoms of severe infection (sepsis) such as cold/chills, low blood pressure, mental confusion and signs of rigidity. In such cases, blood count and blood culture should be performed immediately if possible. If travelling abroad, contact your local health authorities for information on the need for any prophylactic vaccinations.",
      "definition" : "Spleen problems"
    },
    {
      "code" : "37",
      "display" : "Genetic counselling (if not already performed) to determine any further screening tests.",
      "definition" : "Tumor predisposition"
    },
    {
      "code" : "38",
      "display" : "Protect yourself from the sun rays with highly protective sunscreen, especially on areas of the body that have been exposed to radiotherapy. Constantly check your skin paying attention to the appearance of new moles and/or changes in colour and size of those already present. Perform a dermatological check-up for mole mapping at least every 2 years.",
      "definition" : "Subsequent melanoma and non-melanoma skin cancer"
    },
    {
      "code" : "39",
      "display" : "Check for occult blood in stool every three years from the age of 30. If the test is positive, a colonoscopy should be performed.",
      "definition" : "Subsequent colorectal cancer"
    },
    {
      "code" : "40",
      "display" : "Have proper dental hygiene and pay attention to the appearance of any lesions inside the mouth.",
      "definition" : "Subsequent Oral Cancer"
    },
    {
      "code" : "41",
      "display" : "Check blood count in case of petechiae, intense pallor, persistent bone pain and/or fatigue.",
      "definition" : "Subsequent acute myeloid leukaemia or myelodysplasia"
    },
    {
      "code" : "42",
      "display" : "If there is blood in urine or burning sensation during urination, a cytological and chemical urinalysis should be performed. If pathological, perform a urological examination.",
      "definition" : "Subsequent bladder cancer"
    },
    {
      "code" : "43",
      "display" : "X-ray should be performed if swelling and/or persistent bone pain appears.",
      "definition" : "Subsequent Bone Cancer"
    },
    {
      "code" : "44",
      "display" : "Chest X-ray in case of persistent respiratory distress.",
      "definition" : "Subsequent lung cancer"
    },
    {
      "code" : "45",
      "display" : "Pay attention to the appearance of any neurological symptoms (e.g. persistent headache, visual disturbances, strength deficits) and report them to your doctor to discuss whether a neuro-radiological examination is necessary.",
      "definition" : "Subsequent CNS neoplasms"
    },
    {
      "code" : "46",
      "display" : "Perform: Cardiological examination at the end of treatment and every 5 years thereafter; Electrocardiogram (ECG) at the end of treatment, to be repeated at the age of 18 and cardiological evaluation in case of palpitations, dizziness and/or fainting/loss of consciousness. Echocardiogram 2 years after the end of treatment, to be repeated every 5 years; If female, echocardiogram in the first trimester of pregnancy.",
      "definition" : "Cardiac problems (Cardiomyopathy and/or Valvular disease and/or Cardiac ischemia)"
    },
    {
      "code" : "47",
      "display" : "Perform every 5 years: Urinalysis for creatinuria, proteinuria. Blood test for creatininemia and calculation of glomerular filtration rate (GFR). In case of nephrectomy, non-steroidal anti-inflammatory drugs should be used with caution.",
      "definition" : "Renal problems (Tubular dysfunction)"
    }
  ]
}

```
