# Logical Models - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* **Logical Models**

## Logical Models

### SurPass Overview

The Survivorship Passport (SurPass) is a digital tool based on international clinical guidelines that provides childhood cancer survivors (CCS) and health care professionals (HCPs) with the information needed for long-term follow-up survivorship care, better health promotion, improved late effects management and secondary cancer prevention. The SurPass provides an overview of all relevant personal health data related to the cancer treatment of CCS (e.g. demographics, cancer diagnosis, therapeutic management etc.) in a Treatment Summary together with a personalized Survivorship Care Plan.

### HL7 FHIR Models

The following table summarizes the logical models used by this guide.

| | | |
| :--- | :--- | :--- |
| **Name** | **Title** | **Description** |
| [Chemotherapy](StructureDefinition-Chemotherapy.md) | Chemotherapy | Chemotherapy |
| [Diagnosis](StructureDefinition-Diagnosis.md) | Diagnosis | Diagnosis |
| [DocMetadataFSE](StructureDefinition-DocMetadataFSE.md) | Metadata FSE Italy | Metadata FSE Italy. |
| [FrontLineTreatment](StructureDefinition-FrontLineTreatment.md) | Front Line Treatment | Front Line Treatment. The first treatment given for a disease. It is often part of a standard set of treatments, such as surgery followed by chemotherapy and radiation. When used by itself, first-line therapy is the one accepted as the best treatment. If it does not cure the disease or it causes severe side effects, other treatment may be added or used instead. Also called induction therapy, primary therapy, and primary treatment. |
| [MajorSurgery](StructureDefinition-MajorSurgery.md) | Major Surgery | Major Surgery. |
| [OtherInfos](StructureDefinition-OtherInfos.md) | Other info and relevant events | Other info and relevant events |
| [PlanOfCare](StructureDefinition-PlanOfCare.md) | Care Plan | Care Plan |
| [Radiotherapy](StructureDefinition-Radiotherapy.md) | Radiotherapy | Radiotherapy |
| [RelapseAfterFLT](StructureDefinition-RelapseAfterFLT.md) | Progression-Relapse after FLT | Progression-Relapse after FLT |
| [RelapseDuringFLT](StructureDefinition-RelapseDuringFLT.md) | Progression-Relapse during FLT | Progression-Relapse during FLT |
| [StemCellTransplantation](StructureDefinition-StemCellTransplantation.md) | Stem Cell Transplantation | Stem Cell Transplantation. |
| [Subject](StructureDefinition-Subject.md) | Subject of care | Subject of care |
| [SurPass](StructureDefinition-SurPass.md) | SurPass V2.0 | Survivorship Passport V2.0 |
| [TreatmentSummary](StructureDefinition-TreatmentSummary.md) | Treatment Summary | Treatment Summary data model |

