# PanCareSurPass FHIR IG - Home Page - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* **PanCareSurPass FHIR IG - Home Page**

## PanCareSurPass FHIR IG - Home Page

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/ImplementationGuide/hl7.eu.fhir.pcsp | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:PCSPImplementationGuide |

### Scope

Specify **HL7 FHIR logical models** and **profiles** to be used within the European project **PanCareSurPass**. This project studies the scale-up and implementation of the digital Survivorship Passport to improve people-centred care for childhood cancer survivors.

### The PancareSurPass Project

#### Overview

**PanCareSurPass** is a EU funded Research and Innovation action aiming to study the scale-up and implementation of the digital Survivorship Passport to improve people-centred care for childhood cancer survivors.

PanCareSurPass will conduct a robust assessment of the implementation of the Survivorship Passport by first conducting a pre-implementation study in six countries (Austria, Belgium, Germany, Italy, Lithuania, Spain) representing three infrastructural scenarios in Europe. The Survivorship Passport is an innovative, digital tool, developed in previous EU-funded projects, that can be used to overcome well-known knowledge gaps to improve people-centred long-term survivorship care.

#### Objectives

The overall aim of PanCareSurPass is to **leverage the digital transformation of healthcare to improve people-centred survivorship care by scaling up and implementing an interoperable SurPass v2.0 across Europe.**

##### Preparation for Implementation

1. **design and conduct a multi-country pre-implementation study**to assess the barriers and facilitators for scaling up use of the SurPass v2.0
1. **develop a practical Implementation Strategy**informed by the findings of the pre-implementation activities and**IT technical specifications**for SurPass v2.0 ensuring interoperability and cybersecurity.
1. **develop, test and launch SurPass v2.0**using the IT specifications developed use in the multi-country implementation study.

##### Implementation and evaluation

1. **conduct a multi-country implementation study of SurPass v2.0**for people-centred care with >5-year CCS and to**assess implementation**in terms of people-centred care (e.g. activation, empowerment, satisfaction, increase in knowledge), feasibility and cost effectiveness.
1. **conduct a parallel observational qualitative study using SurPass v2.0**for delivering people-centred survivorship care to <5-year CCS and >5-year CCS (but with limited treatment data available).

##### European Future Implementation & Achieving Impact

1. **develop a Prediction Model**using data from the pre-implementation activities and multi-country implementation study to enable healthcare decision-makers to assess the suitability and costs of SurPass v2.0.
1. **host an Implementation Toolkit**for further European implementation of the SurPass for people-centred care in various healthcare settings across Europe.
1. **disseminate and communicate the importance of people-centred survivorship care and results of PanCareSurPass**to key stakeholders to promote future implementation of SurPass v2.0 to improve people-centred survivorship care in Europe.

### Dependencies











### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (hl7.eu.fhir.pcsp.r4)](package.r4.tgz) and [R4B (hl7.eu.fhir.pcsp.r4b)](package.r4b.tgz) are available.

### Global Profiles

*There are no Global profiles defined*

### IP statements

This publication includes IP covered under the following statements.

* The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. [https://ucum.org/trac/wiki/TermsOfUse](https://ucum.org/trac/wiki/TermsOfUse)

* [Unified Code for Units of Measure (UCUM)](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ucum.html): [Bundle/BundleHulafe](Bundle-BundleHulafe.md), [ChemoUnitsVs](ValueSet-ChemoUnitsVs.md)...Show 8 more,[CumulativeDoseChemoObsPcsp](StructureDefinition-Observation-cumulativeDoseChemo-eu-pcsp.md),[Observation/ChemoHulafe-1-Ciclofosfamide-dose](Observation-ChemoHulafe-1-Ciclofosfamide-dose.md),[Observation/ChemoHulafe-1-Citarabina-dose](Observation-ChemoHulafe-1-Citarabina-dose.md),[Observation/ChemoHulafe-1-Metotrexato-dose](Observation-ChemoHulafe-1-Metotrexato-dose.md),[Observation/ChemoHulafe-1-Vincristina-dose](Observation-ChemoHulafe-1-Vincristina-dose.md),[Observation/ObservationRadTotalDose-1](Observation-ObservationRadTotalDose-1.md),[RadioUnitsVs](ValueSet-vs-radiotherapyDoseUnit-eu-pcsp.md)and[RadiotherapyEnergyOrIsotope](StructureDefinition-radiotherapy-energy-or-isotope.md)


* These codes are excerpted from Digital Imaging and Communications in Medicine (DICOM) Standard, Part 16: Content Mapping Resource, Copyright © 2011 by the National Electrical Manufacturers Association.

* [DICOM Controlled Terminology Definitions](http://hl7.org/fhir/R4/codesystem-dicom-dcim.html): [RadiotherapyDoseTypeVs](ValueSet-vs-radiotherapyDoseType-eu-pcsp.md) and [TotalDoseRadObsPcsp](StructureDefinition-Observation-totalDoseRad-eu-pcsp.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/6.5.0/CodeSystem-v3-loinc.html): [Bundle/54](Bundle-54.md), [Bundle/BundleHulafe](Bundle-BundleHulafe.md)...Show 18 more,[CancerStageGroup](StructureDefinition-mcode-cancer-stage-group.md),[CompositionSurpassPcsp](StructureDefinition-Composition-surpass-eu-pcsp.md),[Condition/ConditionPrimCancerMainzZeisig](Condition-ConditionPrimCancerMainzZeisig.md),[ConditionPrimaryCancerPcsp](StructureDefinition-Condition-primaryCancer-eu-pcsp.md),[DocRefDocType](ValueSet-vs-docref-doctype-eu-pcsp.md),[DocumentReferencePcsp](StructureDefinition-DocumentReference-eu-pcsp.md),[FollowupSurPass](Questionnaire-FollowupSurPass.md),[Observation/ObservationCBloodSCT-1-1](Observation-ObservationCBloodSCT-1-1.md),[Observation/ObservationPrimCancerMainzZeisig](Observation-ObservationPrimCancerMainzZeisig.md),[ObservationBloodAboRh](StructureDefinition-Observation-bld-abo-rh-eu-pcsp.md),[ObservationCodesDistantMetastasesVS](ValueSet-mcode-observation-codes-distant-metastases-vs.md),[ObservationCodesPrimaryTumorVS](ValueSet-mcode-observation-codes-primary-tumor-vs.md),[ObservationCodesRegionalNodesVS](ValueSet-mcode-observation-codes-regional-nodes-vs.md),[ObservationCodesStageGroupVS](ValueSet-mcode-observation-codes-stage-group-vs.md),[ObservationDiagnosisPcsp](StructureDefinition-Observation-diagnosis-eu-pcsp.md),[TNMDistantMetastasesCategory](StructureDefinition-mcode-tnm-distant-metastases-category.md),[TNMPrimaryTumorCategory](StructureDefinition-mcode-tnm-primary-tumor-category.md)and[TNMRegionalNodesCategory](StructureDefinition-mcode-tnm-regional-nodes-category.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://hl7.org/fhir/R4/codesystem-snomedct.html): [AffectedOrganVs](ValueSet-vs-affectedOrgan-eu-pcsp.md), [AmputationProcedureTypeVs](ValueSet-vs-amputationProcedureType-eu-pcsp.md)...Show 66 more,[BodyLocationQualifier](StructureDefinition-mcode-body-location-qualifier.md),[BodyLocationQualifierVS](ValueSet-mcode-body-location-qualifier-vs.md),[Bundle/54](Bundle-54.md),[Bundle/BundleHulafe](Bundle-BundleHulafe.md),[CalculatedEstimatedVs](ValueSet-vs-calcest-eu-pcsp.md),[CancerStageGroup](StructureDefinition-mcode-cancer-stage-group.md),[CancerStagingSystemVS](ValueSet-mcode-cancer-staging-system-vs.md),[ColostomyProcedureTypeVs](ValueSet-vs-colostomyProcedureType-eu-pcsp.md),[Condition/ConditionPrimCancerMainzZeisig](Condition-ConditionPrimCancerMainzZeisig.md),[ConditionGvhdPcsp](StructureDefinition-Condition-gvhd-eu-pcsp.md),[ConditionOtherInfosPcsp](StructureDefinition-Condition-otherinfos-eu-pcsp.md),[ConditionPrimaryCancerPcsp](StructureDefinition-Condition-primaryCancer-eu-pcsp.md),[ConditionSecondaryCancerPcsp](StructureDefinition-Condition-secondaryCancer-eu-pcsp.md),[ConditionToxicityPcsp](StructureDefinition-Condition-toxicity-eu-pcsp.md),[CumulativeDoseChemoObsPcsp](StructureDefinition-Observation-cumulativeDoseChemo-eu-pcsp.md),[FollowupSurPass](Questionnaire-FollowupSurPass.md),[FromToPosteriorAnteriorVs](ValueSet-vs-fromToPosteriorAnterior-eu-pcsp.md),[GastrostomyProcedureTypeVs](ValueSet-vs-gastrostomyProcedureType-eu-pcsp.md),[GradeVS](ValueSet-grade-test-vs.md),[HereditaryPredispositionDisease](ValueSet-vs-hereditary-eu-pcsp.md),[LeftRightBiUnilateralVS](ValueSet-laterality-qualifier-lrub-vs.md),[MorphologicAbnormalityVS](ValueSet-morphologicAbnormality-eu-vs.md),[NotAffectedOrgan](StructureDefinition-procedure-notAffectedOrgan.md),[Observation/ChemoHulafe-1-Ciclofosfamide-dose](Observation-ChemoHulafe-1-Ciclofosfamide-dose.md),[Observation/ChemoHulafe-1-Citarabina-dose](Observation-ChemoHulafe-1-Citarabina-dose.md),[Observation/ChemoHulafe-1-Metotrexato-dose](Observation-ChemoHulafe-1-Metotrexato-dose.md),[Observation/ChemoHulafe-1-Vincristina-dose](Observation-ChemoHulafe-1-Vincristina-dose.md),[Observation/ObservationCBloodSCT-1-1](Observation-ObservationCBloodSCT-1-1.md),[Observation/ObservationRadTotalDose-1](Observation-ObservationRadTotalDose-1.md),[Observation/ObservationRiskFactor-1](Observation-ObservationRiskFactor-1.md),[Observation/ObservationRiskFactor-2](Observation-ObservationRiskFactor-2.md),[Observation/ObservationRiskFactor-3](Observation-ObservationRiskFactor-3.md),[Observation/ObservationRiskFactor-4](Observation-ObservationRiskFactor-4.md),[ObservationHereditaryPredispositionPcsp](StructureDefinition-Observation-predisposition-eu-pcsp.md),[ObservationRiskFactor](StructureDefinition-Observation-riskfactor-eu-pcsp.md),[OtherInfosConditionVS](ValueSet-otherInfos-condition-vs.md),[Procedure/ProcedureRadio-1](Procedure-ProcedureRadio-1.md),[Procedure/ProcedureSTC-1](Procedure-ProcedureSTC-1.md),[Procedure/ProcedureTransfusion-1](Procedure-ProcedureTransfusion-1.md),[ProcedureCVCOtherInfosPcsp](StructureDefinition-Procedure-cvc-otherinfos-eu-pcsp.md),[ProcedureCryopreservationOtherInfosPcsp](StructureDefinition-Procedure-cryopreservation-otherinfos-eu-pcsp.md),[ProcedureFltPcsp](StructureDefinition-Procedure-flt-eu-pcsp.md),[ProcedureRadiotherapyBoostPcsp](StructureDefinition-Procedure-radiotheraphyBoost-eu-pcsp.md),[ProcedureRadiotherapyPcsp](StructureDefinition-Procedure-radiotheraphy-eu-pcsp.md),[ProcedureRadiotherapyShieldingPcsp](StructureDefinition-Procedure-radiotheraphyShield-eu-pcsp.md),[ProcedureSctPcsp](StructureDefinition-Procedure-sct-eu-pcsp.md),[ProcedureSctProphylaxisPcsp](StructureDefinition-Procedure-sct-prophylaxis-eu-pcsp.md),[ProcedureSurgeryPcsp](StructureDefinition-Procedure-surgery-eu-pcsp.md),[ProcedureTransfusionOtherInfosPcsp](StructureDefinition-Procedure-transfusion-otherinfos-eu-pcsp.md),[ProstheticProcedureTypeVs](ValueSet-vs-ProstheticProcedureType-eu-pcsp.md),[RadiotherapyDoseTypeVs](ValueSet-vs-radiotherapyDoseType-eu-pcsp.md),[RadiotherapyEnergyOrIsotope](StructureDefinition-radiotherapy-energy-or-isotope.md),[RadiotherapyIsotopes](ValueSet-vs-isotopes-eu-pcsp.md),[RadiotherapyTypeVs](ValueSet-vs-radiotherapyType-eu-pcsp.md),[RelapseTypeVS](ValueSet-relapse-type-vs.md),[SacrifiedOrgan](StructureDefinition-surgery-sacrifiedOrgan.md),[SacrifiedOrganVs](ValueSet-vs-sacrifiedOrgan-eu-pcsp.md),[SctGvhdType](ValueSet-vs-Gvhd-type-eu-pcsp.md),[SctProphylaxisCathegory](ValueSet-vs-sct-prophylaxis-cathegory-eu-pcsp.md),[SctProphylaxisType](ValueSet-vs-sct-prophylaxis-type-eu-pcsp.md),[SctTypeVs](ValueSet-vs-sct-type-eu-pcsp.md),[SurgicalActionVs](ValueSet-vs-action-eu-pcsp.md),[TNMDistantMetastasesCategory](StructureDefinition-mcode-tnm-distant-metastases-category.md),[TNMPrimaryTumorCategory](StructureDefinition-mcode-tnm-primary-tumor-category.md),[TNMRegionalNodesCategory](StructureDefinition-mcode-tnm-regional-nodes-category.md)and[TotalDoseRadObsPcsp](StructureDefinition-Observation-totalDoseRad-eu-pcsp.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [Condition Clinical Status Codes](http://terminology.hl7.org/6.5.0/CodeSystem-condition-clinical.html): [ActiveResolvedConditionVS](ValueSet-activeResolved-condition-vs.md), [Bundle/54](Bundle-54.md)...Show 4 more,[ConditionPrimaryCancerPcsp](StructureDefinition-Condition-primaryCancer-eu-pcsp.md),[ConditionToxicityPcsp](StructureDefinition-Condition-toxicity-eu-pcsp.md),[PreviousStatus](StructureDefinition-condition-previousStatus.md)and[ProcedureFltPcsp](StructureDefinition-Procedure-flt-eu-pcsp.md)
* [DataAbsentReason](http://terminology.hl7.org/6.5.0/CodeSystem-data-absent-reason.html): [Bundle/54](Bundle-54.md), [CalculatedEstimatedVs](ValueSet-vs-calcest-eu-pcsp.md)...Show 26 more,[ConditionGvhdPcsp](StructureDefinition-Condition-gvhd-eu-pcsp.md),[ConditionPrimaryCancerPcsp](StructureDefinition-Condition-primaryCancer-eu-pcsp.md),[ConditionSecondaryCancerPcsp](StructureDefinition-Condition-secondaryCancer-eu-pcsp.md),[ConditionToxicityPcsp](StructureDefinition-Condition-toxicity-eu-pcsp.md),[CumulativeDoseChemoObsPcsp](StructureDefinition-Observation-cumulativeDoseChemo-eu-pcsp.md),[FltPlanType](ValueSet-vs-flt-plan-type-eu-pcsp.md),[ICD10HereditaryPredisposition](ValueSet-vs-icd10-predisposition-eu-pcsp.md),[ICDO3MorphologyVs](ValueSet-vs-icdo3-morphology-eu-pcsp.md),[LeftRightBiUnilateralVS](ValueSet-laterality-qualifier-lrub-vs.md),[NotApplicableUnknownVs](ValueSet-vs-naunk-eu-pcsp.md),[NotPerformedUnknownVs](ValueSet-vs-npunk-eu-pcsp.md),[ObservationHereditaryPredispositionPcsp](StructureDefinition-Observation-predisposition-eu-pcsp.md),[OtherUnknownTextVs](ValueSet-vs-othUnkTxt-eu-pcsp.md),[PlanDefinitionFltPcsp](StructureDefinition-PlanDefinition-flt-eu-pcsp.md),[ProcedureRadiotherapyBoostPcsp](StructureDefinition-Procedure-radiotheraphyBoost-eu-pcsp.md),[ProcedureRadiotherapyPcsp](StructureDefinition-Procedure-radiotheraphy-eu-pcsp.md),[ProcedureRadiotherapyShieldingPcsp](StructureDefinition-Procedure-radiotheraphyShield-eu-pcsp.md),[ProcedureSurgeryPcsp](StructureDefinition-Procedure-surgery-eu-pcsp.md),[ProsthesisTypeVs](ValueSet-vs-ProsthesisType-eu-pcsp.md),[RadiotherapyTypeVs](ValueSet-vs-radiotherapyType-eu-pcsp.md),[SctAcuteGvhdGrade](ValueSet-vs-Gvhd-acute-grade-eu-pcsp.md),[SctChronicGvhdGrade](ValueSet-vs-Gvhd-chronic-grade-eu-pcsp.md),[TotalDoseRadObsPcsp](StructureDefinition-Observation-totalDoseRad-eu-pcsp.md),[ToxicitySeverityVS](ValueSet-toxicityseverity-vs.md),[UnknownOtherVs](ValueSet-vs-unknownOther-eu-pcsp.md)and[VsRadiotherapy](ValueSet-vs-radiotherapy-pcsp.md)
* [Observation Category Codes](http://terminology.hl7.org/6.5.0/CodeSystem-observation-category.html): [CumulativeDoseChemoObsPcsp](StructureDefinition-Observation-cumulativeDoseChemo-eu-pcsp.md), [Observation/ObservationRadTotalDose-1](Observation-ObservationRadTotalDose-1.md) and [TotalDoseRadObsPcsp](StructureDefinition-Observation-totalDoseRad-eu-pcsp.md)
* [PlanDefinitionType](http://terminology.hl7.org/6.5.0/CodeSystem-plan-definition-type.html): [FltPlanType](ValueSet-vs-flt-plan-type-eu-pcsp.md), [PlanDefinition/3976](PlanDefinition-3976.md) and [PlanDefinitionFltPcsp](StructureDefinition-PlanDefinition-flt-eu-pcsp.md)
* [ActCode](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActCode.html): [Bundle/54](Bundle-54.md), [Bundle/BundleHulafe](Bundle-BundleHulafe.md), [Encounter/EncHulafe-1](Encounter-EncHulafe-1.md), [Encounter/EncounterPrimCancerMainzFischer](Encounter-EncounterPrimCancerMainzFischer.md) and [Encounter/EncounterPrimCancerMainzZeisig](Encounter-EncounterPrimCancerMainzZeisig.md)
* [NullFlavor](http://terminology.hl7.org/6.5.0/CodeSystem-v3-NullFlavor.html): [Bundle/54](Bundle-54.md), [Bundle/BundleHulafe](Bundle-BundleHulafe.md)...Show 7 more,[Condition/ConditionPrimCancerMainzFischer](Condition-ConditionPrimCancerMainzFischer.md),[Condition/PrimaryCancerHulafe-1](Condition-PrimaryCancerHulafe-1.md),[ConditionPrimaryCancerPcsp](StructureDefinition-Condition-primaryCancer-eu-pcsp.md),[ObservationHereditaryPredispositionPcsp](StructureDefinition-Observation-predisposition-eu-pcsp.md),[OrphaHereditaryPredisposition](ValueSet-vs-orpha-predisposition-eu-pcsp.md),[OtherUnknownTextVs](ValueSet-vs-othUnkTxt-eu-pcsp.md)and[UnknownOtherVs](ValueSet-vs-unknownOther-eu-pcsp.md)
* [RoleCode](http://terminology.hl7.org/6.5.0/CodeSystem-v3-RoleCode.html): [Patient/PatientCineca](Patient-PatientCineca.md) and [Patient/PatientHulafe](Patient-PatientHulafe.md)


