# Examples - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* **Examples**

## Examples

### BiologicallyDerivedProduct

* [BiologicallyDerivedProduct/BiologicallyDerivedProduct-SCT1](BiologicallyDerivedProduct-BiologicallyDerivedProduct-SCT1.md)

### Bundle

* [Bundle/54](Bundle-54.md)
* [Bundle/BundleHulafe](Bundle-BundleHulafe.md)

### CarePlan

* [CarePlan/CarePlanExample-1](CarePlan-CarePlanExample-1.md)

### Composition

* [Bundle/54](Bundle-54.md)
* [Bundle/BundleHulafe](Bundle-BundleHulafe.md)

### Condition

* [Condition/ConditionPrimCancerMainzFischer](Condition-ConditionPrimCancerMainzFischer.md)
* [Condition/ConditionPrimCancerMainzZeisig](Condition-ConditionPrimCancerMainzZeisig.md)
* [Condition/ConditionSecCancerMainzZeisig](Condition-ConditionSecCancerMainzZeisig.md)
* [Condition/PrimaryCancerHulafe-1](Condition-PrimaryCancerHulafe-1.md)

### DocumentReference

* [DocumentReference/DocumentReferenceExample-1](DocumentReference-DocumentReferenceExample-1.md)

### Encounter

* [Encounter/EncHulafe-1](Encounter-EncHulafe-1.md)
* [Encounter/EncounterPrimCancerMainzFischer](Encounter-EncounterPrimCancerMainzFischer.md)
* [Encounter/EncounterPrimCancerMainzZeisig](Encounter-EncounterPrimCancerMainzZeisig.md)

### Location

* [Hospital la Fe](Location-ChemoHulafe-1-Location.md)
* [Universitätsklinikum Schleswig-Holstein - Campus Lübeck](Location-Location-SCT1.md)

### MedicationAdministration

* [MedicationAdministration/ChemoHulafe-1-Ciclofosfamide](MedicationAdministration-ChemoHulafe-1-Ciclofosfamide.md)
* [MedicationAdministration/ChemoHulafe-1-Citarabina](MedicationAdministration-ChemoHulafe-1-Citarabina.md)
* [MedicationAdministration/ChemoHulafe-1-Metotrexato](MedicationAdministration-ChemoHulafe-1-Metotrexato.md)
* [MedicationAdministration/ChemoHulafe-1-Vincristina](MedicationAdministration-ChemoHulafe-1-Vincristina.md)

### MedicationStatement

* [MedicationStatement/ChemoHulafe-1-corticosteroids](MedicationStatement-ChemoHulafe-1-corticosteroids.md)

### Observation

* [Observation/ChemoHulafe-1-Ciclofosfamide-dose](Observation-ChemoHulafe-1-Ciclofosfamide-dose.md)
* [Observation/ChemoHulafe-1-Citarabina-dose](Observation-ChemoHulafe-1-Citarabina-dose.md)
* [Observation/ChemoHulafe-1-Metotrexato-dose](Observation-ChemoHulafe-1-Metotrexato-dose.md)
* [Observation/ChemoHulafe-1-Vincristina-dose](Observation-ChemoHulafe-1-Vincristina-dose.md)
* [Observation/ObservationCBloodSCT-1-1](Observation-ObservationCBloodSCT-1-1.md)
* [Observation/ObservationPrimCancerMainzZeisig](Observation-ObservationPrimCancerMainzZeisig.md)
* [Observation/ObservationRadTotalDose-1](Observation-ObservationRadTotalDose-1.md)
* [Observation/ObservationRiskFactor-1](Observation-ObservationRiskFactor-1.md)
* [Observation/ObservationRiskFactor-2](Observation-ObservationRiskFactor-2.md)
* [Observation/ObservationRiskFactor-3](Observation-ObservationRiskFactor-3.md)
* [Observation/ObservationRiskFactor-4](Observation-ObservationRiskFactor-4.md)

### Organization

* [Hospital Universitari i Politècnic La Fe](Organization-OrgHulafe-1.md)

### Patient

* [Patient/PatientCineca](Patient-PatientCineca.md)
* [Patient/PatientHulafe-1](Patient-PatientHulafe-1.md)
* [Patient/PatientHulafe](Patient-PatientHulafe.md)
* [Patient/PatientMainzFischer](Patient-PatientMainzFischer.md)
* [Patient/PatientMainzZeisig](Patient-PatientMainzZeisig.md)
* [Patient/PatientVulsk](Patient-PatientVulsk.md)

### PlanDefinition

* [Cineca - Clinical Protocol](PlanDefinition-3976.md)

### Procedure

* [Procedure/ProcedureRadio-1](Procedure-ProcedureRadio-1.md)
* [Procedure/ProcedureSTC-1](Procedure-ProcedureSTC-1.md)
* [Procedure/ProcedureTransfusion-1](Procedure-ProcedureTransfusion-1.md)

**Examples:** all the examples that are used in this Implementation Guide available for download:

* [XML](examples.xml.zip)
* [JSON](examples.json.zip)
* [TTl](examples.ttl.zip)

