# Stem Cell Donor type - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Stem Cell Donor type**

## ValueSet: Stem Cell Donor type 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/ValueSet/vs-sct-donorType-eu-pcsp | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:SctDonorTypeVs |

 
Stem Cell Donor type 

 **References** 

* [BiologicallyDerivedProduct: Stem Cell](StructureDefinition-BiologicallyDerivedProduct-sct-eu-pcsp.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "vs-sct-donorType-eu-pcsp",
  "url" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/vs-sct-donorType-eu-pcsp",
  "version" : "1.0.0",
  "name" : "SctDonorTypeVs",
  "title" : "Stem Cell Donor type",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "Stem Cell Donor type",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-generic-eu-pcsp",
        "concept" : [
          {
            "code" : "sct-matched-related",
            "display" : "matched related"
          },
          {
            "code" : "sct-matched-unrelated",
            "display" : "matched unrelated"
          },
          {
            "code" : "sct-mismatch-related",
            "display" : "mismatch related"
          },
          {
            "code" : "sct-mismatch-unrelated",
            "display" : "mismatch unrelated"
          },
          {
            "code" : "sct-haplo-identical",
            "display" : "haplo-identical"
          },
          {
            "code" : "sct-matched-related–sibling",
            "display" : "matched related – sibling"
          },
          {
            "code" : "sct-matched-related–parent",
            "display" : "matched related – parent"
          },
          {
            "code" : "sct-matched-related–other",
            "display" : "matched related – other"
          }
        ]
      }
    ]
  }
}

```
