# Radiotherapy Isotopes - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Radiotherapy Isotopes**

## ValueSet: Radiotherapy Isotopes 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/ValueSet/vs-isotopes-eu-pcsp | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:RadiotherapyIsotopes |

 
Radiotherapy Isotopes 

 **References** 

* [Radiotherapy Energy or Isotope](StructureDefinition-radiotherapy-energy-or-isotope.md)

### Logical Definition (CLD)

 

### Expansion

This value set contains 19 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "vs-isotopes-eu-pcsp",
  "url" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/vs-isotopes-eu-pcsp",
  "version" : "1.0.0",
  "name" : "RadiotherapyIsotopes",
  "title" : "Radiotherapy Isotopes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "Radiotherapy Isotopes",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "13237009",
            "display" : "Cesium-131"
          },
          {
            "code" : "55117002",
            "display" : "Cesium-137"
          },
          {
            "code" : "5405008",
            "display" : "Cobalt-60"
          },
          {
            "code" : "24301009",
            "display" : "Gold-198"
          },
          {
            "code" : "68630002",
            "display" : "Iodine-125"
          },
          {
            "code" : "1368003",
            "display" : "Iodine-131"
          },
          {
            "code" : "48341001",
            "display" : "Iridium-192"
          },
          {
            "code" : "447553000",
            "display" : "Lutetium-177"
          },
          {
            "code" : "9351000",
            "display" : "Palladium-103"
          },
          {
            "code" : "32505007",
            "display" : "Phosphorus-32"
          },
          {
            "code" : "24853006",
            "display" : "Radium-223"
          },
          {
            "code" : "423578007",
            "display" : "Rhenium-188"
          },
          {
            "code" : "8227001",
            "display" : "Ruthenium-106"
          },
          {
            "code" : "14071002",
            "display" : "Strontium-90"
          },
          {
            "code" : "80751004",
            "display" : "Xenon-133"
          },
          {
            "code" : "14691008",
            "display" : "Yttrium-90"
          },
          {
            "code" : "395786000",
            "display" : "MIBG - metaiodobenzylguanidine"
          }
        ]
      },
      {
        "valueSet" : [
          "http://hl7.eu/fhir/ig/pcsp/ValueSet/vs-unknownOther-eu-pcsp"
        ]
      }
    ]
  }
}

```
