# Relapse type (Local/Distant/Combined) - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Relapse type (Local/Distant/Combined)**

## ValueSet: Relapse type (Local/Distant/Combined) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/ValueSet/relapse-type-vs | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:RelapseTypeVS |

 
Relapse type (Local/Distant/Combined) 

 **References** 

* [Condition: Primary Cancer](StructureDefinition-Condition-primaryCancer-eu-pcsp.md)
* [Condition: Metastatic Cancer](StructureDefinition-Condition-secondaryCancer-eu-pcsp.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "relapse-type-vs",
  "url" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/relapse-type-vs",
  "version" : "1.0.0",
  "name" : "RelapseTypeVS",
  "title" : "Relapse type (Local/Distant/Combined)",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "Relapse type (Local/Distant/Combined)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "255470001",
            "display" : "Local"
          },
          {
            "code" : "261007001",
            "display" : "Distant"
          },
          {
            "code" : "89780004",
            "display" : "Combined"
          }
        ]
      }
    ]
  }
}

```
