# Treatment Summary - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Treatment Summary**

## Logical Model: Treatment Summary 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/StructureDefinition/TreatmentSummary | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:TreatmentSummary |

 
Treatment Summary data model 

**Usages:**

* Use this Logical Model: [SurPass V2.0](StructureDefinition-SurPass.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.pcsp|current/StructureDefinition/TreatmentSummary)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-TreatmentSummary.csv), [Excel](StructureDefinition-TreatmentSummary.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "TreatmentSummary",
  "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/TreatmentSummary",
  "version" : "1.0.0",
  "name" : "TreatmentSummary",
  "title" : "Treatment Summary",
  "status" : "active",
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "Treatment Summary data model",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "fhir",
      "uri" : "hl7.org/fhir/r4",
      "name" : "TreatmentSummary model to PCSP HL7 FHIR R4 Profiles"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/TreatmentSummary",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "TreatmentSummary",
        "path" : "TreatmentSummary",
        "short" : "Treatment Summary",
        "definition" : "Treatment Summary data model"
      },
      {
        "id" : "TreatmentSummary.subject",
        "path" : "TreatmentSummary.subject",
        "short" : "Subject",
        "definition" : "Subject",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Subject"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Patient"
          }
        ]
      },
      {
        "id" : "TreatmentSummary.diagnosis",
        "path" : "TreatmentSummary.diagnosis",
        "short" : "Diagnosis",
        "definition" : "Diagnosis",
        "min" : 0,
        "max" : "5",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "TreatmentSummary.diagnosis.details",
        "path" : "TreatmentSummary.diagnosis.details",
        "short" : "Details about this diagnosis",
        "definition" : "Details about this diagnosis",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Diagnosis"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Condition.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-primaryCancer-eu-pcsp')"
          }
        ]
      },
      {
        "id" : "TreatmentSummary.diagnosis.frontLineTreatment",
        "path" : "TreatmentSummary.diagnosis.frontLineTreatment",
        "short" : "Front line treatment",
        "definition" : "Front line treatment",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/FrontLineTreatment"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Procedure.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-flt-eu-pcsp')"
          }
        ]
      },
      {
        "id" : "TreatmentSummary.diagnosis.chemotherapy",
        "path" : "TreatmentSummary.diagnosis.chemotherapy",
        "short" : "Chemotherapy",
        "definition" : "Chemotherapy",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Chemotherapy"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "MedicationAdministration.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/MedicationAdministration-eu-pcsp')"
          }
        ]
      },
      {
        "id" : "TreatmentSummary.diagnosis.stemCellTransplantation",
        "path" : "TreatmentSummary.diagnosis.stemCellTransplantation",
        "short" : "Stem Cell transplantation",
        "definition" : "Stem Cell transplantation",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/StemCellTransplantation"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Procedure.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-sct-eu-pcsp')"
          }
        ]
      },
      {
        "id" : "TreatmentSummary.diagnosis.radiotherapy",
        "path" : "TreatmentSummary.diagnosis.radiotherapy",
        "short" : "Radiotherapy",
        "definition" : "Radiotherapy",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Radiotherapy"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Procedure.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-radiotheraphy-eu-pcsp')"
          }
        ]
      },
      {
        "id" : "TreatmentSummary.diagnosis.majorSurgery",
        "path" : "TreatmentSummary.diagnosis.majorSurgery",
        "short" : "Major Surgery",
        "definition" : "Major Surgery",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/MajorSurgery"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Procedure.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-surgery-eu-pcsp')"
          }
        ]
      },
      {
        "id" : "TreatmentSummary.diagnosis.otherInfos",
        "path" : "TreatmentSummary.diagnosis.otherInfos",
        "short" : "Other info and relevant events",
        "definition" : "Other info and relevant events",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/OtherInfos"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Procedure"
          },
          {
            "identity" : "fhir",
            "map" : "Condition"
          }
        ]
      },
      {
        "id" : "TreatmentSummary.diagnosis.medicalSuggestion",
        "path" : "TreatmentSummary.diagnosis.medicalSuggestion",
        "short" : "Medical suggestion",
        "definition" : "Medical suggestion",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "TreatmentSummary.diagnosis.relapseDuringFLT",
        "path" : "TreatmentSummary.diagnosis.relapseDuringFLT",
        "short" : "Progression-Relapse during FLT",
        "definition" : "Progression-Relapse during Front line treatment",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/RelapseDuringFLT"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Condition.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-primaryCancer-eu-pcsp').where( (extension('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/condition-previousStatus').valueCode = #replaspe or #recurrence) and  ( onsetDateTime < Procedure.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-flt-eu-pcsp').performedPeriod.end) )"
          }
        ]
      },
      {
        "id" : "TreatmentSummary.diagnosis.relapseAfterEOT",
        "path" : "TreatmentSummary.diagnosis.relapseAfterEOT",
        "short" : "Progression-relapse after the End of Treatment",
        "definition" : "Progression-relapse after the End of Treatment",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "TreatmentSummary.diagnosis.relapseAfterEOT.details",
        "path" : "TreatmentSummary.diagnosis.relapseAfterEOT.details",
        "short" : "Details  about this relapse-progression",
        "definition" : "Details  about this relapse-progression",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/RelapseAfterFLT"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Condition.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-primaryCancer-eu-pcsp').where( (extension('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/condition-previousStatus').valueCode = #replaspe or #recurrence) and  ( onsetDateTime >= Procedure.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-flt-eu-pcsp').performedPeriod.end) )"
          }
        ]
      },
      {
        "id" : "TreatmentSummary.diagnosis.relapseAfterEOT.frontLineTreatment",
        "path" : "TreatmentSummary.diagnosis.relapseAfterEOT.frontLineTreatment",
        "short" : "Salvage treatment",
        "definition" : "The salvage treatment has been executed following",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/FrontLineTreatment"
          }
        ],
        "constraint" : [
          {
            "key" : "no-frontLineTreatment",
            "severity" : "error",
            "human" : "notForRelapse details are not provided for relapses after EOT",
            "expression" : "notForRelapse.exists()",
            "source" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/TreatmentSummary"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Procedure.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-flt-eu-pcsp')"
          }
        ]
      },
      {
        "id" : "TreatmentSummary.diagnosis.relapseAfterEOT.chemotherapy",
        "path" : "TreatmentSummary.diagnosis.relapseAfterEOT.chemotherapy",
        "short" : "Chemotherapy",
        "definition" : "Chemotherapy",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Chemotherapy"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "MedicationAdministration.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/MedicationAdministration-eu-pcsp')"
          }
        ]
      },
      {
        "id" : "TreatmentSummary.diagnosis.relapseAfterEOT.stemCellTransplantation",
        "path" : "TreatmentSummary.diagnosis.relapseAfterEOT.stemCellTransplantation",
        "short" : "Stem Cell transplantation",
        "definition" : "Stem Cell transplantation",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/StemCellTransplantation"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Procedure.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-sct-eu-pcsp')"
          }
        ]
      },
      {
        "id" : "TreatmentSummary.diagnosis.relapseAfterEOT.radiotherapy",
        "path" : "TreatmentSummary.diagnosis.relapseAfterEOT.radiotherapy",
        "short" : "Radiotherapy",
        "definition" : "Radiotherapy",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Radiotherapy"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Procedure.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-radiotheraphy-eu-pcsp')"
          }
        ]
      },
      {
        "id" : "TreatmentSummary.diagnosis.relapseAfterEOT.majorSurgery",
        "path" : "TreatmentSummary.diagnosis.relapseAfterEOT.majorSurgery",
        "short" : "Major Surgery",
        "definition" : "Major Surgery",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/MajorSurgery"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Procedure.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-surgery-eu-pcsp')"
          }
        ]
      },
      {
        "id" : "TreatmentSummary.diagnosis.relapseAfterEOT.otherInfos",
        "path" : "TreatmentSummary.diagnosis.relapseAfterEOT.otherInfos",
        "short" : "Other info and relevant events",
        "definition" : "Other info and relevant events",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/OtherInfos"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Procedure"
          },
          {
            "identity" : "fhir",
            "map" : "Condition"
          }
        ]
      },
      {
        "id" : "TreatmentSummary.diagnosis.relapseAfterEOT.medicalSuggestion",
        "path" : "TreatmentSummary.diagnosis.relapseAfterEOT.medicalSuggestion",
        "short" : "Medical suggestion",
        "definition" : "Medical suggestion",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "TreatmentSummary.diagnosis.otherConditions",
        "path" : "TreatmentSummary.diagnosis.otherConditions",
        "short" : "Other medical conditions, not cancer associated",
        "definition" : "Please list here if the patient has or had other medical conditions not reported to be cancer-associated (e.g. diabetes, congenital cardiopathy, amputations, kidney transplant)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      }
    ]
  }
}

```
