# Stem Cell Transplantation - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Stem Cell Transplantation**

## Logical Model: Stem Cell Transplantation 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/StructureDefinition/StemCellTransplantation | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:StemCellTransplantation |

 
Stem Cell Transplantation. 

**Usages:**

* Use this Logical Model: [Treatment Summary](StructureDefinition-TreatmentSummary.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.pcsp|current/StructureDefinition/StemCellTransplantation)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-StemCellTransplantation.csv), [Excel](StructureDefinition-StemCellTransplantation.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "StemCellTransplantation",
  "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/StemCellTransplantation",
  "version" : "1.0.0",
  "name" : "StemCellTransplantation",
  "title" : "Stem Cell Transplantation",
  "status" : "active",
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "Stem Cell Transplantation.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "fhir",
      "uri" : "hl7.org/fhir/r4",
      "name" : "StemCellTransplantation model to PCSP HL7 FHIR R4 Profiles"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/StemCellTransplantation",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "StemCellTransplantation",
        "path" : "StemCellTransplantation",
        "short" : "Stem Cell Transplantation",
        "definition" : "Stem Cell Transplantation.",
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Procedure.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-sct-eu-pcsp')"
          }
        ]
      },
      {
        "id" : "StemCellTransplantation.identifier",
        "path" : "StemCellTransplantation.identifier",
        "short" : "SCT Identifier",
        "definition" : "Progressive SCT number",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".identifier"
          }
        ]
      },
      {
        "id" : "StemCellTransplantation.relatedDiagnosis",
        "path" : "StemCellTransplantation.relatedDiagnosis",
        "short" : "Progressive number of diagnosis",
        "definition" : "Progressive number of diagnosis",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".reasonReference"
          }
        ]
      },
      {
        "id" : "StemCellTransplantation.relatedRelapse",
        "path" : "StemCellTransplantation.relatedRelapse",
        "short" : "Progressive number of relapse/progression (after FLT)",
        "definition" : "Progressive number of relapse/progression (after FLT)",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".reasonReference"
          }
        ]
      },
      {
        "id" : "StemCellTransplantation.istitutionOfTreatment",
        "path" : "StemCellTransplantation.istitutionOfTreatment",
        "short" : "Institution of treatment",
        "definition" : "Please Identify the institution were the procedure was performed",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "location.resolve().conformsTo(http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Location-eu-pcsp)"
          }
        ]
      },
      {
        "id" : "StemCellTransplantation.istitutionOfTreatment.description",
        "path" : "StemCellTransplantation.istitutionOfTreatment.description",
        "short" : "Institution description",
        "definition" : "Institution description",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Location.description"
          }
        ]
      },
      {
        "id" : "StemCellTransplantation.istitutionOfTreatment.name",
        "path" : "StemCellTransplantation.istitutionOfTreatment.name",
        "short" : "Institution name",
        "definition" : "Institution name",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Location.name"
          }
        ]
      },
      {
        "id" : "StemCellTransplantation.istitutionOfTreatment.address",
        "path" : "StemCellTransplantation.istitutionOfTreatment.address",
        "short" : "Institution address",
        "definition" : "Institution address",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Location.address.city"
          }
        ]
      },
      {
        "id" : "StemCellTransplantation.istitutionOfTreatment.address.name",
        "path" : "StemCellTransplantation.istitutionOfTreatment.address.name",
        "short" : "Institution city",
        "definition" : "Institution city",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "StemCellTransplantation.istitutionOfTreatment.address.country",
        "path" : "StemCellTransplantation.istitutionOfTreatment.address.country",
        "short" : "Institution country",
        "definition" : "Institution country",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Location.address.country"
          }
        ]
      },
      {
        "id" : "StemCellTransplantation.date",
        "path" : "StemCellTransplantation.date",
        "short" : "Date of transplant",
        "definition" : "Date of the reinfusion of hematopoietic stem cells. If the date is unkown or partially missed insert the year at the best of your knowledge.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".performedDateTime"
          }
        ]
      },
      {
        "id" : "StemCellTransplantation.transplantType",
        "path" : "StemCellTransplantation.transplantType",
        "short" : "Type of transplant",
        "definition" : "Indicate if the transplant was autologous or allogeneic.\n1 = Autologous\n2 = Allogeneic\n-9922 = NK",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".code"
          }
        ]
      },
      {
        "id" : "StemCellTransplantation.donorType",
        "path" : "StemCellTransplantation.donorType",
        "short" : "Type of donor",
        "definition" : "Define the type of donor \nin case of allogenic transplant,\n1 = matched related\n2 = matched unrelated\n3 = mismatch related\n4 = mismatch unrelated\n5 = haplo-identical\n-9922 = NK\n\n1 = matched related ? sibling\n2 = matched related ? parent\n3 = matched related ? other (e.g. cousin)\n-9922 = NK",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "BiologicallyDerivedProduct .conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/BiologicallyDerivedProduct-sct-eu-pcsp').extension('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/sct-donor-type').valueCodeableConcept"
          }
        ]
      },
      {
        "id" : "StemCellTransplantation.cellSource",
        "path" : "StemCellTransplantation.cellSource",
        "short" : "Source of cells",
        "definition" : "Indicate the source of cells\n1 = PBSC \n2 = Bone marrow\n3 = Cord\n-9922 = NK",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "BiologicallyDerivedProduct .conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/BiologicallyDerivedProduct-sct-eu-pcsp').extension('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/sct-source-type').valueCodeableConcept"
          }
        ]
      },
      {
        "id" : "StemCellTransplantation.conditioningRegimen",
        "path" : "StemCellTransplantation.conditioningRegimen",
        "short" : "Conditioning regimen: drugs used",
        "definition" : "Please list the drugs (name) and radiotherapy used or the conditioning regimen.  These drugs contribute to the calculation of cumulative doses received by the patient reported in the chemotherapy section.  Here it is requested only the names of the drugs and if possible the dosage used (only for possible information in the future).\nNo calculations are made on these data.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Procedure.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-sct-prophylaxis-eu-pcsp').where(reasonReference.resolve().conformTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-sct-eu-pcsp') ).text"
          }
        ]
      },
      {
        "id" : "StemCellTransplantation.gvhd",
        "path" : "StemCellTransplantation.gvhd",
        "short" : "Graft Versus Host Disease",
        "definition" : "Graft Versus Host Disease",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Condition.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-gvdh-eu-pcsp')"
          }
        ]
      },
      {
        "id" : "StemCellTransplantation.gvhd.prophylaxis",
        "path" : "StemCellTransplantation.gvhd.prophylaxis",
        "short" : "GVHD prophylaxis",
        "definition" : "State if any GVHD prophylaxis was given. Details on the drug names used for GVHD prophylaxis should be listed in the chemotherapy section under 'immunotherapy').\n1 => Yes\n2 => No\n-9922 => NK   ",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Procedure.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-sct-prophylaxis-eu-pcsp').where(code = $sct#868254008 'GVHD (graft versus host disease) prophylaxis').exists()"
          }
        ]
      },
      {
        "id" : "StemCellTransplantation.gvhd.acute",
        "path" : "StemCellTransplantation.gvhd.acute",
        "short" : "GVHD Acute",
        "definition" : "GVHD Acute ",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".where(code = http://snomed.info/sct#402355000 'Acute graft-versus-host disease')"
          }
        ]
      },
      {
        "id" : "StemCellTransplantation.gvhd.acute.status",
        "path" : "StemCellTransplantation.gvhd.acute.status",
        "short" : "GVHD Acutestatus",
        "definition" : "Please State if acute GVHD occurred\n1 => Yes\n2 => No\n-9922 => NK ",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".where(code = http://snomed.info/sct#402355000 'Acute graft-versus-host disease').exists()"
          }
        ]
      },
      {
        "id" : "StemCellTransplantation.gvhd.acute.grade",
        "path" : "StemCellTransplantation.gvhd.acute.grade",
        "short" : "Grade",
        "definition" : "If yes, state the maximum grade of acute GVHD.\n\n1 => 1\n2 => 2\n3 => 3\n4 => 4\n-9922 => NK ",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".stage.summary"
          }
        ]
      },
      {
        "id" : "StemCellTransplantation.gvhd.acute.startDate",
        "path" : "StemCellTransplantation.gvhd.acute.startDate",
        "short" : "Start date",
        "definition" : "Define the starting date of GVHD. If the date is unkown or partially missed insert the year at the best of your knowledge.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "date"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".onsetDateTime"
          }
        ]
      },
      {
        "id" : "StemCellTransplantation.gvhd.acute.endDate",
        "path" : "StemCellTransplantation.gvhd.acute.endDate",
        "short" : "End date",
        "definition" : "Define the ending date of GVHD. If the date is unkown or partially missed insert the year at the best of your knowledge.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "date"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".abatementDateTime"
          }
        ]
      },
      {
        "id" : "StemCellTransplantation.gvhd.chronic",
        "path" : "StemCellTransplantation.gvhd.chronic",
        "short" : "GVHD Chronic",
        "definition" : "GVHD Chronic ",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".where(code = http://snomed.info/sct#402356004 'Chronic graft-versus-host disease')"
          }
        ]
      },
      {
        "id" : "StemCellTransplantation.gvhd.chronic.status",
        "path" : "StemCellTransplantation.gvhd.chronic.status",
        "short" : "GVHD Chronicstatus",
        "definition" : "Please State if chronic GVHD occurred\n1 => Yes\n2 => No\n-9922 => NK ",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".where(code = http://snomed.info/sct#402356004 'Chronic graft-versus-host disease').exists()"
          }
        ]
      },
      {
        "id" : "StemCellTransplantation.gvhd.chronic.grade",
        "path" : "StemCellTransplantation.gvhd.chronic.grade",
        "short" : "Grade",
        "definition" : " If yes, state the maximum grade of chronic GVHD\n1 => Limited\n2 => Extensive\n-9922 => NK",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".stage.summary"
          }
        ]
      },
      {
        "id" : "StemCellTransplantation.gvhd.chronic.startDate",
        "path" : "StemCellTransplantation.gvhd.chronic.startDate",
        "short" : "Start date",
        "definition" : "Please Define the starting date of GVHD. If the date is unkown or partially missed insert the year at the best of your knowledge.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "date"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".onsetDateTime"
          }
        ]
      },
      {
        "id" : "StemCellTransplantation.gvhd.chronic.endDate",
        "path" : "StemCellTransplantation.gvhd.chronic.endDate",
        "short" : "End date",
        "definition" : "Please Define the ending date of GVHD. If the date is unkown or partially missed insert the year at the best of your knowledge.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "date"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".abatementDateTime"
          }
        ]
      },
      {
        "id" : "StemCellTransplantation.gvhd.organAffected",
        "path" : "StemCellTransplantation.gvhd.organAffected",
        "short" : "Organs affected",
        "definition" : "Please List organs affected by GVHD",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".bodySite"
          }
        ]
      },
      {
        "id" : "StemCellTransplantation.bloodBeforeTransplant",
        "path" : "StemCellTransplantation.bloodBeforeTransplant",
        "short" : "Blood before transplant",
        "definition" : "Blood before transplant ",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Observation.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-bld-abo-rh-eu-pcsp').where(effectiveTiming.code = #before-procedure)"
          }
        ]
      },
      {
        "id" : "StemCellTransplantation.bloodBeforeTransplant.type",
        "path" : "StemCellTransplantation.bloodBeforeTransplant.type",
        "short" : "Blood type",
        "definition" : "Blood type before transplant \n1 => A\n2 => B\n3 => AB\n4 => O \n-9922 => NK",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "component.where(code = $loinc#883-9\t'ABO group [Type] in Blood').value"
          }
        ]
      },
      {
        "id" : "StemCellTransplantation.bloodBeforeTransplant.rh",
        "path" : "StemCellTransplantation.bloodBeforeTransplant.rh",
        "short" : "Rh",
        "definition" : "Rh factor before transplant\n1 => +\n2 => -\n-9922 => NK ",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "component.where(code = $loinc#10331-7 'Rh [Type] in Blood').value"
          }
        ]
      },
      {
        "id" : "StemCellTransplantation.bloodAfterTransplant",
        "path" : "StemCellTransplantation.bloodAfterTransplant",
        "short" : "Blood after transplant",
        "definition" : "Blood after transplant ",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Observation.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-bld-abo-rh-eu-pcsp').where(effectiveTiming.code = #after-procedure)"
          }
        ]
      },
      {
        "id" : "StemCellTransplantation.bloodAfterTransplant.type",
        "path" : "StemCellTransplantation.bloodAfterTransplant.type",
        "short" : "Blood type",
        "definition" : "Blood type after transplant \n1 => A\n2 => B\n3 => AB\n4 => O \n-9922 => NK",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "component.where(code = $loinc#883-9\t'ABO group [Type] in Blood').value"
          }
        ]
      },
      {
        "id" : "StemCellTransplantation.bloodAfterTransplant.rh",
        "path" : "StemCellTransplantation.bloodAfterTransplant.rh",
        "short" : "Rh",
        "definition" : "Rh factor after transplant\n1 => +\n2 => -\n-9922 => NK ",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "component.where(code = $loinc#10331-7 'Rh [Type] in Blood').value"
          }
        ]
      },
      {
        "id" : "StemCellTransplantation.endOfTreatment",
        "path" : "StemCellTransplantation.endOfTreatment",
        "short" : "Date of end of immunosuppressive treatmentafter HSCT",
        "definition" : "Date of end of immunosuppressive treatment. If the date is unkown or partially missed insert the year at the best of your knowledge.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "date"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Procedure.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-sct-prophylaxis-eu-pcsp').where(category = $sct#416608005 'Drug therapy' ).performedPeriod.end"
          }
        ]
      }
    ]
  }
}

```
