# Progression-Relapse after FLT - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Progression-Relapse after FLT**

## Logical Model: Progression-Relapse after FLT 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/StructureDefinition/RelapseAfterFLT | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:RelapseAfterFLT |

 
Progression-Relapse after FLT 

**Usages:**

* Use this Logical Model: [Treatment Summary](StructureDefinition-TreatmentSummary.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.pcsp|current/StructureDefinition/RelapseAfterFLT)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-RelapseAfterFLT.csv), [Excel](StructureDefinition-RelapseAfterFLT.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "RelapseAfterFLT",
  "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/RelapseAfterFLT",
  "version" : "1.0.0",
  "name" : "RelapseAfterFLT",
  "title" : "Progression-Relapse after FLT",
  "status" : "active",
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "Progression-Relapse after FLT",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "fhir",
      "uri" : "hl7.org/fhir/r4",
      "name" : "RelapseAfterFLT model to PCSP HL7 FHIR R4 Profiles"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/RelapseAfterFLT",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "RelapseAfterFLT",
        "path" : "RelapseAfterFLT",
        "short" : "Progression-Relapse after FLT",
        "definition" : "Progression-Relapse after FLT",
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Condition.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-primaryCancer-eu-pcsp').where( (extension('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/condition-previousStatus').valueCode = #replaspe or #recurrence) and  ( onsetDateTime >= Procedure.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-flt-eu-pcsp').performedPeriod.end) )"
          }
        ]
      },
      {
        "id" : "RelapseAfterFLT.identifier",
        "path" : "RelapseAfterFLT.identifier",
        "short" : "Progression-relapse after FLT number",
        "definition" : "Progressive number of progression/relapse (1=first; 2= second; 3 = third; ?) after the end of treatment.\nIn this field must be reported the ordinal number of the progression/relapse after the end of treatment.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".identifier"
          }
        ]
      },
      {
        "id" : "RelapseAfterFLT.relatedDiagnosis",
        "path" : "RelapseAfterFLT.relatedDiagnosis",
        "short" : "Progressive number of diagnosis",
        "definition" : "Progressive number of diagnosis (1=first; 2= second; 3 = third; ?).  \nIn this field must be reported the ordinal number of the tumor diagnosis in which progression/relapse ocuured during front line treatment.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".extension('http://hl7.org/fhir/StructureDefinition/condition-occurredFollowing')"
          }
        ]
      },
      {
        "id" : "RelapseAfterFLT.date",
        "path" : "RelapseAfterFLT.date",
        "short" : "date of relapse",
        "definition" : "Report here the date (dd/mm/yyyy ) of the relapse/progression. If the date is unkown or partially missed insert the year at the best of your knowledge.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "date"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".extension('http://hl7.org/fhir/StructureDefinition/condition-assertedDate')"
          }
        ]
      },
      {
        "id" : "RelapseAfterFLT.relapseOrProgression",
        "path" : "RelapseAfterFLT.relapseOrProgression",
        "short" : "relapse | progression",
        "definition" : "Report here if a relapse or progression occurred after the elective end of therapies.\nPlease note that 'progressions' may occurr since in some cases (e.g. stage 3 unoperable residual neuroblastoma or residual CNS tumor) that were considered as 'non active' may progress\n1 => Relapse\n2 => Progression\n-9922= > NK",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".extension('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/condition-previousStatus').valueCodeableConcept OR Condition.where( clinicalStatus = #relapse or clinicalStatus = #recurrence).clinicalStatus"
          }
        ]
      },
      {
        "id" : "RelapseAfterFLT.type",
        "path" : "RelapseAfterFLT.type",
        "short" : "local | distant | combined",
        "definition" : "Please define if the relapse/progression was local, distant or combined.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".extension('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/condition-relapseType').valueCodeableConcept"
          }
        ]
      },
      {
        "id" : "RelapseAfterFLT.site",
        "path" : "RelapseAfterFLT.site",
        "short" : "If distant, site of metastases",
        "definition" : "Please define if the relapse/progression was local, distant or combined.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".bodySite"
          }
        ]
      }
    ]
  }
}

```
