# Radiotherapy - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Radiotherapy**

## Logical Model: Radiotherapy 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Radiotherapy | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:Radiotherapy |

 
Radiotherapy 

**Usages:**

* Use this Logical Model: [Treatment Summary](StructureDefinition-TreatmentSummary.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.pcsp|current/StructureDefinition/Radiotherapy)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Radiotherapy.csv), [Excel](StructureDefinition-Radiotherapy.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Radiotherapy",
  "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Radiotherapy",
  "version" : "1.0.0",
  "name" : "Radiotherapy",
  "title" : "Radiotherapy",
  "status" : "active",
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "Radiotherapy",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "fhir",
      "uri" : "hl7.org/fhir/r4",
      "name" : "Radiotherapy model to PCSP HL7 FHIR R4 Profiles"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Radiotherapy",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "Radiotherapy",
        "path" : "Radiotherapy",
        "short" : "Radiotherapy",
        "definition" : "Radiotherapy",
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Procedure.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-radiotheraphy-eu-pcsp')"
          }
        ]
      },
      {
        "id" : "Radiotherapy.relatedDiagnosis",
        "path" : "Radiotherapy.relatedDiagnosis",
        "short" : "Related Diagnosis",
        "definition" : "Identifier of the diagnosis for which this radiotherapy is performed",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".reasonReference"
          }
        ]
      },
      {
        "id" : "Radiotherapy.relatedRelapse",
        "path" : "Radiotherapy.relatedRelapse",
        "short" : "Related relapse/progression (after FLT)",
        "definition" : "Identifier of the relapse/progression (after FLT) for which this radiotherapy is performed",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".reasonReference"
          }
        ]
      },
      {
        "id" : "Radiotherapy.identifier",
        "path" : "Radiotherapy.identifier",
        "short" : "Identifier of the radotherapy episode",
        "definition" : "Progressive number of radotherapy episode.  An EPISODE might be a single or several courses of pre-planned treatment within a consecutive time period to different sites. For example, if a patient had radiotherapy to a limb and also to the lungs for a Ewing?s sarcoma these should be entered  in one episode of treatment but as separate radiotherapy courses with their respective site, total dose, and number of fractions. They will both be within one episode",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".identifier"
          }
        ]
      },
      {
        "id" : "Radiotherapy.istitutionOfTreatment",
        "path" : "Radiotherapy.istitutionOfTreatment",
        "short" : "Institution of treatment",
        "definition" : "Please indicate the institution in which the radiotherapeutic treatment was given",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".location.resolve().conformsTo(http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Location-eu-pcsp)"
          }
        ]
      },
      {
        "id" : "Radiotherapy.istitutionOfTreatment.description",
        "path" : "Radiotherapy.istitutionOfTreatment.description",
        "short" : "Institution description",
        "definition" : "Please provide name, city and countryof the institution",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Location.description"
          }
        ]
      },
      {
        "id" : "Radiotherapy.istitutionOfTreatment.name",
        "path" : "Radiotherapy.istitutionOfTreatment.name",
        "short" : "Institution name",
        "definition" : "Institution name",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Location.name"
          }
        ]
      },
      {
        "id" : "Radiotherapy.istitutionOfTreatment.address",
        "path" : "Radiotherapy.istitutionOfTreatment.address",
        "short" : "Institution address",
        "definition" : "Institution address",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Location.address.city"
          }
        ]
      },
      {
        "id" : "Radiotherapy.istitutionOfTreatment.address.name",
        "path" : "Radiotherapy.istitutionOfTreatment.address.name",
        "short" : "Institution city",
        "definition" : "Institution city",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "Radiotherapy.istitutionOfTreatment.address.country",
        "path" : "Radiotherapy.istitutionOfTreatment.address.country",
        "short" : "Institution country",
        "definition" : "Institution country",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Location.address.country"
          }
        ]
      },
      {
        "id" : "Radiotherapy.startDate",
        "path" : "Radiotherapy.startDate",
        "short" : "Start date",
        "definition" : "Enter the date on which the first treatment (fraction) of radiotherapy was given, in a DD/MM/YYYY format. If the date is unkown or partially missed insert the year at the best of your knowledge.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".performedPeriod.start"
          }
        ]
      },
      {
        "id" : "Radiotherapy.enddate",
        "path" : "Radiotherapy.enddate",
        "short" : "End date",
        "definition" : "Enter the full date on which the last treatment (fraction) of radiotherapy was given in a DD/MM/YYYY format.   \nWhen only a single radiation treatment/fraction was given, the start and end dates will be the same. If the date is unkown or partially missed insert the year at the best of your knowledge.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".performedPeriod.end"
          }
        ]
      },
      {
        "id" : "Radiotherapy.type",
        "path" : "Radiotherapy.type",
        "short" : "Type of radiotherapy",
        "definition" : "External Beam Radiation: The radiation is produced by a large machine, and the type of the machine needs to be recorded in the subsequent field.\nBrachytherapy: a material that is radioactive (often a fine wire or a tiny ?seed?) is placed on or in the body to give a very localized high dose of radiation. Details will be asked in the next field\nMetabolic or radionuclide treatment/therapy: a liquid substance is injected into the blood stream and carries radiation throughout the body with the aim of reaching tumour tissue.  Also in this case, details will be asked in the subsequent field.\n1 => External beam\n2 => Brachytherapy\n3 => Metabolic/radionuclide therapy",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".code"
          }
        ]
      },
      {
        "id" : "Radiotherapy.deviceType",
        "path" : "Radiotherapy.deviceType",
        "short" : "type of machine (If external beam)",
        "definition" : "A detailed description of the type of machine can be found in the user's manual.\nIf you have the name of a machine but cannot find it in this list, please select Other and add the name in free text. \nIf you know the treatment was with external beam but not which machine or energy, select 'Unknown'.\n1 =>Orthovoltage / kilovoltage usually 200 - 300kv X rays/photons\n2 =>Linac (Linear Accelerator) megavoltage MV X Rays/photons\n3 =>Linac (Linear Accelerator) electrons\n4 => Cobalt - MV gamma rays / photons\n5 => Proton Beam\n6 => Other, if other specify the name\n-9922 => Unknown ",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".usedCode"
          }
        ]
      },
      {
        "id" : "Radiotherapy.brachytherapyType",
        "path" : "Radiotherapy.brachytherapyType",
        "short" : "type of brachytherapy (if brachytherapy)",
        "definition" : "? Surface brachytherapy - a radiation source (radioactive material) is positioned on a superficial tumour\n? Interstitial brachytherapy ? a radiation source is implanted into a tumour\n? Intracavitary or intraluminal brachytherapy - a radiation source is introduced in special applicators into a body cavity or lumen\n\n1 => Surface brachytherapy\n2 => Interstitial brachytherapy\n3 => Intracavitary or intraluminal brachytherapy\n-9922=> Unknown",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".extension('http://hl7.org/fhir/StructureDefinition/procedure-method').valueCodeableConcept"
          }
        ]
      },
      {
        "id" : "Radiotherapy.isotopes",
        "path" : "Radiotherapy.isotopes",
        "short" : "Radioactive materials (if brachytherapy)",
        "definition" : "Specify the radioactive material (isotopes) used: If not listed, select 'Other then specify'\n1 => Iridium (Ir)\n2 => Gold (Au)\n3 => Iodine (I)\n4 => Caesium (Cs)\n5 => Other\n-9922 => Unknown",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".extension('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/radiotherapy-energy-or-isotope').valueCodeableConcept"
          }
        ]
      },
      {
        "id" : "Radiotherapy.radionuclides",
        "path" : "Radiotherapy.radionuclides",
        "short" : "radionuclides (required If metabolic/radionuclide)",
        "definition" : "A detailed description of the radionuclides can be found in the user's manual.\nIf you have the name of a radionuclide but cannot find it in this list, please select Other and add the name in free text. \nIf you know the treatment was with external beam but not which machine or energy, select 'Unknown'.\n1 => Iodine-131\n2 => MIBG\n3 =>Yttrium 90\n4 => Other\n-9922 => Unknown",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".extension('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/radiotherapy-energy-or-isotope').valueCodeableConcept"
          }
        ]
      },
      {
        "id" : "Radiotherapy.numberOfCourses",
        "path" : "Radiotherapy.numberOfCourses",
        "short" : "Number of courses  (If metabolic/radionuclide)",
        "definition" : "For Metabolic/radionuclide therapy",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "integer"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".extension(http://hl7.eu/fhir/ig/pcsp/StructureDefinition/procedure-performedTiming).valueTiming.repeat.count"
          }
        ]
      },
      {
        "id" : "Radiotherapy.target",
        "path" : "Radiotherapy.target",
        "short" : "Target",
        "definition" : "Site' refers to the radiation therapy treatment field, i.e. the part of the body that received the radiation dose in order to treat the tumour. \nRequired if Type of radiotherapy = 1 or 2 (External Beam, Brachytherapy)�\nIf more than one body site was treated with radiotherapy, you can add anther site and describe; upto 5 sites are allowed by the system ",
        "min" : 0,
        "max" : "5",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".bodySite"
          },
          {
            "identity" : "fhir",
            "map" : ".extension(http://hl7.eu/fhir/ig/pcsp/StructureDefinition/ResourceRelatedInfo-eu-pcsp).resolve().conformsTo(http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-cumulativeDoseRad-eu-pcsp)"
          }
        ]
      },
      {
        "id" : "Radiotherapy.target.site",
        "path" : "Radiotherapy.target.site",
        "short" : "Body Site Code",
        "definition" : "RT sites are coded with a 3 tier level (see list). The first is ?Tier 1?.  The first digit/s of the code, describes the large topographical body areas e.g. brain, chest, abdomen, limb. Since radiation fields often involve more than one topographical area we have added ?cervico-thoracic?, ?thoraco abdominal? and ?abdomino pelvic? areas to Tier 1. \nThe second (Tier 2) includes subcategories of Tier 1 sites e.g. brain stem, heart, liver, upper limb. \nWhere the information is available a third (Tier 3) of further subdivisions includes more detailed areas. \nWhen using the SurPass platform, as you start typing the name of the site, a drop down list with related terms will appear (special sites like Inverted Y are included). If the RT site listed in the medical record cannot reasonably be matched to one of the sites listed in the computer, choose ??Other' (.98 in tier 2) and then add in free text the name of this RT site. ",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".bodySite"
          }
        ]
      },
      {
        "id" : "Radiotherapy.target.site.notes",
        "path" : "Radiotherapy.target.site.notes",
        "short" : "Additional description",
        "definition" : "Record any available details on the shielded tissue/organ (or size of shielded area).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".note"
          }
        ]
      },
      {
        "id" : "Radiotherapy.target.laterality",
        "path" : "Radiotherapy.target.laterality",
        "short" : "Laterality",
        "definition" : "Report laterality of the radiation.\n R = right,\n L = left,\n B = bilateral",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".extension(http://hl7.eu/fhir/ig/pcsp/StructureDefinition/mcode-laterality-qualifier).valueCodeableConcept"
          }
        ]
      },
      {
        "id" : "Radiotherapy.target.details",
        "path" : "Radiotherapy.target.details",
        "short" : "Details",
        "definition" : "If needed it is possible to add details",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".text"
          }
        ]
      },
      {
        "id" : "Radiotherapy.target.from",
        "path" : "Radiotherapy.target.from",
        "short" : "Start point",
        "definition" : "When the radiation involves more than one site, eventually covering different body areas (e.g. torax and abdomen), select the starting point using the vertebrae to identify the upper limit (e.g.: Thoraco-Abdominal (area): Paraspinal - Thoracic / dorsal vertebra 10)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".bodySite.where(extension('mcode-body-location-qualifier').valueCodeableConcept = http://snomed.info/sct#272488003 'From-structure')"
          }
        ]
      },
      {
        "id" : "Radiotherapy.target.to",
        "path" : "Radiotherapy.target.to",
        "short" : "End point",
        "definition" : "When the radiation involves more than one site, eventually covering different body areas (e.g. torax and abdomen), select the ending point using the vertebrae to identify the lower limit (e.g.: Thoraco-Abdominal (area): Paraspinal - Lumbar vertebra 3)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".bodySite.where(extension('mcode-body-location-qualifier').valueCodeableConcept = http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-generic-eu-pcsp#to-structure 'To-structure')"
          }
        ]
      },
      {
        "id" : "Radiotherapy.target.position",
        "path" : "Radiotherapy.target.position",
        "short" : "Position",
        "definition" : "Specify whether the radiation was anterior or posterior. \n1 => Anterior\n2 => Posterior\n-9922 = NK",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".extension('http://hl7.org/fhir/us/mcode/StructureDefinition/mcode-body-location-qualifier').valueCodeableConcept"
          }
        ]
      },
      {
        "id" : "Radiotherapy.target.totalDose",
        "path" : "Radiotherapy.target.totalDose",
        "short" : "Total dose",
        "definition" : "Specify the total dose given to the primary radiation therapy site.\nIf the dose is not known, write NK.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".extension(http://hl7.eu/fhir/ig/pcsp/StructureDefinition/ResourceRelatedInfo-eu-pcsp).resolve().conformsTo(http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-cumulativeDoseRad-eu-pcsp)"
          }
        ]
      },
      {
        "id" : "Radiotherapy.target.totalDose.completionStatus",
        "path" : "Radiotherapy.target.totalDose.completionStatus",
        "short" : "The reported doses are incomplete (either under- or over-estimated)",
        "definition" : "Check in case of incomplete doses",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".status = #preliminary"
          }
        ]
      },
      {
        "id" : "Radiotherapy.target.totalDose.statusReason",
        "path" : "Radiotherapy.target.totalDose.statusReason",
        "short" : "Specify reasons why",
        "definition" : "Specify reasons of incomplete estimated doses",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".extension('http://hl7.org/fhir/StructureDefinition/event-statusReason')"
          }
        ]
      },
      {
        "id" : "Radiotherapy.target.totalDose.notKnown",
        "path" : "Radiotherapy.target.totalDose.notKnown",
        "short" : "Not known dose",
        "definition" : "Not known dose",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".valueCodeableConcept = http://terminology.hl7.org/CodeSystem/data-absent-reason#unknown"
          }
        ]
      },
      {
        "id" : "Radiotherapy.target.totalDose.dose",
        "path" : "Radiotherapy.target.totalDose.dose",
        "short" : "Dose",
        "definition" : "Specify the total dose given to the primary radiation therapy site.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "decimal"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".valueQuantity.value"
          }
        ]
      },
      {
        "id" : "Radiotherapy.target.totalDose.unit",
        "path" : "Radiotherapy.target.totalDose.unit",
        "short" : "Measure unit",
        "definition" : "External Beam Radiation Therapy (EBRT) and Brachytherapy doses are in Gy. If doses are reported in cGY, roughly two zeroes need to be deleted (e.g. 100 cGy = 1 Gy).\nspecify if dose is recorded in bequerels (MBq or GBq) or curies (Ci) or Unkwnon",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".valueQuantity.code"
          }
        ]
      },
      {
        "id" : "Radiotherapy.target.totalDose.fractions",
        "path" : "Radiotherapy.target.totalDose.fractions",
        "short" : "Number of fractions (if  external beam)",
        "definition" : "A FRACTION of radiation treatment is a single attendance for treatment; if 'not known' insert NK",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "integer"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".extension(http://hl7.eu/fhir/ig/pcsp/StructureDefinition/procedure-performedTiming).valueTiming.repeat.count"
          }
        ]
      },
      {
        "id" : "Radiotherapy.target.boost",
        "path" : "Radiotherapy.target.boost",
        "short" : "Boost",
        "definition" : "A boost is an extra dose of radiotherapy directed to a smaller area inside the primary radiation field. (only if type is External Beam)",
        "min" : 0,
        "max" : "5",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Procedure.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-radiotheraphyBoost-eu-pcsp')"
          }
        ]
      },
      {
        "id" : "Radiotherapy.target.boost.type",
        "path" : "Radiotherapy.target.boost.type",
        "short" : "Type of Boost",
        "definition" : "Specify radiation type of the boost.\n1 => External Beam\n2 => Brachytherapy\n-9922 => NK �",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".partOf.resolve().code"
          }
        ]
      },
      {
        "id" : "Radiotherapy.target.boost.given",
        "path" : "Radiotherapy.target.boost.given",
        "short" : "Boost given",
        "definition" : "Flag indicating if a boost was given, not given or unknown",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".status"
          }
        ]
      },
      {
        "id" : "Radiotherapy.target.boost.site",
        "path" : "Radiotherapy.target.boost.site",
        "short" : "Boost site",
        "definition" : "Site' refers to the radiation therapy treatment field. As you start typing the name of the site, a drop down list with related terms will appear (special sites like Inverted Y are included). If the RT site listed in the medical record cannot reasonably be matched to one of the sites listed in the computer, choose: ??Other' and then add in free text the name of this RT site. \nrequired if given",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".bodySite"
          },
          {
            "identity" : "fhir",
            "map" : ".extension(http://hl7.eu/fhir/ig/pcsp/StructureDefinition/ResourceRelatedInfo-eu-pcsp).resolve().conformsTo(http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-cumulativeDoseRad-eu-pcsp).bodySite"
          }
        ]
      },
      {
        "id" : "Radiotherapy.target.boost.laterality",
        "path" : "Radiotherapy.target.boost.laterality",
        "short" : "Laterality",
        "definition" : "Report laterality of the radiation.\n R = right,\n L = left,\n B = bilateral",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".extension(http://hl7.eu/fhir/ig/pcsp/StructureDefinition/mcode-laterality-qualifier).valueCodeableConcept"
          }
        ]
      },
      {
        "id" : "Radiotherapy.target.boost.details",
        "path" : "Radiotherapy.target.boost.details",
        "short" : "Details",
        "definition" : "If needed it is possible to add details",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".note"
          }
        ]
      },
      {
        "id" : "Radiotherapy.target.boost.from",
        "path" : "Radiotherapy.target.boost.from",
        "short" : "Start point",
        "definition" : "When the radiation involves more than one site, eventually covering different body areas (e.g. torax and abdomen), select the starting point using the vertebrae to identify the upper limit (e.g.: Thoraco-Abdominal (area): Paraspinal - Thoracic / dorsal vertebra 10)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".bodySite.where(extension(http://hl7.org/fhir/us/mcode/StructureDefinition/mcode-body-location-qualifier).valueCodeableConcept = http://snomed.info/sct#272488003 'From-structure')"
          }
        ]
      },
      {
        "id" : "Radiotherapy.target.boost.to",
        "path" : "Radiotherapy.target.boost.to",
        "short" : "End point",
        "definition" : "When the radiation involves more than one site, eventually covering different body areas (e.g. torax and abdomen), select the ending point using the vertebrae to identify the lower limit (e.g.: Thoraco-Abdominal (area): Paraspinal - Lumbar vertebra 3)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".bodySite.where(extension(http://hl7.org/fhir/us/mcode/StructureDefinition/mcode-body-location-qualifier).valueCodeableConcept = http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-generic-eu-pcsp#to-structure 'To-structure')"
          }
        ]
      },
      {
        "id" : "Radiotherapy.target.boost.position",
        "path" : "Radiotherapy.target.boost.position",
        "short" : "Position",
        "definition" : "Specify whether the radiation was anterior or posterior. \n1 => Anterior\n2 => Posterior\n-9922 = NK",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".extension(http://hl7.org/fhir/us/mcode/StructureDefinition/mcode-body-location-qualifier).valueCodeableConcept"
          }
        ]
      },
      {
        "id" : "Radiotherapy.target.boost.totalDose",
        "path" : "Radiotherapy.target.boost.totalDose",
        "short" : "Total dose",
        "definition" : "Specify the total dose given to the boost site.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".extension(http://hl7.eu/fhir/ig/pcsp/StructureDefinition/ResourceRelatedInfo-eu-pcsp).resolve().conformsTo(http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-cumulativeDoseRad-eu-pcsp)"
          }
        ]
      },
      {
        "id" : "Radiotherapy.target.boost.totalDose.completionStatus",
        "path" : "Radiotherapy.target.boost.totalDose.completionStatus",
        "short" : "The reported doses are incomplete (either under- or over-estimated)",
        "definition" : "Check in case of incomplete doses",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".status = #preliminary"
          }
        ]
      },
      {
        "id" : "Radiotherapy.target.boost.totalDose.statusReason",
        "path" : "Radiotherapy.target.boost.totalDose.statusReason",
        "short" : "Specify reasons why",
        "definition" : "Specify reasons of incomplete estimated doses",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".extension('http://hl7.org/fhir/StructureDefinition/event-statusReason')"
          }
        ]
      },
      {
        "id" : "Radiotherapy.target.boost.totalDose.notKnown",
        "path" : "Radiotherapy.target.boost.totalDose.notKnown",
        "short" : "Not known dose",
        "definition" : "Not known dose",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".valueCodeableConcept = http://terminology.hl7.org/CodeSystem/data-absent-reason#unknown"
          }
        ]
      },
      {
        "id" : "Radiotherapy.target.boost.totalDose.dose",
        "path" : "Radiotherapy.target.boost.totalDose.dose",
        "short" : "Dose",
        "definition" : "Specify the total dose given to the boost site.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "decimal"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".valueQuantity.value"
          }
        ]
      },
      {
        "id" : "Radiotherapy.target.boost.totalDose.unit",
        "path" : "Radiotherapy.target.boost.totalDose.unit",
        "short" : "Unit",
        "definition" : "Specify the unit of the boost in case of external beam radiotherapy as  Gy. \nspecify if dose is recorded in bequerels (MBq or GBq) or curies (Ci) or Unkwnon",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".valueQuantity.code"
          }
        ]
      },
      {
        "id" : "Radiotherapy.target.boost.totalDose.fractions",
        "path" : "Radiotherapy.target.boost.totalDose.fractions",
        "short" : "Number of fractions (if  external beam)",
        "definition" : "A fraction of radiation treatment is a single attendance for treatment. Please specify the number of fractions given as included in the boost. If not known, insert NK.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "integer"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".extension(http://hl7.eu/fhir/ig/pcsp/StructureDefinition/procedure-performedTiming).valueTiming.repeat.count"
          }
        ]
      },
      {
        "id" : "Radiotherapy.target.shielding",
        "path" : "Radiotherapy.target.shielding",
        "short" : "Shielding",
        "definition" : "Shielding, in some records this is called ?blocking? or ?blocks?. ",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Procedure.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-radiotheraphyShield-eu-pcsp')"
          }
        ]
      },
      {
        "id" : "Radiotherapy.target.shielding.status",
        "path" : "Radiotherapy.target.shielding.status",
        "short" : "Shielding status",
        "definition" : "Specify if shielding was used or not. \nYes;  No;  NK �",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".status"
          }
        ]
      },
      {
        "id" : "Radiotherapy.target.shielding.position",
        "path" : "Radiotherapy.target.shielding.position",
        "short" : "Position of shielding",
        "definition" : "Describe the positioning of shielding",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".bodySite"
          }
        ]
      },
      {
        "id" : "Radiotherapy.organAtRisk",
        "path" : "Radiotherapy.organAtRisk",
        "short" : "Organ at Risk",
        "definition" : "Organs at Risk",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".extension(http://hl7.org/fhir/StructureDefinition/workflow-supportingInfo).ofType(DocumentReference)"
          }
        ]
      },
      {
        "id" : "Radiotherapy.organAtRisk.dosimetry",
        "path" : "Radiotherapy.organAtRisk.dosimetry",
        "short" : "Dosimetry on Organ at Risk",
        "definition" : "Specify if there is available information on Dosimetry of Organs at Risk [Yes/No]",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".exists()"
          }
        ]
      },
      {
        "id" : "Radiotherapy.organAtRisk.dosimetryDocument",
        "path" : "Radiotherapy.organAtRisk.dosimetryDocument",
        "short" : "Electronic / scanned version(s) of relevant document(s)",
        "definition" : "If Dosimetry on Organ at Risk is available, upload here the electronic / scanned version(s) of any relevant document(s)",
        "min" : 0,
        "max" : "2",
        "type" : [
          {
            "code" : "Binary"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "."
          }
        ]
      },
      {
        "id" : "Radiotherapy.files",
        "path" : "Radiotherapy.files",
        "short" : "Upload radiotherapy file (1)",
        "definition" : "Radiotherapy file(s) can be uploaded here",
        "min" : 0,
        "max" : "2",
        "type" : [
          {
            "code" : "Binary"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".extension(http://hl7.org/fhir/StructureDefinition/workflow-supportingInfo).ofType(DocumentReference)"
          }
        ]
      },
      {
        "id" : "Radiotherapy.notes",
        "path" : "Radiotherapy.notes",
        "short" : "Notes",
        "definition" : "Notes",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".note"
          }
        ]
      }
    ]
  }
}

```
