# Procedure: Other Treatments - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Procedure: Other Treatments**

## Resource Profile: Procedure: Other Treatments 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-treatment-otherinfos-eu-pcsp | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:ProcedureOtherTreatmentPcsp |

 
This profile defines how to convey textual information about other oncological treatments in HL7 FHIR for the purpose of the PanCareSurPass project. 

**Usages:**

* Use this Profile: [Bundle: Survivor Passport](StructureDefinition-Bundle-eu-pcsp.md)
* Refer to this Profile: [Composition: Survivor Passport](StructureDefinition-Composition-surpass-eu-pcsp.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.pcsp|current/StructureDefinition/Procedure-treatment-otherinfos-eu-pcsp)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Procedure-treatment-otherinfos-eu-pcsp.csv), [Excel](StructureDefinition-Procedure-treatment-otherinfos-eu-pcsp.xlsx), [Schematron](StructureDefinition-Procedure-treatment-otherinfos-eu-pcsp.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Procedure-treatment-otherinfos-eu-pcsp",
  "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-treatment-otherinfos-eu-pcsp",
  "version" : "1.0.0",
  "name" : "ProcedureOtherTreatmentPcsp",
  "title" : "Procedure: Other Treatments",
  "status" : "active",
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "This profile defines how to convey textual information about other oncological treatments in HL7 FHIR for the purpose of the PanCareSurPass project.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Procedure",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Procedure",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Procedure.text",
        "path" : "Procedure.text",
        "short" : "Any other treatment (not included in the chemotherapy, surgery or radiotherapy sections)",
        "min" : 1
      },
      {
        "id" : "Procedure.code",
        "path" : "Procedure.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-generic-eu-pcsp",
              "code" : "other-treatment",
              "display" : "Other oncological treatments"
            }
          ]
        }
      },
      {
        "id" : "Procedure.subject",
        "path" : "Procedure.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Patient-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.reasonReference",
        "path" : "Procedure.reasonReference",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-primaryCancer-eu-pcsp"
            ]
          }
        ]
      }
    ]
  }
}

```
