# Procedure: Radiotherapy Shielding - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Procedure: Radiotherapy Shielding**

## Resource Profile: Procedure: Radiotherapy Shielding 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-radiotheraphyShield-eu-pcsp | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:ProcedureRadiotherapyShieldingPcsp |

 
This profile defines how to represent Shielding Procedures in FHIR for describing a set of Radiotherapy data required by the PanCareSurPass algorithm to generate the care plan. 

**Usages:**

* Use this Profile: [Bundle: Survivor Passport](StructureDefinition-Bundle-eu-pcsp.md)
* Refer to this Profile: [Composition: Survivor Passport](StructureDefinition-Composition-surpass-eu-pcsp.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.pcsp|current/StructureDefinition/Procedure-radiotheraphyShield-eu-pcsp)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Procedure-radiotheraphyShield-eu-pcsp.csv), [Excel](StructureDefinition-Procedure-radiotheraphyShield-eu-pcsp.xlsx), [Schematron](StructureDefinition-Procedure-radiotheraphyShield-eu-pcsp.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Procedure-radiotheraphyShield-eu-pcsp",
  "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-radiotheraphyShield-eu-pcsp",
  "version" : "1.0.0",
  "name" : "ProcedureRadiotherapyShieldingPcsp",
  "title" : "Procedure: Radiotherapy Shielding",
  "status" : "active",
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "This profile defines how to represent Shielding Procedures in FHIR for describing a set of Radiotherapy data required by the PanCareSurPass algorithm to generate the care plan.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Procedure",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Procedure",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Procedure.partOf",
        "path" : "Procedure.partOf",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-radiotheraphy-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.category",
        "path" : "Procedure.category",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "108290001",
              "display" : "Radiotherapy"
            }
          ]
        }
      },
      {
        "id" : "Procedure.code",
        "path" : "Procedure.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "228720004",
              "display" : "Making of shielding block for radiotherapy"
            }
          ]
        }
      },
      {
        "id" : "Procedure.subject",
        "path" : "Procedure.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Patient-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.reasonReference",
        "path" : "Procedure.reasonReference",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-primaryCancer-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.bodySite",
        "path" : "Procedure.bodySite",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/vs-radiotherapy-pcsp"
        }
      },
      {
        "id" : "Procedure.bodySite.extension:locationQualifier",
        "path" : "Procedure.bodySite.extension",
        "sliceName" : "locationQualifier",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/mcode-body-location-qualifier"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.bodySite.extension:locationQualifier.value[x]",
        "path" : "Procedure.bodySite.extension.value[x]",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/vs-fromToPosteriorAnterior-eu-pcsp"
        }
      },
      {
        "id" : "Procedure.bodySite.extension:lateralityQualifier",
        "path" : "Procedure.bodySite.extension",
        "sliceName" : "lateralityQualifier",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/mcode-laterality-qualifier"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.note",
        "path" : "Procedure.note",
        "short" : "Additional information about the Radiotherapy"
      }
    ]
  }
}

```
