# Procedure: Radiotherapy Boost - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Procedure: Radiotherapy Boost**

## Resource Profile: Procedure: Radiotherapy Boost 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-radiotheraphyBoost-eu-pcsp | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:ProcedureRadiotherapyBoostPcsp |

 
This profile defines how to represent Procedures in FHIR for describing a set of data required by PanCareSurPass for Radiotherapy Boosts 

**Usages:**

* Use this Profile: [Bundle: Survivor Passport](StructureDefinition-Bundle-eu-pcsp.md)
* Refer to this Profile: [Composition: Survivor Passport](StructureDefinition-Composition-surpass-eu-pcsp.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.pcsp|current/StructureDefinition/Procedure-radiotheraphyBoost-eu-pcsp)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Procedure-radiotheraphyBoost-eu-pcsp.csv), [Excel](StructureDefinition-Procedure-radiotheraphyBoost-eu-pcsp.xlsx), [Schematron](StructureDefinition-Procedure-radiotheraphyBoost-eu-pcsp.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Procedure-radiotheraphyBoost-eu-pcsp",
  "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-radiotheraphyBoost-eu-pcsp",
  "version" : "1.0.0",
  "name" : "ProcedureRadiotherapyBoostPcsp",
  "title" : "Procedure: Radiotherapy Boost",
  "status" : "active",
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "This profile defines how to represent Procedures in FHIR for describing a set of data required by PanCareSurPass for Radiotherapy Boosts",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Procedure",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Procedure",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Procedure.extension",
        "path" : "Procedure.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Procedure.extension:relatedDose",
        "path" : "Procedure.extension",
        "sliceName" : "relatedDose",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/resource-relatedInfo"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.extension:relatedDose.value[x]",
        "path" : "Procedure.extension.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-totalDoseRad-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.extension:procedureMethod",
        "path" : "Procedure.extension",
        "sliceName" : "procedureMethod",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/procedure-method|5.2.0"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.extension:procedureMethod.value[x]",
        "path" : "Procedure.extension.value[x]",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/vs-brachytherapyType-eu-pcsp"
        }
      },
      {
        "id" : "Procedure.extension:energyOrIsotope",
        "path" : "Procedure.extension",
        "sliceName" : "energyOrIsotope",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/radiotherapy-energy-or-isotope"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.extension:performedTiming",
        "path" : "Procedure.extension",
        "sliceName" : "performedTiming",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/procedure-performedTiming"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.extension:performedTiming.value[x].repeat.count",
        "path" : "Procedure.extension.value[x].repeat.count",
        "short" : "Number of repetitions"
      },
      {
        "id" : "Procedure.identifier",
        "path" : "Procedure.identifier",
        "short" : "External Identifiers for this radiotherapy / boost"
      },
      {
        "id" : "Procedure.partOf",
        "path" : "Procedure.partOf",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-radiotheraphy-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.status",
        "path" : "Procedure.status",
        "short" : "Procedure status"
      },
      {
        "id" : "Procedure.category",
        "path" : "Procedure.category",
        "min" : 1
      },
      {
        "id" : "Procedure.category.coding",
        "path" : "Procedure.category.coding",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "$this"
            }
          ],
          "description" : "Slice based on the values set binding",
          "rules" : "open"
        },
        "min" : 2
      },
      {
        "id" : "Procedure.category.coding:radiotheraphy",
        "path" : "Procedure.category.coding",
        "sliceName" : "radiotheraphy",
        "min" : 1,
        "max" : "1",
        "patternCoding" : {
          "system" : "http://snomed.info/sct",
          "code" : "108290001",
          "display" : "Radiotherapy"
        }
      },
      {
        "id" : "Procedure.category.coding:boost",
        "path" : "Procedure.category.coding",
        "sliceName" : "boost",
        "min" : 1,
        "max" : "1",
        "patternCoding" : {
          "system" : "http://snomed.info/sct",
          "code" : "445232009",
          "display" : "Boost radiation therapy"
        }
      },
      {
        "id" : "Procedure.code",
        "path" : "Procedure.code",
        "min" : 1,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/vs-radiotherapyType-eu-pcsp"
        }
      },
      {
        "id" : "Procedure.subject",
        "path" : "Procedure.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Patient-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.performed[x]",
        "path" : "Procedure.performed[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Procedure.performed[x]:performedPeriod",
        "path" : "Procedure.performed[x]",
        "sliceName" : "performedPeriod",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Period"
          }
        ]
      },
      {
        "id" : "Procedure.reasonReference",
        "path" : "Procedure.reasonReference",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-primaryCancer-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.bodySite",
        "path" : "Procedure.bodySite",
        "short" : "required for Brachytherapy and External beam",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/vs-radiotherapy-pcsp"
        }
      },
      {
        "id" : "Procedure.bodySite.extension:locationQualifier",
        "path" : "Procedure.bodySite.extension",
        "sliceName" : "locationQualifier",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/mcode-body-location-qualifier"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.bodySite.extension:locationQualifier.value[x]",
        "path" : "Procedure.bodySite.extension.value[x]",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/vs-fromToPosteriorAnterior-eu-pcsp"
        }
      },
      {
        "id" : "Procedure.bodySite.extension:lateralityQualifier",
        "path" : "Procedure.bodySite.extension",
        "sliceName" : "lateralityQualifier",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/mcode-laterality-qualifier"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.note",
        "path" : "Procedure.note",
        "short" : "Additional information about the Radiotherapy"
      }
    ]
  }
}

```
