# Hulafe - Patient: Sample of demographics data - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Hulafe - Patient: Sample of demographics data**

## Example Patient: Hulafe - Patient: Sample of demographics data

Language: es-ES

Profile: [Patient: PCSP](StructureDefinition-Patient-eu-pcsp.md)

NOMBRE APELLIDO1 APELLIDO2(anonymous) Female, DoB: 2005-07-01 ( urn:oid:2.16.724.4.10.50.200#123456789 (use: official, ))

-------

| | |
| :--- | :--- |
| Contact Detail | [belensmicorr@gggmail.com](mailto:belensmicorr@gggmail.com) |
| Language: | Spanish (Spain) |
| [Patient Mother's Maiden Name](http://hl7.org/fhir/extensions/5.2.0/StructureDefinition-patient-mothersMaidenName.html) | APELLIDO2 |
| [Patient Birth Place](http://hl7.org/fhir/extensions/5.2.0/StructureDefinition-patient-birthPlace.html) | CALLEFALSA123 Valencia Valencia España |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "PatientHulafe-1",
  "meta" : {
    "profile" : [
      "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Patient-eu-pcsp"
    ]
  },
  "language" : "es-ES",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/patient-mothersMaidenName",
      "valueString" : "APELLIDO2"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/patient-birthPlace",
      "valueAddress" : {
        "line" : ["CALLEFALSA123"],
        "city" : "Valencia",
        "state" : "Valencia",
        "country" : "España"
      }
    }
  ],
  "identifier" : [
    {
      "use" : "official",
      "system" : "urn:oid:2.16.724.4.10.50.200",
      "value" : "123456789"
    }
  ],
  "name" : [
    {
      "use" : "anonymous",
      "text" : "NOMBRE APELLIDO1 APELLIDO2",
      "family" : "APELLIDO1",
      "given" : ["NOMBRE"]
    }
  ],
  "telecom" : [
    {
      "system" : "email",
      "value" : "belensmicorr@gggmail.com"
    }
  ],
  "gender" : "female",
  "birthDate" : "2005-07-01",
  "communication" : [
    {
      "language" : {
        "coding" : [
          {
            "system" : "urn:ietf:bcp:47",
            "code" : "es-ES",
            "display" : "Spanish (Spain)"
          }
        ]
      }
    }
  ]
}

```
