# Mainz - Observation: Radiotherapy Total Dose (Zeisig) - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Mainz - Observation: Radiotherapy Total Dose (Zeisig)**

## Example Observation: Mainz - Observation: Radiotherapy Total Dose (Zeisig)

Profile: [Observation: Radiotherapy Total Dose PCSP](StructureDefinition-Observation-totalDoseRad-eu-pcsp.md)

**status**: Final

**category**: Procedure

**code**: Total boost radiation dose delivered

**subject**: [Sarah Zeisig Female, DoB: 1996-12-12 ( http://hl7.eu/fhir/ig/pcsp/sid/pat-id-mainz#L0010)](Patient-PatientMainzZeisig.md)

**value**: 5 Gy(Details: UCUM codeGy = 'Gy')

**bodySite**: Brain: Occipital lobe



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "ObservationRadTotalDose-1",
  "meta" : {
    "profile" : [
      "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-totalDoseRad-eu-pcsp"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "procedure"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "445565002",
        "display" : "Total boost radiation dose delivered"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/PatientMainzZeisig"
  },
  "valueQuantity" : {
    "value" : 5,
    "unit" : "Gy",
    "system" : "http://unitsofmeasure.org",
    "code" : "Gy"
  },
  "bodySite" : {
    "coding" : [
      {
        "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-radiotherapy-pcsp",
        "code" : "1.4",
        "display" : "Brain: Occipital lobe"
      }
    ]
  }
}

```
