# Mainz - Observation: Blood type/RH before the SCT (Zeisig) - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Mainz - Observation: Blood type/RH before the SCT (Zeisig)**

## Example Observation: Mainz - Observation: Blood type/RH before the SCT (Zeisig)

Profile: [Observation: Blood type/RH](StructureDefinition-Observation-bld-abo-rh-eu-pcsp.md)

**partOf**: [Procedure Autogenous transplantation](Procedure-ProcedureSTC-1.md)

**status**: Final

**code**: ABO and Rh group panel - Blood

**subject**: [Sarah Zeisig Female, DoB: 1996-12-12 ( http://hl7.eu/fhir/ig/pcsp/sid/pat-id-mainz#L0010)](Patient-PatientMainzZeisig.md)

**effective**: Code 

> **component****code**:ABO group [Type] in Blood**value**:Group A

> **component****code**:Rh [Type] in Blood**value**:Positive



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "ObservationCBloodSCT-1-1",
  "meta" : {
    "profile" : [
      "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-bld-abo-rh-eu-pcsp"
    ]
  },
  "partOf" : [
    {
      "reference" : "Procedure/ProcedureSTC-1"
    }
  ],
  "status" : "final",
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "34530-6",
        "display" : "ABO and Rh group panel - Blood"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/PatientMainzZeisig"
  },
  "effectiveTiming" : {
    "code" : {
      "coding" : [
        {
          "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-generic-eu-pcsp",
          "code" : "before-procedure",
          "display" : "Before procedure"
        }
      ]
    }
  },
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "883-9",
            "display" : "ABO group [Type] in Blood"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "LA19710-5",
            "display" : "Group A"
          },
          {
            "system" : "http://snomed.info/sct",
            "code" : "112144000",
            "display" : "Blood group A"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "10331-7",
            "display" : "Rh [Type] in Blood"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "LA6576-8",
            "display" : "Positive"
          },
          {
            "system" : "http://snomed.info/sct",
            "code" : "10828004",
            "display" : "Positive"
          }
        ]
      }
    }
  ]
}

```
