# Risk Factors - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Risk Factors**

## CodeSystem: Risk Factors 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-riskfactor-eu-pcsp | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:CsRiskFactorPcsp |

 
Risk Factors used by the PCSP algorithm 

 This Code system is referenced in the content logical definition of the following value sets: 

* [RiskFactor](ValueSet-vs-riskfactor-eu-pcsp.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "cs-riskfactor-eu-pcsp",
  "url" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-riskfactor-eu-pcsp",
  "version" : "1.0.0",
  "name" : "CsRiskFactorPcsp",
  "title" : "Risk Factors",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "Risk Factors used by the PCSP algorithm",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 112,
  "concept" : [
    {
      "code" : "1.1",
      "display" : "RT to a vol exposing the thyroid gland",
      "definition" : "RT to a vol exposing the thyroid gland"
    },
    {
      "code" : "1.2",
      "display" : "TBI",
      "definition" : "TBI"
    },
    {
      "code" : "1.3",
      "display" : "MIBG therapy (I-131 MIBG therapy)",
      "definition" : "MIBG therapy (I-131 MIBG therapy)"
    },
    {
      "code" : "2.1",
      "display" : "RT >= 10 Gy to a vol exposing the breasts",
      "definition" : "RT >= 10 Gy to a vol exposing the breasts"
    },
    {
      "code" : "2.2",
      "display" : "OR upper abdominal field radiation that can extend above the diaphragm likely exposing breast tissue at a young age",
      "definition" : "OR upper abdominal field radiation that can extend above the diaphragm likely exposing breast tissue at a young age"
    },
    {
      "code" : "3.1",
      "display" : "RT >= 35 Gy to a vol exposing the heart",
      "definition" : "RT >= 35 Gy to a vol exposing the heart"
    },
    {
      "code" : "3.2",
      "display" : "Anthracyclines (doxorubicin isotoxic equivalents)>= 250 mg/m2",
      "definition" : "Anthracyclines (doxorubicin isotoxic equivalents)>= 250 mg/m2"
    },
    {
      "code" : "3.3",
      "display" : "RT >= 15 Gy to a vol exposing the heart AND Anthracyclines (doxorubicin isotoxic equivalents)>= 100 mg/m2",
      "definition" : "RT >= 15 Gy to a vol exposing the heart AND Anthracyclines (doxorubicin isotoxic equivalents)>= 100 mg/m2"
    },
    {
      "code" : "4.1",
      "display" : "Alkylating agents",
      "definition" : "Alkylating agents"
    },
    {
      "code" : "4.2",
      "display" : "RT to a vol exposing the testes",
      "definition" : "RT to a vol exposing the testes"
    },
    {
      "code" : "4.3",
      "display" : "Including TBI",
      "definition" : "Including TBI"
    },
    {
      "code" : "5.1",
      "display" : "RT >=12 Gy to a vol exposing the testicles",
      "definition" : "RT >=12 Gy to a vol exposing the testicles"
    },
    {
      "code" : "6.3",
      "display" : "Surgery to the spinal cord, sympathetic nerves or pelvis",
      "definition" : "Surgery to the spinal cord, sympathetic nerves or pelvis"
    },
    {
      "code" : "6.4",
      "display" : "Hypogonadal",
      "definition" : "Hypogonadal"
    },
    {
      "code" : "7.2",
      "display" : "RT to a vol exposing the ovaries",
      "definition" : "RT to a vol exposing the ovaries"
    },
    {
      "code" : "8.1",
      "display" : "RT >= 30 Gy to a vol exposing the head or the brain",
      "definition" : "RT >= 30 Gy to a vol exposing the head or the brain"
    },
    {
      "code" : "8.2",
      "display" : "Cisplatin (with or without carboplatin > 1500 mg/m2)",
      "definition" : "Cisplatin (with or without carboplatin > 1500 mg/m2)"
    },
    {
      "code" : "9.1",
      "display" : "RT to a vol exposing the pancreas",
      "definition" : "RT to a vol exposing the pancreas"
    },
    {
      "code" : "10.2",
      "display" : "HSCT",
      "definition" : "HSCT"
    },
    {
      "code" : "11.1",
      "display" : "RT to a volume exposing the hypothalamus or pituatary gland",
      "definition" : "RT to a volume exposing the hypothalamus or pituatary gland"
    },
    {
      "code" : "11.3",
      "display" : "Hypothalamic or pituitary tumour",
      "definition" : "Hypothalamic or pituitary tumour"
    },
    {
      "code" : "11.4",
      "display" : "Neurosurgery of the hypothalamus or pituitary gland",
      "definition" : "Neurosurgery of the hypothalamus or pituitary gland"
    },
    {
      "code" : "12.1",
      "display" : "RT to a vol exposing the kidneys, heart and associated large vessels",
      "definition" : "RT to a vol exposing the kidneys, heart and associated large vessels"
    },
    {
      "code" : "12.3",
      "display" : "Nephrectomy",
      "definition" : "Nephrectomy"
    },
    {
      "code" : "12.4",
      "display" : "Ifosfamide",
      "definition" : "Ifosfamide"
    },
    {
      "code" : "12.5",
      "display" : "Platinium based chemotherapy",
      "definition" : "Platinium based chemotherapy"
    },
    {
      "code" : "12.6",
      "display" : "Nitrosureas",
      "definition" : "Nitrosureas"
    },
    {
      "code" : "12.7",
      "display" : "Immunosuppressives treatment and prolonged steroids as anticancer treatment (at least 4 weeks, continuously)",
      "definition" : "Immunosuppressives treatment and prolonged steroids as anticancer treatment (at least 4 weeks, continuously)"
    },
    {
      "code" : "13.1",
      "display" : "Cranial and/or spinal RT",
      "definition" : "Cranial and/or spinal RT"
    },
    {
      "code" : "13.3",
      "display" : "Methotrexate",
      "definition" : "Methotrexate"
    },
    {
      "code" : "13.4",
      "display" : "Gonadal failure",
      "definition" : "Gonadal failure"
    },
    {
      "code" : "13.5",
      "display" : "Growth hormone deficiency",
      "definition" : "Growth hormone deficiency"
    },
    {
      "code" : "13.6",
      "display" : "Prolonged (at least 4 weeks, continuously) corticosteroids as anti-cancer treatment",
      "definition" : "Prolonged (at least 4 weeks, continuously) corticosteroids as anti-cancer treatment"
    },
    {
      "code" : "13.7",
      "display" : "HSCT, especially with an history of GVHD",
      "definition" : "HSCT, especially with an history of GVHD"
    },
    {
      "code" : "14.3",
      "display" : "High dose RT",
      "definition" : "High dose RT"
    },
    {
      "code" : "15.1",
      "display" : "Radiotherapy to a vol exposing the HP region >= 30 Gy",
      "definition" : "Radiotherapy to a vol exposing the HP region >= 30 Gy"
    },
    {
      "code" : "15.2",
      "display" : "Surgery near or within the HP region",
      "definition" : "Surgery near or within the HP region"
    },
    {
      "code" : "15.3",
      "display" : "CNS tumours near or within the HP region",
      "definition" : "CNS tumours near or within the HP region"
    },
    {
      "code" : "16.1",
      "display" : "Radiotherapy to a vol exposing the HP region< 30 Gy",
      "definition" : "Radiotherapy to a vol exposing the HP region< 30 Gy"
    },
    {
      "code" : "16.2",
      "display" : "Hydrocephalus or cerebrospinal fluid shunt(Risk factor for GHD)",
      "definition" : "Hydrocephalus or cerebrospinal fluid shunt(Risk factor for GHD)"
    },
    {
      "code" : "17.1",
      "display" : "Radiotherapy to a vol exposing the HP region",
      "definition" : "Radiotherapy to a vol exposing the HP region"
    },
    {
      "code" : "17.5",
      "display" : "hydrocephalus or cerebrospinal fluid shunt",
      "definition" : "hydrocephalus or cerebrospinal fluid shunt"
    },
    {
      "code" : "19.3",
      "display" : "Radioiodine therapy (I-131 ablation therapy)",
      "definition" : "Radioiodine therapy (I-131 ablation therapy)"
    },
    {
      "code" : "19.5",
      "display" : "Allogenic HSCT",
      "definition" : "Allogenic HSCT"
    },
    {
      "code" : "19.6",
      "display" : "Total thyroidectomy",
      "definition" : "Total thyroidectomy"
    },
    {
      "code" : "20.1",
      "display" : "RT to a vol exposing the head, brain or neck",
      "definition" : "RT to a vol exposing the head, brain or neck"
    },
    {
      "code" : "21.1",
      "display" : "History of a central nervous system tumor",
      "definition" : "History of a central nervous system tumor"
    },
    {
      "code" : "21.2",
      "display" : "RT to a vol exposing the brain ANY DOSE",
      "definition" : "RT to a vol exposing the brain ANY DOSE"
    },
    {
      "code" : "21.4",
      "display" : "Brain surgery",
      "definition" : "Brain surgery"
    },
    {
      "code" : "21.5",
      "display" : "High dose cytarabine IV (intravenous)",
      "definition" : "High dose cytarabine IV (intravenous)"
    },
    {
      "code" : "21.6",
      "display" : "High dose MTX IV",
      "definition" : "High dose MTX IV"
    },
    {
      "code" : "21.7",
      "display" : "Any Chemotherapy IT (intrathecal)",
      "definition" : "Any Chemotherapy IT (intrathecal)"
    },
    {
      "code" : "22.1",
      "display" : "Vinca-Alkaloids",
      "definition" : "Vinca-Alkaloids"
    },
    {
      "code" : "22.2",
      "display" : "Cisplatin or carboplatin",
      "definition" : "Cisplatin or carboplatin"
    },
    {
      "code" : "23.1",
      "display" : "RT to a vol exposing the lens",
      "definition" : "RT to a vol exposing the lens"
    },
    {
      "code" : "24.1",
      "display" : "RT to a vol exposing the eye and orbit",
      "definition" : "RT to a vol exposing the eye and orbit"
    },
    {
      "code" : "25.1",
      "display" : "RT to a vol exposing the craniofacial area, especially after high doses and at a young age",
      "definition" : "RT to a vol exposing the craniofacial area, especially after high doses and at a young age"
    },
    {
      "code" : "25.3",
      "display" : "Surgery to the face, especially at a young age",
      "definition" : "Surgery to the face, especially at a young age"
    },
    {
      "code" : "26.1",
      "display" : "Surgery of the spine",
      "definition" : "Surgery of the spine"
    },
    {
      "code" : "26.2",
      "display" : "Surgery of the chest (Does not include CVC pose)",
      "definition" : "Surgery of the chest (Does not include CVC pose)"
    },
    {
      "code" : "26.3",
      "display" : "RT to a vol exposing the spine",
      "definition" : "RT to a vol exposing the spine"
    },
    {
      "code" : "26.4",
      "display" : "Spinal or paraspinal malignancies",
      "definition" : "Spinal or paraspinal malignancies"
    },
    {
      "code" : "27.1",
      "display" : "Cyclophosphamide",
      "definition" : "Cyclophosphamide"
    },
    {
      "code" : "27.3",
      "display" : "RT to a vol exposing the bladder",
      "definition" : "RT to a vol exposing the bladder"
    },
    {
      "code" : "27.5",
      "display" : "Cystectomy",
      "definition" : "Cystectomy"
    },
    {
      "code" : "27.6",
      "display" : "Hysterectomy",
      "definition" : "Hysterectomy"
    },
    {
      "code" : "27.7",
      "display" : "Pelvic surgery",
      "definition" : "Pelvic surgery"
    },
    {
      "code" : "27.8",
      "display" : "Spinal cord surgery",
      "definition" : "Spinal cord surgery"
    },
    {
      "code" : "28.1",
      "display" : "RT to a vol exposing the uterus only female",
      "definition" : "RT to a vol exposing the uterus only female"
    },
    {
      "code" : "29.1",
      "display" : "RT to a vol exposing the oral cavity or salivary glands",
      "definition" : "RT to a vol exposing the oral cavity or salivary glands"
    },
    {
      "code" : "29.4",
      "display" : "Chemotherapy",
      "definition" : "Chemotherapy"
    },
    {
      "code" : "30.1",
      "display" : "RT to a vol exposing the gastro-intestinal tract",
      "definition" : "RT to a vol exposing the gastro-intestinal tract"
    },
    {
      "code" : "30.3",
      "display" : "Oesophageal surgery",
      "definition" : "Oesophageal surgery"
    },
    {
      "code" : "30.4",
      "display" : "Abdominal surgery",
      "definition" : "Abdominal surgery"
    },
    {
      "code" : "30.5",
      "display" : "With a history of chronic GVHD",
      "definition" : "With a history of chronic GVHD"
    },
    {
      "code" : "31.1",
      "display" : "Anthracyclines (doxorubicin isotoxic equivalents) <100 mg/m2",
      "definition" : "Anthracyclines (doxorubicin isotoxic equivalents) <100 mg/m2"
    },
    {
      "code" : "32.1",
      "display" : "RT to a vol exposing the lungs",
      "definition" : "RT to a vol exposing the lungs"
    },
    {
      "code" : "32.3",
      "display" : "Bleomycin",
      "definition" : "Bleomycin"
    },
    {
      "code" : "32.4",
      "display" : "Busulfan",
      "definition" : "Busulfan"
    },
    {
      "code" : "32.5",
      "display" : "BCNU Carmustine",
      "definition" : "BCNU Carmustine"
    },
    {
      "code" : "32.6",
      "display" : "CCNU Lomustine",
      "definition" : "CCNU Lomustine"
    },
    {
      "code" : "32.7",
      "display" : "Thoracic surgery",
      "definition" : "Thoracic surgery"
    },
    {
      "code" : "33.1",
      "display" : "Cisplatin Any dose",
      "definition" : "Cisplatin Any dose"
    },
    {
      "code" : "33.2",
      "display" : "Ifosfamide Any dose",
      "definition" : "Ifosfamide Any dose"
    },
    {
      "code" : "33.3",
      "display" : "Carboplatin Any dose",
      "definition" : "Carboplatin Any dose"
    },
    {
      "code" : "34.1",
      "display" : "RT to a volume exposing the liver",
      "definition" : "RT to a volume exposing the liver"
    },
    {
      "code" : "34.10",
      "display" : "Chronic GVHD",
      "definition" : "Chronic GVHD"
    },
    {
      "code" : "34.11",
      "display" : "Liver surgery",
      "definition" : "Liver surgery"
    },
    {
      "code" : "34.3",
      "display" : "HSCT (irrespective of GVHD)",
      "definition" : "HSCT (irrespective of GVHD)"
    },
    {
      "code" : "34.5",
      "display" : "Mercaptopurine Thioguanine",
      "definition" : "Mercaptopurine Thioguanine"
    },
    {
      "code" : "34.6",
      "display" : "Dactinomycin",
      "definition" : "Dactinomycin"
    },
    {
      "code" : "34.8",
      "display" : "Chronic viral hepatitis",
      "definition" : "Chronic viral hepatitis"
    },
    {
      "code" : "34.9",
      "display" : "Sinusoidal obstruction syndrome",
      "definition" : "Sinusoidal obstruction syndrome"
    },
    {
      "code" : "35.1",
      "display" : "HSCT (irrespective of GVHD)",
      "definition" : "HSCT (irrespective of GVHD)"
    },
    {
      "code" : "35.2",
      "display" : "Multiple red blood cell transfusions",
      "definition" : "Multiple red blood cell transfusions"
    },
    {
      "code" : "36.1",
      "display" : "Splenectomy",
      "definition" : "Splenectomy"
    },
    {
      "code" : "36.2",
      "display" : "RT >= 10 Gy to a vol exposing the spleen",
      "definition" : "RT >= 10 Gy to a vol exposing the spleen"
    },
    {
      "code" : "36.3",
      "display" : "Allogenic HSCT (with or without TBI)",
      "definition" : "Allogenic HSCT (with or without TBI)"
    },
    {
      "code" : "36.4",
      "display" : "Autologus HSCT conditioned with TBI",
      "definition" : "Autologus HSCT conditioned with TBI"
    },
    {
      "code" : "37.1",
      "display" : "Hereditary cancer sd",
      "definition" : "Hereditary cancer sd"
    },
    {
      "code" : "38.1",
      "display" : "Any RT including TBI (predominantly in the RT field)",
      "definition" : "Any RT including TBI (predominantly in the RT field)"
    },
    {
      "code" : "38.2",
      "display" : "HSCT Especially with a history of skin GvHD",
      "definition" : "HSCT Especially with a history of skin GvHD"
    },
    {
      "code" : "39.1",
      "display" : "RT to a vol exposing the colon and rectum",
      "definition" : "RT to a vol exposing the colon and rectum"
    },
    {
      "code" : "40.1",
      "display" : "RT to a vol exposing the oral cavity",
      "definition" : "RT to a vol exposing the oral cavity"
    },
    {
      "code" : "41.2",
      "display" : "Anthracyclines and/or Mitoxantrone",
      "definition" : "Anthracyclines and/or Mitoxantrone"
    },
    {
      "code" : "41.3",
      "display" : "Epipodophyllotoxins or autologous",
      "definition" : "Epipodophyllotoxins or autologous"
    },
    {
      "code" : "41.4",
      "display" : "Autologous haematopoietic stem cell transplant",
      "definition" : "Autologous haematopoietic stem cell transplant"
    },
    {
      "code" : "42.1",
      "display" : "Ciclofosfamide, Ifosfamide (particularly if they have a history of severe hemorrhagic cystitis)",
      "definition" : "Ciclofosfamide, Ifosfamide (particularly if they have a history of severe hemorrhagic cystitis)"
    },
    {
      "code" : "45.1",
      "display" : "RT to a vol exposing the head or brain",
      "definition" : "RT to a vol exposing the head or brain"
    },
    {
      "code" : "46.1",
      "display" : "RT between 15 and 35 Gy to a vol exposing the heart",
      "definition" : "RT between 15 and 35 Gy to a vol exposing the heart"
    },
    {
      "code" : "46.2",
      "display" : "Anthracyclines (doxorubicin isotoxic equivalents) between 100 and 250 mg/m2",
      "definition" : "Anthracyclines (doxorubicin isotoxic equivalents) between 100 and 250 mg/m2"
    },
    {
      "code" : "47.1",
      "display" : "RT to a vol exposing the kidney or urinary tract",
      "definition" : "RT to a vol exposing the kidney or urinary tract"
    }
  ]
}

```
