# Hulafe - Bundle: Example of a Childhood Cancer Survivor Passport - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Hulafe - Bundle: Example of a Childhood Cancer Survivor Passport**

## Example Bundle: Hulafe - Bundle: Example of a Childhood Cancer Survivor Passport

**Document Details**

Profile: [Bundle: Survivor Passport](StructureDefinition-Bundle-eu-pcsp.md)

Preliminary Document at 2025-06-11 07:41:51+0000 by Identifier: test for [NOMBRE APELLIDO1 APELLIDO2(anonymous) Female, DoB: 2005-07-01 ( urn:oid:2.16.724.4.10.50.200#123456789 (use: official, ))](Patient-PatientHulafe-1.md) 

-------

**Document Subject**

Language: es-ES

Profile: [Patient: PCSP](StructureDefinition-Patient-eu-pcsp.md)

NOMBRE APELLIDO1 APELLIDO2(anonymous) Female, DoB: 2005-07-01 ( urn:oid:2.16.724.4.10.50.200#123456789 (use: official, ))

-------

-------

**Document Content**

## Cancer Diagnosis and Treatment

Primary Cancer Diagnosis and Treatment Summary

### Chemotherapy

Chemotherapy Treatments

## Care Plan

Care Plan

-------

## Additional Resources Included in Document

-------

Entry 2 - fullUrl = http://hl7.eu/fhir/ig/pcsp/Patient/PatientHulafe-1

Resource Patient:

> 

Language: es-ES

Profile: [Patient: PCSP](StructureDefinition-Patient-eu-pcsp.md)

NOMBRE APELLIDO1 APELLIDO2(anonymous) Female, DoB: 2005-07-01 ( urn:oid:2.16.724.4.10.50.200#123456789 (use: official, ))
-------

-------

Entry 3 - fullUrl = http://hl7.eu/fhir/ig/pcsp/Condition/PrimaryCancerHulafe-1

Resource Condition:

> 

Language: es-ES

Profile: [Condition: Primary Cancer](StructureDefinition-Condition-primaryCancer-eu-pcsp.md)

**Condition Asserted Date**: 2021**Histology-Morphology-Behavior Extension**:8260/3 - Carcinoma papilar de tiroides**code**:Carcinoma tiroides**bodySite**:C73.9**subject**:[NOMBRE APELLIDO1 APELLIDO2(anonymous) Female, DoB: 2005-07-01 ( urn:oid:2.16.724.4.10.50.200#123456789 (use: official, ))](Patient-PatientHulafe-1.md)**encounter**:[Encounter: status = finished; class = ambulatory (ActCode#AMB)](Encounter-EncHulafe-1.md)

### Stages

| | |
| :--- | :--- |
| - | **Summary** |
| * | pT1a |

**note**:
> 

Alergia al epitelio de gato



-------

Entry 4 - fullUrl = http://hl7.eu/fhir/ig/pcsp/Encounter/EncHulafe-1

Resource Encounter:

> 

Language: es-ES

**status**: completed**class**:ambulatory**subject**:[NOMBRE APELLIDO1 APELLIDO2(anonymous) Female, DoB: 2005-07-01 ( urn:oid:2.16.724.4.10.50.200#123456789 (use: official, ))](Patient-PatientHulafe-1.md)**serviceProvider**:[Organization Hospital Universitari i Politècnic La Fe](Organization-OrgHulafe-1.md)

-------

Entry 5 - fullUrl = http://hl7.eu/fhir/ig/pcsp/MedicationAdministration/ChemoHulafe-1-Ciclofosfamide

Resource MedicationAdministration:

> 

Profile: [MedicationAdministration: Chemotherapy](StructureDefinition-MedicationAdministration-eu-pcsp.md)

**Act Location**:[Location Hospital la Fe](Location-ChemoHulafe-1-Location.md)**Resource related information**:[Observation Cumulative dose received by a patient for a specific drug.](Observation-ChemoHulafe-1-Ciclofosfamide-dose.md)**status**: completed**subject**:[NOMBRE APELLIDO1 APELLIDO2(anonymous) Female, DoB: 2005-07-01 ( urn:oid:2.16.724.4.10.50.200#123456789 (use: official, ))](Patient-PatientHulafe-1.md)

-------

Entry 6 - fullUrl = http://hl7.eu/fhir/ig/pcsp/MedicationAdministration/ChemoHulafe-1-Metotrexato

Resource MedicationAdministration:

> 

Profile: [MedicationAdministration: Chemotherapy](StructureDefinition-MedicationAdministration-eu-pcsp.md)

**Act Location**:[Location Hospital la Fe](Location-ChemoHulafe-1-Location.md)**Resource related information**:[Observation Cumulative dose received by a patient for a specific drug.](Observation-ChemoHulafe-1-Metotrexato-dose.md)**status**: completed**subject**:[NOMBRE APELLIDO1 APELLIDO2(anonymous) Female, DoB: 2005-07-01 ( urn:oid:2.16.724.4.10.50.200#123456789 (use: official, ))](Patient-PatientHulafe-1.md)

-------

Entry 7 - fullUrl = http://hl7.eu/fhir/ig/pcsp/MedicationAdministration/ChemoHulafe-1-Vincristina

Resource MedicationAdministration:

> 

Profile: [MedicationAdministration: Chemotherapy](StructureDefinition-MedicationAdministration-eu-pcsp.md)

**Act Location**:[Location Hospital la Fe](Location-ChemoHulafe-1-Location.md)**Resource related information**:[Observation Cumulative dose received by a patient for a specific drug.](Observation-ChemoHulafe-1-Vincristina-dose.md)**status**: completed**subject**:[NOMBRE APELLIDO1 APELLIDO2(anonymous) Female, DoB: 2005-07-01 ( urn:oid:2.16.724.4.10.50.200#123456789 (use: official, ))](Patient-PatientHulafe-1.md)

-------

Entry 8 - fullUrl = http://hl7.eu/fhir/ig/pcsp/MedicationAdministration/ChemoHulafe-1-Citarabina

Resource MedicationAdministration:

> 

Profile: [MedicationAdministration: Chemotherapy](StructureDefinition-MedicationAdministration-eu-pcsp.md)

**Act Location**:[Location Hospital la Fe](Location-ChemoHulafe-1-Location.md)**Resource related information**:[Observation Cumulative dose received by a patient for a specific drug.](Observation-ChemoHulafe-1-Citarabina-dose.md)**status**: completed**subject**:[NOMBRE APELLIDO1 APELLIDO2(anonymous) Female, DoB: 2005-07-01 ( urn:oid:2.16.724.4.10.50.200#123456789 (use: official, ))](Patient-PatientHulafe-1.md)

-------

Entry 9 - fullUrl = http://hl7.eu/fhir/ig/pcsp/MedicationStatement/ChemoHulafe-1-corticosteroids

Resource MedicationStatement:

> 

Profile: [MedicationStatement: Chemotherapy](StructureDefinition-MedicationStatement-eu-pcsp.md)

**status**: not-taken**status**: recorded**subject**:[NOMBRE APELLIDO1 APELLIDO2(anonymous) Female, DoB: 2005-07-01 ( urn:oid:2.16.724.4.10.50.200#123456789 (use: official, ))](Patient-PatientHulafe-1.md)

### Dosages

| | |
| :--- | :--- |
| - | **Timing** |
| * | Once |


-------

Entry 10 - fullUrl = http://hl7.eu/fhir/ig/pcsp/Observation/ChemoHulafe-1-Ciclofosfamide-dose

Resource Observation:

> 

Profile: [Observation: Chemotherapy Cumulative Dose](StructureDefinition-Observation-cumulativeDoseChemo-eu-pcsp.md)

**status**: Final**code**:Cumulative dose received by a patient for a specific drug.**subject**:[NOMBRE APELLIDO1 APELLIDO2(anonymous) Female, DoB: 2005-07-01 ( urn:oid:2.16.724.4.10.50.200#123456789 (use: official, ))](Patient-PatientHulafe-1.md)**value**: 3000 mg/m2(Details: UCUM codemg/m2 = 'mg/m2')**method**:Calculation technique

-------

Entry 11 - fullUrl = http://hl7.eu/fhir/ig/pcsp/Observation/ChemoHulafe-1-Metotrexato-dose

Resource Observation:

> 

Profile: [Observation: Chemotherapy Cumulative Dose](StructureDefinition-Observation-cumulativeDoseChemo-eu-pcsp.md)

**status**: Final**code**:Cumulative dose received by a patient for a specific drug.**subject**:[NOMBRE APELLIDO1 APELLIDO2(anonymous) Female, DoB: 2005-07-01 ( urn:oid:2.16.724.4.10.50.200#123456789 (use: official, ))](Patient-PatientHulafe-1.md)**value**: 12000 mg/m2(Details: UCUM codemg/m2 = 'mg/m2')**method**:Calculation technique

-------

Entry 12 - fullUrl = http://hl7.eu/fhir/ig/pcsp/Observation/ChemoHulafe-1-Vincristina-dose

Resource Observation:

> 

Profile: [Observation: Chemotherapy Cumulative Dose](StructureDefinition-Observation-cumulativeDoseChemo-eu-pcsp.md)

**status**: Final**code**:Cumulative dose received by a patient for a specific drug.**subject**:[NOMBRE APELLIDO1 APELLIDO2(anonymous) Female, DoB: 2005-07-01 ( urn:oid:2.16.724.4.10.50.200#123456789 (use: official, ))](Patient-PatientHulafe-1.md)**value**: 5.4 mg/m2(Details: UCUM codemg/m2 = 'mg/m2')**method**:Calculation technique

-------

Entry 13 - fullUrl = http://hl7.eu/fhir/ig/pcsp/Observation/ChemoHulafe-1-Citarabina-dose

Resource Observation:

> 

Profile: [Observation: Chemotherapy Cumulative Dose](StructureDefinition-Observation-cumulativeDoseChemo-eu-pcsp.md)

**status**: Final**code**:Cumulative dose received by a patient for a specific drug.**subject**:[NOMBRE APELLIDO1 APELLIDO2(anonymous) Female, DoB: 2005-07-01 ( urn:oid:2.16.724.4.10.50.200#123456789 (use: official, ))](Patient-PatientHulafe-1.md)**value**: 920 mg/m2(Details: UCUM codemg/m2 = 'mg/m2')**method**:Calculation technique

-------

Entry 14 - fullUrl = http://hl7.eu/fhir/ig/pcsp/Organization/OrgHulafe-1

Resource Organization:

> 

Language: es-ES

Profile: [Organization: Primary Treatment Center / Center of diagnosis](StructureDefinition-Organization-center-eu-pcsp.md)

**active**: true**name**: Hospital Universitari i Politècnic La Fe**alias**: La Fe
> **contact****telecom**:[+34 961 244 000](tel:+34961244000),[prensa_lafe@gva.es](mailto:prensa_lafe@gva.es)**address**: Avinguda de Fernando Abril Martorell, nº 106 Valencia Comunidad Valenciana 46026 ES (work)

-------

Entry 15 - fullUrl = http://hl7.eu/fhir/ig/pcsp/Location/ChemoHulafe-1-Location

Resource Location:

> 

Profile: [Location: PCSP](StructureDefinition-Location-eu-pcsp.md)

**name**: Hospital la Fe**address**: Valencia Spain

-------

Entry 16 - fullUrl = http://hl7.eu/fhir/ig/pcsp/CarePlan/CarePlanExample-1

Resource CarePlan:

> ****FOLLOW-UP RECOMMENDATIONS****Here below are listed personalized follow-up recommendations, based on the treatments you received. These advices are based on international experience with people who received similar treatments as you.They are meant to prevent and/or diagnose at an early stage possible future complications.It is possible that over time these recommendations will be updated according to new clinical situations and/or new data in the scientific literature. We will make all possible efforts in order to update about any new update.We encourage you to report to your doctor any persistent symptom you might have, in order to allow an early identification of its cause.**General recommendations**A healthy lifestyle helps to maintain physical and mental wellbeing, as well as preventing possible diseases such as cardiovascular complications, tumors, and psychological problems.We therefore recommend you to:
* Maintain a normal body weight and engage in regular physical activity.
* Eat plenty of fruits and vegetables, and reduce fat, sugar, and salt intake.
* Don't smoke and avoid excessive alcohol intake.
* Maintain proper dental hygiene.
* Avoid excessive sun exposure and remember to use high-protection sunscreen.
* Check your blood pressure periodically.
* Report to your health care provider any experience of chronic pain, excessive fatigue and/or deterioration of performance in your daily activities (study, work and/or exercise).
* Adhere to all cancer screening programs that will be offered by the health system.

| | | |
| :--- | :--- | :--- |
| **You might be at risk of** | **Because you were treated with** | **We therefore recommend you to** |
| Subsequent thyroid cancer | * RT to a vol exposing the thyroid gland
 | Counselling regarding the increased risk for developing differentiated thyroid to inform their HCP if they detect a thyroid mass (independent of the presence or absence of associated symptoms), every 5 years - Physical examination of the neck as part of a complete physical examination, whenever a survivor is assessed by a HCP - Counselling regarding options for differentiated thyroid carcinoma surveillance, at least every 5 years If the decision to commence surveillance is made, make a shared decision for one of these two surveillance modalities: - Neck palpation, every 1-2 years, starting 5 years after radiotherapy, or - Thyroid ultrasonographyw, every 3-5 years, starting 5 years after radiotherapy |
| Subsequent breast cancer | * RT >= 10 Gy to a vol exposing the breasts
 | Mammography and breast MRI every year if > 25 years of age or > 8 years from radiation, whichever occurs last |
| Cardiac problems (High risk) | * RT >= 35 Gy to a vol exposing the heart
* Anthracyclines (doxorubicin isotoxic equivalents)>= 250 mg/m2
 | A physical cardiac examination at every LTFU visit, at least every 5 years. Screening for modifiable cardiovascular risk factors (hypertension, diabetes, dyslipidaemia, obesity, smoking and low levels of physical activity). - ECG once at entry into LTFU. Repeat ECG once after the age of 18 years if entry into LTFU was at a younger age. - Echocardiogram with specific attention to left ventricular systolic function, to valvular structure and function and to the pericardium, starting 2 years after treatment and at least every 2-3 years; Echocardiogram with specific attention to left ventricular function, prior to pregnancy or in the first trimester, if female - Refer to a cardiologist if an abnormal ejection fraction or if other abnormalities are identified - Refer for interventions to help avert the risk of symptomatic cardiomyopathy if modifiable cardiovascular risk factors are identified Refer to a cardiologist if an abnormal ejection fraction or if other abnormalities are identified - Refer for interventions to help avert the risk of symptomatic cardiomyopathy if modifiable cardiovascular risk factors are identified |


-------

Entry 17 - fullUrl = http://hl7.eu/fhir/ig/pcsp/Observation/ObservationRiskFactor-1

Resource Observation:

> 

Profile: [Observation: Risk Factor](StructureDefinition-Observation-riskfactor-eu-pcsp.md)

**status**: Final**code**:Risk factor**subject**:[APELLIDO1](Patient-PatientHulafe-1.md)**effective**: 2022-05-12 --> (ongoing)**value**:RT to a vol exposing the thyroid gland

-------

Entry 18 - fullUrl = http://hl7.eu/fhir/ig/pcsp/Observation/ObservationRiskFactor-2

Resource Observation:

> 

Profile: [Observation: Risk Factor](StructureDefinition-Observation-riskfactor-eu-pcsp.md)

**status**: Final**code**:Risk factor**subject**:[APELLIDO1](Patient-PatientHulafe-1.md)**effective**: 2022-05-12 --> (ongoing)**value**:RT >= 10 Gy to a vol exposing the breasts

-------

Entry 19 - fullUrl = http://hl7.eu/fhir/ig/pcsp/Observation/ObservationRiskFactor-3

Resource Observation:

> 

Profile: [Observation: Risk Factor](StructureDefinition-Observation-riskfactor-eu-pcsp.md)

**status**: Final**code**:Risk factor**subject**:[APELLIDO1](Patient-PatientHulafe-1.md)**effective**: 2022-05-12 --> (ongoing)**value**:RT >= 35 Gy to a vol exposing the heart

-------

Entry 20 - fullUrl = http://hl7.eu/fhir/ig/pcsp/Observation/ObservationRiskFactor-4

Resource Observation:

> 

Profile: [Observation: Risk Factor](StructureDefinition-Observation-riskfactor-eu-pcsp.md)

**status**: Final**code**:Risk factor**subject**:[APELLIDO1](Patient-PatientHulafe-1.md)**effective**: 2022-05-12 --> (ongoing)**value**:Anthracyclines (doxorubicin isotoxic equivalents)>= 250 mg/m2

-------

Entry 21 - fullUrl = http://hl7.eu/fhir/ig/pcsp/DocumentReference/DocumentReferenceExample-1

Resource DocumentReference:

> 

Profile: [DocumentReference: PCSP](StructureDefinition-DocumentReference-eu-pcsp.md)

**status**: Current**docStatus**: Preliminary**type**:Childhood Cancer Survivor Passport**subject**:[APELLIDO1](Patient-PatientHulafe-1.md)**date**: 2022-06-14 13:28:17+0200
> **content**

### Attachments

| | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- |
| - | **ContentType** | **Language** | **Data** | **Title** | **Creation** |
| * | application/pdf | es-ES | (base64 data - 251,792 base64 chars) | Survivor Passport of APELLIDO1 | 2022-06-14 |





## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "BundleHulafe",
  "meta" : {
    "profile" : [
      "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Bundle-eu-pcsp"
    ]
  },
  "identifier" : {
    "system" : "http://fhir.ehealth-systems.at/identifier/pcsp-bundle",
    "value" : "hulafe-pcsp-bundle-2025"
  },
  "type" : "document",
  "timestamp" : "2025-06-11T07:41:51.868411+00:00",
  "entry" : [
    {
      "fullUrl" : "http://hl7.eu/fhir/ig/pcsp/Composition/CompositionHulafe",
      "resource" : {
        "resourceType" : "Composition",
        "id" : "CompositionHulafe",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Composition-surpass-eu-pcsp"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Composition_CompositionHulafe\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Composition CompositionHulafe</b></p><a name=\"CompositionHulafe\"> </a><a name=\"hcCompositionHulafe\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-Composition-surpass-eu-pcsp.html\">Composition: Survivor Passport</a></p></div><p><b>status</b>: Preliminary</p><p><b>type</b>: <span title=\"Codes:{http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-generic-eu-pcsp surpass}\">Childhood Cancer Survivor Passport</span></p><p><b>date</b>: 2025-06-11 07:41:51+0000</p><p><b>author</b>: Identifier: test</p><p><b>title</b>: Childhood Cancer Survivor Passport</p></div>"
        },
        "status" : "preliminary",
        "type" : {
          "coding" : [
            {
              "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-generic-eu-pcsp",
              "code" : "surpass"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/PatientHulafe-1"
        },
        "date" : "2025-06-11T07:41:51.417033+00:00",
        "author" : [
          {
            "identifier" : {
              "value" : "test"
            }
          }
        ],
        "title" : "Childhood Cancer Survivor Passport",
        "section" : [
          {
            "title" : "Cancer Diagnosis and Treatment",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "72135-7"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p>Primary Cancer Diagnosis and Treatment Summary</p></div>"
            },
            "entry" : [
              {
                "reference" : "Condition/PrimaryCancerHulafe-1"
              }
            ],
            "section" : [
              {
                "title" : "Chemotherapy",
                "code" : {
                  "coding" : [
                    {
                      "system" : "http://loinc.org",
                      "code" : "11486-8"
                    }
                  ]
                },
                "text" : {
                  "status" : "generated",
                  "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p>Chemotherapy Treatments</p></div>"
                },
                "entry" : [
                  {
                    "reference" : "MedicationAdministration/ChemoHulafe-1-Ciclofosfamide"
                  },
                  {
                    "reference" : "MedicationAdministration/ChemoHulafe-1-Metotrexato"
                  },
                  {
                    "reference" : "MedicationAdministration/ChemoHulafe-1-Vincristina"
                  },
                  {
                    "reference" : "MedicationAdministration/ChemoHulafe-1-Citarabina"
                  },
                  {
                    "reference" : "MedicationStatement/ChemoHulafe-1-corticosteroids"
                  }
                ]
              }
            ]
          },
          {
            "title" : "Care Plan",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "18776-5"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p>Care Plan</p></div>"
            },
            "entry" : [
              {
                "reference" : "CarePlan/CarePlanExample-1"
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "http://hl7.eu/fhir/ig/pcsp/Patient/PatientHulafe-1",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "PatientHulafe-1",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Patient-eu-pcsp"
          ]
        },
        "language" : "es-ES",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"es-ES\" lang=\"es-ES\"><a name=\"Patient_PatientHulafe-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Patient PatientHulafe-1</b></p><a name=\"PatientHulafe-1\"> </a><a name=\"hcPatientHulafe-1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">Language: es-ES</p><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-Patient-eu-pcsp.html\">Patient: PCSP</a></p></div><p style=\"border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;\">NOMBRE APELLIDO1 APELLIDO2(anonymous) Female, DoB: 2005-07-01 ( urn:oid:2.16.724.4.10.50.200#123456789 (use: official, ))</p><hr/><table class=\"grid\"><tr><td style=\"background-color: #f3f5da\" title=\"Ways to contact the Patient\">Contact Detail</td><td colspan=\"3\"><a href=\"mailto:belensmicorr@gggmail.com\">belensmicorr@gggmail.com</a></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Language spoken\">Language:</td><td colspan=\"3\"><span title=\"Codes:{urn:ietf:bcp:47 es-ES}\">Spanish (Spain)</span></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Mother's maiden (unmarried) name, commonly collected to help verify patient identity.\"><a href=\"http://hl7.org/fhir/extensions/5.2.0/StructureDefinition-patient-mothersMaidenName.html\">Patient Mother's Maiden Name</a></td><td colspan=\"3\">APELLIDO2</td></tr><tr><td style=\"background-color: #f3f5da\" title=\"The registered place of birth of the patient. A sytem may use the address.text if they don't store the birthPlace address in discrete elements.\"><a href=\"http://hl7.org/fhir/extensions/5.2.0/StructureDefinition-patient-birthPlace.html\">Patient Birth Place</a></td><td colspan=\"3\">CALLEFALSA123 Valencia Valencia España </td></tr></table></div>"
        },
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/patient-mothersMaidenName",
            "valueString" : "APELLIDO2"
          },
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/patient-birthPlace",
            "valueAddress" : {
              "line" : ["CALLEFALSA123"],
              "city" : "Valencia",
              "state" : "Valencia",
              "country" : "España"
            }
          }
        ],
        "identifier" : [
          {
            "use" : "official",
            "system" : "urn:oid:2.16.724.4.10.50.200",
            "value" : "123456789"
          }
        ],
        "name" : [
          {
            "use" : "anonymous",
            "text" : "NOMBRE APELLIDO1 APELLIDO2",
            "family" : "APELLIDO1",
            "given" : ["NOMBRE"]
          }
        ],
        "telecom" : [
          {
            "system" : "email",
            "value" : "belensmicorr@gggmail.com"
          }
        ],
        "gender" : "female",
        "birthDate" : "2005-07-01",
        "communication" : [
          {
            "language" : {
              "coding" : [
                {
                  "system" : "urn:ietf:bcp:47",
                  "code" : "es-ES",
                  "display" : "Spanish (Spain)"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://hl7.eu/fhir/ig/pcsp/Condition/PrimaryCancerHulafe-1",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "PrimaryCancerHulafe-1",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-primaryCancer-eu-pcsp"
          ]
        },
        "language" : "es-ES",
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"es-ES\" lang=\"es-ES\"><a name=\"Condition_PrimaryCancerHulafe-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition PrimaryCancerHulafe-1</b></p><a name=\"PrimaryCancerHulafe-1\"> </a><a name=\"hcPrimaryCancerHulafe-1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">Language: es-ES</p><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-Condition-primaryCancer-eu-pcsp.html\">Condition: Primary Cancer</a></p></div><p><b>Condition Asserted Date</b>: 2021</p><p><b>Histology-Morphology-Behavior Extension</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/icd-o-3 8260/3}\">8260/3 - Carcinoma papilar de tiroides</span></p><p><b>code</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-NullFlavor UNC}\">Carcinoma tiroides</span></p><p><b>bodySite</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/icd-o-3 C73.9}\">C73.9</span></p><p><b>subject</b>: <a href=\"Patient-PatientHulafe-1.html\">NOMBRE APELLIDO1 APELLIDO2(anonymous) Female, DoB: 2005-07-01 ( urn:oid:2.16.724.4.10.50.200#123456789 (use: official, ))</a></p><p><b>encounter</b>: <a href=\"Encounter-EncHulafe-1.html\">Encounter: status = finished; class = ambulatory (ActCode#AMB)</a></p><h3>Stages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Summary</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-NullFlavor UNC}\">pT1a</span></td></tr></table><p><b>note</b>: </p><blockquote><div><p>Alergia al epitelio de gato</p>\n</div></blockquote></div>"
        },
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/condition-assertedDate",
            "valueDateTime" : "2021"
          },
          {
            "url" : "http://hl7.org/fhir/us/mcode/StructureDefinition/mcode-histology-morphology-behavior",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/icd-o-3",
                  "code" : "8260/3",
                  "display" : "8260/3 - Carcinoma papilar de tiroides"
                }
              ]
            }
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-NullFlavor",
              "code" : "UNC",
              "display" : "un-encoded"
            }
          ],
          "text" : "Carcinoma tiroides"
        },
        "bodySite" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/mcode-laterality-qualifier",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/v3-NullFlavor",
                      "code" : "NA",
                      "display" : "Not Applicable"
                    }
                  ]
                }
              }
            ],
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/icd-o-3",
                "code" : "C73.9",
                "display" : "C73.9 - Tiroides"
              }
            ],
            "text" : "C73.9"
          }
        ],
        "subject" : {
          "reference" : "Patient/PatientHulafe-1",
          "type" : "Patient"
        },
        "encounter" : {
          "reference" : "Encounter/EncHulafe-1",
          "type" : "Encounter"
        },
        "stage" : [
          {
            "summary" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-NullFlavor",
                  "code" : "UNC",
                  "display" : "un-encoded"
                }
              ],
              "text" : "pT1a"
            }
          }
        ],
        "note" : [
          {
            "text" : "Alergia al epitelio de gato"
          }
        ]
      }
    },
    {
      "fullUrl" : "http://hl7.eu/fhir/ig/pcsp/Encounter/EncHulafe-1",
      "resource" : {
        "resourceType" : "Encounter",
        "id" : "EncHulafe-1",
        "language" : "es-ES",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"es-ES\" lang=\"es-ES\"><a name=\"Encounter_EncHulafe-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Encounter EncHulafe-1</b></p><a name=\"EncHulafe-1\"> </a><a name=\"hcEncHulafe-1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">Language: es-ES</p></div><p><b>status</b>: Finished</p><p><b>class</b>: <a href=\"http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActCode.html#v3-ActCode-AMB\">ActCode AMB</a>: ambulatory</p><p><b>subject</b>: <a href=\"Patient-PatientHulafe-1.html\">NOMBRE APELLIDO1 APELLIDO2(anonymous) Female, DoB: 2005-07-01 ( urn:oid:2.16.724.4.10.50.200#123456789 (use: official, ))</a></p><p><b>serviceProvider</b>: <a href=\"Organization-OrgHulafe-1.html\">Organization Hospital Universitari i Politècnic La Fe</a></p></div>"
        },
        "status" : "finished",
        "class" : {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
          "code" : "AMB",
          "display" : "ambulatory"
        },
        "subject" : {
          "reference" : "Patient/PatientHulafe-1",
          "type" : "Patient"
        },
        "serviceProvider" : {
          "reference" : "Organization/OrgHulafe-1",
          "type" : "Organization"
        }
      }
    },
    {
      "fullUrl" : "http://hl7.eu/fhir/ig/pcsp/MedicationAdministration/ChemoHulafe-1-Ciclofosfamide",
      "resource" : {
        "resourceType" : "MedicationAdministration",
        "id" : "ChemoHulafe-1-Ciclofosfamide",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/MedicationAdministration-eu-pcsp"
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationAdministration_ChemoHulafe-1-Ciclofosfamide\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationAdministration ChemoHulafe-1-Ciclofosfamide</b></p><a name=\"ChemoHulafe-1-Ciclofosfamide\"> </a><a name=\"hcChemoHulafe-1-Ciclofosfamide\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-MedicationAdministration-eu-pcsp.html\">MedicationAdministration: Chemotherapy</a></p></div><p><b>Act Location</b>: <a href=\"Location-ChemoHulafe-1-Location.html\">Location Hospital la Fe</a></p><p><b>Resource related information</b>: <a href=\"Observation-ChemoHulafe-1-Ciclofosfamide-dose.html\">Observation Cumulative dose received by a patient for a specific drug.</a></p><p><b>status</b>: Completed</p><p><b>medication</b>: <span title=\"Codes:{http://www.whocc.no/atc L01AA01}\">cyclophosphamide</span></p><p><b>subject</b>: <a href=\"Patient-PatientHulafe-1.html\">NOMBRE APELLIDO1 APELLIDO2(anonymous) Female, DoB: 2005-07-01 ( urn:oid:2.16.724.4.10.50.200#123456789 (use: official, ))</a></p><p><b>effective</b>: 2012-08-08 --&gt; 2012-10-11</p><p><b>reasonReference</b>: <a href=\"Condition-PrimaryCancerHulafe-1.html\">Condition un-encoded</a></p></div>"
        },
        "extension" : [
          {
            "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/event-location",
            "valueReference" : {
              "reference" : "Location/ChemoHulafe-1-Location"
            }
          },
          {
            "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/resource-relatedInfo",
            "valueReference" : {
              "reference" : "Observation/ChemoHulafe-1-Ciclofosfamide-dose"
            }
          }
        ],
        "status" : "completed",
        "medicationCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "L01AA01",
              "display" : "cyclophosphamide"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/PatientHulafe-1",
          "type" : "Patient"
        },
        "effectivePeriod" : {
          "start" : "2012-08-08",
          "end" : "2012-10-11"
        },
        "reasonReference" : [
          {
            "reference" : "Condition/PrimaryCancerHulafe-1"
          }
        ]
      }
    },
    {
      "fullUrl" : "http://hl7.eu/fhir/ig/pcsp/MedicationAdministration/ChemoHulafe-1-Metotrexato",
      "resource" : {
        "resourceType" : "MedicationAdministration",
        "id" : "ChemoHulafe-1-Metotrexato",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/MedicationAdministration-eu-pcsp"
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationAdministration_ChemoHulafe-1-Metotrexato\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationAdministration ChemoHulafe-1-Metotrexato</b></p><a name=\"ChemoHulafe-1-Metotrexato\"> </a><a name=\"hcChemoHulafe-1-Metotrexato\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-MedicationAdministration-eu-pcsp.html\">MedicationAdministration: Chemotherapy</a></p></div><p><b>Act Location</b>: <a href=\"Location-ChemoHulafe-1-Location.html\">Location Hospital la Fe</a></p><p><b>Resource related information</b>: <a href=\"Observation-ChemoHulafe-1-Metotrexato-dose.html\">Observation Cumulative dose received by a patient for a specific drug.</a></p><p><b>status</b>: Completed</p><p><b>medication</b>: <span title=\"Codes:{http://www.whocc.no/atc L01BA01}\">methotrexate</span></p><p><b>subject</b>: <a href=\"Patient-PatientHulafe-1.html\">NOMBRE APELLIDO1 APELLIDO2(anonymous) Female, DoB: 2005-07-01 ( urn:oid:2.16.724.4.10.50.200#123456789 (use: official, ))</a></p><p><b>effective</b>: 2012-08-08 --&gt; 2012-10-11</p><p><b>reasonReference</b>: <a href=\"Condition-PrimaryCancerHulafe-1.html\">Condition un-encoded</a></p></div>"
        },
        "extension" : [
          {
            "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/event-location",
            "valueReference" : {
              "reference" : "Location/ChemoHulafe-1-Location"
            }
          },
          {
            "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/resource-relatedInfo",
            "valueReference" : {
              "reference" : "Observation/ChemoHulafe-1-Metotrexato-dose"
            }
          }
        ],
        "status" : "completed",
        "medicationCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "L01BA01",
              "display" : "methotrexate"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/PatientHulafe-1",
          "type" : "Patient"
        },
        "effectivePeriod" : {
          "start" : "2012-08-08",
          "end" : "2012-10-11"
        },
        "reasonReference" : [
          {
            "reference" : "Condition/PrimaryCancerHulafe-1"
          }
        ]
      }
    },
    {
      "fullUrl" : "http://hl7.eu/fhir/ig/pcsp/MedicationAdministration/ChemoHulafe-1-Vincristina",
      "resource" : {
        "resourceType" : "MedicationAdministration",
        "id" : "ChemoHulafe-1-Vincristina",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/MedicationAdministration-eu-pcsp"
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationAdministration_ChemoHulafe-1-Vincristina\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationAdministration ChemoHulafe-1-Vincristina</b></p><a name=\"ChemoHulafe-1-Vincristina\"> </a><a name=\"hcChemoHulafe-1-Vincristina\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-MedicationAdministration-eu-pcsp.html\">MedicationAdministration: Chemotherapy</a></p></div><p><b>Act Location</b>: <a href=\"Location-ChemoHulafe-1-Location.html\">Location Hospital la Fe</a></p><p><b>Resource related information</b>: <a href=\"Observation-ChemoHulafe-1-Vincristina-dose.html\">Observation Cumulative dose received by a patient for a specific drug.</a></p><p><b>status</b>: Completed</p><p><b>medication</b>: <span title=\"Codes:{http://www.whocc.no/atc L01CA02}\">vincristine</span></p><p><b>subject</b>: <a href=\"Patient-PatientHulafe-1.html\">NOMBRE APELLIDO1 APELLIDO2(anonymous) Female, DoB: 2005-07-01 ( urn:oid:2.16.724.4.10.50.200#123456789 (use: official, ))</a></p><p><b>effective</b>: 2012-08-08 --&gt; 2012-10-11</p><p><b>reasonReference</b>: <a href=\"Condition-PrimaryCancerHulafe-1.html\">Condition un-encoded</a></p></div>"
        },
        "extension" : [
          {
            "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/event-location",
            "valueReference" : {
              "reference" : "Location/ChemoHulafe-1-Location"
            }
          },
          {
            "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/resource-relatedInfo",
            "valueReference" : {
              "reference" : "Observation/ChemoHulafe-1-Vincristina-dose"
            }
          }
        ],
        "status" : "completed",
        "medicationCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "L01CA02",
              "display" : "vincristine"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/PatientHulafe-1",
          "type" : "Patient"
        },
        "effectivePeriod" : {
          "start" : "2012-08-08",
          "end" : "2012-10-11"
        },
        "reasonReference" : [
          {
            "reference" : "Condition/PrimaryCancerHulafe-1"
          }
        ]
      }
    },
    {
      "fullUrl" : "http://hl7.eu/fhir/ig/pcsp/MedicationAdministration/ChemoHulafe-1-Citarabina",
      "resource" : {
        "resourceType" : "MedicationAdministration",
        "id" : "ChemoHulafe-1-Citarabina",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/MedicationAdministration-eu-pcsp"
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationAdministration_ChemoHulafe-1-Citarabina\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationAdministration ChemoHulafe-1-Citarabina</b></p><a name=\"ChemoHulafe-1-Citarabina\"> </a><a name=\"hcChemoHulafe-1-Citarabina\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-MedicationAdministration-eu-pcsp.html\">MedicationAdministration: Chemotherapy</a></p></div><p><b>Act Location</b>: <a href=\"Location-ChemoHulafe-1-Location.html\">Location Hospital la Fe</a></p><p><b>Resource related information</b>: <a href=\"Observation-ChemoHulafe-1-Citarabina-dose.html\">Observation Cumulative dose received by a patient for a specific drug.</a></p><p><b>status</b>: Completed</p><p><b>medication</b>: <span title=\"Codes:{http://www.whocc.no/atc L01BC01}\">cytarabine</span></p><p><b>subject</b>: <a href=\"Patient-PatientHulafe-1.html\">NOMBRE APELLIDO1 APELLIDO2(anonymous) Female, DoB: 2005-07-01 ( urn:oid:2.16.724.4.10.50.200#123456789 (use: official, ))</a></p><p><b>effective</b>: 2012-08-08 --&gt; 2012-10-11</p><p><b>reasonReference</b>: <a href=\"Condition-PrimaryCancerHulafe-1.html\">Condition un-encoded</a></p></div>"
        },
        "extension" : [
          {
            "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/event-location",
            "valueReference" : {
              "reference" : "Location/ChemoHulafe-1-Location"
            }
          },
          {
            "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/resource-relatedInfo",
            "valueReference" : {
              "reference" : "Observation/ChemoHulafe-1-Citarabina-dose"
            }
          }
        ],
        "status" : "completed",
        "medicationCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "L01BC01",
              "display" : "cytarabine"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/PatientHulafe-1",
          "type" : "Patient"
        },
        "effectivePeriod" : {
          "start" : "2012-08-08",
          "end" : "2012-10-11"
        },
        "reasonReference" : [
          {
            "reference" : "Condition/PrimaryCancerHulafe-1"
          }
        ]
      }
    },
    {
      "fullUrl" : "http://hl7.eu/fhir/ig/pcsp/MedicationStatement/ChemoHulafe-1-corticosteroids",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "ChemoHulafe-1-corticosteroids",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/MedicationStatement-eu-pcsp"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_ChemoHulafe-1-corticosteroids\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement ChemoHulafe-1-corticosteroids</b></p><a name=\"ChemoHulafe-1-corticosteroids\"> </a><a name=\"hcChemoHulafe-1-corticosteroids\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-MedicationStatement-eu-pcsp.html\">MedicationStatement: Chemotherapy</a></p></div><p><b>status</b>: Not Taken</p><p><b>medication</b>: <span title=\"Codes:{http://www.whocc.no/atc H02}\">CORTICOSTEROIDS FOR SYSTEMIC USE</span></p><p><b>subject</b>: <a href=\"Patient-PatientHulafe-1.html\">NOMBRE APELLIDO1 APELLIDO2(anonymous) Female, DoB: 2005-07-01 ( urn:oid:2.16.724.4.10.50.200#123456789 (use: official, ))</a></p><p><b>reasonReference</b>: <a href=\"Condition-PrimaryCancerHulafe-1.html\">Condition un-encoded</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Timing</b></td></tr><tr><td style=\"display: none\">*</td><td>Once</td></tr></table></div>"
        },
        "status" : "not-taken",
        "medicationCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "H02",
              "display" : "CORTICOSTEROIDS FOR SYSTEMIC USE"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/PatientHulafe-1",
          "type" : "Patient"
        },
        "reasonReference" : [
          {
            "reference" : "Condition/PrimaryCancerHulafe-1"
          }
        ],
        "dosage" : [
          {
            "timing" : {
              "repeat" : {
                "boundsDuration" : {
                  "value" : 4,
                  "comparator" : ">",
                  "unit" : "w",
                  "system" : "http://unitsofmeasure.org",
                  "code" : "w"
                }
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://hl7.eu/fhir/ig/pcsp/Observation/ChemoHulafe-1-Ciclofosfamide-dose",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "ChemoHulafe-1-Ciclofosfamide-dose",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-cumulativeDoseChemo-eu-pcsp"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_ChemoHulafe-1-Ciclofosfamide-dose\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation ChemoHulafe-1-Ciclofosfamide-dose</b></p><a name=\"ChemoHulafe-1-Ciclofosfamide-dose\"> </a><a name=\"hcChemoHulafe-1-Ciclofosfamide-dose\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-Observation-cumulativeDoseChemo-eu-pcsp.html\">Observation: Chemotherapy Cumulative Dose</a></p></div><p><b>status</b>: Final</p><p><b>code</b>: <span title=\"Codes:{http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-generic-eu-pcsp cumulativeDose}\">Cumulative dose received by a patient for a specific drug.</span></p><p><b>subject</b>: <a href=\"Patient-PatientHulafe-1.html\">NOMBRE APELLIDO1 APELLIDO2(anonymous) Female, DoB: 2005-07-01 ( urn:oid:2.16.724.4.10.50.200#123456789 (use: official, ))</a></p><p><b>value</b>: 3000 mg/m2<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg/m2 = 'mg/m2')</span></p><p><b>method</b>: <span title=\"Codes:{http://snomed.info/sct 702873001}\">Calculation technique</span></p></div>"
        },
        "status" : "final",
        "code" : {
          "coding" : [
            {
              "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-generic-eu-pcsp",
              "code" : "cumulativeDose"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/PatientHulafe-1",
          "type" : "Patient"
        },
        "valueQuantity" : {
          "value" : 3000,
          "unit" : "mg/m2",
          "system" : "http://unitsofmeasure.org",
          "code" : "mg/m2"
        },
        "method" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "702873001",
              "display" : "Calculation technique"
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "http://hl7.eu/fhir/ig/pcsp/Observation/ChemoHulafe-1-Metotrexato-dose",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "ChemoHulafe-1-Metotrexato-dose",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-cumulativeDoseChemo-eu-pcsp"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_ChemoHulafe-1-Metotrexato-dose\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation ChemoHulafe-1-Metotrexato-dose</b></p><a name=\"ChemoHulafe-1-Metotrexato-dose\"> </a><a name=\"hcChemoHulafe-1-Metotrexato-dose\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-Observation-cumulativeDoseChemo-eu-pcsp.html\">Observation: Chemotherapy Cumulative Dose</a></p></div><p><b>status</b>: Final</p><p><b>code</b>: <span title=\"Codes:{http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-generic-eu-pcsp cumulativeDose}\">Cumulative dose received by a patient for a specific drug.</span></p><p><b>subject</b>: <a href=\"Patient-PatientHulafe-1.html\">NOMBRE APELLIDO1 APELLIDO2(anonymous) Female, DoB: 2005-07-01 ( urn:oid:2.16.724.4.10.50.200#123456789 (use: official, ))</a></p><p><b>value</b>: 12000 mg/m2<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg/m2 = 'mg/m2')</span></p><p><b>method</b>: <span title=\"Codes:{http://snomed.info/sct 702873001}\">Calculation technique</span></p></div>"
        },
        "status" : "final",
        "code" : {
          "coding" : [
            {
              "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-generic-eu-pcsp",
              "code" : "cumulativeDose"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/PatientHulafe-1",
          "type" : "Patient"
        },
        "valueQuantity" : {
          "value" : 12000,
          "unit" : "mg/m2",
          "system" : "http://unitsofmeasure.org",
          "code" : "mg/m2"
        },
        "method" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "702873001",
              "display" : "Calculation technique"
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "http://hl7.eu/fhir/ig/pcsp/Observation/ChemoHulafe-1-Vincristina-dose",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "ChemoHulafe-1-Vincristina-dose",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-cumulativeDoseChemo-eu-pcsp"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_ChemoHulafe-1-Vincristina-dose\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation ChemoHulafe-1-Vincristina-dose</b></p><a name=\"ChemoHulafe-1-Vincristina-dose\"> </a><a name=\"hcChemoHulafe-1-Vincristina-dose\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-Observation-cumulativeDoseChemo-eu-pcsp.html\">Observation: Chemotherapy Cumulative Dose</a></p></div><p><b>status</b>: Final</p><p><b>code</b>: <span title=\"Codes:{http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-generic-eu-pcsp cumulativeDose}\">Cumulative dose received by a patient for a specific drug.</span></p><p><b>subject</b>: <a href=\"Patient-PatientHulafe-1.html\">NOMBRE APELLIDO1 APELLIDO2(anonymous) Female, DoB: 2005-07-01 ( urn:oid:2.16.724.4.10.50.200#123456789 (use: official, ))</a></p><p><b>value</b>: 5.4 mg/m2<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg/m2 = 'mg/m2')</span></p><p><b>method</b>: <span title=\"Codes:{http://snomed.info/sct 702873001}\">Calculation technique</span></p></div>"
        },
        "status" : "final",
        "code" : {
          "coding" : [
            {
              "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-generic-eu-pcsp",
              "code" : "cumulativeDose"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/PatientHulafe-1",
          "type" : "Patient"
        },
        "valueQuantity" : {
          "value" : 5.4,
          "unit" : "mg/m2",
          "system" : "http://unitsofmeasure.org",
          "code" : "mg/m2"
        },
        "method" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "702873001",
              "display" : "Calculation technique"
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "http://hl7.eu/fhir/ig/pcsp/Observation/ChemoHulafe-1-Citarabina-dose",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "ChemoHulafe-1-Citarabina-dose",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-cumulativeDoseChemo-eu-pcsp"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_ChemoHulafe-1-Citarabina-dose\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation ChemoHulafe-1-Citarabina-dose</b></p><a name=\"ChemoHulafe-1-Citarabina-dose\"> </a><a name=\"hcChemoHulafe-1-Citarabina-dose\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-Observation-cumulativeDoseChemo-eu-pcsp.html\">Observation: Chemotherapy Cumulative Dose</a></p></div><p><b>status</b>: Final</p><p><b>code</b>: <span title=\"Codes:{http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-generic-eu-pcsp cumulativeDose}\">Cumulative dose received by a patient for a specific drug.</span></p><p><b>subject</b>: <a href=\"Patient-PatientHulafe-1.html\">NOMBRE APELLIDO1 APELLIDO2(anonymous) Female, DoB: 2005-07-01 ( urn:oid:2.16.724.4.10.50.200#123456789 (use: official, ))</a></p><p><b>value</b>: 920 mg/m2<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg/m2 = 'mg/m2')</span></p><p><b>method</b>: <span title=\"Codes:{http://snomed.info/sct 702873001}\">Calculation technique</span></p></div>"
        },
        "status" : "final",
        "code" : {
          "coding" : [
            {
              "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-generic-eu-pcsp",
              "code" : "cumulativeDose"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/PatientHulafe-1",
          "type" : "Patient"
        },
        "valueQuantity" : {
          "value" : 920,
          "unit" : "mg/m2",
          "system" : "http://unitsofmeasure.org",
          "code" : "mg/m2"
        },
        "method" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "702873001",
              "display" : "Calculation technique"
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "http://hl7.eu/fhir/ig/pcsp/Organization/OrgHulafe-1",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "OrgHulafe-1",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Organization-center-eu-pcsp"
          ]
        },
        "language" : "es-ES",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"es-ES\" lang=\"es-ES\"><a name=\"Organization_OrgHulafe-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Organization OrgHulafe-1</b></p><a name=\"OrgHulafe-1\"> </a><a name=\"hcOrgHulafe-1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">Language: es-ES</p><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-Organization-center-eu-pcsp.html\">Organization: Primary Treatment Center / Center of diagnosis</a></p></div><p><b>active</b>: true</p><p><b>name</b>: Hospital Universitari i Politècnic La Fe</p><p><b>alias</b>: La Fe</p><p><b>telecom</b>: <a href=\"tel:+34961244000\">+34 961 244 000</a>, <a href=\"mailto:prensa_lafe@gva.es\">prensa_lafe@gva.es</a></p><p><b>address</b>: Avinguda de Fernando Abril Martorell, nº 106 Valencia Comunidad Valenciana 46026 ES (work)</p></div>"
        },
        "active" : true,
        "name" : "Hospital Universitari i Politècnic La Fe",
        "alias" : ["La Fe"],
        "telecom" : [
          {
            "system" : "phone",
            "value" : "+34 961 244 000"
          },
          {
            "system" : "email",
            "value" : "prensa_lafe@gva.es"
          }
        ],
        "address" : [
          {
            "use" : "work",
            "type" : "both",
            "line" : ["Avinguda de Fernando Abril Martorell, nº 106"],
            "city" : "Valencia",
            "state" : "Comunidad Valenciana",
            "postalCode" : "46026",
            "country" : "ES"
          }
        ]
      }
    },
    {
      "fullUrl" : "http://hl7.eu/fhir/ig/pcsp/Location/ChemoHulafe-1-Location",
      "resource" : {
        "resourceType" : "Location",
        "id" : "ChemoHulafe-1-Location",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Location-eu-pcsp"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Location_ChemoHulafe-1-Location\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Location ChemoHulafe-1-Location</b></p><a name=\"ChemoHulafe-1-Location\"> </a><a name=\"hcChemoHulafe-1-Location\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-Location-eu-pcsp.html\">Location: PCSP</a></p></div><p><b>name</b>: Hospital la Fe</p><p><b>address</b>: Valencia Spain </p></div>"
        },
        "name" : "Hospital la Fe",
        "address" : {
          "city" : "Valencia",
          "country" : "Spain"
        }
      }
    },
    {
      "fullUrl" : "http://hl7.eu/fhir/ig/pcsp/CarePlan/CarePlanExample-1",
      "resource" : {
        "resourceType" : "CarePlan",
        "id" : "CarePlanExample-1",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/CarePlan-eu-pcsp"
          ]
        },
        "text" : {
          "status" : "additional",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"CarePlan_CarePlanExample-1\"> </a><p><strong><em>FOLLOW-UP RECOMMENDATIONS</em></strong></p><p>Here below are listed personalized follow-up recommendations, based on the treatments you received. These advices are based on international experience with people who received similar treatments as you.</p><p>They are meant to prevent and/or diagnose at an early stage possible future complications.</p><p>It is possible that over time these recommendations will be updated according to new clinical situations and/or new data in the scientific literature. We will make all possible efforts in order to update about any new update.</p><p>We encourage you to report to your doctor any persistent symptom you might have, in order to allow an early identification of its cause.</p>  <!-- <p></br></p> --><p><strong>General recommendations</strong></p><p>A healthy lifestyle helps to maintain physical and mental wellbeing, as well as preventing possible diseases such as cardiovascular complications, tumors, and psychological problems.</p><p>We therefore recommend you to:</p><ul><li>Maintain a normal body weight and engage in regular physical activity.</li><li>Eat plenty of fruits and vegetables, and reduce fat, sugar, and salt intake.</li><li>Don't smoke and avoid excessive alcohol intake.</li><li>Maintain proper dental hygiene.</li><li>Avoid excessive sun exposure and remember to use high-protection sunscreen.</li><li>Check your blood pressure periodically.</li><li>Report to your health care provider any experience of chronic pain, excessive fatigue and/or deterioration of performance in your daily activities (study, work and/or exercise).</li><li>Adhere to all cancer screening programs that will be offered by the health system.</li></ul>  <!-- <p></br></p> --><table border=\"1\"><tbody><tr><td><strong>You might be at risk of</strong></td><td><strong>Because you were treated with</strong></td><td><strong>We therefore recommend you to</strong></td></tr><tr><td>Subsequent thyroid cancer</td><td><ul><li>RT to a vol exposing the thyroid gland</li></ul></td><td>Counselling regarding the increased risk for developing differentiated thyroid to inform their HCP if they detect a thyroid mass (independent of the presence or absence of associated symptoms), every 5 years - Physical examination of the neck as part of a complete physical examination, whenever a survivor is assessed by a HCP - Counselling regarding options for differentiated thyroid carcinoma surveillance, at least every 5 years If the decision to commence surveillance is made, make a shared decision for one of these two surveillance modalities: - Neck palpation, every 1-2 years, starting 5 years after radiotherapy, or - Thyroid ultrasonographyw, every 3-5 years, starting 5 years after radiotherapy</td></tr><tr><td>Subsequent breast cancer</td><td><ul><li>RT &gt;= 10 Gy to a vol exposing the breasts</li></ul></td><td>Mammography and breast MRI every year if &gt; 25 years of age or &gt; 8 years from radiation, whichever occurs last</td></tr><tr><td>Cardiac problems (High risk)</td><td><ul><li>RT &gt;= 35 Gy to a vol exposing the heart</li><li>Anthracyclines (doxorubicin isotoxic equivalents)&gt;= 250 mg/m2</li></ul></td><td>A physical cardiac examination at every LTFU visit, at least every 5 years. Screening for modifiable cardiovascular risk factors (hypertension, diabetes, dyslipidaemia, obesity, smoking and low levels of physical activity). - ECG once at entry into LTFU. Repeat ECG once after the age of 18 years if entry into LTFU was at a younger age. - Echocardiogram with specific attention to left ventricular systolic function, to valvular structure and function and to the pericardium, starting 2 years after treatment and at least every 2-3 years; Echocardiogram with specific attention to left ventricular function, prior to pregnancy or in the first trimester, if female - Refer to a cardiologist if an abnormal ejection fraction or if other abnormalities are identified - Refer for interventions to help avert the risk of symptomatic cardiomyopathy if modifiable cardiovascular risk factors are identified Refer to a cardiologist if an abnormal ejection fraction or if other abnormalities are identified - Refer for interventions to help avert the risk of symptomatic cardiomyopathy if modifiable cardiovascular risk factors are identified</td></tr></tbody></table></div>"
        },
        "status" : "draft",
        "intent" : "proposal",
        "subject" : {
          "reference" : "Patient/PatientHulafe-1",
          "display" : "APELLIDO1"
        },
        "period" : {
          "start" : "2022-05-17"
        },
        "created" : "2022-05-12",
        "addresses" : [
          {
            "reference" : "Condition/PrimaryCancerHulafe-1",
            "display" : "Carcinoma tiroides"
          }
        ],
        "activity" : [
          {
            "detail" : {
              "code" : {
                "coding" : [
                  {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-recommendation-eu-pcsp",
                    "code" : "2",
                    "display" : "Perform Mammography and Breast magnetic resonance imaging (MRI) should be performed annually from the eighth year after the end of radiotherapy, but not before the age of 25. These examinations should be continued until at least age 60."
                  }
                ]
              },
              "reasonCode" : [
                {
                  "coding" : [
                    {
                      "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-riskcondition-eu-pcsp",
                      "code" : "2",
                      "display" : "Subsequent breast cancer"
                    }
                  ]
                }
              ],
              "reasonReference" : [
                {
                  "reference" : "Observation/ObservationRiskFactor-2",
                  "display" : "RT >= 10 Gy to a vol exposing the breasts"
                }
              ],
              "status" : "not-started",
              "description" : "A healthy lifestyle helps to maintain physical and mental wellbeing, as well as preventing possible diseases such as cardiovascular complications, tumors, and psychological problems. We therefore recommend you to: (1) Maintain a normal body weight and engage in regular physical activity. (2) Eat plenty of fruits and vegetables, and reduce fat, sugar, and salt intake. (3) Don't smoke and avoid excessive alcohol intake. (4) Maintain proper dental hygiene. (5) Avoid excessive sun exposure and remember to use high-protection sunscreen.(6) Check your blood pressure periodically.\t(7) Report to your health care provider any experience of chronic pain, excessive fatigue and/or deterioration of performance in your daily activities (study, work and/or exercise). (8) Adhere to all cancer screening programs that will be offered by the health system."
            }
          },
          {
            "detail" : {
              "code" : {
                "coding" : [
                  {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-recommendation-eu-pcsp",
                    "code" : "1",
                    "display" : "Perform appropriate thyroid screening from the fifth year after the end of radiotherapy. Discuss with your doctor whether to schedule: Clinical thyroid examination every 1-2 years; or Thyroid ultrasound every 3-5 years."
                  }
                ]
              },
              "reasonCode" : [
                {
                  "coding" : [
                    {
                      "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-riskcondition-eu-pcsp",
                      "code" : "1",
                      "display" : "Subsequent thyroid cancer"
                    }
                  ]
                }
              ],
              "reasonReference" : [
                {
                  "reference" : "Observation/ObservationRiskFactor-1",
                  "display" : "RT to a vol exposing the thyroid gland"
                }
              ],
              "status" : "not-started",
              "description" : "Counselling regarding the increased risk for developing differentiated thyroid to inform their HCP if they detect a thyroid mass (independent of the presence or absence of associated symptoms), every 5 years - Physical examination of the neck as part of a complete physical examination, whenever a survivor is assessed by a HCP - Counselling regarding options for differentiated thyroid carcinoma surveillance, at least every 5 years If the decision to commence surveillance is made, make a shared decision for one of these two surveillance modalities: - Neck palpation, every 1-2 years, starting 5 years after radiotherapy, or - Thyroid ultrasonographyw, every 3-5 years, starting 5 years after radiotherapy"
            }
          },
          {
            "detail" : {
              "code" : {
                "coding" : [
                  {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-recommendation-eu-pcsp",
                    "code" : "2",
                    "display" : "Perform Mammography and Breast magnetic resonance imaging (MRI) should be performed annually from the eighth year after the end of radiotherapy, but not before the age of 25. These examinations should be continued until at least age 60."
                  }
                ]
              },
              "reasonCode" : [
                {
                  "coding" : [
                    {
                      "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-riskcondition-eu-pcsp",
                      "code" : "2",
                      "display" : "Subsequent breast cancer"
                    }
                  ]
                }
              ],
              "reasonReference" : [
                {
                  "reference" : "Observation/ObservationRiskFactor-2",
                  "display" : "RT >= 10 Gy to a vol exposing the breasts"
                }
              ],
              "status" : "not-started",
              "description" : "Mammography and breast MRI every year if ≥ 25 years of age or ≥ 8 years from radiation, whichever occurs last"
            }
          },
          {
            "detail" : {
              "code" : {
                "coding" : [
                  {
                    "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-recommendation-eu-pcsp",
                    "code" : "3",
                    "display" : "Perform: Cardiological evaluation at the end of treatment and every 2-3 years thereafter; Electrocardiogram (ECG) at the end of treatment, to be repeated at the age of 18 and cardiological evaluation in case of palpitations, dizziness and/or fainting/loss of consciousness. Echocardiogram 2 years after the end of treatment, to be repeated every 2-3 years; If female, echocardiogram in the first trimester of pregnancy."
                  }
                ]
              },
              "reasonCode" : [
                {
                  "coding" : [
                    {
                      "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-riskcondition-eu-pcsp",
                      "code" : "3",
                      "display" : "Cardiac problems (Cardiomyopathy and/or Valvular disease and/or Cardiac ischemia)"
                    }
                  ]
                }
              ],
              "reasonReference" : [
                {
                  "reference" : "Observation/ObservationRiskFactor-3",
                  "display" : "RT >= 35 Gy to a vol exposing the heart"
                },
                {
                  "reference" : "Observation/ObservationRiskFactor-4",
                  "display" : "Anthracyclines (doxorubicin isotoxic equivalents)>= 250 mg/m2"
                }
              ],
              "status" : "not-started",
              "description" : "A physical cardiac examination at every LTFU visit, at least every 5 years. Screening for modifiable cardiovascular risk factors (hypertension, diabetes, dyslipidaemia, obesity, smoking and low levels of physical activity). - ECG once at entry into LTFU. Repeat ECG once after the age of 18 years if entry into LTFU was at a younger age. - Echocardiogram with specific attention to left ventricular systolic function, to valvular structure and function and to the pericardium, starting 2 years after treatment and at least every 2-3 years; Echocardiogram with specific attention to left ventricular function, prior to pregnancy or in the first trimester, if female - Refer to a cardiologist if an abnormal ejection fraction or if other abnormalities are identified - Refer for interventions to help avert the risk of symptomatic cardiomyopathy if modifiable cardiovascular risk factors are identified Refer to a cardiologist if an abnormal ejection fraction or if other abnormalities are identified - Refer for interventions to help avert the risk of symptomatic cardiomyopathy if modifiable cardiovascular risk factors are identified"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://hl7.eu/fhir/ig/pcsp/Observation/ObservationRiskFactor-1",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "ObservationRiskFactor-1",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-riskfactor-eu-pcsp"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_ObservationRiskFactor-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation ObservationRiskFactor-1</b></p><a name=\"ObservationRiskFactor-1\"> </a><a name=\"hcObservationRiskFactor-1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-Observation-riskfactor-eu-pcsp.html\">Observation: Risk Factor</a></p></div><p><b>status</b>: Final</p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 80943009}\">Risk factor</span></p><p><b>subject</b>: <a href=\"Patient-PatientHulafe-1.html\">APELLIDO1</a></p><p><b>effective</b>: 2022-05-12 --&gt; (ongoing)</p><p><b>value</b>: <span title=\"Codes:{http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-riskfactor-eu-pcsp 1.1}\">RT to a vol exposing the thyroid gland</span></p></div>"
        },
        "status" : "final",
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "80943009",
              "display" : "Risk factor"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/PatientHulafe-1",
          "display" : "APELLIDO1"
        },
        "effectivePeriod" : {
          "start" : "2022-05-12"
        },
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-riskfactor-eu-pcsp",
              "code" : "1.1",
              "display" : "RT to a vol exposing the thyroid gland"
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "http://hl7.eu/fhir/ig/pcsp/Observation/ObservationRiskFactor-2",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "ObservationRiskFactor-2",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-riskfactor-eu-pcsp"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_ObservationRiskFactor-2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation ObservationRiskFactor-2</b></p><a name=\"ObservationRiskFactor-2\"> </a><a name=\"hcObservationRiskFactor-2\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-Observation-riskfactor-eu-pcsp.html\">Observation: Risk Factor</a></p></div><p><b>status</b>: Final</p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 80943009}\">Risk factor</span></p><p><b>subject</b>: <a href=\"Patient-PatientHulafe-1.html\">APELLIDO1</a></p><p><b>effective</b>: 2022-05-12 --&gt; (ongoing)</p><p><b>value</b>: <span title=\"Codes:{http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-riskfactor-eu-pcsp 2.1}\">RT &gt;= 10 Gy to a vol exposing the breasts</span></p></div>"
        },
        "status" : "final",
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "80943009",
              "display" : "Risk factor"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/PatientHulafe-1",
          "display" : "APELLIDO1"
        },
        "effectivePeriod" : {
          "start" : "2022-05-12"
        },
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-riskfactor-eu-pcsp",
              "code" : "2.1",
              "display" : "RT >= 10 Gy to a vol exposing the breasts"
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "http://hl7.eu/fhir/ig/pcsp/Observation/ObservationRiskFactor-3",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "ObservationRiskFactor-3",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-riskfactor-eu-pcsp"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_ObservationRiskFactor-3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation ObservationRiskFactor-3</b></p><a name=\"ObservationRiskFactor-3\"> </a><a name=\"hcObservationRiskFactor-3\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-Observation-riskfactor-eu-pcsp.html\">Observation: Risk Factor</a></p></div><p><b>status</b>: Final</p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 80943009}\">Risk factor</span></p><p><b>subject</b>: <a href=\"Patient-PatientHulafe-1.html\">APELLIDO1</a></p><p><b>effective</b>: 2022-05-12 --&gt; (ongoing)</p><p><b>value</b>: <span title=\"Codes:{http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-riskfactor-eu-pcsp 3.1}\">RT &gt;= 35 Gy to a vol exposing the heart</span></p></div>"
        },
        "status" : "final",
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "80943009",
              "display" : "Risk factor"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/PatientHulafe-1",
          "display" : "APELLIDO1"
        },
        "effectivePeriod" : {
          "start" : "2022-05-12"
        },
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-riskfactor-eu-pcsp",
              "code" : "3.1",
              "display" : "RT >= 35 Gy to a vol exposing the heart"
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "http://hl7.eu/fhir/ig/pcsp/Observation/ObservationRiskFactor-4",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "ObservationRiskFactor-4",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-riskfactor-eu-pcsp"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_ObservationRiskFactor-4\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation ObservationRiskFactor-4</b></p><a name=\"ObservationRiskFactor-4\"> </a><a name=\"hcObservationRiskFactor-4\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-Observation-riskfactor-eu-pcsp.html\">Observation: Risk Factor</a></p></div><p><b>status</b>: Final</p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 80943009}\">Risk factor</span></p><p><b>subject</b>: <a href=\"Patient-PatientHulafe-1.html\">APELLIDO1</a></p><p><b>effective</b>: 2022-05-12 --&gt; (ongoing)</p><p><b>value</b>: <span title=\"Codes:{http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-riskfactor-eu-pcsp 3.2}\">Anthracyclines (doxorubicin isotoxic equivalents)&gt;= 250 mg/m2</span></p></div>"
        },
        "status" : "final",
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "80943009",
              "display" : "Risk factor"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/PatientHulafe-1",
          "display" : "APELLIDO1"
        },
        "effectivePeriod" : {
          "start" : "2022-05-12"
        },
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-riskfactor-eu-pcsp",
              "code" : "3.2",
              "display" : "Anthracyclines (doxorubicin isotoxic equivalents)>= 250 mg/m2"
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "http://hl7.eu/fhir/ig/pcsp/DocumentReference/DocumentReferenceExample-1",
      "resource" : {
        "resourceType" : "DocumentReference",
        "id" : "DocumentReferenceExample-1",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/DocumentReference-eu-pcsp"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"DocumentReference_DocumentReferenceExample-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: DocumentReference DocumentReferenceExample-1</b></p><a name=\"DocumentReferenceExample-1\"> </a><a name=\"hcDocumentReferenceExample-1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-DocumentReference-eu-pcsp.html\">DocumentReference: PCSP</a></p></div><p><b>status</b>: Current</p><p><b>docStatus</b>: Preliminary</p><p><b>type</b>: <span title=\"Codes:{http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-generic-eu-pcsp surpass}\">Childhood Cancer Survivor Passport</span></p><p><b>subject</b>: <a href=\"Patient-PatientHulafe-1.html\">APELLIDO1</a></p><p><b>date</b>: 2022-06-14 13:28:17+0200</p><blockquote><p><b>content</b></p><h3>Attachments</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>ContentType</b></td><td><b>Language</b></td><td><b>Data</b></td><td><b>Title</b></td><td><b>Creation</b></td></tr><tr><td style=\"display: none\">*</td><td>application/pdf</td><td>Spanish (Region=Spain)</td><td>(base64 data - 251,792 base64 chars)</td><td>Survivor Passport of APELLIDO1</td><td>2022-06-14</td></tr></table></blockquote></div>"
        },
        "status" : "current",
        "docStatus" : "preliminary",
        "type" : {
          "coding" : [
            {
              "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-generic-eu-pcsp",
              "code" : "surpass",
              "display" : "Childhood Cancer Survivor Passport"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/PatientHulafe-1",
          "display" : "APELLIDO1"
        },
        "date" : "2022-06-14T13:28:17+02:00",
        "content" : [
          {
            "attachment" : {
              "contentType" : "application/pdf",
              "language" : "es-ES",
              "data" : "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",
              "title" : "Survivor Passport of APELLIDO1",
              "creation" : "2022-06-14"
            }
          }
        ]
      }
    }
  ]
}

```
