# Mainz - BiologicallyDerivedProduct: Stem Cell Transplantation (Zeisig) - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Mainz - BiologicallyDerivedProduct: Stem Cell Transplantation (Zeisig)**

## Example BiologicallyDerivedProduct: Mainz - BiologicallyDerivedProduct: Stem Cell Transplantation (Zeisig)

Profile: [BiologicallyDerivedProduct: Stem Cell](StructureDefinition-BiologicallyDerivedProduct-sct-eu-pcsp.md)

**Stem Cell Donor Type**: matched related

**Stem Cell Source Type**: PBSC

**productCategory**: Cells

### Collections

| | |
| :--- | :--- |
| - | **Source** |
| * | [Sarah Zeisig Female, DoB: 1996-12-12 ( http://hl7.eu/fhir/ig/pcsp/sid/pat-id-mainz#L0010)](Patient-PatientMainzZeisig.md) |



## Resource Content

```json
{
  "resourceType" : "BiologicallyDerivedProduct",
  "id" : "BiologicallyDerivedProduct-SCT1",
  "meta" : {
    "profile" : [
      "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/BiologicallyDerivedProduct-sct-eu-pcsp"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/sct-donor-type",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-generic-eu-pcsp",
            "code" : "sct-matched-related",
            "display" : "matched related"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/sct-source-type",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-generic-eu-pcsp",
            "code" : "sct-pbsc",
            "display" : "PBSC"
          }
        ]
      }
    }
  ],
  "productCategory" : "cells",
  "collection" : {
    "source" : {
      "reference" : "Patient/PatientMainzZeisig"
    }
  }
}

```
