# Sequence diagrams - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* **Sequence diagrams**

## Sequence diagrams

### Overview

The following diagrams provide a high level description of the interactions between external local systems (here described as local system A and B, in most cases cohincident) and the SurPass v2.0 Platform.

The first describes the case of generation of a PCSP Passport


The second of the generation of a PCSP Care Plan


### Actors

#### Local System A

Any system or system of systems providing to the [**SurPass v2.0 Platform**](#pcsp-platform) 

1. [**Treatment Summary**](#treatment-summary)

#### SurPass v2.0 Platform

The Pancare SurPass platform:

1. receives from the[**Local System A**](#local-system-a):
1. [**Treatment Summary**](#treatment-summary)

1. offers a web GUI enabling Clinicians to complete and validate the**[Treatment Summary](#treatment-summary)**
1. processes the**[Treatment Summary](#treatment-summary)**to generate the**[draft SCP (Survivor Care Plan)](#surpass-draft-or-final)**
1. offers a web GUI enabling Clinicians to complete and validate the**[draft SCP (Survivor Care Plan)](#surpass-draft-or-final)**
1. makes available to[Local System B](#local-system-b)
1. A**HL7 FHIR[SurPass](#surpass-draft-or-final)(draft or final);**and/or
1. A**PDF[SurPass](#surpass-draft-or-final)(draft or final)**via HL7 FHIR API; and/or
1. A**HL7 FHIR[draft SCP (Survivor Care Plan).](#surpass-draft-or-final)**

#### Local System B

Any system or system of systems receiving from the **SurPass v2.0 Platform** 

1. A**HL7 FHIR[SurPass](#surpass-draft-or-final)(draft or final);**and/or
1. A**PDF[SurPass](#surpass-draft-or-final)(draft or final)**via HL7 FHIR API; and/or
1. A**HL7 FHIR[draft SCP (Survivor Care Plan).](#surpass-draft-or-final)**

It may be the same system realizing the[**Local System A**](#local-system-a) 

### Objects

#### Treatment Summary

Logical model of the **[Treatment Summary](StructureDefinition-TreatmentSummary.md)** 

#### Survivor Care Plan

Logical model of the **[SCP Care Plan](StructureDefinition-PlanOfCare.md)** 

#### SurPass with the SCP (draft or final)

Logical model of the **[SurPass V2.0](StructureDefinition-SurPass.md)** 

