# Profiles - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* **Profiles**

## Profiles

### Profiles

This page lists all the profiles that have been specificed for the purpose of this project

[BiologicallyDerivedProduct: Stem Cell](StructureDefinition-BiologicallyDerivedProduct-sct-eu-pcsp.md)

This profile defines how to represent Stem Cell in FHIR for describing a Stem Cell Transplantation data required by the PanCareSurPass algorithm to generate the care plan.

[Bundle: Survivor Passport](StructureDefinition-Bundle-eu-pcsp.md)

This profile represents the constraints applied to the Bundle resource by the PCSP FHIR Implementation Guide.

[CarePlan: PCSP-generated plan](StructureDefinition-CarePlan-eu-pcsp.md)

This profile defines how to represent the Care Plan proposed by the PCSP platoform in HL7 FHIR. This profile can be used for both the version generated by the platoform and that curated and validated by Clinicians.

[Composition: Survivor Passport](StructureDefinition-Composition-surpass-eu-pcsp.md)

This profile defines how to represent a PCSP Survivor Passport by using a HL7 FHIR Composition for the purpose of the PanCareSurPass project.

[Condition: GvHD](StructureDefinition-Condition-gvhd-eu-pcsp.md)

This profile defines how to represent Graft versus host disease (GvHD) in HL7 FHIR for the purpose of the PanCareSurPass project.

[Condition: Metastatic Cancer](StructureDefinition-Condition-secondaryCancer-eu-pcsp.md)

This profile defines how to represent metastatic cancer in FHIR for the purpose of the PanCareSurPass project. This profile is inspired from the [mCode IG](http://build.fhir.org/ig/HL7/fhir-mCODE-ig). Records the history of secondary neoplasms, including location(s) and the date of onset of metastases. A secondary cancer results from the spread (metastasization) of cancer from its original site (Definition from: NCI Dictionary of Cancer Terms).

[Condition: Others](StructureDefinition-Condition-otherinfos-eu-pcsp.md)

This profile defines how to describe the presence of some other conditions (e.g. Hypogonadism, Growth hormone deficiency, Hydrocephalus in HL7 FHIR for the purpose of the PanCareSurPass project.

[Condition: Primary Cancer](StructureDefinition-Condition-primaryCancer-eu-pcsp.md)

This profile defines how to represent Primary Cancer Condition in HL7 FHIR for the purpose of the PanCareSurPass project. This profile is inspired from the [mCode IG](http://build.fhir.org/ig/HL7/fhir-mCODE-ig). A primary cancer condition, the original or first tumor in the body (Definition from: [NCI Dictionary of Cancer Terms](https://www.cancer.gov/publications/dictionaries/cancer-terms/def/primary-tumor)). Cancers that are not clearly secondary (i.e., of uncertain origin or behavior) should be documented as primary. This profile should be also used for documenting primary cancer relapses during or after FLT.

[Condition: Severe Toxicity](StructureDefinition-Condition-toxicity-eu-pcsp.md)

This profile defines how to describe a Severe Toxicity event in HL7 FHIR for the purpose of the PanCareSurPass project.

[DocumentReference: PCSP](StructureDefinition-DocumentReference-eu-pcsp.md)

This profile defines how to embed a PDF PCSP Survivor Passport in FHIR for the purpose of the PanCareSurPass project. This profile can be aslo used for send attachments (e.g Raditherapy reports or HDR) to the platform

[Encounter: Treatment Center](StructureDefinition-Encounter-eu-pcsp.md)

This profile defines how to represent data of arrival to the center and Center information in FHIR for the purpose of the PanCareSurPass project.

[Location: PCSP](StructureDefinition-Location-eu-pcsp.md)

This profile defines how to represent FHIR Location for the purpose of the PanCareSurPass project.

[MedicationAdministration: Chemotherapy](StructureDefinition-MedicationAdministration-eu-pcsp.md)

This profile defines how to represent MedicationAdministration in HL7 FHIR for describing Chemotherapy data for the purpose of the PanCareSurPass project.

[MedicationStatement: Chemotherapy](StructureDefinition-MedicationStatement-eu-pcsp.md)

This profile defines how to represent MedicationStatement in FHIR for describing minimal information about provided medications for the purpose of the PanCareSurPass project.

[Observation: Blood type/RH](StructureDefinition-Observation-bld-abo-rh-eu-pcsp.md)

This profile defines how to represent Blood type/RH before or after the SCT in HL7 FHIR for the purpose of the PanCareSurPass project.

[Observation: Cancer Stage Group](StructureDefinition-mcode-cancer-stage-group.md)

The extent of the cancer in the body, according to a given cancer staging classification system, based on evidence such as physical examination, imaging, and/or biopsy or based on pathologic analysis of a specimen.

[Observation: Chemotherapy Cumulative Dose](StructureDefinition-Observation-cumulativeDoseChemo-eu-pcsp.md)

This profile defines how to represent Chemotherapy Cumulative Dose in FHIR for the purpose of the PanCareSurPass project.

[Observation: Diagnosis details](StructureDefinition-Observation-diagnosis-eu-pcsp.md)

This profile defines how to represent diagnosis details (when the diagnosis was made; who made it;...) in FHIR for the purpose of the PanCareSurPass project.

[Observation: Hereditary Predisposition](StructureDefinition-Observation-predisposition-eu-pcsp.md)

This profile defines how to represent Hereditary Predispositions in HL7 FHIR for the purpose of the PanCareSurPass project.

[Observation: Radiotherapy Total Dose PCSP](StructureDefinition-Observation-totalDoseRad-eu-pcsp.md)

This profile defines how to represent Radiotherapy Total Dose in FHIR for the purpose of the PanCareSurPass project.

[Observation: Risk Factor](StructureDefinition-Observation-riskfactor-eu-pcsp.md)

This profile defines how to represent a Risk Factor in HL7 FHIR as determined by the PCSP platoform.

[Observation: TNM Distant Metastases Category](StructureDefinition-mcode-tnm-distant-metastases-category.md)

Category describing the extent of a tumor metastasis in remote anatomical locations, based on evidence such as physical examination, imaging, and/or biopsy.

[Observation: TNM Primary Tumor Category](StructureDefinition-mcode-tnm-primary-tumor-category.md)

Category of the primary tumor, based on its size and extent, based on evidence such as physical examination, imaging, and/or biopsy.

[Observation: TNM Regional Nodes Category](StructureDefinition-mcode-tnm-regional-nodes-category.md)

Category of the presence or absence of metastases in regional lymph nodes, based on evidence such as physical examination, imaging, and/or biopsy.

[Organization: Primary Treatment Center / Center of diagnosis](StructureDefinition-Organization-center-eu-pcsp.md)

This profile defines how to represent the Primary Treatment Center or the Center of diagnosis in FHIR for the purpose of the PanCareSurPass project.

[Patient: PCSP](StructureDefinition-Patient-eu-pcsp.md)

This profile defines how to represent Patient in FHIR for the purpose of the PanCareSurPass project.

[PlanDefinition: Front Line Treatment](StructureDefinition-PlanDefinition-flt-eu-pcsp.md)

This profile defines how to provide Front Line Treatment protocol infos in FHIR for the scope of the PanCareSurPass project.

[Procedure: Catheter](StructureDefinition-Procedure-cvc-otherinfos-eu-pcsp.md)

This profile defines how to describe the Catheterization of vein Procedure in HL7 FHIR for the purpose of the PanCareSurPass project.

[Procedure: Cryopreservation](StructureDefinition-Procedure-cryopreservation-otherinfos-eu-pcsp.md)

This profile defines how to describe the cryopreservation of sperms or oocyte for cancer patient in HL7 FHIR for the purpose of the PanCareSurPass project.

[Procedure: Front Line Treatment](StructureDefinition-Procedure-flt-eu-pcsp.md)

This profile defines how to provide Front Line Treatment data in FHIR for the scope of the PanCareSurPass project.

[Procedure: Other Treatments](StructureDefinition-Procedure-treatment-otherinfos-eu-pcsp.md)

This profile defines how to convey textual information about other oncological treatments in HL7 FHIR for the purpose of the PanCareSurPass project.

[Procedure: Radiotherapy](StructureDefinition-Procedure-radiotheraphy-eu-pcsp.md)

This profile defines how to represent Procedures in FHIR for describing a set of Radiotherapy data required by the PanCareSurPass algorithm to generate the care plan.

[Procedure: Radiotherapy Boost](StructureDefinition-Procedure-radiotheraphyBoost-eu-pcsp.md)

This profile defines how to represent Procedures in FHIR for describing a set of data required by PanCareSurPass for Radiotherapy Boosts

[Procedure: Radiotherapy Shielding](StructureDefinition-Procedure-radiotheraphyShield-eu-pcsp.md)

This profile defines how to represent Shielding Procedures in FHIR for describing a set of Radiotherapy data required by the PanCareSurPass algorithm to generate the care plan.

[Procedure: SCT Prophylaxis](StructureDefinition-Procedure-sct-prophylaxis-eu-pcsp.md)

This profile defines how to represent GVHD prophylaxis, conditioning regimen Procedures in FHIR for supporting Stem Cell Transplantation data, as required by the PanCareSurPass algorithm to generate the care plan.

[Procedure: Stem Cell Transplantation](StructureDefinition-Procedure-sct-eu-pcsp.md)

This profile defines how to represent Procedures in FHIR for describing a set of Stem Cell Transplantation data required by the PanCareSurPass algorithm to generate the care plan.

[Procedure: Surgery](StructureDefinition-Procedure-surgery-eu-pcsp.md)

This profile defines how to represent Procedures in FHIR for describing a set of Surgery data required by the PanCareSurPass algorithm to generate the care plan. It is used also to provide inforamtion about shunt, amputation, and other procedures

[Procedure: Transfusion other infos](StructureDefinition-Procedure-transfusion-otherinfos-eu-pcsp.md)

This profile defines how to describe the Transfusion Procedure in HL7 FHIR for the purpose of the PanCareSurPass project.

-------

