# PanCareSurPass FHIR IG - Home Page - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* **PanCareSurPass FHIR IG - Home Page**

## PanCareSurPass FHIR IG - Home Page

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/ImplementationGuide/hl7.eu.fhir.pcsp | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:PCSPImplementationGuide |

### Scope

Specify **HL7 FHIR logical models** and **profiles** to be used within the European project **PanCareSurPass**. This project studies the scale-up and implementation of the digital Survivorship Passport to improve people-centred care for childhood cancer survivors.

### The PancareSurPass Project

#### Overview

**PanCareSurPass** is a EU funded Research and Innovation action aiming to study the scale-up and implementation of the digital Survivorship Passport to improve people-centred care for childhood cancer survivors.

PanCareSurPass will conduct a robust assessment of the implementation of the Survivorship Passport by first conducting a pre-implementation study in six countries (Austria, Belgium, Germany, Italy, Lithuania, Spain) representing three infrastructural scenarios in Europe. The Survivorship Passport is an innovative, digital tool, developed in previous EU-funded projects, that can be used to overcome well-known knowledge gaps to improve people-centred long-term survivorship care.

#### Objectives

The overall aim of PanCareSurPass is to **leverage the digital transformation of healthcare to improve people-centred survivorship care by scaling up and implementing an interoperable SurPass v2.0 across Europe.**

##### Preparation for Implementation

1. **design and conduct a multi-country pre-implementation study**to assess the barriers and facilitators for scaling up use of the SurPass v2.0
1. **develop a practical Implementation Strategy**informed by the findings of the pre-implementation activities and**IT technical specifications**for SurPass v2.0 ensuring interoperability and cybersecurity.
1. **develop, test and launch SurPass v2.0**using the IT specifications developed use in the multi-country implementation study.

##### Implementation and evaluation

1. **conduct a multi-country implementation study of SurPass v2.0**for people-centred care with >5-year CCS and to**assess implementation**in terms of people-centred care (e.g. activation, empowerment, satisfaction, increase in knowledge), feasibility and cost effectiveness.
1. **conduct a parallel observational qualitative study using SurPass v2.0**for delivering people-centred survivorship care to <5-year CCS and >5-year CCS (but with limited treatment data available).

##### European Future Implementation & Achieving Impact

1. **develop a Prediction Model**using data from the pre-implementation activities and multi-country implementation study to enable healthcare decision-makers to assess the suitability and costs of SurPass v2.0.
1. **host an Implementation Toolkit**for further European implementation of the SurPass for people-centred care in various healthcare settings across Europe.
1. **disseminate and communicate the importance of people-centred survivorship care and results of PanCareSurPass**to key stakeholders to promote future implementation of SurPass v2.0 to improve people-centred survivorship care in Europe.

### Dependencies











### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (hl7.eu.fhir.pcsp.r4)](package.r4.tgz) and [R4B (hl7.eu.fhir.pcsp.r4b)](package.r4b.tgz) are available.

### Global Profiles

*There are no Global profiles defined*

### IP statements

This publication includes IP covered under the following statements.

* The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. [https://ucum.org/trac/wiki/TermsOfUse](https://ucum.org/trac/wiki/TermsOfUse)

* [Unified Code for Units of Measure (UCUM)](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ucum.html): [Bundle/BundleHulafe](Bundle-BundleHulafe.md), [ChemoUnitsVs](ValueSet-ChemoUnitsVs.md)...Show 8 more,[CumulativeDoseChemoObsPcsp](StructureDefinition-Observation-cumulativeDoseChemo-eu-pcsp.md),[Observation/ChemoHulafe-1-Ciclofosfamide-dose](Observation-ChemoHulafe-1-Ciclofosfamide-dose.md),[Observation/ChemoHulafe-1-Citarabina-dose](Observation-ChemoHulafe-1-Citarabina-dose.md),[Observation/ChemoHulafe-1-Metotrexato-dose](Observation-ChemoHulafe-1-Metotrexato-dose.md),[Observation/ChemoHulafe-1-Vincristina-dose](Observation-ChemoHulafe-1-Vincristina-dose.md),[Observation/ObservationRadTotalDose-1](Observation-ObservationRadTotalDose-1.md),[RadioUnitsVs](ValueSet-vs-radiotherapyDoseUnit-eu-pcsp.md)and[RadiotherapyEnergyOrIsotope](StructureDefinition-radiotherapy-energy-or-isotope.md)


* These codes are excerpted from Digital Imaging and Communications in Medicine (DICOM) Standard, Part 16: Content Mapping Resource, Copyright © 2011 by the National Electrical Manufacturers Association.

* [DICOM Controlled Terminology Definitions](http://hl7.org/fhir/R4/codesystem-dicom-dcim.html): [RadiotherapyDoseTypeVs](ValueSet-vs-radiotherapyDoseType-eu-pcsp.md) and [TotalDoseRadObsPcsp](StructureDefinition-Observation-totalDoseRad-eu-pcsp.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/6.5.0/CodeSystem-v3-loinc.html): [Bundle/54](Bundle-54.md), [Bundle/BundleHulafe](Bundle-BundleHulafe.md)...Show 18 more,[CancerStageGroup](StructureDefinition-mcode-cancer-stage-group.md),[CompositionSurpassPcsp](StructureDefinition-Composition-surpass-eu-pcsp.md),[Condition/ConditionPrimCancerMainzZeisig](Condition-ConditionPrimCancerMainzZeisig.md),[ConditionPrimaryCancerPcsp](StructureDefinition-Condition-primaryCancer-eu-pcsp.md),[DocRefDocType](ValueSet-vs-docref-doctype-eu-pcsp.md),[DocumentReferencePcsp](StructureDefinition-DocumentReference-eu-pcsp.md),[FollowupSurPass](Questionnaire-FollowupSurPass.md),[Observation/ObservationCBloodSCT-1-1](Observation-ObservationCBloodSCT-1-1.md),[Observation/ObservationPrimCancerMainzZeisig](Observation-ObservationPrimCancerMainzZeisig.md),[ObservationBloodAboRh](StructureDefinition-Observation-bld-abo-rh-eu-pcsp.md),[ObservationCodesDistantMetastasesVS](ValueSet-mcode-observation-codes-distant-metastases-vs.md),[ObservationCodesPrimaryTumorVS](ValueSet-mcode-observation-codes-primary-tumor-vs.md),[ObservationCodesRegionalNodesVS](ValueSet-mcode-observation-codes-regional-nodes-vs.md),[ObservationCodesStageGroupVS](ValueSet-mcode-observation-codes-stage-group-vs.md),[ObservationDiagnosisPcsp](StructureDefinition-Observation-diagnosis-eu-pcsp.md),[TNMDistantMetastasesCategory](StructureDefinition-mcode-tnm-distant-metastases-category.md),[TNMPrimaryTumorCategory](StructureDefinition-mcode-tnm-primary-tumor-category.md)and[TNMRegionalNodesCategory](StructureDefinition-mcode-tnm-regional-nodes-category.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://hl7.org/fhir/R4/codesystem-snomedct.html): [AffectedOrganVs](ValueSet-vs-affectedOrgan-eu-pcsp.md), [AmputationProcedureTypeVs](ValueSet-vs-amputationProcedureType-eu-pcsp.md)...Show 66 more,[BodyLocationQualifier](StructureDefinition-mcode-body-location-qualifier.md),[BodyLocationQualifierVS](ValueSet-mcode-body-location-qualifier-vs.md),[Bundle/54](Bundle-54.md),[Bundle/BundleHulafe](Bundle-BundleHulafe.md),[CalculatedEstimatedVs](ValueSet-vs-calcest-eu-pcsp.md),[CancerStageGroup](StructureDefinition-mcode-cancer-stage-group.md),[CancerStagingSystemVS](ValueSet-mcode-cancer-staging-system-vs.md),[ColostomyProcedureTypeVs](ValueSet-vs-colostomyProcedureType-eu-pcsp.md),[Condition/ConditionPrimCancerMainzZeisig](Condition-ConditionPrimCancerMainzZeisig.md),[ConditionGvhdPcsp](StructureDefinition-Condition-gvhd-eu-pcsp.md),[ConditionOtherInfosPcsp](StructureDefinition-Condition-otherinfos-eu-pcsp.md),[ConditionPrimaryCancerPcsp](StructureDefinition-Condition-primaryCancer-eu-pcsp.md),[ConditionSecondaryCancerPcsp](StructureDefinition-Condition-secondaryCancer-eu-pcsp.md),[ConditionToxicityPcsp](StructureDefinition-Condition-toxicity-eu-pcsp.md),[CumulativeDoseChemoObsPcsp](StructureDefinition-Observation-cumulativeDoseChemo-eu-pcsp.md),[FollowupSurPass](Questionnaire-FollowupSurPass.md),[FromToPosteriorAnteriorVs](ValueSet-vs-fromToPosteriorAnterior-eu-pcsp.md),[GastrostomyProcedureTypeVs](ValueSet-vs-gastrostomyProcedureType-eu-pcsp.md),[GradeVS](ValueSet-grade-test-vs.md),[HereditaryPredispositionDisease](ValueSet-vs-hereditary-eu-pcsp.md),[LeftRightBiUnilateralVS](ValueSet-laterality-qualifier-lrub-vs.md),[MorphologicAbnormalityVS](ValueSet-morphologicAbnormality-eu-vs.md),[NotAffectedOrgan](StructureDefinition-procedure-notAffectedOrgan.md),[Observation/ChemoHulafe-1-Ciclofosfamide-dose](Observation-ChemoHulafe-1-Ciclofosfamide-dose.md),[Observation/ChemoHulafe-1-Citarabina-dose](Observation-ChemoHulafe-1-Citarabina-dose.md),[Observation/ChemoHulafe-1-Metotrexato-dose](Observation-ChemoHulafe-1-Metotrexato-dose.md),[Observation/ChemoHulafe-1-Vincristina-dose](Observation-ChemoHulafe-1-Vincristina-dose.md),[Observation/ObservationCBloodSCT-1-1](Observation-ObservationCBloodSCT-1-1.md),[Observation/ObservationRadTotalDose-1](Observation-ObservationRadTotalDose-1.md),[Observation/ObservationRiskFactor-1](Observation-ObservationRiskFactor-1.md),[Observation/ObservationRiskFactor-2](Observation-ObservationRiskFactor-2.md),[Observation/ObservationRiskFactor-3](Observation-ObservationRiskFactor-3.md),[Observation/ObservationRiskFactor-4](Observation-ObservationRiskFactor-4.md),[ObservationHereditaryPredispositionPcsp](StructureDefinition-Observation-predisposition-eu-pcsp.md),[ObservationRiskFactor](StructureDefinition-Observation-riskfactor-eu-pcsp.md),[OtherInfosConditionVS](ValueSet-otherInfos-condition-vs.md),[Procedure/ProcedureRadio-1](Procedure-ProcedureRadio-1.md),[Procedure/ProcedureSTC-1](Procedure-ProcedureSTC-1.md),[Procedure/ProcedureTransfusion-1](Procedure-ProcedureTransfusion-1.md),[ProcedureCVCOtherInfosPcsp](StructureDefinition-Procedure-cvc-otherinfos-eu-pcsp.md),[ProcedureCryopreservationOtherInfosPcsp](StructureDefinition-Procedure-cryopreservation-otherinfos-eu-pcsp.md),[ProcedureFltPcsp](StructureDefinition-Procedure-flt-eu-pcsp.md),[ProcedureRadiotherapyBoostPcsp](StructureDefinition-Procedure-radiotheraphyBoost-eu-pcsp.md),[ProcedureRadiotherapyPcsp](StructureDefinition-Procedure-radiotheraphy-eu-pcsp.md),[ProcedureRadiotherapyShieldingPcsp](StructureDefinition-Procedure-radiotheraphyShield-eu-pcsp.md),[ProcedureSctPcsp](StructureDefinition-Procedure-sct-eu-pcsp.md),[ProcedureSctProphylaxisPcsp](StructureDefinition-Procedure-sct-prophylaxis-eu-pcsp.md),[ProcedureSurgeryPcsp](StructureDefinition-Procedure-surgery-eu-pcsp.md),[ProcedureTransfusionOtherInfosPcsp](StructureDefinition-Procedure-transfusion-otherinfos-eu-pcsp.md),[ProstheticProcedureTypeVs](ValueSet-vs-ProstheticProcedureType-eu-pcsp.md),[RadiotherapyDoseTypeVs](ValueSet-vs-radiotherapyDoseType-eu-pcsp.md),[RadiotherapyEnergyOrIsotope](StructureDefinition-radiotherapy-energy-or-isotope.md),[RadiotherapyIsotopes](ValueSet-vs-isotopes-eu-pcsp.md),[RadiotherapyTypeVs](ValueSet-vs-radiotherapyType-eu-pcsp.md),[RelapseTypeVS](ValueSet-relapse-type-vs.md),[SacrifiedOrgan](StructureDefinition-surgery-sacrifiedOrgan.md),[SacrifiedOrganVs](ValueSet-vs-sacrifiedOrgan-eu-pcsp.md),[SctGvhdType](ValueSet-vs-Gvhd-type-eu-pcsp.md),[SctProphylaxisCathegory](ValueSet-vs-sct-prophylaxis-cathegory-eu-pcsp.md),[SctProphylaxisType](ValueSet-vs-sct-prophylaxis-type-eu-pcsp.md),[SctTypeVs](ValueSet-vs-sct-type-eu-pcsp.md),[SurgicalActionVs](ValueSet-vs-action-eu-pcsp.md),[TNMDistantMetastasesCategory](StructureDefinition-mcode-tnm-distant-metastases-category.md),[TNMPrimaryTumorCategory](StructureDefinition-mcode-tnm-primary-tumor-category.md),[TNMRegionalNodesCategory](StructureDefinition-mcode-tnm-regional-nodes-category.md)and[TotalDoseRadObsPcsp](StructureDefinition-Observation-totalDoseRad-eu-pcsp.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [Condition Clinical Status Codes](http://terminology.hl7.org/6.5.0/CodeSystem-condition-clinical.html): [ActiveResolvedConditionVS](ValueSet-activeResolved-condition-vs.md), [Bundle/54](Bundle-54.md)...Show 4 more,[ConditionPrimaryCancerPcsp](StructureDefinition-Condition-primaryCancer-eu-pcsp.md),[ConditionToxicityPcsp](StructureDefinition-Condition-toxicity-eu-pcsp.md),[PreviousStatus](StructureDefinition-condition-previousStatus.md)and[ProcedureFltPcsp](StructureDefinition-Procedure-flt-eu-pcsp.md)
* [DataAbsentReason](http://terminology.hl7.org/6.5.0/CodeSystem-data-absent-reason.html): [Bundle/54](Bundle-54.md), [CalculatedEstimatedVs](ValueSet-vs-calcest-eu-pcsp.md)...Show 26 more,[ConditionGvhdPcsp](StructureDefinition-Condition-gvhd-eu-pcsp.md),[ConditionPrimaryCancerPcsp](StructureDefinition-Condition-primaryCancer-eu-pcsp.md),[ConditionSecondaryCancerPcsp](StructureDefinition-Condition-secondaryCancer-eu-pcsp.md),[ConditionToxicityPcsp](StructureDefinition-Condition-toxicity-eu-pcsp.md),[CumulativeDoseChemoObsPcsp](StructureDefinition-Observation-cumulativeDoseChemo-eu-pcsp.md),[FltPlanType](ValueSet-vs-flt-plan-type-eu-pcsp.md),[ICD10HereditaryPredisposition](ValueSet-vs-icd10-predisposition-eu-pcsp.md),[ICDO3MorphologyVs](ValueSet-vs-icdo3-morphology-eu-pcsp.md),[LeftRightBiUnilateralVS](ValueSet-laterality-qualifier-lrub-vs.md),[NotApplicableUnknownVs](ValueSet-vs-naunk-eu-pcsp.md),[NotPerformedUnknownVs](ValueSet-vs-npunk-eu-pcsp.md),[ObservationHereditaryPredispositionPcsp](StructureDefinition-Observation-predisposition-eu-pcsp.md),[OtherUnknownTextVs](ValueSet-vs-othUnkTxt-eu-pcsp.md),[PlanDefinitionFltPcsp](StructureDefinition-PlanDefinition-flt-eu-pcsp.md),[ProcedureRadiotherapyBoostPcsp](StructureDefinition-Procedure-radiotheraphyBoost-eu-pcsp.md),[ProcedureRadiotherapyPcsp](StructureDefinition-Procedure-radiotheraphy-eu-pcsp.md),[ProcedureRadiotherapyShieldingPcsp](StructureDefinition-Procedure-radiotheraphyShield-eu-pcsp.md),[ProcedureSurgeryPcsp](StructureDefinition-Procedure-surgery-eu-pcsp.md),[ProsthesisTypeVs](ValueSet-vs-ProsthesisType-eu-pcsp.md),[RadiotherapyTypeVs](ValueSet-vs-radiotherapyType-eu-pcsp.md),[SctAcuteGvhdGrade](ValueSet-vs-Gvhd-acute-grade-eu-pcsp.md),[SctChronicGvhdGrade](ValueSet-vs-Gvhd-chronic-grade-eu-pcsp.md),[TotalDoseRadObsPcsp](StructureDefinition-Observation-totalDoseRad-eu-pcsp.md),[ToxicitySeverityVS](ValueSet-toxicityseverity-vs.md),[UnknownOtherVs](ValueSet-vs-unknownOther-eu-pcsp.md)and[VsRadiotherapy](ValueSet-vs-radiotherapy-pcsp.md)
* [Observation Category Codes](http://terminology.hl7.org/6.5.0/CodeSystem-observation-category.html): [CumulativeDoseChemoObsPcsp](StructureDefinition-Observation-cumulativeDoseChemo-eu-pcsp.md), [Observation/ObservationRadTotalDose-1](Observation-ObservationRadTotalDose-1.md) and [TotalDoseRadObsPcsp](StructureDefinition-Observation-totalDoseRad-eu-pcsp.md)
* [PlanDefinitionType](http://terminology.hl7.org/6.5.0/CodeSystem-plan-definition-type.html): [FltPlanType](ValueSet-vs-flt-plan-type-eu-pcsp.md), [PlanDefinition/3976](PlanDefinition-3976.md) and [PlanDefinitionFltPcsp](StructureDefinition-PlanDefinition-flt-eu-pcsp.md)
* [ActCode](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActCode.html): [Bundle/54](Bundle-54.md), [Bundle/BundleHulafe](Bundle-BundleHulafe.md), [Encounter/EncHulafe-1](Encounter-EncHulafe-1.md), [Encounter/EncounterPrimCancerMainzFischer](Encounter-EncounterPrimCancerMainzFischer.md) and [Encounter/EncounterPrimCancerMainzZeisig](Encounter-EncounterPrimCancerMainzZeisig.md)
* [NullFlavor](http://terminology.hl7.org/6.5.0/CodeSystem-v3-NullFlavor.html): [Bundle/54](Bundle-54.md), [Bundle/BundleHulafe](Bundle-BundleHulafe.md)...Show 7 more,[Condition/ConditionPrimCancerMainzFischer](Condition-ConditionPrimCancerMainzFischer.md),[Condition/PrimaryCancerHulafe-1](Condition-PrimaryCancerHulafe-1.md),[ConditionPrimaryCancerPcsp](StructureDefinition-Condition-primaryCancer-eu-pcsp.md),[ObservationHereditaryPredispositionPcsp](StructureDefinition-Observation-predisposition-eu-pcsp.md),[OrphaHereditaryPredisposition](ValueSet-vs-orpha-predisposition-eu-pcsp.md),[OtherUnknownTextVs](ValueSet-vs-othUnkTxt-eu-pcsp.md)and[UnknownOtherVs](ValueSet-vs-unknownOther-eu-pcsp.md)
* [RoleCode](http://terminology.hl7.org/6.5.0/CodeSystem-v3-RoleCode.html): [Patient/PatientCineca](Patient-PatientCineca.md) and [Patient/PatientHulafe](Patient-PatientHulafe.md)




## Resource Content

```json
{
  "resourceType" : "ImplementationGuide",
  "id" : "hl7.eu.fhir.pcsp",
  "url" : "http://hl7.eu/fhir/ig/pcsp/ImplementationGuide/hl7.eu.fhir.pcsp",
  "version" : "1.0.0",
  "name" : "PCSPImplementationGuide",
  "title" : "PanCareSurPass Project HL7 FHIR Implementation Guide",
  "status" : "active",
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "PanCareSurPass is an EU project aiming to conduct a robust assessment of the Cancer Survivorship Passport (SurPass).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "packageId" : "hl7.eu.fhir.pcsp",
  "license" : "CC-BY-SA-4.0",
  "fhirVersion" : ["4.0.1"],
  "dependsOn" : [
    {
      "id" : "hl7tx",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on HL7 Terminology"
        }
      ],
      "uri" : "http://terminology.hl7.org/ImplementationGuide/hl7.terminology",
      "packageId" : "hl7.terminology.r4",
      "version" : "6.5.0"
    },
    {
      "id" : "hl7_fhir_uv_extensions_r4",
      "uri" : "http://hl7.org/fhir/extensions/ImplementationGuide/hl7.fhir.uv.extensions",
      "packageId" : "hl7.fhir.uv.extensions.r4",
      "version" : "5.2.0"
    },
    {
      "id" : "hl7_fhir_uv_ips",
      "uri" : "http://hl7.org/fhir/uv/ips/ImplementationGuide/hl7.fhir.uv.ips",
      "packageId" : "hl7.fhir.uv.ips",
      "version" : "2.0.0"
    },
    {
      "id" : "hl7_fhir_us_mcode",
      "uri" : "http://hl7.org/fhir/us/mcode/ImplementationGuide/hl7.fhir.us.mcode",
      "packageId" : "hl7.fhir.us.mcode",
      "version" : "4.0.0"
    }
  ],
  "definition" : {
    "extension" : [
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2021+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "release"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "show-inherited-invariants"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "pin-canonicals"
          },
          {
            "url" : "value",
            "valueString" : "pin-multiples"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://www.orpha.net"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://terminology.hl7.org/CodeSystem/icd-o-3"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://terminology.hl7.org/CodeSystem/iccc-3"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.eu/fhir/ig/pcsp/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-internal-dependency",
        "valueCode" : "hl7.fhir.uv.tools.r4#0.8.0"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2021+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "release"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "show-inherited-invariants"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "pin-canonicals"
          },
          {
            "url" : "value",
            "valueString" : "pin-multiples"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://www.orpha.net"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://terminology.hl7.org/CodeSystem/icd-o-3"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://terminology.hl7.org/CodeSystem/iccc-3"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.eu/fhir/ig/pcsp/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      }
    ],
    "grouping" : [
      {
        "id" : "SurPassLogicalModel",
        "name" : "SurPass Logical model",
        "description" : "Logical data models as HL7 FHIR resources"
      },
      {
        "id" : "SurPassProfile",
        "name" : "SurPass Bundle profile",
        "description" : "HL7 FHIR profile for the SurPass document bundle"
      }
    ],
    "resource" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/event-location"
        },
        "name" : "Act Location",
        "description" : "This extension provides a means to indicate where an act was, is or it is intended to take place.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/activeResolved-condition-vs"
        },
        "name" : "Active or resolved Condition",
        "description" : "Active or resolved Condition",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vs-Gvhd-acute-grade-eu-pcsp"
        },
        "name" : "Acute Gvhd Grade",
        "description" : "Acute Gvhd Grade",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vs-affectedOrgan-eu-pcsp"
        },
        "name" : "Affected Organs (surgery)",
        "description" : "Affected Organs (surgery)",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vs-amputationProcedureType-eu-pcsp"
        },
        "name" : "Amputation Surgical Procedure Type",
        "description" : "Types of amputation procedure this resource is referring to",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/annotation-type"
        },
        "name" : "Annotation Type",
        "description" : "This extension is used to indicate the kind of note captured",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/annotation-type-vs"
        },
        "name" : "Annotation type",
        "description" : "Annotation type",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/drugsAtc-eu-pcsp"
        },
        "name" : "Antineoplastic and immunostimulating agents",
        "description" : "List of WHO ATC codes for antineoplastic and immunostimulating agents.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/54"
        },
        "name" : "Austria - Bundle: Example of a Childhood Cancer Survivor Passport",
        "description" : "Example of a Childhood Cancer Survivor Passport Bundle for the PanCareSurPass project",
        "exampleCanonical" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Bundle-eu-pcsp"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vs-sct-timing-eu-pcsp"
        },
        "name" : "Before/after procedure",
        "description" : "SCT Timing events: Before/after procedure",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/BiologicallyDerivedProduct-sct-eu-pcsp"
        },
        "name" : "BiologicallyDerivedProduct: Stem Cell",
        "description" : "This profile defines how to represent Stem Cell in FHIR for describing a Stem Cell Transplantation data required by the PanCareSurPass algorithm to generate the care plan.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/mcode-body-location-qualifier"
        },
        "name" : "Body Location Qualifier",
        "description" : "Qualifier to refine an body location. These include qualifiers for relative location, directionality, number, and plane, and exclude qualifiers for laterality.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/mcode-body-location-qualifier-vs"
        },
        "name" : "Body Location Qualifier Value Set",
        "description" : "Qualifiers to refine a body structure or location including qualifiers for relative location, directionality, number, and plane, and excluding qualifiers for laterality.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vs-fromToPosteriorAnterior-eu-pcsp"
        },
        "name" : "Body Location Qualifier Value Set",
        "description" : "Types of documents exchanged with the PCSP platform",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vs-brachytherapyType-eu-pcsp"
        },
        "name" : "Brachytherapy Type",
        "description" : "Types of Brachytherapy this procedure is referring to",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Bundle-eu-pcsp"
        },
        "name" : "Bundle: Survivor Passport",
        "description" : "This profile represents the constraints applied to the Bundle resource by the PCSP FHIR Implementation Guide.",
        "exampleBoolean" : false,
        "groupingId" : "SurPassProfile"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vs-calcest-eu-pcsp"
        },
        "name" : "Calculated|Estimated",
        "description" : "Calculated|Estimated Value Set",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/mcode-cancer-staging-system-vs"
        },
        "name" : "Cancer Staging System Value Set",
        "description" : "System used for staging.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/PlanOfCare"
        },
        "name" : "Care Plan",
        "description" : "Care Plan",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/CarePlan-eu-pcsp"
        },
        "name" : "CarePlan: PCSP-generated plan",
        "description" : "This profile defines how to represent the Care Plan proposed by the PCSP platoform in HL7 FHIR. This profile can be used for both the version generated by the platoform and that curated and validated by Clinicians.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Chemotherapy"
        },
        "name" : "Chemotherapy",
        "description" : "Chemotherapy",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/ChemoUnitsVs"
        },
        "name" : "Chemotherapy cumulative dose units",
        "description" : "Chemotherapy cumulative dose units",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vs-Gvhd-chronic-grade-eu-pcsp"
        },
        "name" : "Chronic Gvhd condition",
        "description" : "Acute Gvhd Grade",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "PlanDefinition"
          }
        ],
        "reference" : {
          "reference" : "PlanDefinition/3976"
        },
        "name" : "Cineca - Clinical Protocol",
        "description" : "Clinical protocol for the CINECA project",
        "exampleCanonical" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/PlanDefinition-flt-eu-pcsp"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/PatientCineca"
        },
        "name" : "Cineca - Patient: Sample of Patient (Rossi)",
        "description" : "Sample of Patient created based on information available in the PCSP platform",
        "exampleCanonical" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Patient-eu-pcsp"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vs-colostomyProcedureType-eu-pcsp"
        },
        "name" : "Colostomy Surgical Procedure Type",
        "description" : "Types of colostomy procedure this resource is referring to",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Composition-surpass-eu-pcsp"
        },
        "name" : "Composition: Survivor Passport",
        "description" : "This profile defines how to represent a PCSP Survivor Passport by using a HL7 FHIR Composition for the purpose of the PanCareSurPass project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/mcode-condition-related"
        },
        "name" : "Condition related to resource",
        "description" : "The resource has an unspecified relationship with a Condition.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Condition-gvhd-eu-pcsp"
        },
        "name" : "Condition: GvHD",
        "description" : "This profile defines how to represent Graft versus host disease (GvHD) in HL7 FHIR for the purpose of the PanCareSurPass project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Condition-secondaryCancer-eu-pcsp"
        },
        "name" : "Condition: Metastatic Cancer",
        "description" : "This profile defines how to represent metastatic cancer in FHIR for the purpose of the PanCareSurPass project. \r\nThis profile is inspired from the [mCode IG](http://build.fhir.org/ig/HL7/fhir-mCODE-ig). \r\nRecords the history of secondary neoplasms, including location(s) and the date of onset of metastases. A secondary cancer results from the spread (metastasization) of cancer from its original site (Definition from: NCI Dictionary of Cancer Terms).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Condition-otherinfos-eu-pcsp"
        },
        "name" : "Condition: Others",
        "description" : "This profile defines how to describe the presence of some other conditions (e.g. Hypogonadism, Growth hormone deficiency, Hydrocephalus in HL7 FHIR for the purpose of the PanCareSurPass project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Condition-primaryCancer-eu-pcsp"
        },
        "name" : "Condition: Primary Cancer",
        "description" : "This profile defines how to represent Primary Cancer Condition in HL7 FHIR for the purpose of the PanCareSurPass project. \r\nThis profile is inspired from the [mCode IG](http://build.fhir.org/ig/HL7/fhir-mCODE-ig). \r\nA primary cancer condition, the original or first tumor in the body (Definition from: [NCI Dictionary of Cancer Terms]( https://www.cancer.gov/publications/dictionaries/cancer-terms/def/primary-tumor)).  Cancers that are not clearly secondary (i.e., of uncertain origin or behavior) should be documented as primary.\r\nThis profile should be also used for documenting primary cancer relapses during or after FLT.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Condition-toxicity-eu-pcsp"
        },
        "name" : "Condition: Severe Toxicity",
        "description" : "This profile defines how to describe a Severe Toxicity event in HL7 FHIR for the purpose of the PanCareSurPass project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/ConditionsCS"
        },
        "name" : "Conditions",
        "description" : "PancareSurPass Conditions Code System",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vs-riskcondition-eu-pcsp"
        },
        "name" : "Conditions at risk",
        "description" : "Condition at risk proposed by the PCSP algorithm",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cond-test-vs"
        },
        "name" : "Conditions: follow up",
        "description" : "Conditions: follow up",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Diagnosis"
        },
        "name" : "Diagnosis",
        "description" : "Diagnosis",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vs-docref-doctype-eu-pcsp"
        },
        "name" : "Document Type",
        "description" : "Types of documents exchanged with the PCSP platform",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/DocumentReference-eu-pcsp"
        },
        "name" : "DocumentReference: PCSP",
        "description" : "This profile defines how to embed a PDF PCSP Survivor Passport in FHIR for the purpose of the PanCareSurPass project. This profile can be aslo used for send attachments (e.g Raditherapy reports or HDR) to the platform",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Encounter-eu-pcsp"
        },
        "name" : "Encounter: Treatment Center",
        "description" : "This profile defines how to represent data of arrival to the center and Center information in FHIR for the purpose of the PanCareSurPass project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vs-flt-plan-type-eu-pcsp"
        },
        "name" : "FLT Plan Type",
        "description" : "FLT Plan Type",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Questionnaire"
          }
        ],
        "reference" : {
          "reference" : "Questionnaire/FollowupSurPass"
        },
        "name" : "FollowupSurPass",
        "description" : "Follow up form.\nThe first Followup-Surpass form must be completed at the same time as the SurPass is delivered or in any case at the first visit after the end of the treatment (OT).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/FrontLineTreatment"
        },
        "name" : "Front Line Treatment",
        "description" : "Front Line Treatment. The first treatment given for a disease. It is often part of a standard set of treatments, such as surgery followed by chemotherapy and radiation. When used by itself, first-line therapy is the one accepted as the best treatment. If it does not cure the disease or it causes severe side effects, other treatment may be added or used instead. Also called induction therapy, primary therapy, and primary treatment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vs-gastrostomyProcedureType-eu-pcsp"
        },
        "name" : "Gastrostomy Surgical Procedure Type",
        "description" : "Types of Gastrostomy procedure this resource is referring to",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/grade-test-vs"
        },
        "name" : "Grade: follow up",
        "description" : "Grade: follow up",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vs-Gvhd-type-eu-pcsp"
        },
        "name" : "Gvhd condition",
        "description" : "Gvhd condition",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vs-icd10-predisposition-eu-pcsp"
        },
        "name" : "Hereditary Predispositions (ICD10)",
        "description" : "Hereditary Predispositions (ICD10)",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vs-orpha-predisposition-eu-pcsp"
        },
        "name" : "Hereditary Predispositions (Orphacode)",
        "description" : "Hereditary Predispositions (Orphacode)",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vs-hereditary-eu-pcsp"
        },
        "name" : "Hereditary Predispositions or Disease",
        "description" : "Hereditary Predispositions or Disease",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/BundleHulafe"
        },
        "name" : "Hulafe - Bundle: Example of a Childhood Cancer Survivor Passport",
        "description" : "Example of a Childhood Cancer Survivor Passport Bundle for the PanCareSurPass project (Hulafe)",
        "exampleCanonical" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Bundle-eu-pcsp"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CarePlan"
          }
        ],
        "reference" : {
          "reference" : "CarePlan/CarePlanExample-1"
        },
        "name" : "Hulafe - CarePlan: Follow-up Recommendations",
        "description" : "Sample of Care Plan generated by the platform",
        "exampleCanonical" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/CarePlan-eu-pcsp"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/PrimaryCancerHulafe-1"
        },
        "name" : "Hulafe - Condition: Primary Diagnosis",
        "description" : "Sample of Primary Diagnosis based on information provided by Hulafe (Condition)",
        "exampleCanonical" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-primaryCancer-eu-pcsp"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DocumentReference"
          }
        ],
        "reference" : {
          "reference" : "DocumentReference/DocumentReferenceExample-1"
        },
        "name" : "Hulafe - DocumentReference: Preliminary SurPass",
        "description" : "Sample of DocumentReference used to refer a preliminary SurPass",
        "exampleCanonical" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/DocumentReference-eu-pcsp"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/EncHulafe-1"
        },
        "name" : "Hulafe - Encounter: Primary Diagnosis",
        "description" : "Sample of Primary Diagnosis based on information provided by Hulafe (Encounter)",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Location"
          }
        ],
        "reference" : {
          "reference" : "Location/ChemoHulafe-1-Location"
        },
        "name" : "Hulafe - Location: Chemotherapy",
        "description" : "Sample of Chemotherapy based on information provided by Hulafe (Location)",
        "exampleCanonical" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Location-eu-pcsp"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationAdministration"
          }
        ],
        "reference" : {
          "reference" : "MedicationAdministration/ChemoHulafe-1-Ciclofosfamide"
        },
        "name" : "Hulafe - MedicationAdministration: Chemotherapy Ciclofosfamide",
        "description" : "Sample of Chemotherapy based on information provided by Hulafe (Ciclofosfamide)",
        "exampleCanonical" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/MedicationAdministration-eu-pcsp"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationAdministration"
          }
        ],
        "reference" : {
          "reference" : "MedicationAdministration/ChemoHulafe-1-Citarabina"
        },
        "name" : "Hulafe - MedicationAdministration: Chemotherapy Citarabina",
        "description" : "Sample of Chemotherapy based on information provided by Hulafe (Citarabina)",
        "exampleCanonical" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/MedicationAdministration-eu-pcsp"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationAdministration"
          }
        ],
        "reference" : {
          "reference" : "MedicationAdministration/ChemoHulafe-1-Metotrexato"
        },
        "name" : "Hulafe - MedicationAdministration: Chemotherapy Metotrexato",
        "description" : "Sample of Chemotherapy based on information provided by Hulafe (Metotrexato)",
        "exampleCanonical" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/MedicationAdministration-eu-pcsp"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationAdministration"
          }
        ],
        "reference" : {
          "reference" : "MedicationAdministration/ChemoHulafe-1-Vincristina"
        },
        "name" : "Hulafe - MedicationAdministration: Chemotherapy Vincristina",
        "description" : "Sample of Chemotherapy based on information provided by Hulafe (Vincristina)",
        "exampleCanonical" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/MedicationAdministration-eu-pcsp"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/ChemoHulafe-1-corticosteroids"
        },
        "name" : "Hulafe - MedicationStatement: Chemotherapy Corticosteroids",
        "description" : "Sample of Chemotherapy based on information provided by Hulafe (Corticosteroids not used for at least 4 weeks continuously)",
        "exampleCanonical" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/MedicationStatement-eu-pcsp"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/ChemoHulafe-1-Ciclofosfamide-dose"
        },
        "name" : "Hulafe - Observation: Chemotherapy Ciclofosfamide Cumulative Dose",
        "description" : "Sample of Chemotherapy based on information provided by Hulafe (Ciclofosfamide Cumulative Dose)",
        "exampleCanonical" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-cumulativeDoseChemo-eu-pcsp"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/ChemoHulafe-1-Citarabina-dose"
        },
        "name" : "Hulafe - Observation: Chemotherapy Citarabina Cumulative Dose",
        "description" : "Sample of Chemotherapy based on information provided by Hulafe (Citarabina Cumulative Dose)",
        "exampleCanonical" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-cumulativeDoseChemo-eu-pcsp"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/ChemoHulafe-1-Metotrexato-dose"
        },
        "name" : "Hulafe - Observation: Chemotherapy Metotrexato Cumulative Dose",
        "description" : "Sample of Chemotherapy based on information provided by Hulafe (Metotrexato Cumulative Dose)",
        "exampleCanonical" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-cumulativeDoseChemo-eu-pcsp"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/ChemoHulafe-1-Vincristina-dose"
        },
        "name" : "Hulafe - Observation: Chemotherapy Vincristina Cumulative Dose",
        "description" : "Sample of Chemotherapy based on information provided by Hulafe (Vincristina Cumulative Dose)",
        "exampleCanonical" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-cumulativeDoseChemo-eu-pcsp"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/ObservationRiskFactor-4"
        },
        "name" : "Hulafe - Observation: Risk Factor Anthracyclines",
        "description" : "Sample of Risk Factor: Anthracyclines >= 250 mg/m2",
        "exampleCanonical" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-riskfactor-eu-pcsp"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/ObservationRiskFactor-2"
        },
        "name" : "Hulafe - Observation: Risk Factor RT breasts",
        "description" : "Sample of Risk Factor: RT >= 10 Gy to breasts",
        "exampleCanonical" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-riskfactor-eu-pcsp"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/ObservationRiskFactor-3"
        },
        "name" : "Hulafe - Observation: Risk Factor RT heart",
        "description" : "Sample of Risk Factor: RT >= 35 Gy to heart",
        "exampleCanonical" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-riskfactor-eu-pcsp"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/ObservationRiskFactor-1"
        },
        "name" : "Hulafe - Observation: Risk Factor RT thyroid gland",
        "description" : "Sample of Risk Factor: RT to thyroid gland",
        "exampleCanonical" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-riskfactor-eu-pcsp"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/OrgHulafe-1"
        },
        "name" : "Hulafe - Organization: Primary Diagnosis",
        "description" : "Sample of Primary Diagnosis based on information provided by Hulafe (Organization)",
        "exampleCanonical" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Organization-center-eu-pcsp"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/PatientHulafe-1"
        },
        "name" : "Hulafe - Patient: Sample of demographics data",
        "description" : "Sample of Patient demographics data based on information provided by Hulafe",
        "exampleCanonical" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Patient-eu-pcsp"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/PatientHulafe"
        },
        "name" : "Hulafe - Patient: Sample of Patient (Basoa Mancebo)",
        "description" : "Sample of Patient created based on information provided by Hulafe",
        "exampleCanonical" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Patient-eu-pcsp"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vs-iccc3-eu-pcsp"
        },
        "name" : "ICCC-3",
        "description" : "International Classification of Childhood Cancer, third edition + exceptional values",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vs-icdo3-morphology-eu-pcsp"
        },
        "name" : "ICD-O-3 Morphology",
        "description" : "ICD-O-3 Morphology",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vs-icdo3-topography-eu-pcsp"
        },
        "name" : "ICD-O-3 Topography",
        "description" : "ICD-O-3 Topography",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/iccc-3"
        },
        "name" : "International Classification of Childhood Cancer, Third Edition",
        "description" : "The International Classification of Childhood Cancer, Third Edition (ICCC-3) is a classification system used to categorize childhood cancers based on their histology and primary site. It is widely used in pediatric oncology for epidemiological studies and clinical research.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/icd-o-3"
        },
        "name" : "International Classification of Diseases for Oncology, Third Edition",
        "description" : "The International Classification of Diseases for Oncology, Third Edition (ICD-O-3) is a coding system used primarily for classifying and coding neoplasms (tumors) based on their topography (site) and morphology (histology). It is widely used in cancer registries and epidemiological research.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/mcode-laterality-qualifier"
        },
        "name" : "Laterality Qualifier",
        "description" : "Qualifier to specify laterality.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/laterality-qualifier-lrub-vs"
        },
        "name" : "Laterality Qualifier Value Set",
        "description" : "Qualifiers to specify laterality.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Location-eu-pcsp"
        },
        "name" : "Location: PCSP",
        "description" : "This profile defines how to represent FHIR Location for the purpose of the PanCareSurPass project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "BiologicallyDerivedProduct"
          }
        ],
        "reference" : {
          "reference" : "BiologicallyDerivedProduct/BiologicallyDerivedProduct-SCT1"
        },
        "name" : "Mainz - BiologicallyDerivedProduct: Stem Cell Transplantation (Zeisig)",
        "description" : "Sample of stem cell transplantation biologically derived product (Zeisig)",
        "exampleCanonical" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/BiologicallyDerivedProduct-sct-eu-pcsp"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/ConditionSecCancerMainzZeisig"
        },
        "name" : "Mainz - Condition: complete metastatic site Condition example (TBC) (Zeisig)",
        "description" : "Sample of metastatic site Condition based on information available by Mainz (Zeisig)",
        "exampleCanonical" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-secondaryCancer-eu-pcsp"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/ConditionPrimCancerMainzZeisig"
        },
        "name" : "Mainz - Condition: complete Primary Cancer Condition example (TBC) (Zeisig)",
        "description" : "Sample of Primary Cancer Condition  based on information available by Mainz (Zeisig)",
        "exampleCanonical" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-primaryCancer-eu-pcsp"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/ConditionPrimCancerMainzFischer"
        },
        "name" : "Mainz - Condition: Primary Cancer (Fischer)",
        "description" : "Sample of Primary Cancer Condition based on information available by Mainz (Fischer)",
        "exampleCanonical" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-primaryCancer-eu-pcsp"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/EncounterPrimCancerMainzFischer"
        },
        "name" : "Mainz - Encounter: Primary Cancer (Fischer)",
        "description" : "Sample of Encounter associated to the Primary Cancer Condition Mainz sample (Fischer)",
        "exampleCanonical" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Encounter-eu-pcsp"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/EncounterPrimCancerMainzZeisig"
        },
        "name" : "Mainz - Encounter: Primary Cancer (Zeisig)",
        "description" : "Sample of Encounter associated to the Primary Cancer Condition Mainz sample (Zeisig)",
        "exampleCanonical" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Encounter-eu-pcsp"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Location"
          }
        ],
        "reference" : {
          "reference" : "Location/Location-SCT1"
        },
        "name" : "Mainz - Location: Stem Cell Transplantation (Zeisig)",
        "description" : "Sample of location for stem cell transplantation (Zeisig)",
        "exampleCanonical" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Location-eu-pcsp"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/ObservationCBloodSCT-1-1"
        },
        "name" : "Mainz - Observation: Blood type/RH before the SCT (Zeisig)",
        "description" : "Sample of blood type/RH observation (Zeisig)",
        "exampleCanonical" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-bld-abo-rh-eu-pcsp"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/ObservationPrimCancerMainzZeisig"
        },
        "name" : "Mainz - Observation: Primary Cancer (Zeisig)",
        "description" : "Sample of Observation associated to the Primary Cancer Condition Mainz sample to provide details about the diagnosis (Zeisig)",
        "exampleCanonical" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-diagnosis-eu-pcsp"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/ObservationRadTotalDose-1"
        },
        "name" : "Mainz - Observation: Radiotherapy Total Dose (Zeisig)",
        "description" : "Sample of radiotherapy total dose observation from Mainz (Zeisig)",
        "exampleCanonical" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-totalDoseRad-eu-pcsp"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/PatientMainzFischer"
        },
        "name" : "Mainz - Patient: Sample of Patient (Fischer)",
        "description" : "Sample of Patient created based on information provided by Mainz (Fischer)",
        "exampleCanonical" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Patient-eu-pcsp"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/PatientMainzZeisig"
        },
        "name" : "Mainz - Patient: Sample of Patient (Zeisig)",
        "description" : "Sample of Patient created based on information provided by Mainz (Zeisig)",
        "exampleCanonical" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Patient-eu-pcsp"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Procedure"
          }
        ],
        "reference" : {
          "reference" : "Procedure/ProcedureRadio-1"
        },
        "name" : "Mainz - Procedure: Radiotherapy (Zeisig)",
        "description" : "Sample of radiotherapy procedure based on information from Mainz (Zeisig)",
        "exampleCanonical" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-radiotheraphy-eu-pcsp"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Procedure"
          }
        ],
        "reference" : {
          "reference" : "Procedure/ProcedureSTC-1"
        },
        "name" : "Mainz - Procedure: Stem Cell Transplantation (Zeisig)",
        "description" : "Sample of stem cell transplantation procedure from Mainz (Zeisig)",
        "exampleCanonical" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-sct-eu-pcsp"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Procedure"
          }
        ],
        "reference" : {
          "reference" : "Procedure/ProcedureTransfusion-1"
        },
        "name" : "Mainz - Procedure: Transfusion (Zeisig)",
        "description" : "Sample of transfusion procedure (Zeisig)",
        "exampleCanonical" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-transfusion-otherinfos-eu-pcsp"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/MajorSurgery"
        },
        "name" : "Major Surgery",
        "description" : "Major Surgery.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/MedicationAdministration-eu-pcsp"
        },
        "name" : "MedicationAdministration: Chemotherapy",
        "description" : "This profile defines how to represent MedicationAdministration in HL7 FHIR for describing Chemotherapy data for the purpose of the PanCareSurPass project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/MedicationStatement-eu-pcsp"
        },
        "name" : "MedicationStatement: Chemotherapy",
        "description" : "This profile defines how to represent MedicationStatement in FHIR for describing minimal information about provided medications for the purpose of the PanCareSurPass project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/DocMetadataFSE"
        },
        "name" : "Metadata FSE Italy",
        "description" : "Metadata FSE Italy.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/morphologicAbnormality-eu-vs"
        },
        "name" : "Morphologically abnormal structure",
        "description" : "Morphologically abnormal structure.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/procedure-notAffectedOrgan"
        },
        "name" : "Not affected Organ",
        "description" : "This extension is used to explicitly indicate the Organ (body site) that has not been affected by this procedure.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vs-naunk-eu-pcsp"
        },
        "name" : "Not Applicable|Unknown",
        "description" : "Not Applicable/Unknown Value Set",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vs-npunk-eu-pcsp"
        },
        "name" : "Not Performed|Unknown",
        "description" : "Not Performed/Unknown Value Set",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/mcode-observation-codes-distant-metastases-vs"
        },
        "name" : "Observation Codes for Distant Metastases Category",
        "description" : "Identifying codes based on the timing of classification for distant metastases (M) staging observations.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/mcode-observation-codes-primary-tumor-vs"
        },
        "name" : "Observation Codes for Primary Tumor Category",
        "description" : "Identifying codes based on the timing of classification for primary tumor (T) staging observations.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/mcode-observation-codes-regional-nodes-vs"
        },
        "name" : "Observation Codes for Regional Node Category",
        "description" : "Identifying codes based on the timing of classification for regional node (N) staging observations.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/mcode-observation-codes-stage-group-vs"
        },
        "name" : "Observation Codes for Stage Group Category",
        "description" : "Identifying codes based on the timing of classification for stage group observations.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Observation-bld-abo-rh-eu-pcsp"
        },
        "name" : "Observation: Blood type/RH",
        "description" : "This profile defines how to represent Blood type/RH  before or after the SCT in HL7 FHIR for the purpose of the PanCareSurPass project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/mcode-cancer-stage-group"
        },
        "name" : "Observation: Cancer Stage Group",
        "description" : "The extent of the cancer in the body, according to a given cancer staging classification system, based on evidence such as physical examination, imaging, and/or biopsy or based on pathologic analysis of a specimen.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Observation-cumulativeDoseChemo-eu-pcsp"
        },
        "name" : "Observation: Chemotherapy Cumulative Dose",
        "description" : "This profile defines how to represent Chemotherapy Cumulative Dose in FHIR for the purpose of the PanCareSurPass project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Observation-diagnosis-eu-pcsp"
        },
        "name" : "Observation: Diagnosis details",
        "description" : "This profile defines how to represent diagnosis details (when the diagnosis was made; who made it;...) in FHIR for the purpose of the PanCareSurPass project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Observation-predisposition-eu-pcsp"
        },
        "name" : "Observation: Hereditary Predisposition",
        "description" : "This profile defines how to represent Hereditary Predispositions in HL7 FHIR for the purpose of the PanCareSurPass project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Observation-totalDoseRad-eu-pcsp"
        },
        "name" : "Observation: Radiotherapy Total Dose PCSP",
        "description" : "This profile defines how to represent Radiotherapy Total Dose in FHIR for the purpose of the PanCareSurPass project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Observation-riskfactor-eu-pcsp"
        },
        "name" : "Observation: Risk Factor",
        "description" : "This profile defines how to represent a Risk Factor in HL7 FHIR as determined by the PCSP platoform.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/mcode-tnm-distant-metastases-category"
        },
        "name" : "Observation: TNM Distant Metastases Category",
        "description" : "Category describing the extent of a tumor metastasis in remote anatomical locations, based on evidence such as physical examination, imaging, and/or biopsy.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/mcode-tnm-primary-tumor-category"
        },
        "name" : "Observation: TNM Primary Tumor Category",
        "description" : "Category of the primary tumor, based on its size and extent, based on evidence such as physical examination, imaging, and/or biopsy.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/mcode-tnm-regional-nodes-category"
        },
        "name" : "Observation: TNM Regional Nodes Category",
        "description" : "Category of the presence or absence of metastases in regional lymph nodes, based on evidence such as physical examination, imaging, and/or biopsy.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Organization-center-eu-pcsp"
        },
        "name" : "Organization: Primary Treatment Center / Center of diagnosis",
        "description" : "This profile defines how to represent the Primary Treatment Center or the Center of diagnosis in FHIR for the purpose of the PanCareSurPass project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/OrphaNet"
        },
        "name" : "OrphaNet",
        "description" : "Orphanet selected codes",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/OtherInfos"
        },
        "name" : "Other info and relevant events",
        "description" : "Other info and relevant events",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/otherInfos-condition-vs"
        },
        "name" : "Other Infors Condition",
        "description" : "Other Infors Condition",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vs-othUnkTxt-eu-pcsp"
        },
        "name" : "Other/Unknown/Text",
        "description" : "Other/Unknown/Text Value Set",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Patient-eu-pcsp"
        },
        "name" : "Patient: PCSP",
        "description" : "This profile defines how to represent Patient in FHIR for the purpose of the PanCareSurPass project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cs-generic-eu-pcsp"
        },
        "name" : "PCSP Code System",
        "description" : "Coded concepts specified by the PancareSurPass Project",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cs-riskcondition-eu-pcsp"
        },
        "name" : "PCSP Conditions at risk",
        "description" : "Condition at risk proposed by the PCSP algorithm",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cs-recommendation-eu-pcsp"
        },
        "name" : "PCSP Recommendations",
        "description" : "Recommendations proposed by the PCSP algorithm",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/procedure-performedTiming"
        },
        "name" : "Performed Timing",
        "description" : "This extension allows to indicate when the procedure was performed as Timing.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/PlanDefinition-flt-eu-pcsp"
        },
        "name" : "PlanDefinition: Front Line Treatment",
        "description" : "This profile defines how to provide Front Line Treatment protocol infos in FHIR for the scope of the PanCareSurPass project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/condition-previousStatus"
        },
        "name" : "Previous Status",
        "description" : "This extension provides a mean to indicate the previous clinicalStatus of a condition. It might be used for example to indicate if a relapse is now in remission.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/procedure-usedReference"
        },
        "name" : "Procedure Used Reference",
        "description" : "Extend the usedReference element to BiologicallyDerivedProduct",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Procedure-cvc-otherinfos-eu-pcsp"
        },
        "name" : "Procedure: Catheter",
        "description" : "This profile defines how to describe the  Catheterization of vein Procedure in HL7 FHIR for the purpose of the PanCareSurPass project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Procedure-cryopreservation-otherinfos-eu-pcsp"
        },
        "name" : "Procedure: Cryopreservation",
        "description" : "This profile defines how to describe the cryopreservation of sperms or oocyte for cancer patient in HL7 FHIR for the purpose of the PanCareSurPass project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Procedure-flt-eu-pcsp"
        },
        "name" : "Procedure: Front Line Treatment",
        "description" : "This profile defines how to provide Front Line Treatment data in FHIR for the scope of the PanCareSurPass project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Procedure-treatment-otherinfos-eu-pcsp"
        },
        "name" : "Procedure: Other Treatments",
        "description" : "This profile defines how to convey textual information about other oncological treatments in HL7 FHIR for the purpose of the PanCareSurPass project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Procedure-radiotheraphy-eu-pcsp"
        },
        "name" : "Procedure: Radiotherapy",
        "description" : "This profile defines how to represent Procedures in FHIR for describing a set of Radiotherapy data required by the PanCareSurPass algorithm to generate the care plan.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Procedure-radiotheraphyBoost-eu-pcsp"
        },
        "name" : "Procedure: Radiotherapy Boost",
        "description" : "This profile defines how to represent Procedures in FHIR for describing a set of data required by PanCareSurPass for Radiotherapy Boosts",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Procedure-radiotheraphyShield-eu-pcsp"
        },
        "name" : "Procedure: Radiotherapy Shielding",
        "description" : "This profile defines how to represent Shielding Procedures in FHIR for describing a set of Radiotherapy data required by the PanCareSurPass algorithm to generate the care plan.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Procedure-sct-prophylaxis-eu-pcsp"
        },
        "name" : "Procedure: SCT Prophylaxis",
        "description" : "This profile defines how to represent GVHD prophylaxis, conditioning regimen Procedures in FHIR for supporting Stem Cell Transplantation data, as required by the PanCareSurPass algorithm to generate the care plan.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Procedure-sct-eu-pcsp"
        },
        "name" : "Procedure: Stem Cell Transplantation",
        "description" : "This profile defines how to represent Procedures in FHIR for describing a set of Stem Cell Transplantation data required by the PanCareSurPass algorithm to generate the care plan.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Procedure-surgery-eu-pcsp"
        },
        "name" : "Procedure: Surgery",
        "description" : "This profile defines how to represent Procedures in FHIR for describing a set of Surgery data required by the PanCareSurPass algorithm to generate the care plan. It is used also to provide inforamtion about shunt, amputation, and other procedures",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Procedure-transfusion-otherinfos-eu-pcsp"
        },
        "name" : "Procedure: Transfusion other infos",
        "description" : "This profile defines how to describe the Transfusion Procedure in HL7 FHIR for the purpose of the PanCareSurPass project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/RelapseAfterFLT"
        },
        "name" : "Progression-Relapse after FLT",
        "description" : "Progression-Relapse after FLT",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/RelapseDuringFLT"
        },
        "name" : "Progression-Relapse during FLT",
        "description" : "Progression-Relapse during FLT",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vs-ProsthesisType-eu-pcsp"
        },
        "name" : "Prosthesis Type",
        "description" : "Types of Prosthesis this procedure is referring to",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vs-ProstheticProcedureType-eu-pcsp"
        },
        "name" : "Prosthetic Surgical Procedure Type",
        "description" : "Types of Prosthetic procedure this resource is referring to",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Radiotherapy"
        },
        "name" : "Radiotherapy",
        "description" : "Radiotherapy",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vs-radiotherapyDeviceType-eu-pcsp"
        },
        "name" : "Radiotherapy Device Type",
        "description" : "Radiotherapy device type this procedure is referring to",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vs-radiotherapyDoseType-eu-pcsp"
        },
        "name" : "Radiotherapy Dose Type",
        "description" : "Types of radiotherapy cumulative dose this procedure is referring to",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vs-radiotherapyDoseUnit-eu-pcsp"
        },
        "name" : "Radiotherapy dose units",
        "description" : "Radiotherapy dose units",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/radiotherapy-energy-or-isotope"
        },
        "name" : "Radiotherapy Energy or Isotope",
        "description" : "The radiation energy used for radiotherapy. The energy spectrum is characterized\nby the maximum energy, the maximum accelaration voltage, or the used isotope. This extension is based on the CodeX™ Radiation Therapy RadiotherapyEnergyOrIsotope extension",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vs-isotopes-eu-pcsp"
        },
        "name" : "Radiotherapy Isotopes",
        "description" : "Radiotherapy Isotopes",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vs-radiotherapy-pcsp"
        },
        "name" : "Radiotherapy sites",
        "description" : "PancareSurPass radiotherapy sites Value Set",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cs-radiotherapy-pcsp"
        },
        "name" : "Radiotherapy sites",
        "description" : "PancareSurPass radiotherapy sites Code System",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vs-radiotherapyType-eu-pcsp"
        },
        "name" : "Radiotherapy Type",
        "description" : "Types of radiotherapy this procedure is referring to",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/procedure-fltArm"
        },
        "name" : "Randomization arm for trial",
        "description" : "This extension is used to provide a textual description of the randomization arm for trials (FLT).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vs-recommendation-eu-pcsp"
        },
        "name" : "Recommendations",
        "description" : "Recommendations proposed by the PCSP algorithm",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/condition-relapseType"
        },
        "name" : "Relapse Type",
        "description" : "This extension is used to indicate if a relapse/progression is local, remote or combined.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/relapse-type-vs"
        },
        "name" : "Relapse type (Local/Distant/Combined)",
        "description" : "Relapse type (Local/Distant/Combined)",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/resource-relatedInfo"
        },
        "name" : "Resource related information",
        "description" : "This extension provides a means to link the source resource to any target related information. This extension shall not be used when other more specific elements or standard extensions apply. E.g. Observation.hasMember.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vs-riskfactor-eu-pcsp"
        },
        "name" : "Risk Factors",
        "description" : "Risk Factors used by the PCSP algorithm",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cs-riskfactor-eu-pcsp"
        },
        "name" : "Risk Factors",
        "description" : "Risk Factors used by the PCSP algorithm",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vs-roa-eu-pcsp"
        },
        "name" : "Route of administration",
        "description" : "Route of administration",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/surgery-sacrifiedOrgan"
        },
        "name" : "Sacrified organ",
        "description" : "Organs are 'sacrified' either to allow a radical excision of the tumor or on purpose (spleen) for staging procedures",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vs-sacrifiedOrgan-eu-pcsp"
        },
        "name" : "Sacrified Organs (surgery)",
        "description" : "Sacrified Organs (surgery). Organs are 'sacrified' either to allow a radical excision of the tumor or on purpose (spleen) for staging procedures",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vs-sct-prophylaxis-cathegory-eu-pcsp"
        },
        "name" : "SCT Prophylaxis Cathegory",
        "description" : "SCT Prophylaxis Cathegory",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vs-sct-prophylaxis-type-eu-pcsp"
        },
        "name" : "SCT Prophylaxis Type",
        "description" : "SCT Prophylaxis Type",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vs-shuntProcedureType-eu-pcsp"
        },
        "name" : "Shunt Procedure Type",
        "description" : "Types of shunt surgical procedure this resource is referring to",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/mcode-cancer-stage-group-vs"
        },
        "name" : "Stage Group Value Set",
        "description" : "This value set is intended to contain allowable values for Stage Group, according to TNM staging rules. AJCC codes (preferably, version 8 for current cancers) SHOULD be used.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/sct-donor-type"
        },
        "name" : "Stem Cell Donor Type",
        "description" : "Specify the type of donor for the cell used in a transplantation",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vs-sct-donorType-eu-pcsp"
        },
        "name" : "Stem Cell Donor type",
        "description" : "Stem Cell Donor type",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/sct-source-type"
        },
        "name" : "Stem Cell Source Type",
        "description" : "Specify the type of source for the cell used in a transplantation",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vs-sct-sourceType-eu-pcsp"
        },
        "name" : "Stem Cell Source type",
        "description" : "Stem Cell Source type",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/StemCellTransplantation"
        },
        "name" : "Stem Cell Transplantation",
        "description" : "Stem Cell Transplantation.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vs-sct-type-eu-pcsp"
        },
        "name" : "Stem Cell Transplantation type",
        "description" : "Stem Cell Transplantation type",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Subject"
        },
        "name" : "Subject of care",
        "description" : "Subject of care",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vs-action-eu-pcsp"
        },
        "name" : "Surgical Actions",
        "description" : "Surgical Actions",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vs-surgicalProcedureType-eu-pcsp"
        },
        "name" : "Surgical Procedure Type",
        "description" : "Types of surgical procedure this resource is referring to",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SurPass"
        },
        "name" : "SurPass V2.0",
        "description" : "Survivorship Passport V2.0",
        "exampleBoolean" : false,
        "groupingId" : "SurPassLogicalModel"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/mcode-tnm-distant-metastases-category-vs"
        },
        "name" : "TNM Distant Metastases Category Value Set",
        "description" : "This value set is intended to contain allowable values for the M category, according to TNM staging rules. AJCC codes (preferably, version 8 for current cancers) SHOULD be used.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/mcode-tnm-primary-tumor-category-vs"
        },
        "name" : "TNM Primary Tumor Category Value Set",
        "description" : "This value set is intended to contain allowable values for the T category, according to TNM staging rules. AJCC codes (preferably, version 8 for current cancers) SHOULD be used.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/mcode-tnm-regional-nodes-category-vs"
        },
        "name" : "TNM Regional Nodes Category Value Set",
        "description" : "This value set is intended to contain allowable values for the N category, according to TNM staging rules. AJCC codes (preferably, version 8 for current cancers) SHOULD be used.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/toxicityseverity-vs"
        },
        "name" : "Toxicity Severity",
        "description" : "Toxicity Severity",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/TreatmentSummary"
        },
        "name" : "Treatment Summary",
        "description" : "Treatment Summary data model",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vs-unknownOther-eu-pcsp"
        },
        "name" : "Unknown|Other",
        "description" : "Unknown or Other",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/PatientVulsk"
        },
        "name" : "Vulsk - Patient: Sample of Patient (Jonaitė)",
        "description" : "Sample of Patient created based on information provided by Vulsk",
        "exampleCanonical" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Patient-eu-pcsp"
      }
    ],
    "page" : {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
          "valueUrl" : "toc.html"
        }
      ],
      "nameUrl" : "toc.html",
      "title" : "Table of Contents",
      "generation" : "html",
      "page" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "index.html"
            }
          ],
          "nameUrl" : "index.html",
          "title" : "PanCareSurPass FHIR IG - Home Page",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "logicalModel.html"
            }
          ],
          "nameUrl" : "logicalModel.html",
          "title" : "Logical Models",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "sequence.html"
            }
          ],
          "nameUrl" : "sequence.html",
          "title" : "Sequence diagrams",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "collaboration.html"
            }
          ],
          "nameUrl" : "collaboration.html",
          "title" : "Collaboration diagrams",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "profiles.html"
            }
          ],
          "nameUrl" : "profiles.html",
          "title" : "Profiles",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "terminology.html"
            }
          ],
          "nameUrl" : "terminology.html",
          "title" : "Terminology",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "extensions.html"
            }
          ],
          "nameUrl" : "extensions.html",
          "title" : "Extensions",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "examples.html"
            }
          ],
          "nameUrl" : "examples.html",
          "title" : "Examples",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "questionnaire.html"
            }
          ],
          "nameUrl" : "questionnaire.html",
          "title" : "Questionnaire",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "downloads.html"
            }
          ],
          "nameUrl" : "downloads.html",
          "title" : "Useful Downloads",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "changes.html"
            }
          ],
          "nameUrl" : "changes.html",
          "title" : "IG Change History",
          "generation" : "html"
        }
      ]
    },
    "parameter" : [
      {
        "code" : "path-resource",
        "value" : "input/capabilities"
      },
      {
        "code" : "path-resource",
        "value" : "input/examples"
      },
      {
        "code" : "path-resource",
        "value" : "input/extensions"
      },
      {
        "code" : "path-resource",
        "value" : "input/models"
      },
      {
        "code" : "path-resource",
        "value" : "input/operations"
      },
      {
        "code" : "path-resource",
        "value" : "input/profiles"
      },
      {
        "code" : "path-resource",
        "value" : "input/resources"
      },
      {
        "code" : "path-resource",
        "value" : "input/vocabulary"
      },
      {
        "code" : "path-resource",
        "value" : "input/maps"
      },
      {
        "code" : "path-resource",
        "value" : "input/testing"
      },
      {
        "code" : "path-resource",
        "value" : "input/history"
      },
      {
        "code" : "path-resource",
        "value" : "fsh-generated/resources"
      },
      {
        "code" : "path-pages",
        "value" : "template/config"
      },
      {
        "code" : "path-pages",
        "value" : "input/images"
      },
      {
        "code" : "path-tx-cache",
        "value" : "input-cache/txcache"
      }
    ]
  }
}

```
