# Sacrified Organs (surgery) - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Sacrified Organs (surgery)**

## ValueSet: Sacrified Organs (surgery) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/ValueSet/vs-sacrifiedOrgan-eu-pcsp | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:SacrifiedOrganVs |

 
Sacrified Organs (surgery). Organs are 'sacrified' either to allow a radical excision of the tumor or on purpose (spleen) for staging procedures 

 **References** 

* [Sacrified organ](StructureDefinition-surgery-sacrifiedOrgan.md)

### Logical Definition (CLD)

 

### Expansion

This value set contains 11 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "vs-sacrifiedOrgan-eu-pcsp",
  "url" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/vs-sacrifiedOrgan-eu-pcsp",
  "version" : "1.0.0",
  "name" : "SacrifiedOrganVs",
  "title" : "Sacrified Organs (surgery)",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "Sacrified Organs (surgery). Organs are 'sacrified' either to allow a radical excision of the tumor or on purpose (spleen) for staging procedures",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "78961009",
            "display" : "Spleen"
          },
          {
            "code" : "64033007",
            "display" : "Kidney"
          },
          {
            "code" : "81745001",
            "display" : "Eye"
          },
          {
            "code" : "39607008",
            "display" : "Lung"
          },
          {
            "code" : "15497006",
            "display" : "Ovary"
          },
          {
            "code" : "67923007",
            "display" : "Hypothalamic structure"
          },
          {
            "code" : "69748006",
            "display" : "Thyroid"
          },
          {
            "code" : "89837001",
            "display" : "Bladder"
          },
          {
            "code" : "35039007",
            "display" : "Uterus"
          }
        ]
      },
      {
        "valueSet" : [
          "http://hl7.eu/fhir/ig/pcsp/ValueSet/vs-unknownOther-eu-pcsp"
        ]
      }
    ]
  }
}

```
