# Performed Timing - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Performed Timing**

## Extension: Performed Timing 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/StructureDefinition/procedure-performedTiming | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:PerformedTiming |

This extension allows to indicate when the procedure was performed as Timing.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [Procedure: Radiotherapy](StructureDefinition-Procedure-radiotheraphy-eu-pcsp.md), [Procedure: Radiotherapy Boost](StructureDefinition-Procedure-radiotheraphyBoost-eu-pcsp.md) and [Procedure: Transfusion other infos](StructureDefinition-Procedure-transfusion-otherinfos-eu-pcsp.md)
* Examples for this Extension: [Procedure/ProcedureTransfusion-1](Procedure-ProcedureTransfusion-1.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.pcsp|current/StructureDefinition/procedure-performedTiming)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-procedure-performedTiming.csv), [Excel](StructureDefinition-procedure-performedTiming.xlsx), [Schematron](StructureDefinition-procedure-performedTiming.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "procedure-performedTiming",
  "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/procedure-performedTiming",
  "version" : "1.0.0",
  "name" : "PerformedTiming",
  "title" : "Performed Timing",
  "status" : "active",
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "This extension allows to indicate when the procedure was performed as Timing.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Procedure"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Performed Timing",
        "definition" : "This extension allows to indicate when the procedure was performed as Timing."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/procedure-performedTiming"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "type" : [
          {
            "code" : "Timing"
          }
        ]
      }
    ]
  }
}

```
