# Body Location Qualifier - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Body Location Qualifier**

## Extension: Body Location Qualifier 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/StructureDefinition/mcode-body-location-qualifier | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:BodyLocationQualifier |

Qualifier to refine an body location. These include qualifiers for relative location, directionality, number, and plane, and exclude qualifiers for laterality.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [Condition: Primary Cancer](StructureDefinition-Condition-primaryCancer-eu-pcsp.md), [Condition: Metastatic Cancer](StructureDefinition-Condition-secondaryCancer-eu-pcsp.md), [Observation: Radiotherapy Total Dose PCSP](StructureDefinition-Observation-totalDoseRad-eu-pcsp.md), [Procedure: Radiotherapy](StructureDefinition-Procedure-radiotheraphy-eu-pcsp.md)...Show 2 more,[Procedure: Radiotherapy Boost](StructureDefinition-Procedure-radiotheraphyBoost-eu-pcsp.md)and[Procedure: Radiotherapy Shielding](StructureDefinition-Procedure-radiotheraphyShield-eu-pcsp.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.pcsp|current/StructureDefinition/mcode-body-location-qualifier)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-mcode-body-location-qualifier.csv), [Excel](StructureDefinition-mcode-body-location-qualifier.xlsx), [Schematron](StructureDefinition-mcode-body-location-qualifier.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "mcode-body-location-qualifier",
  "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/mcode-body-location-qualifier",
  "version" : "1.0.0",
  "name" : "BodyLocationQualifier",
  "title" : "Body Location Qualifier",
  "status" : "active",
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "Qualifier to refine an body location. These include qualifiers for relative location, directionality, number, and plane, and exclude qualifiers for laterality.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Element"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Body Location Qualifier",
        "definition" : "Qualifier to refine an body location. These include qualifiers for relative location, directionality, number, and plane, and exclude qualifiers for laterality."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/mcode-body-location-qualifier"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/mcode-body-location-qualifier-vs"
        }
      }
    ]
  }
}

```
