# Act Location - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Act Location**

## Extension: Act Location 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/StructureDefinition/event-location | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:EventLocation |

This extension provides a means to indicate where an act was, is or it is intended to take place.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [MedicationAdministration: Chemotherapy](StructureDefinition-MedicationAdministration-eu-pcsp.md)
* Examples for this Extension: [Bundle/BundleHulafe](Bundle-BundleHulafe.md), [MedicationAdministration/ChemoHulafe-1-Ciclofosfamide](MedicationAdministration-ChemoHulafe-1-Ciclofosfamide.md), [MedicationAdministration/ChemoHulafe-1-Citarabina](MedicationAdministration-ChemoHulafe-1-Citarabina.md), [MedicationAdministration/ChemoHulafe-1-Metotrexato](MedicationAdministration-ChemoHulafe-1-Metotrexato.md) and [MedicationAdministration/ChemoHulafe-1-Vincristina](MedicationAdministration-ChemoHulafe-1-Vincristina.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.pcsp|current/StructureDefinition/event-location)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-event-location.csv), [Excel](StructureDefinition-event-location.xlsx), [Schematron](StructureDefinition-event-location.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "event-location",
  "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/event-location",
  "version" : "1.0.0",
  "name" : "EventLocation",
  "title" : "Act Location",
  "status" : "active",
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "This extension provides a means to indicate where an act was, is or it is intended to take place.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Resource"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Act Location",
        "definition" : "This extension provides a means to indicate where an act was, is or it is intended to take place."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/event-location"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Location"]
          }
        ]
      }
    ]
  }
}

```
