# Progression-Relapse during FLT - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Progression-Relapse during FLT**

## Logical Model: Progression-Relapse during FLT 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/StructureDefinition/RelapseDuringFLT | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:RelapseDuringFLT |

 
Progression-Relapse during FLT 

**Usages:**

* Use this Logical Model: [Treatment Summary](StructureDefinition-TreatmentSummary.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.pcsp|current/StructureDefinition/RelapseDuringFLT)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-RelapseDuringFLT.csv), [Excel](StructureDefinition-RelapseDuringFLT.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "RelapseDuringFLT",
  "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/RelapseDuringFLT",
  "version" : "1.0.0",
  "name" : "RelapseDuringFLT",
  "title" : "Progression-Relapse during FLT",
  "status" : "active",
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "Progression-Relapse during FLT",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "fhir",
      "uri" : "hl7.org/fhir/r4",
      "name" : "RelapseDuringFLT model to PCSP HL7 FHIR R4 Profiles"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/RelapseDuringFLT",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "RelapseDuringFLT",
        "path" : "RelapseDuringFLT",
        "short" : "Progression-Relapse during FLT",
        "definition" : "Progression-Relapse during FLT",
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Condition.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-primaryCancer-eu-pcsp').where( (extension('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/condition-previousStatus').valueCode = #replaspe or #recurrence) and  ( onsetDateTime < Procedure.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-flt-eu-pcsp').performedPeriod.end) )"
          }
        ]
      },
      {
        "id" : "RelapseDuringFLT.identifier",
        "path" : "RelapseDuringFLT.identifier",
        "short" : "Progression-Relapse during FLT identifier",
        "definition" : "Progression-Relapse during FLT identifier",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".identifier"
          }
        ]
      },
      {
        "id" : "RelapseDuringFLT.relatedDiagnosis",
        "path" : "RelapseDuringFLT.relatedDiagnosis",
        "short" : "Related diagnosis identifier",
        "definition" : "Related diagnosis identifier",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".extension('http://hl7.org/fhir/StructureDefinition/condition-occurredFollowing')"
          }
        ]
      },
      {
        "id" : "RelapseDuringFLT.date",
        "path" : "RelapseDuringFLT.date",
        "short" : "Date",
        "definition" : "Report the date of the event in DD/MM/YYYY format. If the date is unkown or partially missed insert the year at the best of your knowledge.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".extension('http://hl7.org/fhir/StructureDefinition/condition-assertedDate')"
          }
        ]
      },
      {
        "id" : "RelapseDuringFLT.type",
        "path" : "RelapseDuringFLT.type",
        "short" : "relapse | progression",
        "definition" : "The type of event should be reported\n1 => Relapse\n2 => Progression \n-9922= NK",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".extension('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/condition-previousStatus').where(Condition.clinicalStatus << #inactive).valueCodeableConcept OR Condition.where( clinicalStatus = #relapse OR clinicalStatus = #recurrence).clinicalStatus"
          }
        ]
      },
      {
        "id" : "RelapseDuringFLT.qualifier",
        "path" : "RelapseDuringFLT.qualifier",
        "short" : "local | distant | combined",
        "definition" : "Please state if the relapse or progression was local, distant,  combined or unk",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".extension('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/condition-previousStatus').where(Condition.clinicalStatus = #inactive or #relapse or #recurrence).valueCodeableConcept OR Condition.where( clinicalStatus = #relapse OR clinicalStatus = #recurrence).clinicalStatus"
          }
        ]
      },
      {
        "id" : "RelapseDuringFLT.site",
        "path" : "RelapseDuringFLT.site",
        "short" : "If distant, site of metastases",
        "definition" : "If distant or comobined, specify site  (text)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Condition.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-secondaryCancer-eu-pcsp').bodySite"
          }
        ]
      }
    ]
  }
}

```
