# Organization: Primary Treatment Center / Center of diagnosis - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Organization: Primary Treatment Center / Center of diagnosis**

## Resource Profile: Organization: Primary Treatment Center / Center of diagnosis 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Organization-center-eu-pcsp | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:OrganizationCenterPcsp |

 
This profile defines how to represent the Primary Treatment Center or the Center of diagnosis in FHIR for the purpose of the PanCareSurPass project. 

**Usages:**

* Use this Profile: [Bundle: Survivor Passport](StructureDefinition-Bundle-eu-pcsp.md)
* Refer to this Profile: [Encounter: Treatment Center](StructureDefinition-Encounter-eu-pcsp.md), [Observation: Diagnosis details](StructureDefinition-Observation-diagnosis-eu-pcsp.md) and [Patient: PCSP](StructureDefinition-Patient-eu-pcsp.md)
* Examples for this Profile: [Hospital Universitari i Politècnic La Fe](Organization-OrgHulafe-1.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.pcsp|current/StructureDefinition/Organization-center-eu-pcsp)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Organization-center-eu-pcsp.csv), [Excel](StructureDefinition-Organization-center-eu-pcsp.xlsx), [Schematron](StructureDefinition-Organization-center-eu-pcsp.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Organization-center-eu-pcsp",
  "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Organization-center-eu-pcsp",
  "version" : "1.0.0",
  "name" : "OrganizationCenterPcsp",
  "title" : "Organization: Primary Treatment Center / Center of diagnosis",
  "status" : "active",
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "This profile defines how to represent the Primary Treatment Center or the Center of diagnosis in FHIR for the purpose of the PanCareSurPass project.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Organization",
  "baseDefinition" : "http://hl7.org/fhir/uv/ips/StructureDefinition/Organization-uv-ips",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organization.identifier",
        "path" : "Organization.identifier",
        "short" : "Identifier of the center"
      },
      {
        "id" : "Organization.name",
        "path" : "Organization.name",
        "short" : "Name of the Center"
      },
      {
        "id" : "Organization.address.city",
        "path" : "Organization.address.city",
        "short" : "Center address: city"
      },
      {
        "id" : "Organization.address.country",
        "path" : "Organization.address.country",
        "short" : "Center address: country"
      }
    ]
  }
}

```
