# MedicationStatement: Chemotherapy - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MedicationStatement: Chemotherapy**

## Resource Profile: MedicationStatement: Chemotherapy 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/StructureDefinition/MedicationStatement-eu-pcsp | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:MedicationStatementPcsp |

 
This profile defines how to represent MedicationStatement in FHIR for describing minimal information about provided medications for the purpose of the PanCareSurPass project. 

**Usages:**

* Use this Profile: [Bundle: Survivor Passport](StructureDefinition-Bundle-eu-pcsp.md)
* Refer to this Profile: [Composition: Survivor Passport](StructureDefinition-Composition-surpass-eu-pcsp.md)
* Examples for this Profile: [MedicationStatement/ChemoHulafe-1-corticosteroids](MedicationStatement-ChemoHulafe-1-corticosteroids.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.pcsp|current/StructureDefinition/MedicationStatement-eu-pcsp)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-MedicationStatement-eu-pcsp.csv), [Excel](StructureDefinition-MedicationStatement-eu-pcsp.xlsx), [Schematron](StructureDefinition-MedicationStatement-eu-pcsp.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "MedicationStatement-eu-pcsp",
  "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/MedicationStatement-eu-pcsp",
  "version" : "1.0.0",
  "name" : "MedicationStatementPcsp",
  "title" : "MedicationStatement: Chemotherapy",
  "status" : "active",
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "This profile defines how to represent MedicationStatement in FHIR for describing minimal information about provided medications for the purpose of the PanCareSurPass project.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MedicationStatement",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/MedicationStatement",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MedicationStatement.status",
        "path" : "MedicationStatement.status",
        "short" : "active | completed | entered-in-error | intended | stopped | on-hold | unknown |not-taken",
        "example" : [
          {
            "label" : "general",
            "valueCode" : "completed"
          }
        ]
      },
      {
        "id" : "MedicationStatement.medication[x]",
        "path" : "MedicationStatement.medication[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "MedicationStatement.medication[x]:medicationCodeableConcept",
        "path" : "MedicationStatement.medication[x]",
        "sliceName" : "medicationCodeableConcept",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "example" : [
          {
            "label" : "general",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.whocc.no/atc",
                  "code" : "H02",
                  "display" : "CORTICOSTEROIDS FOR SYSTEMIC USE"
                }
              ]
            }
          }
        ]
      },
      {
        "id" : "MedicationStatement.reasonReference",
        "path" : "MedicationStatement.reasonReference",
        "short" : "Required if related to chemotherapy treatments",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-primaryCancer-eu-pcsp"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationStatement.dosage.timing.repeat.bounds[x]",
        "path" : "MedicationStatement.dosage.timing.repeat.bounds[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "MedicationStatement.dosage.timing.repeat.bounds[x]:boundsDuration",
        "path" : "MedicationStatement.dosage.timing.repeat.bounds[x]",
        "sliceName" : "boundsDuration",
        "short" : "Length/Range of lengths, or (Start and/or end) limits.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Duration"
          }
        ]
      },
      {
        "id" : "MedicationStatement.dosage.timing.repeat.count",
        "path" : "MedicationStatement.dosage.timing.repeat.count",
        "short" : "Number of administration"
      },
      {
        "id" : "MedicationStatement.dosage.route",
        "path" : "MedicationStatement.dosage.route",
        "example" : [
          {
            "label" : "general",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://standardterms.edqm.eu",
                  "code" : "20042000",
                  "display" : "Intrathecal use"
                }
              ]
            }
          }
        ]
      }
    ]
  }
}

```
