# Condition: Metastatic Cancer - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Condition: Metastatic Cancer**

## Resource Profile: Condition: Metastatic Cancer 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-secondaryCancer-eu-pcsp | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:ConditionSecondaryCancerPcsp |

 
This profile defines how to represent metastatic cancer in FHIR for the purpose of the PanCareSurPass project. This profile is inspired from the[mCode IG](http://build.fhir.org/ig/HL7/fhir-mCODE-ig). Records the history of secondary neoplasms, including location(s) and the date of onset of metastases. A secondary cancer results from the spread (metastasization) of cancer from its original site (Definition from: NCI Dictionary of Cancer Terms). 

**Usages:**

* Use this Profile: [Bundle: Survivor Passport](StructureDefinition-Bundle-eu-pcsp.md)
* Refer to this Profile: [Composition: Survivor Passport](StructureDefinition-Composition-surpass-eu-pcsp.md)
* Examples for this Profile: [Condition/ConditionSecCancerMainzZeisig](Condition-ConditionSecCancerMainzZeisig.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.pcsp|current/StructureDefinition/Condition-secondaryCancer-eu-pcsp)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Condition-secondaryCancer-eu-pcsp.csv), [Excel](StructureDefinition-Condition-secondaryCancer-eu-pcsp.xlsx), [Schematron](StructureDefinition-Condition-secondaryCancer-eu-pcsp.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Condition-secondaryCancer-eu-pcsp",
  "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-secondaryCancer-eu-pcsp",
  "version" : "1.0.0",
  "name" : "ConditionSecondaryCancerPcsp",
  "title" : "Condition: Metastatic Cancer",
  "status" : "active",
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "This profile defines how to represent metastatic cancer in FHIR for the purpose of the PanCareSurPass project. \r\nThis profile is inspired from the [mCode IG](http://build.fhir.org/ig/HL7/fhir-mCODE-ig). \r\nRecords the history of secondary neoplasms, including location(s) and the date of onset of metastases. A secondary cancer results from the spread (metastasization) of cancer from its original site (Definition from: NCI Dictionary of Cancer Terms).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Condition",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Condition",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Condition.extension",
        "path" : "Condition.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Condition.extension:assertedDate",
        "path" : "Condition.extension",
        "sliceName" : "assertedDate",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/condition-assertedDate|5.2.0"
            ]
          }
        ]
      },
      {
        "id" : "Condition.extension:histologyMorphologyBehavior",
        "path" : "Condition.extension",
        "sliceName" : "histologyMorphologyBehavior",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/mcode/StructureDefinition/mcode-histology-morphology-behavior"
            ]
          }
        ]
      },
      {
        "id" : "Condition.extension:histologyMorphologyBehavior.value[x]",
        "path" : "Condition.extension.value[x]",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/vs-icdo3-morphology-eu-pcsp"
        }
      },
      {
        "id" : "Condition.extension:previousStatus",
        "path" : "Condition.extension",
        "sliceName" : "previousStatus",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/condition-previousStatus"
            ]
          }
        ]
      },
      {
        "id" : "Condition.extension:relapseType",
        "path" : "Condition.extension",
        "sliceName" : "relapseType",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/condition-relapseType"
            ]
          }
        ]
      },
      {
        "id" : "Condition.extension:relapseType.value[x]",
        "path" : "Condition.extension.value[x]",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/relapse-type-vs"
        }
      },
      {
        "id" : "Condition.extension:relatedPrimaryCancerCondition",
        "path" : "Condition.extension",
        "sliceName" : "relatedPrimaryCancerCondition",
        "short" : "Related Primary Cancer Condition",
        "definition" : "A reference to the primary cancer condition that provides context for this resource.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/condition-related|5.2.0"
            ]
          }
        ]
      },
      {
        "id" : "Condition.extension:relatedPrimaryCancerCondition.value[x]",
        "path" : "Condition.extension.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-primaryCancer-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Condition.clinicalStatus",
        "path" : "Condition.clinicalStatus",
        "mustSupport" : true
      },
      {
        "id" : "Condition.verificationStatus",
        "path" : "Condition.verificationStatus",
        "mustSupport" : true
      },
      {
        "id" : "Condition.code",
        "path" : "Condition.code",
        "mustSupport" : true
      },
      {
        "id" : "Condition.bodySite",
        "path" : "Condition.bodySite",
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/vs-icdo3-topography-eu-pcsp"
        }
      },
      {
        "id" : "Condition.bodySite.extension:locationQualifier",
        "path" : "Condition.bodySite.extension",
        "sliceName" : "locationQualifier",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/mcode-body-location-qualifier"
            ]
          }
        ]
      },
      {
        "id" : "Condition.bodySite.extension:lateralityQualifier",
        "path" : "Condition.bodySite.extension",
        "sliceName" : "lateralityQualifier",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/mcode-laterality-qualifier"
            ]
          }
        ]
      },
      {
        "id" : "Condition.bodySite.extension:lateralityQualifier.value[x]",
        "path" : "Condition.bodySite.extension.value[x]",
        "binding" : {
          "extension" : [
            {
              "extension" : [
                {
                  "url" : "purpose",
                  "valueCode" : "candidate"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://hl7.org/fhir/us/mcode/ValueSet/mcode-laterality-qualifier-vs"
                },
                {
                  "url" : "documentation",
                  "valueMarkdown" : "Qualifiers to specify laterality."
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            }
          ],
          "strength" : "preferred",
          "description" : "Qualifiers to specify laterality.",
          "valueSet" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/laterality-qualifier-lrub-vs"
        }
      },
      {
        "id" : "Condition.subject",
        "path" : "Condition.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Patient-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Condition.stage",
        "path" : "Condition.stage",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile"
      }
    ]
  }
}

```
