# Composition: Survivor Passport - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Composition: Survivor Passport**

## Resource Profile: Composition: Survivor Passport 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Composition-surpass-eu-pcsp | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:CompositionSurpassPcsp |

 
This profile defines how to represent a PCSP Survivor Passport by using a HL7 FHIR Composition for the purpose of the PanCareSurPass project. 

**Usages:**

* Use this Profile: [Bundle: Survivor Passport](StructureDefinition-Bundle-eu-pcsp.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.pcsp|current/StructureDefinition/Composition-surpass-eu-pcsp)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Composition-surpass-eu-pcsp.csv), [Excel](StructureDefinition-Composition-surpass-eu-pcsp.xlsx), [Schematron](StructureDefinition-Composition-surpass-eu-pcsp.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Composition-surpass-eu-pcsp",
  "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Composition-surpass-eu-pcsp",
  "version" : "1.0.0",
  "name" : "CompositionSurpassPcsp",
  "title" : "Composition: Survivor Passport",
  "status" : "active",
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "This profile defines how to represent a PCSP Survivor Passport by using a HL7 FHIR Composition for the purpose of the PanCareSurPass project.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "fhirdocumentreference",
      "uri" : "http://hl7.org/fhir/documentreference",
      "name" : "FHIR DocumentReference"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Composition",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Composition",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Composition.identifier",
        "path" : "Composition.identifier",
        "short" : "Business identifier for this SurPass"
      },
      {
        "id" : "Composition.status",
        "path" : "Composition.status",
        "short" : "preliminary|final|amended|entered-in-error"
      },
      {
        "id" : "Composition.type",
        "path" : "Composition.type",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-generic-eu-pcsp",
              "code" : "surpass"
            }
          ]
        }
      },
      {
        "id" : "Composition.type.coding.display",
        "path" : "Composition.type.coding.display",
        "short" : "Childhood Cancer Survivor Passport"
      },
      {
        "id" : "Composition.subject",
        "path" : "Composition.subject",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Patient-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Composition.date",
        "path" : "Composition.date",
        "short" : "SurPass Composition editing time"
      },
      {
        "id" : "Composition.author",
        "path" : "Composition.author",
        "short" : "Who and/or what authored this SurPass"
      },
      {
        "id" : "Composition.title",
        "path" : "Composition.title",
        "short" : "Childhood Cancer Survivor Passport"
      },
      {
        "id" : "Composition.attester",
        "path" : "Composition.attester",
        "short" : "Who attested the accuracy of this SurPass"
      },
      {
        "id" : "Composition.section",
        "path" : "Composition.section",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "code"
            }
          ],
          "description" : "Slice based on the coding.code pattern",
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Composition.section:flt",
        "path" : "Composition.section",
        "sliceName" : "flt",
        "short" : "Cancer diagnosis Narrative",
        "min" : 1,
        "max" : "*"
      },
      {
        "id" : "Composition.section:flt.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:flt.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "72135-7"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:flt.text",
        "path" : "Composition.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:flt.entry",
        "path" : "Composition.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resolve()"
            },
            {
              "type" : "profile",
              "path" : "resolve()"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Tumor FLT detail",
        "definition" : "Entrdescribing the primary cancer and optionally FLT anmetastasis.",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Condition",
              "http://hl7.org/fhir/StructureDefinition/Procedure",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.entry:primaryCancer",
        "path" : "Composition.section.entry",
        "sliceName" : "primaryCancer",
        "short" : "Primary Cancer",
        "definition" : "Primary Cancer or relapse during the treatment",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-primaryCancer-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.entry:metastasis",
        "path" : "Composition.section.entry",
        "sliceName" : "metastasis",
        "short" : "Metastasis",
        "definition" : "Metastasis",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-secondaryCancer-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.entry:flt",
        "path" : "Composition.section.entry",
        "sliceName" : "flt",
        "short" : "FLT",
        "definition" : "FronLine Treatment",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-flt-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.emptyReason",
        "path" : "Composition.section.emptyReason",
        "short" : "Why this section is empty"
      },
      {
        "id" : "Composition.section:flt.section",
        "path" : "Composition.section.section",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "code"
            }
          ],
          "description" : "Slice based on the coding.code pattern",
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Composition.section:flt.section:chemotherapy",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section",
        "sliceName" : "chemotherapy",
        "short" : "Chemotherapy",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:chemotherapy.title",
        "path" : "Composition.section.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:flt.section:chemotherapy.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "11486-8"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:flt.section:chemotherapy.text",
        "path" : "Composition.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:flt.section:chemotherapy.entry",
        "path" : "Composition.section.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resolve()"
            },
            {
              "type" : "profile",
              "path" : "resolve()"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Chemotherapy",
        "definition" : "Chemotherapy",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/MedicationAdministration",
              "http://hl7.org/fhir/StructureDefinition/MedicationStatement",
              "http://hl7.org/fhir/StructureDefinition/Procedure",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:chemotherapy.entry:medicationAdministration",
        "path" : "Composition.section.section.entry",
        "sliceName" : "medicationAdministration",
        "short" : "MedicationAdministration Chemotherapy",
        "definition" : "MedicationAdministration Chemotherapy",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/MedicationAdministration-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:chemotherapy.entry:medicationStatement",
        "path" : "Composition.section.section.entry",
        "sliceName" : "medicationStatement",
        "short" : "MedicationStatement: Chemotherapy",
        "definition" : "MedicationStatementChemotherapy",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/MedicationStatement-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:chemotherapy.emptyReason",
        "path" : "Composition.section.section.emptyReason",
        "short" : "Why this section is empty"
      },
      {
        "id" : "Composition.section:flt.section:stemCellTransplantation",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section",
        "sliceName" : "stemCellTransplantation",
        "short" : "Stem Cell Transplantation",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:stemCellTransplantation.title",
        "path" : "Composition.section.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:flt.section:stemCellTransplantation.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-generic-eu-pcsp",
              "code" : "section-sct"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:flt.section:stemCellTransplantation.text",
        "path" : "Composition.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:flt.section:stemCellTransplantation.entry",
        "path" : "Composition.section.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resolve()"
            },
            {
              "type" : "profile",
              "path" : "resolve()"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Stem CelTransplantation",
        "definition" : "Stem Cell Transplantation",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Procedure",
              "http://hl7.org/fhir/StructureDefinition/Condition",
              "http://hl7.org/fhir/StructureDefinition/Observation",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:stemCellTransplantation.entry:sct",
        "path" : "Composition.section.section.entry",
        "sliceName" : "sct",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-sct-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:stemCellTransplantation.entry:gvdh-prophylaxis",
        "path" : "Composition.section.section.entry",
        "sliceName" : "gvdh-prophylaxis",
        "short" : "GVHD prophylaxis",
        "definition" : "GVHD prophylaxis",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-sct-prophylaxis-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:stemCellTransplantation.entry:gvdh",
        "path" : "Composition.section.section.entry",
        "sliceName" : "gvdh",
        "short" : "GvHD",
        "definition" : "Grafversus host disease (GvHD)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-gvhd-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:stemCellTransplantation.entry:blood-abo",
        "path" : "Composition.section.section.entry",
        "sliceName" : "blood-abo",
        "short" : "Blootype/RH",
        "definition" : "Blood type/RH",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-bld-abo-rh-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:stemCellTransplantation.emptyReason",
        "path" : "Composition.section.section.emptyReason",
        "short" : "Why this section is empty"
      },
      {
        "id" : "Composition.section:flt.section:radiotherapy",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section",
        "sliceName" : "radiotherapy",
        "short" : "Radiotherapy",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:radiotherapy.title",
        "path" : "Composition.section.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:flt.section:radiotherapy.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-generic-eu-pcsp",
              "code" : "section-rt"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:flt.section:radiotherapy.text",
        "path" : "Composition.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:flt.section:radiotherapy.entry",
        "path" : "Composition.section.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resolve()"
            },
            {
              "type" : "profile",
              "path" : "resolve()"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Radiotherapy",
        "definition" : "Radiotherapy",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Procedure",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:radiotherapy.entry:radiotherapy",
        "path" : "Composition.section.section.entry",
        "sliceName" : "radiotherapy",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-radiotheraphy-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:radiotherapy.entry:boost",
        "path" : "Composition.section.section.entry",
        "sliceName" : "boost",
        "short" : "Radiotherapy Boost",
        "definition" : "Radiotherapy Boost",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-radiotheraphyBoost-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:radiotherapy.entry:shield",
        "path" : "Composition.section.section.entry",
        "sliceName" : "shield",
        "short" : "Radiotherapy Shielding",
        "definition" : "Radiotherapy Shielding",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-radiotheraphyShield-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:radiotherapy.emptyReason",
        "path" : "Composition.section.section.emptyReason",
        "short" : "Why this section is empty"
      },
      {
        "id" : "Composition.section:flt.section:majorSurgery",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section",
        "sliceName" : "majorSurgery",
        "short" : "History of Surgical procedures",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:majorSurgery.title",
        "path" : "Composition.section.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:flt.section:majorSurgery.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "8690-0"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:flt.section:majorSurgery.text",
        "path" : "Composition.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:flt.section:majorSurgery.entry",
        "path" : "Composition.section.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resolve()"
            },
            {
              "type" : "profile",
              "path" : "resolve()"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Major Surgery",
        "definition" : "Major Surgery",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Procedure",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:majorSurgery.entry:procedure",
        "path" : "Composition.section.section.entry",
        "sliceName" : "procedure",
        "short" : "Surgical procedure",
        "definition" : "Surgical procedure",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-surgery-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:majorSurgery.emptyReason",
        "path" : "Composition.section.section.emptyReason",
        "short" : "Why this section is empty"
      },
      {
        "id" : "Composition.section:flt.section:otherInfos",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section",
        "sliceName" : "otherInfos",
        "short" : "Other Medical Information",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:otherInfos.title",
        "path" : "Composition.section.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:flt.section:otherInfos.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "55752-0"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:flt.section:otherInfos.text",
        "path" : "Composition.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:flt.section:otherInfos.entry",
        "path" : "Composition.section.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resolve()"
            },
            {
              "type" : "profile",
              "path" : "resolve()"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Other infos",
        "definition" : "Other infos",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Condition",
              "http://hl7.org/fhir/StructureDefinition/Procedure",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:otherInfos.entry:conditionToxicity",
        "path" : "Composition.section.section.entry",
        "sliceName" : "conditionToxicity",
        "short" : "Condition: Severe Toxicity",
        "definition" : "Condition: Severe Toxicity",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-toxicity-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:otherInfos.entry:conditionOtherInfos",
        "path" : "Composition.section.section.entry",
        "sliceName" : "conditionOtherInfos",
        "short" : "Other Conditions",
        "definition" : "Other Conditions",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-otherinfos-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:otherInfos.entry:procedureCVC",
        "path" : "Composition.section.section.entry",
        "sliceName" : "procedureCVC",
        "short" : "Procedure: Catheter",
        "definition" : "Procedure: Catheter",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-cvc-otherinfos-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:otherInfos.entry:procedureTransfusion",
        "path" : "Composition.section.section.entry",
        "sliceName" : "procedureTransfusion",
        "short" : "Procedure: Transfusion",
        "definition" : "Procedure: Transfusion",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-transfusion-otherinfos-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:otherInfos.entry:procedureCryopreservation",
        "path" : "Composition.section.section.entry",
        "sliceName" : "procedureCryopreservation",
        "short" : "Procedure: Cryopreservation",
        "definition" : "Procedure: Cryopreservation",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-cryopreservation-otherinfos-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:otherInfos.entry:procedureOtherTreatment",
        "path" : "Composition.section.section.entry",
        "sliceName" : "procedureOtherTreatment",
        "short" : "Procedure: Other Treatments",
        "definition" : "Procedure: Other Treatments",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-treatment-otherinfos-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:otherInfos.emptyReason",
        "path" : "Composition.section.section.emptyReason",
        "short" : "Why this section is empty"
      },
      {
        "id" : "Composition.section:flt.section:medicalSuggestion",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section",
        "sliceName" : "medicalSuggestion",
        "short" : "Medical Suggestions",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:medicalSuggestion.title",
        "path" : "Composition.section.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:flt.section:medicalSuggestion.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-generic-eu-pcsp",
              "code" : "section-suggestion"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:flt.section:medicalSuggestion.text",
        "path" : "Composition.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:flt.section:medicalSuggestion.emptyReason",
        "path" : "Composition.section.section.emptyReason",
        "short" : "Why this section is empty"
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT",
        "path" : "Composition.section.section",
        "sliceName" : "relapseAfterEOT",
        "short" : "Relapse After EOT",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-generic-eu-pcsp",
              "code" : "section-relapseAfterEOT"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.entry",
        "path" : "Composition.section.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resolve()"
            },
            {
              "type" : "profile",
              "path" : "resolve()"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Tumor FLT detail",
        "definition" : "Entry describing the primary cancer and optionally FLT and metastasis.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Condition",
              "http://hl7.org/fhir/StructureDefinition/Procedure",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.entry:primaryCancer",
        "path" : "Composition.section.section.entry",
        "sliceName" : "primaryCancer",
        "short" : "Relapse",
        "definition" : "Relapse or progression after the end of treatment",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-primaryCancer-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.entry:metastasis",
        "path" : "Composition.section.section.entry",
        "sliceName" : "metastasis",
        "short" : "Metastasis",
        "definition" : "Metastasis",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-secondaryCancer-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section",
        "path" : "Composition.section.section.section",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "code"
            }
          ],
          "description" : "Slice based on the coding.code pattern",
          "rules" : "open"
        },
        "short" : "Chemo, Radio, SCT and other subsections"
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:chemotherapy",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section.section",
        "sliceName" : "chemotherapy",
        "short" : "Chemotherapy",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:chemotherapy.title",
        "path" : "Composition.section.section.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:chemotherapy.code",
        "path" : "Composition.section.section.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "11486-8"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:chemotherapy.text",
        "path" : "Composition.section.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:chemotherapy.entry",
        "path" : "Composition.section.section.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resolve()"
            },
            {
              "type" : "profile",
              "path" : "resolve()"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Chemotherapy",
        "definition" : "Chemotherapy",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/MedicationAdministration",
              "http://hl7.org/fhir/StructureDefinition/MedicationStatement",
              "http://hl7.org/fhir/StructureDefinition/Procedure",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:chemotherapy.entry:medicationAdministration",
        "path" : "Composition.section.section.section.entry",
        "sliceName" : "medicationAdministration",
        "short" : "MedicationAdministration Chemotherapy",
        "definition" : "MedicationAdministration Chemotherapy",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/MedicationAdministration-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:chemotherapy.entry:medicationStatement",
        "path" : "Composition.section.section.section.entry",
        "sliceName" : "medicationStatement",
        "short" : "MedicationStatement: Chemotherapy",
        "definition" : "MedicationStatementChemotherapy",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/MedicationStatement-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:chemotherapy.emptyReason",
        "path" : "Composition.section.section.section.emptyReason",
        "short" : "Why this section is empty"
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:stemCellTransplantation",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section.section",
        "sliceName" : "stemCellTransplantation",
        "short" : "Stem Cell Transplantation",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:stemCellTransplantation.title",
        "path" : "Composition.section.section.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:stemCellTransplantation.code",
        "path" : "Composition.section.section.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-generic-eu-pcsp",
              "code" : "section-sct"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:stemCellTransplantation.text",
        "path" : "Composition.section.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:stemCellTransplantation.entry",
        "path" : "Composition.section.section.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resolve()"
            },
            {
              "type" : "profile",
              "path" : "resolve()"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Stem CelTransplantation",
        "definition" : "Stem Cell Transplantation",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Procedure",
              "http://hl7.org/fhir/StructureDefinition/Condition",
              "http://hl7.org/fhir/StructureDefinition/Observation",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:stemCellTransplantation.entry:sct",
        "path" : "Composition.section.section.section.entry",
        "sliceName" : "sct",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-sct-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:stemCellTransplantation.entry:gvdh-prophylaxis",
        "path" : "Composition.section.section.section.entry",
        "sliceName" : "gvdh-prophylaxis",
        "short" : "GVHD prophylaxis",
        "definition" : "GVHD prophylaxis",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-sct-prophylaxis-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:stemCellTransplantation.entry:gvdh",
        "path" : "Composition.section.section.section.entry",
        "sliceName" : "gvdh",
        "short" : "GvHD",
        "definition" : "Grafversus host disease (GvHD)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-gvhd-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:stemCellTransplantation.entry:blood-abo",
        "path" : "Composition.section.section.section.entry",
        "sliceName" : "blood-abo",
        "short" : "Blootype/RH",
        "definition" : "Blood type/RH",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-bld-abo-rh-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:stemCellTransplantation.emptyReason",
        "path" : "Composition.section.section.section.emptyReason",
        "short" : "Why this section is empty"
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:radiotherapy",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section.section",
        "sliceName" : "radiotherapy",
        "short" : "Radiotherapy",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:radiotherapy.title",
        "path" : "Composition.section.section.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:radiotherapy.code",
        "path" : "Composition.section.section.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-generic-eu-pcsp",
              "code" : "section-rt"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:radiotherapy.text",
        "path" : "Composition.section.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:radiotherapy.entry",
        "path" : "Composition.section.section.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resolve()"
            },
            {
              "type" : "profile",
              "path" : "resolve()"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Radiotherapy",
        "definition" : "Radiotherapy",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Procedure",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:radiotherapy.entry:radiotherapy",
        "path" : "Composition.section.section.section.entry",
        "sliceName" : "radiotherapy",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-radiotheraphy-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:radiotherapy.entry:boost",
        "path" : "Composition.section.section.section.entry",
        "sliceName" : "boost",
        "short" : "Radiotherapy Boost",
        "definition" : "Radiotherapy Boost",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-radiotheraphyBoost-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:radiotherapy.entry:shield",
        "path" : "Composition.section.section.section.entry",
        "sliceName" : "shield",
        "short" : "Radiotherapy Shielding",
        "definition" : "Radiotherapy Shielding",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-radiotheraphyShield-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:radiotherapy.emptyReason",
        "path" : "Composition.section.section.section.emptyReason",
        "short" : "Why this section is empty"
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:majorSurgery",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section.section",
        "sliceName" : "majorSurgery",
        "short" : "History of Surgical procedures",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:majorSurgery.title",
        "path" : "Composition.section.section.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:majorSurgery.code",
        "path" : "Composition.section.section.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "8690-0"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:majorSurgery.text",
        "path" : "Composition.section.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:majorSurgery.entry",
        "path" : "Composition.section.section.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resolve()"
            },
            {
              "type" : "profile",
              "path" : "resolve()"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Major Surgery",
        "definition" : "Major Surgery",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Procedure",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:majorSurgery.entry:procedure",
        "path" : "Composition.section.section.section.entry",
        "sliceName" : "procedure",
        "short" : "Surgical procedure",
        "definition" : "Surgical procedure",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-surgery-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:majorSurgery.emptyReason",
        "path" : "Composition.section.section.section.emptyReason",
        "short" : "Why this section is empty"
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:otherInfos",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section.section",
        "sliceName" : "otherInfos",
        "short" : "Other Medical Information",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:otherInfos.title",
        "path" : "Composition.section.section.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:otherInfos.code",
        "path" : "Composition.section.section.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "55752-0"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:otherInfos.text",
        "path" : "Composition.section.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:otherInfos.entry",
        "path" : "Composition.section.section.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resolve()"
            },
            {
              "type" : "profile",
              "path" : "resolve()"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Other infos",
        "definition" : "Other infos",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Condition",
              "http://hl7.org/fhir/StructureDefinition/Procedure",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:otherInfos.entry:conditionToxicity",
        "path" : "Composition.section.section.section.entry",
        "sliceName" : "conditionToxicity",
        "short" : "Condition: Severe Toxicity",
        "definition" : "Condition: Severe Toxicity",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-toxicity-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:otherInfos.entry:conditionOtherInfos",
        "path" : "Composition.section.section.section.entry",
        "sliceName" : "conditionOtherInfos",
        "short" : "Other Conditions",
        "definition" : "Other Conditions",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-otherinfos-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:otherInfos.entry:procedureCVC",
        "path" : "Composition.section.section.section.entry",
        "sliceName" : "procedureCVC",
        "short" : "Procedure: Catheter",
        "definition" : "Procedure: Catheter",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-cvc-otherinfos-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:otherInfos.entry:procedureTransfusion",
        "path" : "Composition.section.section.section.entry",
        "sliceName" : "procedureTransfusion",
        "short" : "Procedure: Transfusion",
        "definition" : "Procedure: Transfusion",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-transfusion-otherinfos-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:otherInfos.entry:procedureCryopreservation",
        "path" : "Composition.section.section.section.entry",
        "sliceName" : "procedureCryopreservation",
        "short" : "Procedure: Cryopreservation",
        "definition" : "Procedure: Cryopreservation",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-cryopreservation-otherinfos-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:otherInfos.entry:procedureOtherTreatment",
        "path" : "Composition.section.section.section.entry",
        "sliceName" : "procedureOtherTreatment",
        "short" : "Procedure: Other Treatments",
        "definition" : "Procedure: Other Treatments",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-treatment-otherinfos-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:otherInfos.emptyReason",
        "path" : "Composition.section.section.section.emptyReason",
        "short" : "Why this section is empty"
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:medicalSuggestion",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section.section",
        "sliceName" : "medicalSuggestion",
        "short" : "Medical Suggestions",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:medicalSuggestion.title",
        "path" : "Composition.section.section.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:medicalSuggestion.code",
        "path" : "Composition.section.section.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-generic-eu-pcsp",
              "code" : "section-suggestion"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:medicalSuggestion.text",
        "path" : "Composition.section.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:flt.section:relapseAfterEOT.section:medicalSuggestion.emptyReason",
        "path" : "Composition.section.section.section.emptyReason",
        "short" : "Why this section is empty"
      },
      {
        "id" : "Composition.section:flt.section:otherConditions",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section",
        "sliceName" : "otherConditions",
        "short" : "Other Health Conditions",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:flt.section:otherConditions.title",
        "path" : "Composition.section.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:flt.section:otherConditions.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-generic-eu-pcsp",
              "code" : "section-otherConditions"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:flt.section:otherConditions.text",
        "path" : "Composition.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:flt.section:otherConditions.emptyReason",
        "path" : "Composition.section.section.emptyReason",
        "short" : "Why this section is empty"
      },
      {
        "id" : "Composition.section:carePlan",
        "path" : "Composition.section",
        "sliceName" : "carePlan",
        "short" : "Plan of Care Section",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:carePlan.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:carePlan.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "18776-5"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:carePlan.text",
        "path" : "Composition.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:carePlan.entry",
        "path" : "Composition.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resolve()"
            },
            {
              "type" : "profile",
              "path" : "resolve()"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Care Plan",
        "definition" : "Care Plan",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/CarePlan",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:carePlan.entry:carePlan",
        "path" : "Composition.section.entry",
        "sliceName" : "carePlan",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/CarePlan-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:carePlan.emptyReason",
        "path" : "Composition.section.emptyReason",
        "short" : "Why this section is empty"
      }
    ]
  }
}

```
