# Bundle: Survivor Passport - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Bundle: Survivor Passport**

## Resource Profile: Bundle: Survivor Passport 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Bundle-eu-pcsp | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:BundlePcsp |

 
This profile represents the constraints applied to the Bundle resource by the PCSP FHIR Implementation Guide. 

**Usages:**

* Examples for this Profile: [Bundle/54](Bundle-54.md) and [Bundle/BundleHulafe](Bundle-BundleHulafe.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.pcsp|current/StructureDefinition/Bundle-eu-pcsp)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Bundle-eu-pcsp.csv), [Excel](StructureDefinition-Bundle-eu-pcsp.xlsx), [Schematron](StructureDefinition-Bundle-eu-pcsp.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Bundle-eu-pcsp",
  "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Bundle-eu-pcsp",
  "version" : "1.0.0",
  "name" : "BundlePcsp",
  "title" : "Bundle: Survivor Passport",
  "status" : "active",
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "This profile represents the constraints applied to the Bundle resource by the PCSP FHIR Implementation Guide.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Bundle",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Bundle",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Bundle",
        "path" : "Bundle",
        "short" : "Survivorship Passport (SurPass) Bundle",
        "definition" : "Survivorship Passport Bundle. \r\nA container for a collection of resources in the patient summary document.",
        "constraint" : [
          {
            "key" : "bdl-pcsp-1",
            "severity" : "error",
            "human" : "An SarPass document must have no additional Composition (including Composition subclass) resources besides the first.",
            "expression" : "entry.tail().where(resource is Composition).empty()",
            "source" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Bundle-eu-pcsp"
          }
        ]
      },
      {
        "id" : "Bundle.identifier",
        "path" : "Bundle.identifier",
        "min" : 1
      },
      {
        "id" : "Bundle.type",
        "path" : "Bundle.type",
        "fixedCode" : "document"
      },
      {
        "id" : "Bundle.timestamp",
        "path" : "Bundle.timestamp",
        "min" : 1
      },
      {
        "id" : "Bundle.link",
        "path" : "Bundle.link",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry",
        "path" : "Bundle.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resource"
            },
            {
              "type" : "profile",
              "path" : "resource"
            }
          ],
          "rules" : "open"
        },
        "short" : "Entry resource in the SurPass bundle",
        "definition" : "An entry resource included in the surpass document bundle resource. ",
        "comment" : "Must contain the PCSP Composition as the first entry (only a single Composition resource instance may be included).  Additional constraints are specified in the PCSP Composition profile.",
        "min" : 3
      },
      {
        "id" : "Bundle.entry.fullUrl",
        "path" : "Bundle.entry.fullUrl",
        "min" : 1
      },
      {
        "id" : "Bundle.entry.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1
      },
      {
        "id" : "Bundle.entry.search",
        "path" : "Bundle.entry.search",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry.request",
        "path" : "Bundle.entry.request",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry.response",
        "path" : "Bundle.entry.response",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry:composition",
        "path" : "Bundle.entry",
        "sliceName" : "composition",
        "short" : "PCSP Composition",
        "definition" : "PCSP Composition",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Bundle.entry:composition.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Composition",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Composition-surpass-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:patient",
        "path" : "Bundle.entry",
        "sliceName" : "patient",
        "short" : "Patient: PCSP",
        "definition" : "Patient: PCSP",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Bundle.entry:patient.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Patient",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Patient-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:flt-def",
        "path" : "Bundle.entry",
        "sliceName" : "flt-def",
        "short" : "PlanDefinition: FLT",
        "definition" : "PlanDefinition: Front Line Treatment",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:flt-def.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "PlanDefinition",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/PlanDefinition-flt-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:flt",
        "path" : "Bundle.entry",
        "sliceName" : "flt",
        "short" : "Procedure: FLT",
        "definition" : "Procedure: FronLine Treatment",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:flt.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Procedure",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-flt-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:cancerCondition",
        "path" : "Bundle.entry",
        "sliceName" : "cancerCondition",
        "short" : "Primary Cancer, Relapse and Metastasis",
        "definition" : "Primary Cancer, Relapse and Metastasis",
        "min" : 1,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:cancerCondition.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Condition",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-primaryCancer-eu-pcsp",
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-secondaryCancer-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:observationDiagnosis",
        "path" : "Bundle.entry",
        "sliceName" : "observationDiagnosis",
        "short" : "Observation: Diagnosis details",
        "definition" : "Observation: Diagnosis details",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:observationDiagnosis.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Observation",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-diagnosis-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:observationHereditaryPredisposition",
        "path" : "Bundle.entry",
        "sliceName" : "observationHereditaryPredisposition",
        "short" : "Observation: Hereditary Predisposition",
        "definition" : "Observation: Hereditary Predisposition",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:observationHereditaryPredisposition.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Observation",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-predisposition-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:cancerStageGroup",
        "path" : "Bundle.entry",
        "sliceName" : "cancerStageGroup",
        "short" : "Observation: Cancer Stage Group",
        "definition" : "Observation: Cancer Stage Group",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:cancerStageGroup.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Observation",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/mcode-cancer-stage-group"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:encounter",
        "path" : "Bundle.entry",
        "sliceName" : "encounter",
        "short" : "Encounter: Treatment Center",
        "definition" : "Encounter: Treatment Center",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:encounter.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Encounter",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Encounter-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:location",
        "path" : "Bundle.entry",
        "sliceName" : "location",
        "short" : "Location: PCSP",
        "definition" : "Location: PCSP",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:location.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Location",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Location-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:organization",
        "path" : "Bundle.entry",
        "sliceName" : "organization",
        "short" : "Organization: Primary Center",
        "definition" : "Organization: Primary Treatment Center / Center of diagnosis",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:organization.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Organization",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Organization-center-eu-pcsp",
              "http://hl7.org/fhir/StructureDefinition/Organization"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:radiotherapy",
        "path" : "Bundle.entry",
        "sliceName" : "radiotherapy",
        "short" : "Procedure: Radiotherapy",
        "definition" : "Procedure: Radiotherapy",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:radiotherapy.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Procedure",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-radiotheraphy-eu-pcsp",
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-radiotheraphyBoost-eu-pcsp",
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-radiotheraphyShield-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:totalDoseRadio",
        "path" : "Bundle.entry",
        "sliceName" : "totalDoseRadio",
        "short" : "Observation: Radiotherapy Total Dose",
        "definition" : "Observation: Radiotherapy Total Dose",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:totalDoseRadio.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Observation",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-totalDoseRad-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:majorSurgery",
        "path" : "Bundle.entry",
        "sliceName" : "majorSurgery",
        "short" : "Procedure: Surgery",
        "definition" : "Procedure: Surgery",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:majorSurgery.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Procedure",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-surgery-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:carePlan",
        "path" : "Bundle.entry",
        "sliceName" : "carePlan",
        "short" : "CarePlan: PCSP-generated plan",
        "definition" : "CarePlan: PCSP-generated plan",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:carePlan.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "CarePlan",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/CarePlan-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:riskFactor",
        "path" : "Bundle.entry",
        "sliceName" : "riskFactor",
        "short" : "Observation: Risk Factor",
        "definition" : "Observation: Risk Factor",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:riskFactor.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Observation",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-riskfactor-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:biologicallyDerivedProduct",
        "path" : "Bundle.entry",
        "sliceName" : "biologicallyDerivedProduct",
        "short" : "BiologicallyDerivedProduct: Stem Cell",
        "definition" : "BiologicallyDerivedProduct: Stem Cell",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:biologicallyDerivedProduct.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "BiologicallyDerivedProduct",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/BiologicallyDerivedProduct-sct-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:stemCellTransplantation",
        "path" : "Bundle.entry",
        "sliceName" : "stemCellTransplantation",
        "short" : "Procedure: Stem Cell Transplantation",
        "definition" : "Procedure: Stem Cell Transplantation",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:stemCellTransplantation.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Procedure",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-sct-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:bloodAboRh",
        "path" : "Bundle.entry",
        "sliceName" : "bloodAboRh",
        "short" : "Observation: Blood type/RH",
        "definition" : "Observation: Blood type/RH",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:bloodAboRh.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Observation",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-bld-abo-rh-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:gvhd",
        "path" : "Bundle.entry",
        "sliceName" : "gvhd",
        "short" : "Condition: GvHD",
        "definition" : "Condition: GvHD",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:gvhd.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Condition",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-gvhd-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:gvhd-prophylaxis",
        "path" : "Bundle.entry",
        "sliceName" : "gvhd-prophylaxis",
        "short" : "Procedure: SCT Prophylaxis",
        "definition" : "Procedure: SCT Prophylaxis",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:gvhd-prophylaxis.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Procedure",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-sct-prophylaxis-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:medAdminChemo",
        "path" : "Bundle.entry",
        "sliceName" : "medAdminChemo",
        "short" : "MedicationAdministration: Chemotherapy",
        "definition" : "MedicationAdministration: Chemotherapy",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:medAdminChemo.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "MedicationAdministration",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/MedicationAdministration-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:medStatementChemo",
        "path" : "Bundle.entry",
        "sliceName" : "medStatementChemo",
        "short" : "MedicationStatement: Chemotherapy",
        "definition" : "MedicationStatement: Chemotherapy",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:medStatementChemo.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "MedicationStatement",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/MedicationStatement-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:cumulativeDoseChemo",
        "path" : "Bundle.entry",
        "sliceName" : "cumulativeDoseChemo",
        "short" : "Observation: Chemotherapy Cumulative Dose",
        "definition" : "Observation: Chemotherapy Cumulative Dose",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:cumulativeDoseChemo.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Observation",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-cumulativeDoseChemo-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:conditionToxicity",
        "path" : "Bundle.entry",
        "sliceName" : "conditionToxicity",
        "short" : "Condition: Severe Toxicity",
        "definition" : "Condition: Severe Toxicity",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:conditionToxicity.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Condition",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-toxicity-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:conditionOtherInfos",
        "path" : "Bundle.entry",
        "sliceName" : "conditionOtherInfos",
        "short" : "Other Conditions",
        "definition" : "Other Conditions",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:conditionOtherInfos.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Condition",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-otherinfos-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:procedureCVC",
        "path" : "Bundle.entry",
        "sliceName" : "procedureCVC",
        "short" : "Procedure: Catheter",
        "definition" : "Procedure: Catheter",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:procedureCVC.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Procedure",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-cvc-otherinfos-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:procedureTransfusion",
        "path" : "Bundle.entry",
        "sliceName" : "procedureTransfusion",
        "short" : "Procedure: Transfusion",
        "definition" : "Procedure: Transfusion",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:procedureTransfusion.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Procedure",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-transfusion-otherinfos-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:procedureCryopreservation",
        "path" : "Bundle.entry",
        "sliceName" : "procedureCryopreservation",
        "short" : "Procedure: Cryopreservation",
        "definition" : "Procedure: Cryopreservation",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:procedureCryopreservation.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Procedure",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-cryopreservation-otherinfos-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:procedureOtherTreatment",
        "path" : "Bundle.entry",
        "sliceName" : "procedureOtherTreatment",
        "short" : "Procedure: Other Treatments",
        "definition" : "Procedure: Other Treatments",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:procedureOtherTreatment.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Procedure",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-treatment-otherinfos-eu-pcsp"
            ]
          }
        ]
      }
    ]
  }
}

```
