# Mainz - Procedure: Radiotherapy (Zeisig) - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Mainz - Procedure: Radiotherapy (Zeisig)**

## Example Procedure: Mainz - Procedure: Radiotherapy (Zeisig)

Profile: [Procedure: Radiotherapy](StructureDefinition-Procedure-radiotheraphy-eu-pcsp.md)

**Resource related information**: [Observation Total boost radiation dose delivered](Observation-ObservationRadTotalDose-1.md)

**status**: Completed

**category**: Radiotherapy

**code**: Radionuclide therapy

**subject**: [Sarah Zeisig Female, DoB: 1996-12-12 ( http://hl7.eu/fhir/ig/pcsp/sid/pat-id-mainz#L0010)](Patient-PatientMainzZeisig.md)

**performed**: 2017-03-06 00:00:00+0100 --> (ongoing)

**location**: [Location Universitätsklinikum Schleswig-Holstein - Campus Lübeck](Location-Location-SCT1.md)

**reasonReference**: [Condition Leukemias, myeloproliferative diseases, and myelodysplastic diseases](Condition-ConditionPrimCancerMainzZeisig.md)

**bodySite**: Brain: Occipital lobe



## Resource Content

```json
{
  "resourceType" : "Procedure",
  "id" : "ProcedureRadio-1",
  "meta" : {
    "profile" : [
      "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-radiotheraphy-eu-pcsp"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/resource-relatedInfo",
      "valueReference" : {
        "reference" : "Observation/ObservationRadTotalDose-1"
      }
    }
  ],
  "status" : "completed",
  "category" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "108290001",
        "display" : "Radiotherapy"
      }
    ]
  },
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "399315003",
        "display" : "Radionuclide therapy"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/PatientMainzZeisig"
  },
  "performedPeriod" : {
    "start" : "2017-03-06T00:00:00+01:00"
  },
  "location" : {
    "reference" : "Location/Location-SCT1"
  },
  "reasonReference" : [
    {
      "reference" : "Condition/ConditionPrimCancerMainzZeisig"
    }
  ],
  "bodySite" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-radiotherapy-pcsp",
          "code" : "1.4",
          "display" : "Brain: Occipital lobe"
        }
      ]
    }
  ]
}

```
