# Hulafe - Patient: Sample of Patient (Basoa Mancebo) - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Hulafe - Patient: Sample of Patient (Basoa Mancebo)**

## Example Patient: Hulafe - Patient: Sample of Patient (Basoa Mancebo)

Profile: [Patient: PCSP](StructureDefinition-Patient-eu-pcsp.md)

Urbano BASOA MANCEBO Male, DoB: 2014-05-14 ( http://hl7.eu/fhir/ig/pcsp/sid/pat-id-hulafe#04969377)

-------

| | |
| :--- | :--- |
| Parent: | * [tattedblackchick@gmail.com](mailto:tattedblackchick@gmail.com)
* ph: 990778314
 |
| [Patient Birth Place](http://hl7.org/fhir/extensions/5.2.0/StructureDefinition-patient-birthPlace.html) | Abrantes 46181 Portugal |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "PatientHulafe",
  "meta" : {
    "profile" : [
      "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Patient-eu-pcsp"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/patient-birthPlace",
      "valueAddress" : {
        "city" : "Abrantes",
        "postalCode" : "46181",
        "country" : "Portugal"
      }
    }
  ],
  "identifier" : [
    {
      "system" : "http://hl7.eu/fhir/ig/pcsp/sid/pat-id-hulafe",
      "value" : "04969377"
    }
  ],
  "name" : [
    {
      "family" : "BASOA MANCEBO",
      "given" : ["Urbano"]
    }
  ],
  "gender" : "male",
  "birthDate" : "2014-05-14",
  "contact" : [
    {
      "relationship" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
              "code" : "PRN",
              "display" : "Parent"
            }
          ]
        }
      ],
      "telecom" : [
        {
          "system" : "email",
          "value" : "tattedblackchick@gmail.com"
        },
        {
          "system" : "phone",
          "value" : "990778314"
        }
      ]
    }
  ]
}

```
