# Mainz - Observation: Primary Cancer (Zeisig) - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Mainz - Observation: Primary Cancer (Zeisig)**

## Example Observation: Mainz - Observation: Primary Cancer (Zeisig)

Profile: [Observation: Diagnosis details](StructureDefinition-Observation-diagnosis-eu-pcsp.md)

**status**: Final

**code**: Diagnosis

**subject**: [Sarah Zeisig Female, DoB: 1996-12-12 ( http://hl7.eu/fhir/ig/pcsp/sid/pat-id-mainz#L0010)](Patient-PatientMainzZeisig.md)

**effective**: 2007-04-04

**performer**: UKE Hamburg (Identifier: `http://hl7.eu/fhir/ig/pcsp/sid/org-id-mainz`/52)

**value**: Leukemias, myeloproliferative diseases, and myelodysplastic diseases



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "ObservationPrimCancerMainzZeisig",
  "meta" : {
    "profile" : [
      "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-diagnosis-eu-pcsp"
    ]
  },
  "status" : "final",
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "29308-4",
        "display" : "Diagnosis"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/PatientMainzZeisig"
  },
  "effectiveDateTime" : "2007-04-04",
  "performer" : [
    {
      "identifier" : {
        "system" : "http://hl7.eu/fhir/ig/pcsp/sid/org-id-mainz",
        "value" : "52"
      },
      "display" : "UKE Hamburg"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/iccc-3",
        "code" : "081"
      },
      {
        "system" : "http://hl7.org/fhir/sid/icd-10",
        "code" : "C41.9"
      }
    ]
  }
}

```
