# International Classification of Childhood Cancer, Third Edition - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **International Classification of Childhood Cancer, Third Edition**

## CodeSystem: International Classification of Childhood Cancer, Third Edition (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/iccc-3 | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:ICCC_3 |

 
The International Classification of Childhood Cancer, Third Edition (ICCC-3) is a classification system used to categorize childhood cancers based on their histology and primary site. It is widely used in pediatric oncology for epidemiological studies and clinical research. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ICCC3Vs](ValueSet-vs-iccc3-eu-pcsp.md)

This case-sensitive code system `http://terminology.hl7.org/CodeSystem/iccc-3` provides **a fragment** that includes following code:



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "iccc-3",
  "url" : "http://terminology.hl7.org/CodeSystem/iccc-3",
  "version" : "1.0.0",
  "name" : "ICCC_3",
  "title" : "International Classification of Childhood Cancer, Third Edition",
  "status" : "active",
  "experimental" : true,
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "The International Classification of Childhood Cancer, Third Edition (ICCC-3) is a classification system used to categorize childhood cancers based on their histology and primary site. It is widely used in pediatric oncology for epidemiological studies and clinical research.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "caseSensitive" : true,
  "content" : "fragment",
  "concept" : [
    {
      "code" : "081",
      "display" : "Leukemias, myeloproliferative diseases, and myelodysplastic diseases"
    }
  ]
}

```
