# Conditions - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Conditions**

## CodeSystem: Conditions 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:ConditionsCS |

 
PancareSurPass Conditions Code System 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ConditionsVS](ValueSet-cond-test-vs.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "ConditionsCS",
  "url" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/ConditionsCS",
  "version" : "1.0.0",
  "name" : "ConditionsCS",
  "title" : "Conditions",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "PancareSurPass Conditions Code System",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "caseSensitive" : true,
  "content" : "complete",
  "concept" : [
    {
      "code" : "1001,04",
      "display" : "Auditory system - Ear - Hearing Impairment (Adults, with subsequent tests available)"
    },
    {
      "code" : "1001,05",
      "display" : "Auditory system - Ear - Hearing Impairment (Adults, without subsequent tests available)"
    },
    {
      "code" : "1001,01",
      "display" : "Auditory system - Ear - Hearing Impairment (Children)"
    },
    {
      "code" : "1001,02",
      "display" : "Auditory system - Ear - Tinnitus"
    },
    {
      "code" : "1001,03",
      "display" : "Auditory system - Ear - Vertigo"
    },
    {
      "code" : "1001,99",
      "display" : "Auditory system - Ear - Other"
    },
    {
      "code" : "2001,01",
      "display" : "Cardiovascular system (excluding cerebrovascular disorder) - Heart - Left ventricular systolic dysfunction"
    },
    {
      "code" : "2001,02",
      "display" : "Cardiovascular system (excluding cerebrovascular disorder) - Heart - Coronary artery disease"
    },
    {
      "code" : "2001,03",
      "display" : "Cardiovascular system (excluding cerebrovascular disorder) - Heart - Bradycardia, sinus"
    },
    {
      "code" : "2001,04",
      "display" : "Cardiovascular system (excluding cerebrovascular disorder) - Heart - Tachycardia sinus"
    },
    {
      "code" : "2001,05",
      "display" : "Cardiovascular system (excluding cerebrovascular disorder) - Heart - Atrio-ventricular Heart Block"
    },
    {
      "code" : "2001,06",
      "display" : "Cardiovascular system (excluding cerebrovascular disorder) - Heart - Conduction abnormalities"
    },
    {
      "code" : "2001,07",
      "display" : "Cardiovascular system (excluding cerebrovascular disorder) - Heart - Prolonged QT corrected (QTc) interval"
    },
    {
      "code" : "2001,98",
      "display" : "Cardiovascular system (excluding cerebrovascular disorder) - Heart - Other Cardiac dysrhythmia"
    },
    {
      "code" : "2001,12",
      "display" : "Cardiovascular system (excluding cerebrovascular disorder) - Heart - Congestive heart failure (Adults)"
    },
    {
      "code" : "2001,09",
      "display" : "Cardiovascular system (excluding cerebrovascular disorder) - Heart - Congestive heart failure (Children - modified NYHA/Ross Classification)"
    },
    {
      "code" : "2001,1",
      "display" : "Cardiovascular system (excluding cerebrovascular disorder) - Heart - Cor pulmonare (right heart failure)"
    },
    {
      "code" : "2001,11",
      "display" : "Cardiovascular system (excluding cerebrovascular disorder) - Heart - Valvular heart disease"
    },
    {
      "code" : "2001,99",
      "display" : "Cardiovascular system (excluding cerebrovascular disorder) - Heart - Other"
    },
    {
      "code" : "2002,01",
      "display" : "Cardiovascular system (excluding cerebrovascular disorder) - Pericardium - Pericardial disease (not infective and autoimmune)"
    },
    {
      "code" : "2002,99",
      "display" : "Cardiovascular system (excluding cerebrovascular disorder) - Pericardium - Other"
    },
    {
      "code" : "2003,08",
      "display" : "Cardiovascular system (excluding cerebrovascular disorder) - Vessels - Hypertension (systemic) - Adults"
    },
    {
      "code" : "2003,01",
      "display" : "Cardiovascular system (excluding cerebrovascular disorder) - Vessels - Hypertension (systemic) - Children"
    },
    {
      "code" : "2003,02",
      "display" : "Cardiovascular system (excluding cerebrovascular disorder) - Vessels - Pulmonary hypertension"
    },
    {
      "code" : "2003,03",
      "display" : "Cardiovascular system (excluding cerebrovascular disorder) - Vessels - Aortic root aneurysm"
    },
    {
      "code" : "2003,04",
      "display" : "Cardiovascular system (excluding cerebrovascular disorder) - Vessels - Vascular disease"
    },
    {
      "code" : "2003,05",
      "display" : "Cardiovascular system (excluding cerebrovascular disorder) - Vessels - Arterio-venus malformation"
    },
    {
      "code" : "2003,06",
      "display" : "Cardiovascular system (excluding cerebrovascular disorder) - Vessels - Thrombus"
    },
    {
      "code" : "2003,07",
      "display" : "Cardiovascular system (excluding cerebrovascular disorder) - Vessels - Capillary leak syndrome"
    },
    {
      "code" : "2003,99",
      "display" : "Cardiovascular system (excluding cerebrovascular disorder) - Vessels - Other"
    },
    {
      "code" : "3001,01",
      "display" : "Lymphatic system - Lymphatic vessels - Lymphedema"
    },
    {
      "code" : "3001,99",
      "display" : "Lymphatic system - Lymphatic vessels - Other"
    },
    {
      "code" : "4001,01",
      "display" : "Central and peripheral nervous system - Cerebrovascular - Transient ischemic attack"
    },
    {
      "code" : "4001,02",
      "display" : "Central and peripheral nervous system - Cerebrovascular - Cerebrovascular accident/stroke"
    },
    {
      "code" : "4001,03",
      "display" : "Central and peripheral nervous system - Cerebrovascular - Cerebrovascular disease"
    },
    {
      "code" : "4001,04",
      "display" : "Central and peripheral nervous system - Cerebrovascular - Aneurysms"
    },
    {
      "code" : "4001,05",
      "display" : "Central and peripheral nervous system - Cerebrovascular - Cavernoma"
    },
    {
      "code" : "4001,99",
      "display" : "Central and peripheral nervous system - Cerebrovascular - Other"
    },
    {
      "code" : "4002,01",
      "display" : "Central and peripheral nervous system - Brain - Seizures"
    },
    {
      "code" : "4002,02",
      "display" : "Central and peripheral nervous system - Brain - Leucoencephalopathy"
    },
    {
      "code" : "4002,03",
      "display" : "Central and peripheral nervous system - Brain - Headaches, chronic/ recurrent"
    },
    {
      "code" : "4002,04",
      "display" : "Central and peripheral nervous system - Brain - Dementia"
    },
    {
      "code" : "4002,05",
      "display" : "Central and peripheral nervous system - Brain - Cerebellar disorder"
    },
    {
      "code" : "4002,99",
      "display" : "Central and peripheral nervous system - Brain - Other"
    },
    {
      "code" : "4003,01",
      "display" : "Central and peripheral nervous system - Spinal cord and nerves - Paralytic disorder"
    },
    {
      "code" : "4003,02",
      "display" : "Central and peripheral nervous system - Spinal cord and nerves - Cranial nerve disorder"
    },
    {
      "code" : "4003,03",
      "display" : "Central and peripheral nervous system - Spinal cord and nerves - Sensory peripheral neuropathy"
    },
    {
      "code" : "4003,04",
      "display" : "Central and peripheral nervous system - Spinal cord and nerves - Motor peripheral neuropathy"
    },
    {
      "code" : "4003,05",
      "display" : "Central and peripheral nervous system - Spinal cord and nerves - Autonomic nervous system dysfunction"
    },
    {
      "code" : "4003,06",
      "display" : "Central and peripheral nervous system - Spinal cord and nerves - Neurogenic bowel"
    },
    {
      "code" : "4003,07",
      "display" : "Central and peripheral nervous system - Spinal cord and nerves - Neurogenic bladder"
    },
    {
      "code" : "4003,99",
      "display" : "Central and peripheral nervous system - Spinal cord and nerves - Other"
    },
    {
      "code" : "5001,01",
      "display" : "Neuro-psychiatric system - Neurocognitive problems - Attention impaired"
    },
    {
      "code" : "5001,02",
      "display" : "Neuro-psychiatric system - Neurocognitive problems - Memory impairment"
    },
    {
      "code" : "5001,03",
      "display" : "Neuro-psychiatric system - Neurocognitive problems - Processing speed impairment"
    },
    {
      "code" : "5001,04",
      "display" : "Neuro-psychiatric system - Neurocognitive problems - Intelligence impairment"
    },
    {
      "code" : "5001,05",
      "display" : "Neuro-psychiatric system - Neurocognitive problems - Executive function impairment"
    },
    {
      "code" : "5001,06",
      "display" : "Neuro-psychiatric system - Neurocognitive problems - Fine-motor dexterity deficit"
    },
    {
      "code" : "5001,99",
      "display" : "Neuro-psychiatric system - Neurocognitive problems - Other"
    },
    {
      "code" : "5002,01",
      "display" : "Neuro-psychiatric system - Psychosocial problems - Depression"
    },
    {
      "code" : "5002,02",
      "display" : "Neuro-psychiatric system - Psychosocial problems - Fatigue, chronic"
    },
    {
      "code" : "5002,03",
      "display" : "Neuro-psychiatric system - Psychosocial problems - Anxiety"
    },
    {
      "code" : "5002,04",
      "display" : "Neuro-psychiatric system - Psychosocial problems - Post-traumatic stress"
    },
    {
      "code" : "5002,98",
      "display" : "Neuro-psychiatric system - Psychosocial problems - Other psychiatric disorders"
    },
    {
      "code" : "5002,06",
      "display" : "Neuro-psychiatric system - Psychosocial problems - Oppositionality - Children only"
    },
    {
      "code" : "5002,07",
      "display" : "Neuro-psychiatric system - Psychosocial problems - Hyperactivity - Children only"
    },
    {
      "code" : "5002,08",
      "display" : "Neuro-psychiatric system - Psychosocial problems - Insomnia"
    },
    {
      "code" : "5002,99",
      "display" : "Neuro-psychiatric system - Psychosocial problems - Other"
    },
    {
      "code" : "5003,01",
      "display" : "Neuro-psychiatric system - Eating disorders - Bulimia/anorexia/binge eating disorder"
    },
    {
      "code" : "5003,99",
      "display" : "Neuro-psychiatric system - Eating disorders - Other"
    },
    {
      "code" : "6001,01",
      "display" : "Musculoskeletal system - Skull - Craniofacial growth problems"
    },
    {
      "code" : "6001,99",
      "display" : "Musculoskeletal system - Skull - Other"
    },
    {
      "code" : "6002,01",
      "display" : "Musculoskeletal system - Bone - Amputation"
    },
    {
      "code" : "6002,02",
      "display" : "Musculoskeletal system - Bone - Prosthetic malfunction"
    },
    {
      "code" : "6002,06",
      "display" : "Musculoskeletal system - Bone - Reduced bone mineral density (Adults)"
    },
    {
      "code" : "6002,03",
      "display" : "Musculoskeletal system - Bone - Reduced bone mineral density (Pediatric)"
    },
    {
      "code" : "6002,04",
      "display" : "Musculoskeletal system - Bone - Osteonecrosis"
    },
    {
      "code" : "6002,05",
      "display" : "Musculoskeletal system - Bone - Exostosis"
    },
    {
      "code" : "6002,99",
      "display" : "Musculoskeletal system - Bone - Other"
    },
    {
      "code" : "6003,01",
      "display" : "Musculoskeletal system - Joints - Arthritis"
    },
    {
      "code" : "6003,02",
      "display" : "Musculoskeletal system - Joints - Arthralgia"
    },
    {
      "code" : "6003,99",
      "display" : "Musculoskeletal system - Joints - Other"
    },
    {
      "code" : "6004,01",
      "display" : "Musculoskeletal system - Spine - Scoliosis"
    },
    {
      "code" : "6004,02",
      "display" : "Musculoskeletal system - Spine - Kyphosis/Lordosis"
    },
    {
      "code" : "6004,03",
      "display" : "Musculoskeletal system - Spine - Intervertebral disc disorder"
    },
    {
      "code" : "6004,99",
      "display" : "Musculoskeletal system - Spine - Other"
    },
    {
      "code" : "6005,01",
      "display" : "Musculoskeletal system - Muscle/Skeleton - Musculoskeletal deformity"
    },
    {
      "code" : "6005,99",
      "display" : "Musculoskeletal system - Muscle/Skeleton - Other"
    },
    {
      "code" : "6006,01",
      "display" : "Musculoskeletal system - Extremities - Limb length discrepancy"
    },
    {
      "code" : "6006,99",
      "display" : "Musculoskeletal system - Extremities - Other"
    },
    {
      "code" : "7001,01",
      "display" : "Integumentary system (skin, subcutaneous, breast) - Hair - Alopecia"
    },
    {
      "code" : "7001,99",
      "display" : "Integumentary system (skin, subcutaneous, breast) - Hair - Other"
    },
    {
      "code" : "7002,01",
      "display" : "Integumentary system (skin, subcutaneous, breast) - Skin - Skin and subcutaneous tissue disorders"
    },
    {
      "code" : "7002,99",
      "display" : "Integumentary system (skin, subcutaneous, breast) - Skin - Other"
    },
    {
      "code" : "7003,01",
      "display" : "Integumentary system (skin, subcutaneous, breast) - Breast - Breast hypoplasia"
    },
    {
      "code" : "7003,99",
      "display" : "Integumentary system (skin, subcutaneous, breast) - Breast - Other"
    },
    {
      "code" : "8001,01",
      "display" : "Gastrointestinal system - Mouth - Dental developmental problems"
    },
    {
      "code" : "8001,02",
      "display" : "Gastrointestinal system - Mouth - Xerostomia"
    },
    {
      "code" : "8001,03",
      "display" : "Gastrointestinal system - Mouth - Oral lesions"
    },
    {
      "code" : "8001,99",
      "display" : "Gastrointestinal system - Mouth - Other"
    },
    {
      "code" : "8002,01",
      "display" : "Gastrointestinal system - Esophagus - Esophageal varices"
    },
    {
      "code" : "8002,02",
      "display" : "Gastrointestinal system - Esophagus - Gastro esophageal reflux disease"
    },
    {
      "code" : "8002,99",
      "display" : "Gastrointestinal system - Esophagus - Other"
    },
    {
      "code" : "8003,01",
      "display" : "Gastrointestinal system - Gastrointestinal tract - Gastritis"
    },
    {
      "code" : "8003,02",
      "display" : "Gastrointestinal system - Gastrointestinal tract - Gastrointestinal obstruction"
    },
    {
      "code" : "8003,03",
      "display" : "Gastrointestinal system - Gastrointestinal tract - Gastrointestinal fistula"
    },
    {
      "code" : "8003,04",
      "display" : "Gastrointestinal system - Gastrointestinal tract - Gastrointestinal ulcer"
    },
    {
      "code" : "8003,99",
      "display" : "Gastrointestinal system - Gastrointestinal tract - Other"
    },
    {
      "code" : "8004,01",
      "display" : "Gastrointestinal system - Bowel - Malabsorption syndrome"
    },
    {
      "code" : "8004,02",
      "display" : "Gastrointestinal system - Bowel - Bowel perforation"
    },
    {
      "code" : "8004,03",
      "display" : "Gastrointestinal system - Bowel - Enterocolitis"
    },
    {
      "code" : "8004,04",
      "display" : "Gastrointestinal system - Bowel - Fecal incontinence"
    },
    {
      "code" : "8004,05",
      "display" : "Gastrointestinal system - Bowel - Constipation"
    },
    {
      "code" : "8004,06",
      "display" : "Gastrointestinal system - Bowel - Abdominal pain (chronic)"
    },
    {
      "code" : "8004,07",
      "display" : "Gastrointestinal system - Bowel - Intestinal surgery"
    },
    {
      "code" : "8004,99",
      "display" : "Gastrointestinal system - Bowel - Other"
    },
    {
      "code" : "8005,01",
      "display" : "Gastrointestinal system - Pancreas - Pancreatic insufficiency"
    },
    {
      "code" : "8005,99",
      "display" : "Gastrointestinal system - Pancreas - Other"
    },
    {
      "code" : "9001,01",
      "display" : "Hepato/biliary system - Biliary tract - Cholelithiasis"
    },
    {
      "code" : "9001,02",
      "display" : "Hepato/biliary system - Biliary tract - Cholecystectomy"
    },
    {
      "code" : "9001,99",
      "display" : "Hepato/biliary system - Biliary tract - Other"
    },
    {
      "code" : "9002,01",
      "display" : "Hepato/biliary system - Liver - Liver fibrosis/cirrhosis"
    },
    {
      "code" : "9002,02",
      "display" : "Hepato/biliary system - Liver - Hypertransaminasemia"
    },
    {
      "code" : "9002,03",
      "display" : "Hepato/biliary system - Liver - Hepatic failure"
    },
    {
      "code" : "9002,04",
      "display" : "Hepato/biliary system - Liver - Hepatic nodular lesions"
    },
    {
      "code" : "9002,05",
      "display" : "Hepato/biliary system - Liver - Hepatic surgery"
    },
    {
      "code" : "9002,98",
      "display" : "Hepato/biliary system - Liver - Other Hepatobiliary disorders, specify"
    },
    {
      "code" : "9002,99",
      "display" : "Hepato/biliary system - Liver - Other"
    },
    {
      "code" : "10001,01",
      "display" : "Immunology and infectious - Immunologic disorders - Immune deficiencies"
    },
    {
      "code" : "10001,02",
      "display" : "Immunology and infectious - Immunologic disorders - Auto-immune diseases"
    },
    {
      "code" : "10001,03",
      "display" : "Immunology and infectious - Immunologic disorders - Graft-versus-host disease"
    },
    {
      "code" : "10001,04",
      "display" : "Immunology and infectious - Immunologic disorders - Allergic reaction"
    },
    {
      "code" : "10001,99",
      "display" : "Immunology and infectious - Immunologic disorders - Other"
    },
    {
      "code" : "10002,01",
      "display" : "Immunology and infectious - Infection - Sepsis"
    },
    {
      "code" : "10002,02",
      "display" : "Immunology and infectious - Infection - Pericarditis (infectious)"
    },
    {
      "code" : "10002,03",
      "display" : "Immunology and infectious - Infection - Genitourinary infection"
    },
    {
      "code" : "10002,04",
      "display" : "Immunology and infectious - Infection - HBV Chronic"
    },
    {
      "code" : "10002,05",
      "display" : "Immunology and infectious - Infection - HCV Chronic"
    },
    {
      "code" : "10002,06",
      "display" : "Immunology and infectious - Infection - HIV"
    },
    {
      "code" : "10002,07",
      "display" : "Immunology and infectious - Infection - Infections and infestations"
    },
    {
      "code" : "10002,99",
      "display" : "Immunology and infectious - Infection - Other"
    },
    {
      "code" : "11001,01",
      "display" : "Hematopoietic system - Blood - Coagulopathy"
    },
    {
      "code" : "11001,02",
      "display" : "Hematopoietic system - Blood - Iron overload"
    },
    {
      "code" : "11001,03",
      "display" : "Hematopoietic system - Blood - Anemia"
    },
    {
      "code" : "11001,04",
      "display" : "Hematopoietic system - Blood - Neutropenia"
    },
    {
      "code" : "11001,05",
      "display" : "Hematopoietic system - Blood - Thrombocytopenia"
    },
    {
      "code" : "11001,06",
      "display" : "Hematopoietic system - Blood - Polycythemia"
    },
    {
      "code" : "11001,07",
      "display" : "Hematopoietic system - Blood - Thrombocytosis"
    },
    {
      "code" : "11001,99",
      "display" : "Hematopoietic system - Blood - Other"
    },
    {
      "code" : "11002,01",
      "display" : "Hematopoietic system - Spleen - Spleen disorder"
    },
    {
      "code" : "11002,99",
      "display" : "Hematopoietic system - Spleen - Other"
    },
    {
      "code" : "12001,01",
      "display" : "Respiratory system - Lung - Obstructive ventilatory defect"
    },
    {
      "code" : "12001,02",
      "display" : "Respiratory system - Lung - Pulmonary restrictive disease"
    },
    {
      "code" : "12001,03",
      "display" : "Respiratory system - Lung - Pulmonary diffusion defect"
    },
    {
      "code" : "12001,04",
      "display" : "Respiratory system - Lung - Lung surgery"
    },
    {
      "code" : "12001,99",
      "display" : "Respiratory system - Lung - Other"
    },
    {
      "code" : "13001,01",
      "display" : "Urinary system - Kidney - Chronic kidney disease (glomerular-tubular-vascular)"
    },
    {
      "code" : "13001,02",
      "display" : "Urinary system - Kidney - Hydronephrosis"
    },
    {
      "code" : "13001,03",
      "display" : "Urinary system - Kidney - Nephrectomy"
    },
    {
      "code" : "13001,99",
      "display" : "Urinary system - Kidney - Other"
    },
    {
      "code" : "13002,01",
      "display" : "Urinary system - Urinary tract - Urinary tract calculi (stones)"
    },
    {
      "code" : "13002,02",
      "display" : "Urinary system - Urinary tract - Vesico-ureteral reflux (acquired)"
    },
    {
      "code" : "13002,03",
      "display" : "Urinary system - Urinary tract - Urinary incontinence"
    },
    {
      "code" : "13002,04",
      "display" : "Urinary system - Urinary tract - Hemorrhagic cystitis"
    },
    {
      "code" : "13002,05",
      "display" : "Urinary system - Urinary tract - Bladder fibrosis"
    },
    {
      "code" : "13002,06",
      "display" : "Urinary system - Urinary tract - Urinary bladder dysfunction"
    },
    {
      "code" : "13002,07",
      "display" : "Urinary system - Urinary tract - Cistectomy"
    },
    {
      "code" : "13002,99",
      "display" : "Urinary system - Urinary tract - Other"
    },
    {
      "code" : "14001,01",
      "display" : "Visual system - Eye - Retinopathy"
    },
    {
      "code" : "14001,02",
      "display" : "Visual system - Eye - Cataract"
    },
    {
      "code" : "14001,03",
      "display" : "Visual system - Eye - Glaucoma"
    },
    {
      "code" : "14001,04",
      "display" : "Visual system - Eye - Dry eye"
    },
    {
      "code" : "14001,05",
      "display" : "Visual system - Eye - Visual acuity reduced (OD)"
    },
    {
      "code" : "14001,06",
      "display" : "Visual system - Eye - Visual acuity reduced (OS)"
    },
    {
      "code" : "14001,07",
      "display" : "Visual system - Eye - Orbital prosthetic complications"
    },
    {
      "code" : "14001,08",
      "display" : "Visual system - Eye - Chronic painful eye"
    },
    {
      "code" : "14001,09",
      "display" : "Visual system - Eye - Eye enucleation"
    },
    {
      "code" : "14001,99",
      "display" : "Visual system - Eye - Other"
    },
    {
      "code" : "15001,01",
      "display" : "Endocrine system - Hypothalamus/pituitary gland - Growth hormone deficiency (Children)"
    },
    {
      "code" : "15001,11",
      "display" : "Endocrine system - Hypothalamus/pituitary gland - Growth hormone deficiency (Adults)"
    },
    {
      "code" : "15001,02",
      "display" : "Endocrine system - Hypothalamus/pituitary gland - Growth hormone excess"
    },
    {
      "code" : "15001,03",
      "display" : "Endocrine system - Hypothalamus/pituitary gland - LH/FSH deficiency (hypogonadotropic hypogonadism - central)"
    },
    {
      "code" : "15001,04",
      "display" : "Endocrine system - Hypothalamus/pituitary gland - ACTH deficiency"
    },
    {
      "code" : "15001,05",
      "display" : "Endocrine system - Hypothalamus/pituitary gland - TSH deficiency (central hypothyroidism)"
    },
    {
      "code" : "15001,06",
      "display" : "Endocrine system - Hypothalamus/pituitary gland - Central precocious puberty"
    },
    {
      "code" : "15001,07",
      "display" : "Endocrine system - Hypothalamus/pituitary gland - Hyperprolactinemia"
    },
    {
      "code" : "15001,08",
      "display" : "Endocrine system - Hypothalamus/pituitary gland - Hypoprolactinemia"
    },
    {
      "code" : "15001,09",
      "display" : "Endocrine system - Hypothalamus/pituitary gland - Diabetes insipidus"
    },
    {
      "code" : "15001,1",
      "display" : "Endocrine system - Hypothalamus/pituitary gland - Syndrome of inappropriate antidiuretic hormone (SIADH)"
    },
    {
      "code" : "15001,99",
      "display" : "Endocrine system - Hypothalamus/pituitary gland - Other"
    },
    {
      "code" : "15002,01",
      "display" : "Endocrine system - Thyroid - Primary hypothyroidism"
    },
    {
      "code" : "15002,02",
      "display" : "Endocrine system - Thyroid - Hyperthyroidism"
    },
    {
      "code" : "15002,03",
      "display" : "Endocrine system - Thyroid - Thyroid nodules"
    },
    {
      "code" : "15002,04",
      "display" : "Endocrine system - Thyroid - Thyroidectomy"
    },
    {
      "code" : "15002,99",
      "display" : "Endocrine system - Thyroid - Other"
    },
    {
      "code" : "15003,01",
      "display" : "Endocrine system - Parathyroid - Hypoparathyroidism"
    },
    {
      "code" : "15003,02",
      "display" : "Endocrine system - Parathyroid - Hyperparathyroidism"
    },
    {
      "code" : "15003,99",
      "display" : "Endocrine system - Parathyroid - Other"
    },
    {
      "code" : "15004,01",
      "display" : "Endocrine system - Adrenal gland - Adrenal insufficiency"
    },
    {
      "code" : "15004,02",
      "display" : "Endocrine system - Adrenal gland - Adrenectomy"
    },
    {
      "code" : "15004,99",
      "display" : "Endocrine system - Adrenal gland - Other"
    },
    {
      "code" : "16001,01",
      "display" : "Metabolic system - Impaired Glucose Metabolism - Iperinsulinism"
    },
    {
      "code" : "16001,02",
      "display" : "Metabolic system - Impaired Glucose Metabolism - Hyperglycemia"
    },
    {
      "code" : "16001,03",
      "display" : "Metabolic system - Impaired Glucose Metabolism - Hypoglycemia"
    },
    {
      "code" : "16001,99",
      "display" : "Metabolic system - Impaired Glucose Metabolism - Other"
    },
    {
      "code" : "16002,01",
      "display" : "Metabolic system - Impaired lipid metabolism (Dyslipidemia) - Hypertriglyceridemia"
    },
    {
      "code" : "16002,02",
      "display" : "Metabolic system - Impaired lipid metabolism (Dyslipidemia) - Hypercholesterolemia"
    },
    {
      "code" : "16002,99",
      "display" : "Metabolic system - Impaired lipid metabolism (Dyslipidemia) - Other"
    },
    {
      "code" : "16003,01",
      "display" : "Metabolic system - Nutrition - Metabolism and nutrition disorders"
    },
    {
      "code" : "16003,99",
      "display" : "Metabolic system - Nutrition - Other"
    },
    {
      "code" : "16004,01",
      "display" : "Metabolic system - Weight disorders - Overweight/Obesity (Age <20 years)"
    },
    {
      "code" : "16004,03",
      "display" : "Metabolic system - Weight disorders - Overweight/Obesity (Age ≥ 20 years)"
    },
    {
      "code" : "16004,04",
      "display" : "Metabolic system - Weight disorders - Underweight (Age ≥ 20 years)"
    },
    {
      "code" : "16004,02",
      "display" : "Metabolic system - Weight disorders - Underweight (Age <20 years)"
    },
    {
      "code" : "16004,99",
      "display" : "Metabolic system - Weight disorders - Other"
    },
    {
      "code" : "17001,01",
      "display" : "Reproductive/genital system - Female reproductive organs - Delayed puberty/ Failure in pubertal progression/ Primary amenorrhea"
    },
    {
      "code" : "17001,02",
      "display" : "Reproductive/genital system - Female reproductive organs - Dysmenorrhea/ Menstrual cycle irregularity (rhythm, quantity, duration and appearance)"
    },
    {
      "code" : "17001,03",
      "display" : "Reproductive/genital system - Female reproductive organs - Impaired female fertility (excluding LH/FSH excess and POI as cause)"
    },
    {
      "code" : "17001,04",
      "display" : "Reproductive/genital system - Female reproductive organs - LH/FSH excess (Hypogonadism hypergonadotropic -ovarian)"
    },
    {
      "code" : "17001,05",
      "display" : "Reproductive/genital system - Female reproductive organs - Genitourinary adhesions (female)"
    },
    {
      "code" : "17001,06",
      "display" : "Reproductive/genital system - Female reproductive organs - Vaginal stenosis"
    },
    {
      "code" : "17001,07",
      "display" : "Reproductive/genital system - Female reproductive organs - Obstetric issues"
    },
    {
      "code" : "17001,08",
      "display" : "Reproductive/genital system - Female reproductive organs - Ovariectomy"
    },
    {
      "code" : "17001,09",
      "display" : "Reproductive/genital system - Female reproductive organs - Hysterectomy"
    },
    {
      "code" : "17001,99",
      "display" : "Reproductive/genital system - Female reproductive organs - Other"
    },
    {
      "code" : "17002,01",
      "display" : "Reproductive/genital system - Male reproductive organs - Delayed puberty/ Failure in pubertal progression"
    },
    {
      "code" : "17002,02",
      "display" : "Reproductive/genital system - Male reproductive organs - Testosterone deficiency and/or LH/FSH excess (Hypogonadism hypergonadotropic -testis)"
    },
    {
      "code" : "17002,03",
      "display" : "Reproductive/genital system - Male reproductive organs - Abnormal sperm concentration/impaired male fertility/ Impaired spermatogenesis"
    },
    {
      "code" : "17002,04",
      "display" : "Reproductive/genital system - Male reproductive organs - Physical sexual dysfunction"
    },
    {
      "code" : "17002,05",
      "display" : "Reproductive/genital system - Male reproductive organs - Genitourinary adhesions (male)"
    },
    {
      "code" : "17002,06",
      "display" : "Reproductive/genital system - Male reproductive organs - Orchiectomy"
    },
    {
      "code" : "17002,99",
      "display" : "Reproductive/genital system - Male reproductive organs - Other"
    }
  ]
}

```
