# Hulafe - CarePlan: Follow-up Recommendations - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Hulafe - CarePlan: Follow-up Recommendations**

## Example CarePlan: Hulafe - CarePlan: Follow-up Recommendations

****FOLLOW-UP RECOMMENDATIONS****

Here below are listed personalized follow-up recommendations, based on the treatments you received. These advices are based on international experience with people who received similar treatments as you.

They are meant to prevent and/or diagnose at an early stage possible future complications.

It is possible that over time these recommendations will be updated according to new clinical situations and/or new data in the scientific literature. We will make all possible efforts in order to update about any new update.

We encourage you to report to your doctor any persistent symptom you might have, in order to allow an early identification of its cause.

**General recommendations**

A healthy lifestyle helps to maintain physical and mental wellbeing, as well as preventing possible diseases such as cardiovascular complications, tumors, and psychological problems.

We therefore recommend you to:

* Maintain a normal body weight and engage in regular physical activity.
* Eat plenty of fruits and vegetables, and reduce fat, sugar, and salt intake.
* Don't smoke and avoid excessive alcohol intake.
* Maintain proper dental hygiene.
* Avoid excessive sun exposure and remember to use high-protection sunscreen.
* Check your blood pressure periodically.
* Report to your health care provider any experience of chronic pain, excessive fatigue and/or deterioration of performance in your daily activities (study, work and/or exercise).
* Adhere to all cancer screening programs that will be offered by the health system.

| | | |
| :--- | :--- | :--- |
| **You might be at risk of** | **Because you were treated with** | **We therefore recommend you to** |
| Subsequent thyroid cancer | * RT to a vol exposing the thyroid gland
 | Counselling regarding the increased risk for developing differentiated thyroid to inform their HCP if they detect a thyroid mass (independent of the presence or absence of associated symptoms), every 5 years - Physical examination of the neck as part of a complete physical examination, whenever a survivor is assessed by a HCP - Counselling regarding options for differentiated thyroid carcinoma surveillance, at least every 5 years If the decision to commence surveillance is made, make a shared decision for one of these two surveillance modalities: - Neck palpation, every 1-2 years, starting 5 years after radiotherapy, or - Thyroid ultrasonographyw, every 3-5 years, starting 5 years after radiotherapy |
| Subsequent breast cancer | * RT >= 10 Gy to a vol exposing the breasts
 | Mammography and breast MRI every year if > 25 years of age or > 8 years from radiation, whichever occurs last |
| Cardiac problems (High risk) | * RT >= 35 Gy to a vol exposing the heart
* Anthracyclines (doxorubicin isotoxic equivalents)>= 250 mg/m2
 | A physical cardiac examination at every LTFU visit, at least every 5 years. Screening for modifiable cardiovascular risk factors (hypertension, diabetes, dyslipidaemia, obesity, smoking and low levels of physical activity). - ECG once at entry into LTFU. Repeat ECG once after the age of 18 years if entry into LTFU was at a younger age. - Echocardiogram with specific attention to left ventricular systolic function, to valvular structure and function and to the pericardium, starting 2 years after treatment and at least every 2-3 years; Echocardiogram with specific attention to left ventricular function, prior to pregnancy or in the first trimester, if female - Refer to a cardiologist if an abnormal ejection fraction or if other abnormalities are identified - Refer for interventions to help avert the risk of symptomatic cardiomyopathy if modifiable cardiovascular risk factors are identified Refer to a cardiologist if an abnormal ejection fraction or if other abnormalities are identified - Refer for interventions to help avert the risk of symptomatic cardiomyopathy if modifiable cardiovascular risk factors are identified |



## Resource Content

```json
{
  "resourceType" : "CarePlan",
  "id" : "CarePlanExample-1",
  "meta" : {
    "profile" : [
      "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/CarePlan-eu-pcsp"
    ]
  },
  "status" : "draft",
  "intent" : "proposal",
  "subject" : {
    "reference" : "Patient/PatientHulafe-1",
    "display" : "APELLIDO1"
  },
  "period" : {
    "start" : "2022-05-17"
  },
  "created" : "2022-05-12",
  "addresses" : [
    {
      "reference" : "Condition/PrimaryCancerHulafe-1",
      "display" : "Carcinoma tiroides"
    }
  ],
  "activity" : [
    {
      "detail" : {
        "code" : {
          "coding" : [
            {
              "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-recommendation-eu-pcsp",
              "code" : "2",
              "display" : "Perform Mammography and Breast magnetic resonance imaging (MRI) should be performed annually from the eighth year after the end of radiotherapy, but not before the age of 25. These examinations should be continued until at least age 60."
            }
          ]
        },
        "reasonCode" : [
          {
            "coding" : [
              {
                "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-riskcondition-eu-pcsp",
                "code" : "2",
                "display" : "Subsequent breast cancer"
              }
            ]
          }
        ],
        "reasonReference" : [
          {
            "reference" : "Observation/ObservationRiskFactor-2",
            "display" : "RT >= 10 Gy to a vol exposing the breasts"
          }
        ],
        "status" : "not-started",
        "description" : "A healthy lifestyle helps to maintain physical and mental wellbeing, as well as preventing possible diseases such as cardiovascular complications, tumors, and psychological problems. We therefore recommend you to: (1) Maintain a normal body weight and engage in regular physical activity. (2) Eat plenty of fruits and vegetables, and reduce fat, sugar, and salt intake. (3) Don't smoke and avoid excessive alcohol intake. (4) Maintain proper dental hygiene. (5) Avoid excessive sun exposure and remember to use high-protection sunscreen.(6) Check your blood pressure periodically.\t(7) Report to your health care provider any experience of chronic pain, excessive fatigue and/or deterioration of performance in your daily activities (study, work and/or exercise). (8) Adhere to all cancer screening programs that will be offered by the health system."
      }
    },
    {
      "detail" : {
        "code" : {
          "coding" : [
            {
              "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-recommendation-eu-pcsp",
              "code" : "1",
              "display" : "Perform appropriate thyroid screening from the fifth year after the end of radiotherapy. Discuss with your doctor whether to schedule: Clinical thyroid examination every 1-2 years; or Thyroid ultrasound every 3-5 years."
            }
          ]
        },
        "reasonCode" : [
          {
            "coding" : [
              {
                "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-riskcondition-eu-pcsp",
                "code" : "1",
                "display" : "Subsequent thyroid cancer"
              }
            ]
          }
        ],
        "reasonReference" : [
          {
            "reference" : "Observation/ObservationRiskFactor-1",
            "display" : "RT to a vol exposing the thyroid gland"
          }
        ],
        "status" : "not-started",
        "description" : "Counselling regarding the increased risk for developing differentiated thyroid to inform their HCP if they detect a thyroid mass (independent of the presence or absence of associated symptoms), every 5 years - Physical examination of the neck as part of a complete physical examination, whenever a survivor is assessed by a HCP - Counselling regarding options for differentiated thyroid carcinoma surveillance, at least every 5 years If the decision to commence surveillance is made, make a shared decision for one of these two surveillance modalities: - Neck palpation, every 1-2 years, starting 5 years after radiotherapy, or - Thyroid ultrasonographyw, every 3-5 years, starting 5 years after radiotherapy"
      }
    },
    {
      "detail" : {
        "code" : {
          "coding" : [
            {
              "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-recommendation-eu-pcsp",
              "code" : "2",
              "display" : "Perform Mammography and Breast magnetic resonance imaging (MRI) should be performed annually from the eighth year after the end of radiotherapy, but not before the age of 25. These examinations should be continued until at least age 60."
            }
          ]
        },
        "reasonCode" : [
          {
            "coding" : [
              {
                "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-riskcondition-eu-pcsp",
                "code" : "2",
                "display" : "Subsequent breast cancer"
              }
            ]
          }
        ],
        "reasonReference" : [
          {
            "reference" : "Observation/ObservationRiskFactor-2",
            "display" : "RT >= 10 Gy to a vol exposing the breasts"
          }
        ],
        "status" : "not-started",
        "description" : "Mammography and breast MRI every year if ≥ 25 years of age or ≥ 8 years from radiation, whichever occurs last"
      }
    },
    {
      "detail" : {
        "code" : {
          "coding" : [
            {
              "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-recommendation-eu-pcsp",
              "code" : "3",
              "display" : "Perform: Cardiological evaluation at the end of treatment and every 2-3 years thereafter; Electrocardiogram (ECG) at the end of treatment, to be repeated at the age of 18 and cardiological evaluation in case of palpitations, dizziness and/or fainting/loss of consciousness. Echocardiogram 2 years after the end of treatment, to be repeated every 2-3 years; If female, echocardiogram in the first trimester of pregnancy."
            }
          ]
        },
        "reasonCode" : [
          {
            "coding" : [
              {
                "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-riskcondition-eu-pcsp",
                "code" : "3",
                "display" : "Cardiac problems (Cardiomyopathy and/or Valvular disease and/or Cardiac ischemia)"
              }
            ]
          }
        ],
        "reasonReference" : [
          {
            "reference" : "Observation/ObservationRiskFactor-3",
            "display" : "RT >= 35 Gy to a vol exposing the heart"
          },
          {
            "reference" : "Observation/ObservationRiskFactor-4",
            "display" : "Anthracyclines (doxorubicin isotoxic equivalents)>= 250 mg/m2"
          }
        ],
        "status" : "not-started",
        "description" : "A physical cardiac examination at every LTFU visit, at least every 5 years. Screening for modifiable cardiovascular risk factors (hypertension, diabetes, dyslipidaemia, obesity, smoking and low levels of physical activity). - ECG once at entry into LTFU. Repeat ECG once after the age of 18 years if entry into LTFU was at a younger age. - Echocardiogram with specific attention to left ventricular systolic function, to valvular structure and function and to the pericardium, starting 2 years after treatment and at least every 2-3 years; Echocardiogram with specific attention to left ventricular function, prior to pregnancy or in the first trimester, if female - Refer to a cardiologist if an abnormal ejection fraction or if other abnormalities are identified - Refer for interventions to help avert the risk of symptomatic cardiomyopathy if modifiable cardiovascular risk factors are identified Refer to a cardiologist if an abnormal ejection fraction or if other abnormalities are identified - Refer for interventions to help avert the risk of symptomatic cardiomyopathy if modifiable cardiovascular risk factors are identified"
      }
    }
  ]
}

```
