# hl7.eu.fhir.pcsp#1.0.0: PanCareSurPass Project HL7 FHIR Implementation Guide

## Pages

* [PanCareSurPass FHIR IG - Home Page](index.md)
* [](ValueSet-FollowupSurPass_YesNoVS-testing.md)
* [Profiles](profiles.md)
* [ValueSet](ValueSet-FollowupSurPass_YesNoVS.md)
* [Collaboration diagrams](collaboration.md)
* [Useful Downloads](downloads.md)
* [Sequence diagrams](sequence.md)
* [Examples](examples.md)
* [Extensions](extensions.md)
* [](ValueSet-FollowupSurPass_YesNoNAVS-testing.md)
* [Artifacts Summary](artifacts.md)
* [Logical Models](logicalModel.md)
* [Questionnaire](questionnaire.md)
* [Terminology](terminology.md)
* [ValueSet](ValueSet-FollowupSurPass_YesNoNAVS.md)
* [IG Change History](changes.md)

## Resources

### CodeSystems

* [Conditions](CodeSystem-ConditionsCS.md)
* [OrphaNet](CodeSystem-OrphaNet.md)
* [PCSP Code System](CodeSystem-cs-generic-eu-pcsp.md)
* [Radiotherapy sites](CodeSystem-cs-radiotherapy-pcsp.md)
* [PCSP Recommendations](CodeSystem-cs-recommendation-eu-pcsp.md)
* [PCSP Conditions at risk](CodeSystem-cs-riskcondition-eu-pcsp.md)
* [Risk Factors](CodeSystem-cs-riskfactor-eu-pcsp.md)
* [International Classification of Childhood Cancer, Third Edition](CodeSystem-iccc-3.md)
* [International Classification of Diseases for Oncology, Third Edition](CodeSystem-icd-o-3.md)

### ValueSets

* [Chemotherapy cumulative dose units](ValueSet-ChemoUnitsVs.md)
* [Active or resolved Condition](ValueSet-activeResolved-condition-vs.md)
* [Annotation type](ValueSet-annotation-type-vs.md)
* [Conditions: follow up](ValueSet-cond-test-vs.md)
* [Antineoplastic and immunostimulating agents](ValueSet-drugsAtc-eu-pcsp.md)
* [Grade: follow up](ValueSet-grade-test-vs.md)
* [Laterality Qualifier Value Set](ValueSet-laterality-qualifier-lrub-vs.md)
* [Body Location Qualifier Value Set](ValueSet-mcode-body-location-qualifier-vs.md)
* [Stage Group Value Set](ValueSet-mcode-cancer-stage-group-vs.md)
* [Cancer Staging System Value Set](ValueSet-mcode-cancer-staging-system-vs.md)
* [Observation Codes for Distant Metastases Category](ValueSet-mcode-observation-codes-distant-metastases-vs.md)
* [Observation Codes for Primary Tumor Category](ValueSet-mcode-observation-codes-primary-tumor-vs.md)
* [Observation Codes for Regional Node Category](ValueSet-mcode-observation-codes-regional-nodes-vs.md)
* [Observation Codes for Stage Group Category](ValueSet-mcode-observation-codes-stage-group-vs.md)
* [TNM Distant Metastases Category Value Set](ValueSet-mcode-tnm-distant-metastases-category-vs.md)
* [TNM Primary Tumor Category Value Set](ValueSet-mcode-tnm-primary-tumor-category-vs.md)
* [TNM Regional Nodes Category Value Set](ValueSet-mcode-tnm-regional-nodes-category-vs.md)
* [Morphologically abnormal structure](ValueSet-morphologicAbnormality-eu-vs.md)
* [Other Infors Condition](ValueSet-otherInfos-condition-vs.md)
* [Relapse type (Local/Distant/Combined)](ValueSet-relapse-type-vs.md)
* [Toxicity Severity](ValueSet-toxicityseverity-vs.md)
* [Acute Gvhd Grade](ValueSet-vs-Gvhd-acute-grade-eu-pcsp.md)
* [Chronic Gvhd condition](ValueSet-vs-Gvhd-chronic-grade-eu-pcsp.md)
* [Gvhd condition](ValueSet-vs-Gvhd-type-eu-pcsp.md)
* [Prosthesis Type](ValueSet-vs-ProsthesisType-eu-pcsp.md)
* [Prosthetic Surgical Procedure Type](ValueSet-vs-ProstheticProcedureType-eu-pcsp.md)
* [Surgical Actions](ValueSet-vs-action-eu-pcsp.md)
* [Affected Organs (surgery)](ValueSet-vs-affectedOrgan-eu-pcsp.md)
* [Amputation Surgical Procedure Type](ValueSet-vs-amputationProcedureType-eu-pcsp.md)
* [Brachytherapy Type](ValueSet-vs-brachytherapyType-eu-pcsp.md)
* [Calculated|Estimated](ValueSet-vs-calcest-eu-pcsp.md)
* [Colostomy Surgical Procedure Type](ValueSet-vs-colostomyProcedureType-eu-pcsp.md)
* [Document Type](ValueSet-vs-docref-doctype-eu-pcsp.md)
* [FLT Plan Type](ValueSet-vs-flt-plan-type-eu-pcsp.md)
* [Body Location Qualifier Value Set](ValueSet-vs-fromToPosteriorAnterior-eu-pcsp.md)
* [Gastrostomy Surgical Procedure Type](ValueSet-vs-gastrostomyProcedureType-eu-pcsp.md)
* [Hereditary Predispositions or Disease](ValueSet-vs-hereditary-eu-pcsp.md)
* [ICCC-3](ValueSet-vs-iccc3-eu-pcsp.md)
* [Hereditary Predispositions (ICD10)](ValueSet-vs-icd10-predisposition-eu-pcsp.md)
* [ICD-O-3 Morphology](ValueSet-vs-icdo3-morphology-eu-pcsp.md)
* [ICD-O-3 Topography](ValueSet-vs-icdo3-topography-eu-pcsp.md)
* [Radiotherapy Isotopes](ValueSet-vs-isotopes-eu-pcsp.md)
* [Not Applicable|Unknown](ValueSet-vs-naunk-eu-pcsp.md)
* [Not Performed|Unknown](ValueSet-vs-npunk-eu-pcsp.md)
* [Hereditary Predispositions (Orphacode)](ValueSet-vs-orpha-predisposition-eu-pcsp.md)
* [Other/Unknown/Text](ValueSet-vs-othUnkTxt-eu-pcsp.md)
* [Radiotherapy sites](ValueSet-vs-radiotherapy-pcsp.md)
* [Radiotherapy Device Type](ValueSet-vs-radiotherapyDeviceType-eu-pcsp.md)
* [Radiotherapy Dose Type](ValueSet-vs-radiotherapyDoseType-eu-pcsp.md)
* [Radiotherapy dose units](ValueSet-vs-radiotherapyDoseUnit-eu-pcsp.md)
* [Radiotherapy Type](ValueSet-vs-radiotherapyType-eu-pcsp.md)
* [Recommendations](ValueSet-vs-recommendation-eu-pcsp.md)
* [Conditions at risk](ValueSet-vs-riskcondition-eu-pcsp.md)
* [Risk Factors](ValueSet-vs-riskfactor-eu-pcsp.md)
* [Route of administration](ValueSet-vs-roa-eu-pcsp.md)
* [Sacrified Organs (surgery)](ValueSet-vs-sacrifiedOrgan-eu-pcsp.md)
* [Stem Cell Donor type](ValueSet-vs-sct-donorType-eu-pcsp.md)
* [SCT Prophylaxis Cathegory](ValueSet-vs-sct-prophylaxis-cathegory-eu-pcsp.md)
* [SCT Prophylaxis Type](ValueSet-vs-sct-prophylaxis-type-eu-pcsp.md)
* [Stem Cell Source type](ValueSet-vs-sct-sourceType-eu-pcsp.md)
* [Before/after procedure](ValueSet-vs-sct-timing-eu-pcsp.md)
* [Stem Cell Transplantation type](ValueSet-vs-sct-type-eu-pcsp.md)
* [Shunt Procedure Type](ValueSet-vs-shuntProcedureType-eu-pcsp.md)
* [Surgical Procedure Type](ValueSet-vs-surgicalProcedureType-eu-pcsp.md)
* [Unknown|Other](ValueSet-vs-unknownOther-eu-pcsp.md)

### Logicals

* [Chemotherapy](StructureDefinition-Chemotherapy.md)
* [Diagnosis](StructureDefinition-Diagnosis.md)
* [Metadata FSE Italy](StructureDefinition-DocMetadataFSE.md)
* [Front Line Treatment](StructureDefinition-FrontLineTreatment.md)
* [Major Surgery](StructureDefinition-MajorSurgery.md)
* [Other info and relevant events](StructureDefinition-OtherInfos.md)
* [Care Plan](StructureDefinition-PlanOfCare.md)
* [Radiotherapy](StructureDefinition-Radiotherapy.md)
* [Progression-Relapse after FLT](StructureDefinition-RelapseAfterFLT.md)
* [Progression-Relapse during FLT](StructureDefinition-RelapseDuringFLT.md)
* [Stem Cell Transplantation](StructureDefinition-StemCellTransplantation.md)
* [Subject of care](StructureDefinition-Subject.md)
* [SurPass V2.0](StructureDefinition-SurPass.md)
* [Treatment Summary](StructureDefinition-TreatmentSummary.md)

### Resource Profiles

* [BiologicallyDerivedProduct: Stem Cell](StructureDefinition-BiologicallyDerivedProduct-sct-eu-pcsp.md)
* [Bundle: Survivor Passport](StructureDefinition-Bundle-eu-pcsp.md)
* [CarePlan: PCSP-generated plan](StructureDefinition-CarePlan-eu-pcsp.md)
* [Composition: Survivor Passport](StructureDefinition-Composition-surpass-eu-pcsp.md)
* [Condition: GvHD](StructureDefinition-Condition-gvhd-eu-pcsp.md)
* [Condition: Others](StructureDefinition-Condition-otherinfos-eu-pcsp.md)
* [Condition: Primary Cancer](StructureDefinition-Condition-primaryCancer-eu-pcsp.md)
* [Condition: Metastatic Cancer](StructureDefinition-Condition-secondaryCancer-eu-pcsp.md)
* [Condition: Severe Toxicity](StructureDefinition-Condition-toxicity-eu-pcsp.md)
* [DocumentReference: PCSP](StructureDefinition-DocumentReference-eu-pcsp.md)
* [Encounter: Treatment Center](StructureDefinition-Encounter-eu-pcsp.md)
* [Location: PCSP](StructureDefinition-Location-eu-pcsp.md)
* [MedicationAdministration: Chemotherapy](StructureDefinition-MedicationAdministration-eu-pcsp.md)
* [MedicationStatement: Chemotherapy](StructureDefinition-MedicationStatement-eu-pcsp.md)
* [Observation: Blood type/RH](StructureDefinition-Observation-bld-abo-rh-eu-pcsp.md)
* [Observation: Chemotherapy Cumulative Dose](StructureDefinition-Observation-cumulativeDoseChemo-eu-pcsp.md)
* [Observation: Diagnosis details](StructureDefinition-Observation-diagnosis-eu-pcsp.md)
* [Observation: Hereditary Predisposition](StructureDefinition-Observation-predisposition-eu-pcsp.md)
* [Observation: Risk Factor](StructureDefinition-Observation-riskfactor-eu-pcsp.md)
* [Observation: Radiotherapy Total Dose PCSP](StructureDefinition-Observation-totalDoseRad-eu-pcsp.md)
* [Organization: Primary Treatment Center / Center of diagnosis](StructureDefinition-Organization-center-eu-pcsp.md)
* [Patient: PCSP](StructureDefinition-Patient-eu-pcsp.md)
* [PlanDefinition: Front Line Treatment](StructureDefinition-PlanDefinition-flt-eu-pcsp.md)
* [Procedure: Cryopreservation](StructureDefinition-Procedure-cryopreservation-otherinfos-eu-pcsp.md)
* [Procedure: Catheter](StructureDefinition-Procedure-cvc-otherinfos-eu-pcsp.md)
* [Procedure: Front Line Treatment](StructureDefinition-Procedure-flt-eu-pcsp.md)
* [Procedure: Radiotherapy](StructureDefinition-Procedure-radiotheraphy-eu-pcsp.md)
* [Procedure: Radiotherapy Boost](StructureDefinition-Procedure-radiotheraphyBoost-eu-pcsp.md)
* [Procedure: Radiotherapy Shielding](StructureDefinition-Procedure-radiotheraphyShield-eu-pcsp.md)
* [Procedure: Stem Cell Transplantation](StructureDefinition-Procedure-sct-eu-pcsp.md)
* [Procedure: SCT Prophylaxis](StructureDefinition-Procedure-sct-prophylaxis-eu-pcsp.md)
* [Procedure: Surgery](StructureDefinition-Procedure-surgery-eu-pcsp.md)
* [Procedure: Transfusion other infos](StructureDefinition-Procedure-transfusion-otherinfos-eu-pcsp.md)
* [Procedure: Other Treatments](StructureDefinition-Procedure-treatment-otherinfos-eu-pcsp.md)
* [Observation: Cancer Stage Group](StructureDefinition-mcode-cancer-stage-group.md)
* [Observation: TNM Distant Metastases Category](StructureDefinition-mcode-tnm-distant-metastases-category.md)
* [Observation: TNM Primary Tumor Category](StructureDefinition-mcode-tnm-primary-tumor-category.md)
* [Observation: TNM Regional Nodes Category](StructureDefinition-mcode-tnm-regional-nodes-category.md)

### Extensions

* [Annotation Type](StructureDefinition-annotation-type.md)
* [Previous Status](StructureDefinition-condition-previousStatus.md)
* [Relapse Type](StructureDefinition-condition-relapseType.md)
* [Act Location](StructureDefinition-event-location.md)
* [Body Location Qualifier](StructureDefinition-mcode-body-location-qualifier.md)
* [Condition related to resource](StructureDefinition-mcode-condition-related.md)
* [Laterality Qualifier](StructureDefinition-mcode-laterality-qualifier.md)
* [Randomization arm for trial](StructureDefinition-procedure-fltArm.md)
* [Not affected Organ](StructureDefinition-procedure-notAffectedOrgan.md)
* [Performed Timing](StructureDefinition-procedure-performedTiming.md)
* [Procedure Used Reference](StructureDefinition-procedure-usedReference.md)
* [Radiotherapy Energy or Isotope](StructureDefinition-radiotherapy-energy-or-isotope.md)
* [Resource related information](StructureDefinition-resource-relatedInfo.md)
* [Stem Cell Donor Type](StructureDefinition-sct-donor-type.md)
* [Stem Cell Source Type](StructureDefinition-sct-source-type.md)
* [Sacrified organ](StructureDefinition-surgery-sacrifiedOrgan.md)

### ImplementationGuides

* [PanCareSurPass Project HL7 FHIR Implementation Guide](index.md)

### Questionnaires

* [FollowupSurPass](Questionnaire-FollowupSurPass.md)

### Examples

* [BiologicallyDerivedProduct-SCT1 (BiologicallyDerivedProduct)](BiologicallyDerivedProduct-BiologicallyDerivedProduct-SCT1.md)
* [54 (Bundle)](Bundle-54.md)
* [BundleHulafe (Bundle)](Bundle-BundleHulafe.md)
* [CarePlanExample-1 (CarePlan)](CarePlan-CarePlanExample-1.md)
* [ConditionPrimCancerMainzFischer (Condition)](Condition-ConditionPrimCancerMainzFischer.md)
* [ConditionPrimCancerMainzZeisig (Condition)](Condition-ConditionPrimCancerMainzZeisig.md)
* [ConditionSecCancerMainzZeisig (Condition)](Condition-ConditionSecCancerMainzZeisig.md)
* [PrimaryCancerHulafe-1 (Condition)](Condition-PrimaryCancerHulafe-1.md)
* [DocumentReferenceExample-1 (DocumentReference)](DocumentReference-DocumentReferenceExample-1.md)
* [EncHulafe-1 (Encounter)](Encounter-EncHulafe-1.md)
* [EncounterPrimCancerMainzFischer (Encounter)](Encounter-EncounterPrimCancerMainzFischer.md)
* [EncounterPrimCancerMainzZeisig (Encounter)](Encounter-EncounterPrimCancerMainzZeisig.md)
* [Hospital la Fe (Location)](Location-ChemoHulafe-1-Location.md)
* [Universitätsklinikum Schleswig-Holstein - Campus Lübeck (Location)](Location-Location-SCT1.md)
* [ChemoHulafe-1-Ciclofosfamide (MedicationAdministration)](MedicationAdministration-ChemoHulafe-1-Ciclofosfamide.md)
* [ChemoHulafe-1-Citarabina (MedicationAdministration)](MedicationAdministration-ChemoHulafe-1-Citarabina.md)
* [ChemoHulafe-1-Metotrexato (MedicationAdministration)](MedicationAdministration-ChemoHulafe-1-Metotrexato.md)
* [ChemoHulafe-1-Vincristina (MedicationAdministration)](MedicationAdministration-ChemoHulafe-1-Vincristina.md)
* [ChemoHulafe-1-corticosteroids (MedicationStatement)](MedicationStatement-ChemoHulafe-1-corticosteroids.md)
* [ChemoHulafe-1-Ciclofosfamide-dose (Observation)](Observation-ChemoHulafe-1-Ciclofosfamide-dose.md)
* [ChemoHulafe-1-Citarabina-dose (Observation)](Observation-ChemoHulafe-1-Citarabina-dose.md)
* [ChemoHulafe-1-Metotrexato-dose (Observation)](Observation-ChemoHulafe-1-Metotrexato-dose.md)
* [ChemoHulafe-1-Vincristina-dose (Observation)](Observation-ChemoHulafe-1-Vincristina-dose.md)
* [ObservationCBloodSCT-1-1 (Observation)](Observation-ObservationCBloodSCT-1-1.md)
* [ObservationPrimCancerMainzZeisig (Observation)](Observation-ObservationPrimCancerMainzZeisig.md)
* [ObservationRadTotalDose-1 (Observation)](Observation-ObservationRadTotalDose-1.md)
* [ObservationRiskFactor-1 (Observation)](Observation-ObservationRiskFactor-1.md)
* [ObservationRiskFactor-2 (Observation)](Observation-ObservationRiskFactor-2.md)
* [ObservationRiskFactor-3 (Observation)](Observation-ObservationRiskFactor-3.md)
* [ObservationRiskFactor-4 (Observation)](Observation-ObservationRiskFactor-4.md)
* [Hospital Universitari i Politècnic La Fe (Organization)](Organization-OrgHulafe-1.md)
* [PatientCineca (Patient)](Patient-PatientCineca.md)
* [PatientHulafe-1 (Patient)](Patient-PatientHulafe-1.md)
* [PatientHulafe (Patient)](Patient-PatientHulafe.md)
* [PatientMainzFischer (Patient)](Patient-PatientMainzFischer.md)
* [PatientMainzZeisig (Patient)](Patient-PatientMainzZeisig.md)
* [PatientVulsk (Patient)](Patient-PatientVulsk.md)
* [Cineca - Clinical Protocol (PlanDefinition)](PlanDefinition-3976.md)
* [ProcedureRadio-1 (Procedure)](Procedure-ProcedureRadio-1.md)
* [ProcedureSTC-1 (Procedure)](Procedure-ProcedureSTC-1.md)
* [ProcedureTransfusion-1 (Procedure)](Procedure-ProcedureTransfusion-1.md)
